<?php 
  /* Template name: Nos diplômes */
  get_header();


  $icon_diplomes = [];
  $icon_diplomes['EG'] = "hands-helping";

  $data_level_1 = get_poles();
  $html_level_1 = "";
  $html_level_2 = "";
  $html_level_3 = "";

  foreach ($data_level_1 as $key1 => $value1) {
    $html_level_1 .= '
      <div class="col-level-1 col-sm-3">
        <div class="trigger-level-button trigger-level-1 level-1" data-level-1="'.$data_level_1[$key1]['id'].'">
          <i class="fas fa-hands-helping fa-'.$icon_diplomes[$data_level_1[$key1]['id']].'"></i>
          <span>'.$data_level_1[$key1]['nom'].'</span>
        </div>
      </div>
    ';
    $data_level_2 = get_filieres_by_pole($data_level_1[$key1]['id']);
    foreach ($data_level_2 as $key2 => $value2) {
      $html_level_2 .= '
        <div class="col-level-2 col-sm-3 id-level-1-'.$data_level_1[$key1]['id'].'">
          <div class="trigger-level-button level-1 trigger-level-2" data-level-2="'.$data_level_2[$key2]['id'].'">
            <i class="fas fa-hands-helping fa-'.$icon_diplomes[$data_level_1[$key2]['id']].'"></i>
            <span>'.$data_level_2[$key2]['intitule'].'</span>
          </div>
        </div>
      ';
      $data_level_3 = get_diplomes_by_filiere($data_level_2[$key2]['id']);
      //var_dump($data_level_3);
      if($data_level_3){
        foreach ($data_level_3 as $key3 => $value3) {
          $html_level_3 .= '<div class="col-level-3 col-xs-12 id-level-2-'.$data_level_2[$key2]['id'].'">';
          $html_level_3 .= item_diplome($data_level_3[$key3]['id']);
          $html_level_3 .='</div>';
        }
      }
    }
  }
?>
<main>
  <div class="container">
    <h2>Nos diplômes</h2>
    <div class="wrapper-level wrapper-level-1">
      <h3>1. Choisir un pôle</h3>
      <div class="row">
        <?php echo $html_level_1 ?>
      </div>
    </div>

    <div class="wrapper-level wrapper-level-2">
      <h3>2. Choisir une filière</h3>
      <div class="row">
        <?php echo $html_level_2 ?>
      </div>
    </div>
    <div class="wrapper-level wrapper-level-3">
      <h3>3. Liste des diplômes</h3>
      <div class="row">
        <?php echo $html_level_3 ?>
      </div>
    </div>

  </div>

  <style>

    .wrapper-level-2:not(.active),
    .wrapper-level-3:not(.active),
    .col-level-2:not(.active),
    .col-level-3:not(.active){
      display: none;
    }
    .wrapper-level{
      margin-bottom: 4rem;
    }
    .trigger-level-button{
      position: relative;
      display: block;
      height: 220px;
      width: 100%;
      text-align: center;
      padding: 25px;
      padding-top: 40px;
      margin-bottom: 10px;
      border-radius: 10px;
      background-color: white;
      font-size: 2rem;
      line-height: 2.6rem;
      cursor: pointer;

    }
    .trigger-level-button:hover,
    .trigger-level-button.active{
      color: #fff;
      background-color: var(--red);
    }
    .trigger-level-button i{
      font-size: 2.5em;
      opacity: 1;
    }
    .trigger-level-button span{
      display: block;
      margin-top: 28px;
      text-align: center;
    }
    .trigger-level-button.trigger-level-2{
      height: 190px;
    }
    .ld{
      display: flex;
      padding: 2rem;
      border-radius: 10px;
      background-color: white;
      margin: 5px 0;
      cursor: pointer; 
    }
    .ld:hover{
      box-shadow: 0 0 8px rgba(0,0,0,0.15);
    }
    .ld-titre{
      width: 50%;
    }
    .ld-cell{
      width: 12.5%;
      text-align: center;
    }
  </style>

</main>
<?php 
  get_footer();
?>


<!-- <div>Icons made by <a href="https://www.flaticon.com/authors/smashicons" title="Smashicons">Smashicons</a> from <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a></div> -->