<!DOCTYPE html>
<html>
<head>
	<meta charset="utf8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
  <link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/img/items/favicon.png" />
	<meta name="viewport" content="width=device-width, initial-scale=1"/>
	<meta name="mobile-web-app-capable" content="yes"/>
	<meta name="apple-mobile-web-app-capable" content="yes"/>
	<meta name="apple-mobile-web-app-title" content="<?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?>"/>
	<link rel="profile" href="http://gmpg.org/xfn/11"/>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"/>
  <meta name="format-detection" content="telephone=no" />
  <link href='http://fonts.googleapis.com/css?family=Varela+Round' rel='stylesheet' type='text/css'>
  <link href='http://fonts.googleapis.com/css?family=Open+Sans:400,700,700italic,400italic' rel='stylesheet' type='text/css'>
	<?php wp_head(); ?>
</head>

<body <?php body_class();?>>
  <header id="main-header">
    <div class="header-top bg-white">
      <div class="container">
        <div class="row">
          <div class="flex-container">
            <div class="flex-item header-top-contact"><a class="varela" href="tel:+262262422837">Nous contacter: <span>0262.42.28.37</span></a></div>
            <div class="header-top-acces"><button class="varela bg-red">Accès rapides</button></div>
          </div>
        </div>
      </div>
    </div>
    <div class="header-nav bg-red">
      <div class="container">
        <div class="row">
          <div class="col-xs-12 col-md-3">
            <a href="<?php echo get_home_url()?>/" class="site-logo">
              <img src="<?php echo get_stylesheet_directory_uri().'/img/cnam-reunion-logo.png' ?>" alt="Logo Cnam Réunion" title="Logo Cnam Réunion">
            </a>
          </div>
          <div class="col-xs-12 col-md-9">
            <div class="flex-container">
              <ul class="menu-list">
                <li class="menu-item"><a href="<?php echo get_home_url()?>/">Le Cnam</a></li>
                <li class="menu-item"><a href="#">Nos unités</a></li>
                <li class="menu-item">
                  <a href="#">Nos diplômes</a>
                  <div class="mega-menu">
                    <div class="mega-menu-col-control">
                      <ul>
                        <?php 
                          $poles = get_poles();
                          foreach ($poles as $key => $value) {
                            echo '<li><a>'.$poles[$key]['nom'].'</a></li>';
                          }
                        ?>
                      </ul>
                    </div>
                    <div class="mega-menu-col-content" style="Xdisplay: none;">
                      
                        <?php 
                          $poles = get_poles(); 
                          foreach ($poles as $key_p => $value_p) {
                            $filieres = get_filieres_by_pole($poles[$key_p]['id']);
                            echo '<div class="mega-menu-col-tab inactive">';
                            foreach ($filieres as $key_f => $value_f) {
                              $diplomes = get_diplomes_by_filiere($filieres[$key_f]['id']);
                              if($diplomes){

                                echo '<div class="mega-menu-col-container">';
                                echo '<h5>'.$filieres[$key_f]['intitule'].'</h5>';
                                foreach ($diplomes as $key_d => $value_d) {
                                  echo '<span href="'.$diplomes[$key_d]['id'].'">'.ucfirst($diplomes[$key_d]['titre']).' '.$diplomes[$key_d]['specialite'].'</span>';
                                }
                                echo '</div>';              
                              }
                            }
                            echo '</div>';
                          }
                        ?>
                      </div>
                    </div>
                  
                </li>
              </ul>
              <?php 
                wp_nav_menu ( array (
                 'theme_location' => 'main-menu' ,
                 'menu' => 'Main',
                 'menu_class' => 'menu-list', 
                 'menu_id' => 'main-menu',
                 'container' => 'ul'
                ) );
              ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </header>