<?php
// =================================
// PARAMETRES POUR LE TRAFFIC AERIEN
// --> 01 Compagnies
// --> 02 Aéroports
// =================================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/traffic_aerien/config/header.inc.php");
?>

<style type="text/css">
.title {
	text-align:left;
	font-weight:bold;
	color:red;
	padding-top:9px;
	padding-bottom:9px;
}
</style>

<script type="text/javascript">
<!--
Fancybox.bind('[data-type="ajax"]', {
	closeButton: true,
	dragToClose: false,
	closeButton : "inside",
	click: false,
	on: {
		closing: function (fancybox, event) {
			document.location.reload();
		},
	},
});

$(document).ready(function() {

	$( "#tabs" ).tabs({ active: 0 });

	function get_json_01_compagnies(tablebody,query_string)
	{
		// Chargement initial
		$.getJSON('/traffic_aerien/config/crud/index_json.php?'+query_string, function(data){
			
			$(tablebody).html("");

			$(data).each(function(i, data_from_json){

				<!-- LES CLES PRIMAIRES -->
				var url_primary_string		 = "&id_compagnie="+data_from_json.id_compagnie;
								
				
				$(tablebody).append($("<tr>")
									
					.append($("<td style='width:50px'>").append("<a data-fancybox data-type='ajax' href='/traffic_aerien/config/crud/update_form.php?"+url_primary_string+"&nb_primary_key=1&table_name=compagnies&title=Competences'><i class='bi bi-pencil-fill text-warning'></i></a>"))
					
					.append($("<td>").append(data_from_json.nom))
					.append($("<td>").append(data_from_json.pdg))
					.append($("<td>").append(data_from_json.nb_appareil))
					.append($("<td>").append(data_from_json.pays))
					.append($("<td>").append(data_from_json.remarque))

				);
			});
		})
		.done(function(){
		})
		.fail(function(e){
			alert("Une erreur s'est produite :"+Object.values(e))
		})
		.always(function(){
		});
	}


	function get_json_02_aeroports(tablebody,query_string)
	{
		// Chargement initial
		$.getJSON('/traffic_aerien/config/crud/index_json.php?'+query_string, function(data){
			
			$(tablebody).html("");

			$(data).each(function(i, data_from_json){

				<!-- LES CLES PRIMAIRES -->
				var url_primary_string		 = "&id_aeroport="+data_from_json.id_aeroport;
								
				
				$(tablebody).append($("<tr>")
									
					.append($("<td style='width:50px'>").append("<a data-fancybox data-type='ajax' href='/traffic_aerien/config/crud/update_form.php?"+url_primary_string+"&nb_primary_key=1&table_name=aeroports&title=Aeroport'><i class='bi bi-pencil-fill text-warning'></i></a>"))
					
					.append($("<td>").append(data_from_json.nom))
					.append($("<td>").append(data_from_json.iata_code))
								
				);
			});
		})
		.done(function(){
		})
		.fail(function(e){
			alert("Une erreur s'est produite :"+Object.values(e))
		})
		.always(function(){
		});

	}

	get_json_01_compagnies('#tablebody_01_compagnies',$("#form_01_compagnies").serialize());
	get_json_02_aeroports('#tablebody_02_aeroports',$("#form_02_aeroports").serialize());

});

//-->
</script>

<div class="title">Paramètres</div>

<div id="tabs" style="width:800px">
	<ul>
		<li><a href="#tabs-1">Compagnies</a></li>
		<li><a href="#tabs-2">Aéroports</a></li>
	</ul>
	<div id="tabs-1">
		<!-- FORMULAIRE DE RECHERCHE 01 compagnies -->
		<form id='form_01_compagnies' style='width:900px'>
			<input type="hidden" name="title"		value="Compétences">
			<input type="hidden" name="table_name"	value="compagnies">
		</form>

		<a class="btn btn-primary" data-fancybox="" data-type="ajax" style="color:white" href="/traffic_aerien/config/crud/add_form.php?table_name=compagnies&amp;title=Compétence&amp;nb_primary_key=1"><i class='bi bi-plus-circle'></i> Ajouter une nouvelle compagnie</a>

		<table style="margin-top:20px" class="table table-striped">
		<thead>
		<tr>
			<th></th>
			<th>Compagnies</th>
			<th>PDG</th>
			<th>Nb appareil</th>
			<th>Pays</th>
			<th>Remarque</th>
		</tr>
		</thead>
		<tbody id="tablebody_01_compagnies"></tbody>
		</table>
	</div>

	<div id="tabs-2">
		<!-- FORMULAIRE DE RECHERCHE 02 aeroport -->
		<form id='form_02_aeroports' style='width:900px'>
			<input type="hidden" name="title"		value="Aéroport">
			<input type="hidden" name="table_name"	value="aeroports">
		</form>

		<a class="btn btn-primary" data-fancybox="" data-type="ajax" style="color:white" href="/traffic_aerien/config/crud/add_form.php?table_name=aeroports&amp;title=Aéroport&amp;nb_primary_key=1"><i class='bi bi-plus-circle'></i>  Ajouter une nouvelle aéroport</a>

		<table style="margin-top:20px" class="table table-striped">
		<thead>
		<tr>
			<th></th>
			<th>Aéroports</th>
			<th>IATA Code</th>
		</tr>
		</thead>
		<tbody id="tablebody_02_aeroports"></tbody>
		</table>
	</div>

</div>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/traffic_aerien/config/footer.inc.php");