<?php
// =======================
// Logs des Erreurs Apache
// --> par jour
// =======================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

$json = [];

// ====================
// Logs des Erreurs PHP
// --> par jour
// ====================

// Creer un tableau qui contient la liste
// des dates des erreurs PHP
// exemple :
// Array
//(
//    [0] => 2008-02-15
//    [1] => 2008-02-16
//    [2] => 2008-02-17
//    [3] => 2008-02-18
//) 

$filename = '../../../../../../logs/apache_error.log';



if (file_exists($filename) == false)	error("Le fichier $filename n'existe pas");

$string = file_get_contents($filename, "r");

$tab = explode("\n",$string);


$key_not_dont_take_care = [
		'favicon.ico',
		'robots.txt',
		'ocsinventory',
		'wamp/www/scripts',
		'wamp/www/admin',
		'wamp/www/db',
		'wamp/www/dbadmin',
		'wamp/www/myadmin',
		'wamp/www/mysql',
		'wamp/www/mysqladmin',
		'wamp/www/mysql-admin',
		'wamp/www/phpadmin',
		'wamp/www/pma',
		'wamp/www/xampp',
		'wamp/www/php-my-admin',
		'wamp/www/websql',
		'wamp/apps/phpmyadmin',
		'wamp/www/phpmyadmin',
		'wamp/www/php-my-admin',
		'wamp/www/sqlmanager',
		'wamp/www/mysqlmanager',
		'wamp/www/pma2005',
		'wamp/www/phpmanager',
		'wamp/www/php-myadmin',
		'wamp/www/phpmy-admin',
		'wamp/www/webadmin',
		'wamp/www/sqlweb',
		'wamp/www/webdb'];


$i = 0;
foreach($tab as $value)
{
	if (substr($value,0,1) == "[")
	{
		$date = new DateTime(substr($value,1,19)." ".substr($value,28,4));
		
		if ($date->format('Y-m-d') == $_GET['date'])
		{
			$heure	= $date->format("H:i:s");			
			$erreur	= substr($value,33);
		
			
			// N'affiche pas certaines errreurs
			$continue = false;
			foreach ($key_not_dont_take_care  as $key => $value)
			{
				if (stristr ($erreur, $value))
					$continue = true;
			}

			if ($continue == true)
				continue;

			
			preg_match("(\[[a-z]*\])", $erreur, $type_erreur);

			if (@$_GET['notice'] <> 1 && @$type_erreur[0] == "[notice]" )	continue;
			if (@$_GET['warn'] <> 1   && @$type_erreur[0] == "[warn]" )	continue;
			if (@$_GET['error'] <> 1  && @$type_erreur[0] == "[error]" )	continue;
			

			// Met de la couleur pour error, warn et notice
			$from 		= array("[:error]", "[:warn]", "[:notice]");
			$to   		= array("<span style='color:red;font-weight:bold'>[:error]</span>", "<span style='color:orange'>[:warn]</span>", "<span style='color:green'>[:notice]</span>");
			
			$erreur = str_replace($from, $to, $erreur);

			$json[] = [	'heure'	=> $heure,
						'erreur'=> $erreur];
		}
	}
}

echo json_encode($json);