<?php
// ==========
// MONITORING
// ==========

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/header.inc.php");
libraries(array('fullcalendar','Chart.js'));
?>

<script>
// ---------------
// 1. INFO SYSTEME
// ---------------
function init_info_system()
{
	data_ = [];

	// Chargement initial
	$.getJSON('info_systeme/info_system_json.php', function(data){
	
		$.each( data, function( key, value ) {
	
			if (key != 'free_space' && key != 'used_space')
			{
				$("#tbody_info_system").append($("<tr>")
					.append($("<td style='font-weight:bold'>").append(key))
					.append($("<td>").append(value))
				);

			}
		
		});
	
		data_.push(parseInt(data.free_space));
		data_.push(parseInt(data.used_space));

	})
	.done(function(){
	
		$("#pie-chart-space-wrapper").html("").html("<canvas id='pie-chart-space'></canvas>");
	
		const myLineChart = new Chart(document.getElementById("pie-chart-space"), {
			type: 'doughnut',
			data: {
			  labels: ["Espace libre", "Espace utilisé"],
			  datasets: [{
				label: "Espace",
				backgroundColor: ["#ACACAC", "#26A0DA"],
				data: data_
			  }]
			},
			options: {
			  title: {
				display: true,
				text: 'Espace'
			  }
			}
		});
	
	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}

// ----------------
// 2. config values
// ----------------
function init_config_value(display_all_config_value)
{
	// Chargement initial
	$.getJSON('info_systeme/config_json.php?display_all_config_value='+display_all_config_value, function(data){
	
		$("#tbody_config_value").html("");

		$.each( data, function( key, value ) {
	
			if (key != 'free_space' && key != 'total_space')
			{
				$("#tbody_config_value").append($("<tr>")
					.append($("<td style='font-weight:bold'>").append(key))
					.append($("<td>").append(value))
				);

			}
		
		});
	
	})
	.done(function(){
	
	
	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}




function init_02(date_iso)
{
	// Mois precedent
	var date_prev = dayjs(date_iso).subtract(1, 'days');

	// Mois Suivant
	var date_suiv = dayjs(date_iso).add(1, 'days');


	$("#previous_02").attr('value',date_prev.format('YYYY-MM-DD'));
	$("#next_02")    .attr('value',date_suiv.format('YYYY-MM-DD'));

	$("#label_encours_02").html(dayjs(date_iso).format('DD MMMM YYYY'));
	
	// Chargement initial
	$.getJSON('logs/02_sql_error_log/json.php?date_from='+date_iso+'&date_to='+date_iso, function(data){
		
		$(tbody_monitoring_02).html("");

		$(data).each(function(i, data_from_json){
			
			$(tbody_monitoring_02).append($("<tr>")
									
				.append($("<td>").append("<i id='"+data_from_json.id_log_sql_error+"' style='color:red;cursor:pointer' class='delete bi bi-trash fa-lg'></i>"))
				.append($("<td>").append(data_from_json.datetime))
				.append($("<td>").append(data_from_json.query))
				.append($("<td>").append(data_from_json.error))
				.append($("<td>").append(data_from_json.errno))
				.append($("<td>").append(data_from_json.personnel))
				.append($("<td>").append(data_from_json.adresse_ip_client))
				.append($("<td>").append(data_from_json.file))

			);
			
		});

	})
	.done(function(){
	
		$(".delete").click(function() {

			id_log_sql_error = $(this).attr('id');
		
			$.ajax({
				type:		"GET",
				url:		"logs/02_sql_error_log/delete.php",
				data:		"id_log_sql_error="+id_log_sql_error,
				beforeSend:	function() {
						
					},
				complete:	function() {	
					},
				success:	function(response) { 

					init_02(date_iso);
				}
			});

		});
	
	})
	.fail(function(e){
		alert("Une erreur s'est nomroduite :"+Object.values(e))
	})
	.always(function(){
	});
}


function init_03(date_iso)
{
	// Mois precedent
	var date_prev = dayjs(date_iso).subtract(1, 'days');

	// Mois Suivant
	var date_suiv = dayjs(date_iso).add(1, 'days');


	$("#previous_03").attr('value',date_prev.format('YYYY-MM-DD'));
	$("#next_03")    .attr('value',date_suiv.format('YYYY-MM-DD'));

	$("#label_encours_03").html(dayjs(date_iso).format('DD MMMM YYYY'));
	
	// Chargement initial
	$.getJSON('logs/03_sql_numrows_log/json.php?date='+date_iso, function(data){
		
		$(tbody_monitoring_03).html("");

		$(data).each(function(i, data_from_json){
			
			$(tbody_monitoring_03).append($("<tr>")
									
				.append($("<td>").append("<i id='"+data_from_json.id_log_sql_numrow+"' style='color:red;cursor:pointer' class='delete bi bi-trash fa-lg'></i>"))
				.append($("<td>").append(data_from_json.datetime))
				.append($("<td>").append(data_from_json.line))
				.append($("<td>").append(data_from_json.field))
				.append($("<td>").append(data_from_json.personnel))
				.append($("<td>").append(data_from_json.adresse_ip_client))
				.append($("<td>").append(data_from_json.file))

			);
			
		});

	})
	.done(function(){
	
		$(".delete").click(function() {

			id_log_sql_numrow = $(this).attr('id');
		
			$.ajax({
				type:		"GET",
				url:		"logs/03_sql_numrows_log/delete.php",
				data:		"id_log_sql_numrow="+id_log_sql_numrow,
				beforeSend:	function() {
						
					},
				complete:	function() {	
					},
				success:	function(response) { 

					init_03(date_iso);
				}
			});

		});
	
	})
	.fail(function(e){
		alert("Une erreur s'est nomroduite :"+Object.values(e))
	})
	.always(function(){
	});
}

function init_05(date_iso)
{
	// Mois precedent
	var date_prev = dayjs(date_iso).subtract(1, 'days');

	// Mois Suivant
	var date_suiv = dayjs(date_iso).add(1, 'days');


	$("#previous_05").attr('value',date_prev.format('YYYY-MM-DD'));
	$("#next_05")    .attr('value',date_suiv.format('YYYY-MM-DD'));

	$("#label_encours_05").html(dayjs(date_iso).format('DD MMMM YYYY'));
	
	// Chargement initial
	$.getJSON('logs/05_php_errors/json.php?date='+date_iso, function(data){
		
		$(tbody_monitoring_05).html("");

		$(data).each(function(i, data_from_json){
			
			$(tbody_monitoring_05).append($("<tr>")
									
				.append($("<td>").append("<i id='"+data_from_json.id_log_php+"' style='color:red;cursor:pointer' class='delete bi bi-trash fa-lg'></i>"))
				.append($("<td>").append(data_from_json.datetime))
				.append($("<td>").append("<i style='color:"+data_from_json.color+"' class='bi bi-circle-fill fa-lg'></i>"))
				.append($("<td>").append(data_from_json.type_error))
				.append($("<td>").append(data_from_json.error))

			);
			
		});

	})
	.done(function(){
	
		$(".delete").click(function() {

			id_log_php = $(this).attr('id');
		
			$.ajax({
				type:		"GET",
				url:		"logs/05_php_errors/delete.php",
				data:		"id_log_php="+id_log_php,
				beforeSend:	function() {
						
					},
				complete:	function() {	
					},
				success:	function(response) { 

					init_05(date_iso);
				}
			});

		});
	
	})
	.fail(function(e){
		alert("Une erreur s'est nomroduite :"+Object.values(e))
	})
	.always(function(){
	});
}



$(document).ready(function() {

	init_info_system();
	init_config_value(0);

	$("#display_all_config_value").click(function() {
		init_config_value(1);
	});

	$("#lanch_benchmark").click(function() {

		$("#test_IfElse").load("info_systeme/test_IfElse.php");
		$("#test_Loops").load("info_systeme/test_Loops.php");
		$("#test_Math").load("info_systeme/test_Math.php");
		$("#test_StringManipulation").load("info_systeme/test_StringManipulation.php");

	});







	// --------------
	// INITIALISATION
	// --------------
	init_02('<?php echo date('Y-m-d') ?>');
	init_03('<?php echo date('Y-m-d') ?>');
	$.ajax({
		async: true,
		type:		"GET",
		url:		"logs/05_php_errors/get_data.php",
		data:		$(this).serialize(),
		success:	function(response){
				
			if (response == "ok")
				init_05('<?php echo date('Y-m-d') ?>');
			else
				alert("Erreur : "+response);
		}
	});


	$( "#tabs" ).tabs();

	
	
	
	// ------
	// GO DAY
	// ------

	$(".go_day_02").click(function() {
		init_02($(this).attr('value'));
	});

	$(".go_day_03").click(function() {
		init_03($(this).attr('value'));
	});


	$(".go_day_05").click(function() {
		init_05($(this).attr('value'));
	});




	$("#delete_selection").click(function()
	{
		$.fancybox.open({
			src  : 'logs/05_php_errors/delete_form.php',
			type : 'ajax',
			opts : {
				afterClose : function() {
				}
			}
		});

	});

});


document.addEventListener('DOMContentLoaded', function() {

	var calendarEl_02 = document.getElementById('calendar_02');
	var calendarEl_03 = document.getElementById('calendar_03');
	var calendarEl_05 = document.getElementById('calendar_05');





	var calendar_02 = new FullCalendar.Calendar(calendarEl_02, {
	
		themeSystem: 'bootstrap5',
		schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',
		
		headerToolbar: {
			left: 'prev,next today',
			center: 'title',
			right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
		},

		locale:'fr',
		
		initialDate: '<?php echo date('Y-m-d') ?>',
		
		dateClick: function(info) {
			init_02(info.dateStr);
		},
		
		weekNumbers: true,

		editable: true,
		navLinks: true, // can click day/week names to navigate views
		dayMaxEventRows: true, // allow "more" link when too many events
		events: {
			url: 'logs/02_sql_error_log/fullcalendar_event.php',
			failure: function() {
				alert('Erreur de chargement des données JSON.');
			}
		}
	});




	var calendar_03 = new FullCalendar.Calendar(calendarEl_03, {
	
		themeSystem: 'bootstrap5',
		schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',
		
		headerToolbar: {
			left: 'prev,next today',
			center: 'title',
			right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
		},

		locale:'fr',
		
		initialDate: '<?php echo date('Y-m-d') ?>',
		
		dateClick: function(info) {
			init_03(info.dateStr);
		},
		
		weekNumbers: true,

		editable: true,
		navLinks: true, // can click day/week names to navigate views
		dayMaxEventRows: true, // allow "more" link when too many events
		events: {
			url: 'logs/03_sql_numrows_log/fullcalendar_event.php',
			failure: function() {
				alert('Erreur de chargement des données JSON.');
			}
		}
	});



	var calendar_05 = new FullCalendar.Calendar(calendarEl_05, {
	
		themeSystem: 'bootstrap5',
		schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',

		headerToolbar: {
		  left: 'prev,next today',
		  center: 'title',
		  right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
		},

		locale:'fr',
		
		initialDate: '<?php echo date('Y-m-d') ?>',
		
		dateClick: function(info) {
			init_05(info.dateStr);
		},
		
		weekNumbers: true,

		editable: true,
		navLinks: true, // can click day/week names to navigate views
		dayMaxEventRows: true, // allow "more" link when too many events
		events: {
			url: 'logs/05_php_errors/fullcalendar_event.php',
			failure: function() {
				alert('Erreur de chargement des données JSON.');
			}
		}
	});



	calendar_02.render();
	calendar_03.render();
	calendar_05.render();

});

</script>

<div id="tabs" style="width:980px">
	<ul>
		<li style='height:45px'><a style='margin-top:4px' href="#tabs-0"><i class="bi bi-info-circle fa-lg"></i></a></li>
		<li style='height:45px'><a href="#tabs-2"><img style='width:50px' src='/images/MySQL_logo.svg'></a></li>
		<li style='height:45px'><a href="#tabs-3"><img style='width:50px' src='/images/MySQL_logo.svg'> <i class="bi bi-list-ul"></i></a></li>
		<li style='height:45px'><a href="#tabs-5"><img style='width:50px' src='/images/PHP_logo.svg'></a></li>
	</ul>
	
	<div id="tabs-0">
	
		<!--
		// ---------------
		// 1. INFO SYSTEME
		// ---------------
		-->
		<table class='table table-striped' style='width:560px'>
		<tbody id='tbody_info_system'>
		</tbody>
		</table>

		<p><a href='info_systeme/bench.php' target='_new'>Benchmark</a></p>

		<button class="btn btn-primary" type="button" id='lanch_benchmark'>Lancer le benchmark</button>


		<div id='test_IfElse'></div>
		<div id='test_Loops'></div>
		<div id='test_Math'></div>
		<div id='test_StringManipulation'></div>




		<div id="pie-chart-space-wrapper" style="position: absolute; top:60px;left:680px;height:180px; width:180px">
			<canvas id="pie-chart-space"></canvas></div>


		<button class='btn btn-secondary' id='display_all_config_value'>Afficher tout</button>

		<!--
		// ----------------
		// 2. config values
		// ----------------
		-->
		<table class='table table-striped' style='width:560px'>
		<thead>
		<tr>
			<th>Valeur de configuration</th>
			<th>global_value</th>
		</tr>
		<thead>
		<tbody id='tbody_config_value'>
		</tbody>
		</table>


	
	</div>


	<div id="tabs-2">
		
		<div style='position:relative;top:0px;left:0px;width:800px' id='calendar_02'></div>


		<a data-fancybox data-type='ajax' class='btn btn-outline-secondary' style='position:absolute;top:64px;left:860px' href='logs/02_sql_error_log/search/index.php'>Recherche</a>

		<div style="position:relative;top:20px;left:10px">
			<!-- PREVIOUS -->
			<i style="position:absolute;top:0px; left:0px; font-weight:bold; cursor:pointer;color:#6C7D96" id='previous_02' class="go_day_02 bi bi-chevron-left fa-2x" value=""></i>

			<!-- NEXT -->
			<i style="position:absolute;top:0px; left:30px; font-weight:bold; cursor:pointer;color:#6C7D96" id='next_02'   class="go_day_02 bi bi-chevron-right fa-2x" value=""></i>

			<!-- LABEL EN COURS -->
			<div id='label_encours_02' style='position:absolute;top:12px;left:50px;width:200px;text-align:center;font-weight:bold'></div>

			<!-- Résultat //-->
			<table class="table table-striped" style="position:absolute;top:50px;width:800px">
			<thead>
			<tr>
				<th></th>
				<th>Date & Heure</th>
				<th>Requete SQL</th>
				<th>Erreur</th>
				<th>Erreur&nbsp;n°</th>
				<th>Personnel connecté</th>
				<th>Adresse IP</th>
				<th>Fichier</th>
			</tr>
			</thead>
			<tbody id='tbody_monitoring_02'></tbody>
			</table>
		</div>

	</div>

	<div id="tabs-3">
	
		<div style='position:relative;top:0px;left:0px;width:800px' id='calendar_03'></div>

	
		<div style="position:relative;top:20px;left:10px">
			<!-- PREVIOUS -->
			<i style="position:absolute;top:0px; left:0px; font-weight:bold; cursor:pointer;color:#6C7D96" id='previous_03' class="go_day_03 bi bi-chevron-left fa-2x" value=""></i>

			<!-- NEXT -->
			<i style="position:absolute;top:0px; left:30px; font-weight:bold; cursor:pointer;color:#6C7D96" id='next_03'   class="go_day_03 bi bi-chevron-right fa-2x" value=""></i>

			<!-- LABEL EN COURS -->
			<div id='label_encours_03' style='position:absolute;top:12px;left:50px;width:200px;text-align:center;font-weight:bold'></div>


			<!-- Résultat //-->
			<table class="table table-striped" style="position:absolute;top:50px;width:800px">
			<thead>
			<tr>
				<th></th>
				<th>Date & Heure</th>
				<th>Ligne</th>
				<th>Champ</th>
				<th>Personnel connecté</th>
				<th>Adresse IP</th>
				<th>Fichier</th>
			</tr>
			</thead>
			<tbody id='tbody_monitoring_03'></tbody>
			</table>
		</div>

	</div>


	<div id="tabs-5">

		<div style='position:relative;top:0px;left:0px;width:800px' id='calendar_05'></div>

		<form id='form1' style='position:absolute;top:64px;left:840px;width:700px' class="form-inline">
			<button class="btn btn-secondary" type='button' id='delete_selection'><i class='bi bi-trash'></i> Efface sélection</button>&nbsp;
		</form>

		<div style="position:relative;top:20px;left:10px">
			<!-- PREVIOUS -->
			<i style="position:absolute;top:0px; left:0px; font-weight:bold; cursor:pointer;color:#6C7D96" id='previous_05' class="go_day_05 bi bi-chevron-left fa-2x" value=""></i>

			<!-- NEXT -->
			<i style="position:absolute;top:0px; left:30px; font-weight:bold; cursor:pointer;color:#6C7D96" id='next_05'   class="go_day_05 bi bi-chevron-right fa-2x" value=""></i>

			<!-- LABEL EN COURS -->
			<div id='label_encours_05' style='position:absolute;top:12px;left:50px;width:200px;text-align:center;font-weight:bold'></div>


			<!-- Résultat //-->
			<table class="table table-striped" style="position:absolute;top:50px;width:800px">
			<thead>
			<tr>
				<th></th>
				<th>Date & Heure</th>
				<th></th>
				<th>Type erreur</th>
				<th>Erreur</th>
			</tr>
			</thead>
			<tbody id='tbody_monitoring_05'></tbody>
			</table>
		</div>
	
	</div>


</div>

<?php
// Header
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/footer.inc.php");