<?php
// ===================
// LOGS DES ERRORS PHP
// ===================

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/header.inc.php");
libraries(array('fullcalendar'));


// --------------------------
// Date par defaut
// --> Vas a la semaine prochaine
// --------------------------
$date = new DateTime("2013-05-02");
?>

<script>
function init(date_iso)
{
	// Chargement initial
    $("#ajax").load("index_ajax.php?date="+date_iso);
}

$(document).ready(function() {
	
	// --------------
	// INITIALISATION
	// --------------
	init('<?php echo $date->format('Y-m-d') ?>');
});	


document.addEventListener('DOMContentLoaded', function() {

	var calendarEl = document.getElementById('calendar');

	var calendar = new FullCalendar.Calendar(calendarEl, {
	
		themeSystem: 'bootstrap5',
		schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',

		headerToolbar: {
		  left: 'prev,next today',
		  center: 'title',
		  right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
		},

		locale:'fr',
		
		initialDate: '<?php echo $date->format('Y-m-d') ?>',
		
		dateClick: function(info) {
			$("#ajax").load("index_ajax.php?date=" + info.dateStr);
		},
		
		weekNumbers: true,

		editable: true,
		navLinks: true, // can click day/week names to navigate views
		dayMaxEventRows: true, // allow "more" link when too many events
		events: {
			url: 'fullcalendar_event.php',
			failure: function() {
				alert('Erreur de chargement des données JSON.');
			}
		}
	});

	calendar.render();
});

</script>


<div class="title">Logs des derniers access</div>

<div style='position:absolute;top:64px;left:20px;width:700px' id='calendar'></div>

<!-- Ajax //-->
<div style="position:relative;top:620px;max-width:1400px" id="ajax">
	<div class='spinner-border spinner-border-sm text-danger' role='status'></div>
</div>

<?php
// Header
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/footer.inc.php");
?>