<?php
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");
libraries(array('PhpSpreadsheet'));
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/excel/xls_style_spreadsheet.inc.php");

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

	

$xls_file_without_extension = "bibliotheques";


// Create new PHPExcel object
$spreadsheet = new Spreadsheet();



// =========
// Feuille 1
// =========
$spreadsheet->setActiveSheetIndex(0);
$spreadsheet->getActiveSheet()->setTitle("Bibliotheques");


// ------------------------------------
// LIGNE 0 & 1 : Les entetes en couleur
// ------------------------------------
// ENTETE 1
$spreadsheet->getActiveSheet()->setCellValue('A1',"Bibliothèques");
$spreadsheet->getActiveSheet()->mergeCells('A1:H2');
$spreadsheet->getActiveSheet()->getStyle('A1:H2')->applyFromArray($styleCenter);
$spreadsheet->getActiveSheet()->getStyle('A1:H2')->applyFromArray($styleDoubleBorder);
$spreadsheet->getActiveSheet()->getStyle('A1:H2')->applyFromArray($styleBold);
$spreadsheet->getActiveSheet()->getStyle('A1:H2')->applyFromArray($styleYellow);
$spreadsheet->getActiveSheet()->getStyle('A1:H2')->getAlignment()->setWrapText(true);



// ----
// Body
// ----


// --------------------
// Largeur des colonnes
// --------------------
$spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(6);
$spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(24);
$spreadsheet->getActiveSheet()->getColumnDimension('C')->setWidth(14);
$spreadsheet->getActiveSheet()->getColumnDimension('D')->setWidth(20);
$spreadsheet->getActiveSheet()->getColumnDimension('E')->setWidth(10);
$spreadsheet->getActiveSheet()->getColumnDimension('F')->setWidth(24);
$spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(6);
$spreadsheet->getActiveSheet()->getColumnDimension('H')->setWidth(6);


$ligne = 5;

foreach(['JS+CSS','PHP'] as $type)
{
	$json = json_decode(file_get_contents('http://localhost/tourisme/base/service_informatique/libraries/index_json.php?type='.urlencode($type)));

	
	$spreadsheet->getActiveSheet()->setCellValue('A'.$ligne,$type);

	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleBold);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleGreen);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleCenterVertical);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleDoubleBorder);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleInsideBorder);

	$spreadsheet->getActiveSheet()->getRowDimension($ligne)->setRowHeight(30);
	$spreadsheet->getActiveSheet()->mergeCells('A'.$ligne.':H'.$ligne);
	$ligne++;
	


	// ---------------------
	// LIGNE 2 : Les entetes
	// ---------------------
	$spreadsheet->getActiveSheet()->setCellValue('A'.$ligne,'#');
	$spreadsheet->getActiveSheet()->setCellValue('B'.$ligne,'Nom');
	$spreadsheet->getActiveSheet()->setCellValue('C'.$ligne,'Protocole');
	$spreadsheet->getActiveSheet()->setCellValue('D'.$ligne,'Domaine');
	$spreadsheet->getActiveSheet()->setCellValue('E'.$ligne,'Version');
	$spreadsheet->getActiveSheet()->setCellValue('F'.$ligne,'Nom fichier');
	
	if ($type == "JS+CSS")
	{
		$spreadsheet->getActiveSheet()->setCellValue('G'.$ligne,'Type');
		$spreadsheet->getActiveSheet()->setCellValue('H'.$ligne,'Hash');
	}
	else
		$spreadsheet->getActiveSheet()->mergeCells('F'.$ligne.':H'.$ligne);



	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleBold);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleWhiteRed);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleDoubleBorder);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleInsideBorder);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne.':H'.$ligne)->applyFromArray($styleCenter);




	$ligne++;

	$ligne_from = $ligne;

	$nb = 1;
	foreach($json as $key_ => $value_)
	{
		$ligne_from2 = $ligne;

		$spreadsheet->getActiveSheet()->setCellValue('A'.$ligne,(string)$nb);
		$spreadsheet->getActiveSheet()->setCellValue('B'.$ligne,$value_->{'name_library'});

		
		foreach($value_->{'files'} as $key_2 => $value_2)
		{
			$spreadsheet->getActiveSheet()->setCellValue('C'.$ligne,$value_2->{'parse_url'}->{'SERVER_PROTOCOL'});
			$spreadsheet->getActiveSheet()->setCellValue('D'.$ligne,$value_2->{'parse_url'}->{'HTTP_HOST'});
			$spreadsheet->getActiveSheet()->setCellValue('E'.$ligne,$value_2->{'version'});
			$spreadsheet->getActiveSheet()->setCellValue('F'.$ligne,$value_2->{'path'});
	
			if ($type == "JS+CSS")
			{
				$spreadsheet->getActiveSheet()->setCellValue('G'.$ligne,$value_2->{'libraries_files_type'});
				$spreadsheet->getActiveSheet()->setCellValue('H'.$ligne,(string)$value_2->{'hascode'});
			}
			else
				$spreadsheet->getActiveSheet()->mergeCells('F'.$ligne.':H'.$ligne);
		
			$ligne++;
		}
	
		$spreadsheet->getActiveSheet()->mergeCells('A'.$ligne_from2.':A'.($ligne-1));
		$spreadsheet->getActiveSheet()->mergeCells('B'.$ligne_from2.':B'.($ligne-1));

		$nb++;

	}
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne_from.':H'.($ligne-1))->applyFromArray($styleDoubleBorder);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne_from.':H'.($ligne-1))->applyFromArray($styleInsideBorder);


	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne_from.':A'.($ligne-1))->applyFromArray($styleCenter);
	$spreadsheet->getActiveSheet()->getStyle('B'.$ligne_from.':B'.($ligne-1))->applyFromArray($styleCenterVertical);
	$spreadsheet->getActiveSheet()->getStyle('A'.$ligne_from.':B'.($ligne-1))->applyFromArray($styleBold);
	$spreadsheet->getActiveSheet()->getStyle('C'.$ligne_from.':C'.($ligne-1))->applyFromArray($styleCenter);
	$spreadsheet->getActiveSheet()->getStyle('E'.$ligne_from.':E'.($ligne-1))->applyFromArray($styleCenter);
	$spreadsheet->getActiveSheet()->getStyle('G'.$ligne_from.':H'.($ligne-1))->applyFromArray($styleCenter);


	$ligne += 2;
}


// -------------------
// Format : Excel 2007
// -------------------
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$xls_file_without_extension.'.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
$objWriter->save('php://output');