<?php
// =============
// BIBLIOTHEQUES
// --> pdf
// =============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

libraries(array('tcpdf'));
require($_SERVER['DOCUMENT_ROOT']."/lib/tcpdf/lib.inc.php");

// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)



if ($_GET['format'] == "A4")
	$landscape_portrait = 'Portrait';
else
	$landscape_portrait = 'Landscape';

// Feuille A4 - Portrait
$pdf = new MY_PDF($landscape_portrait, 'mm', $_GET['format'], true ,'UTF-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Bibliothèques');
$pdf->SetTitle('Bibliothèques');
$pdf->SetSubject('Bibliothèques');
$pdf->SetKeywords('Bibliothèques');

// set font
$pdf->SetFont('helvetica', '', 12);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);


// Add a page
$pdf->AddPage();

// ------
// Entete
// ------
$nb_lines_max = ['A4'=>28,'A5'=>14];

$header = [	'JS+CSS' => [['text' => '',			 'align' => 'C', 'width' => 6,	'height'=> 8],
						['text' => 'Nom',		 'align' => 'L', 'width' => 32,	'height'=> 8],
						['text' => 'Proto.',	 'align' => 'C', 'width' => 18,	'height'=> 8],
						['text' => 'Domaine',	 'align' => 'L', 'width' => 40,	'height'=> 8],
						['text' => 'Version',	 'align' => 'C', 'width' => 18,	'height'=> 8],
						['text' => 'Nom fichier','align' => 'L', 'width' => 54,	'height'=> 8],
						['text' => 'Type',		 'align' => 'C', 'width' => 11,	'height'=> 8],
						['text' => 'Hash',		 'align' => 'C', 'width' => 11,	'height'=> 8]],

			'PHP' =>	[['text' => '',			 'align' => 'C', 'width' => 6,	'height'=> 8],
						['text' => 'Nom',		 'align' => 'L', 'width' => 32,	'height'=> 8],
						['text' => 'Proto.',	 'align' => 'C', 'width' => 18,	'height'=> 8],
						['text' => 'Domaine',	 'align' => 'L', 'width' => 40,	'height'=> 8],
						['text' => 'Version',	 'align' => 'C', 'width' => 18,	'height'=> 8],
						['text' => 'Nom fichier','align' => 'L', 'width' => 76,	'height'=> 8]]];


foreach(['JS+CSS','PHP'] as $type)
{
	$json = json_decode(file_get_contents('http://'.$_SERVER['HTTP_HOST'].'/tourisme/base/service_informatique/libraries/index_json.php?type='.urlencode($type)));

	
	$pdf -> rubrique(12,$pdf->getY()+5,$type);

	$pdf -> setY($pdf->getY()+5);


	$nb = 1;

	$indice = 0;
	$data_table = [];
	foreach($json as $key_ => $value_)
	{
		// Nb
		$data_table[$indice] = [
					['text'	=> $nb,
					'height'	=> 8,'align'=> 'C','is_MultiCell'	=> false,'font-weight'	=> 'bold'],
					['text'	=> $value_->{'name_library'},
					'height'	=> 8,'align'=> 'L','is_MultiCell'	=> false,'font-weight'	=> 'bold']];

		foreach($value_->{'files'} as $key_2 => $value_2)
		{
			if (!isset($data_table[$indice][0]))
			{
				$data_table[$indice][0] = [
					'text'	=> "",	'height'=> 8,	'align'	=> 'C',	'is_MultiCell'	=> false];
			
				$data_table[$indice][1] = [
					'text'	=> "",	'height'=> 8,	'align'	=> 'C',	'is_MultiCell'	=> false];
			}
			
			
			$data_table[$indice][2] = [
					'text'			=> $value_2->{'parse_url'}->{'SERVER_PROTOCOL'},
					'height'		=> 8,
					'align'			=> 'C',
					'is_MultiCell'	=> false];
			
			$data_table[$indice][3] = [
					'text'			=> $value_2->{'parse_url'}->{'HTTP_HOST'},
					'height'		=> 8,
					'align'			=> 'C',
					'is_MultiCell'	=> false];
			
			$data_table[$indice][4] = [
					'text'			=> $value_2->{'version'},
					'height'		=> 8,
					'align'			=> 'C',
					'is_MultiCell'	=> false];
			
			$data_table[$indice][5] = [
					'text'			=> $value_2->{'path'},
					'height'		=> 8,
					'align'			=> 'L',
					'is_MultiCell'	=> false];
			
			$data_table[$indice][6] = [
					'text'			=> $value_2->{'libraries_files_type'},
					'height'		=> 8,
					'align'			=> 'C',
					'is_MultiCell'	=> false];
			
			$data_table[$indice][7] = [
					'text'			=> $value_2->{'hascode'},
					'height'		=> 8,
					'align'			=> 'C',
					'is_MultiCell'	=> false];
			
			$indice++;
		}

		$nb++;
	}


	$options = ['x'				=> 12,
				'nb_lines_max'	=> $nb_lines_max[$_GET['format']],
				'display_header'=> true];

	$pdf -> AdvancedTable($header[$type],$data_table,$options);
	
	if ($type == 'JS+CSS')
		$pdf -> AddPage();
}

ob_end_clean();
$pdf->Output('Bibliotheques_JS_CSS_PHP.pdf', 'I');