<?php
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");
libraries(array('PhpSpreadsheet'));
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/excel/xls_style_spreadsheet.inc.php");

	

$xls_file_without_extension = "documentation_base";


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Create new PHPExcel object
$spreadsheet = new Spreadsheet();



// =========
// Feuille 1
// =========
$spreadsheet->setActiveSheetIndex(0);
$spreadsheet->getActiveSheet()->setTitle($_GET['table']);

// --------------------
// Largeur des colonnes
// --------------------
$spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(4);
$spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(36);
$spreadsheet->getActiveSheet()->getColumnDimension('C')->setWidth(24);
$spreadsheet->getActiveSheet()->getColumnDimension('D')->setWidth(10);
$spreadsheet->getActiveSheet()->getColumnDimension('E')->setWidth(46);



// ------------------------------------
// LIGNE 0 & 1 : Les entetes en couleur
// ------------------------------------
// ENTETE 1
$spreadsheet->getActiveSheet()->setCellValue('A1',"Structure de la table ".$_GET['table']);
$spreadsheet->getActiveSheet()->mergeCells('A1:E2');
$spreadsheet->getActiveSheet()->getStyle('A1:E2')->applyFromArray($styleCenter);
$spreadsheet->getActiveSheet()->getStyle('A1:E2')->applyFromArray($styleDoubleBorder);
$spreadsheet->getActiveSheet()->getStyle('A1:E2')->applyFromArray($styleBold);
$spreadsheet->getActiveSheet()->getStyle('A1:E2')->applyFromArray($styleYellow);
$spreadsheet->getActiveSheet()->getStyle('A1:E2')->getAlignment()->setWrapText(true);




// ---------------------
// LIGNE 2 : Les entetes
// ---------------------
$spreadsheet->getActiveSheet()-> setAutoFilter('A4:E4');
$spreadsheet->getActiveSheet()->setCellValue('A4','#');
$spreadsheet->getActiveSheet()->setCellValue('B4','Nom');
$spreadsheet->getActiveSheet()->setCellValue('C4','Type');
$spreadsheet->getActiveSheet()->setCellValue('D4','Null');
$spreadsheet->getActiveSheet()->setCellValue('E4','Référence');



$spreadsheet->getActiveSheet()->getStyle('A4:E4')->applyFromArray($styleBold);
$spreadsheet->getActiveSheet()->getStyle('A4:E4')->applyFromArray($styleWhiteRed);
$spreadsheet->getActiveSheet()->getStyle('A4:E4')->applyFromArray($styleDoubleBorder);
$spreadsheet->getActiveSheet()->getStyle('A4:E4')->applyFromArray($styleInsideBorder);
$spreadsheet->getActiveSheet()->getStyle('D4:D4')->applyFromArray($styleCenter);



// On gele la ligne
$spreadsheet->getActiveSheet()->freezePane('A5');


// ----
// Body
// ----

$json = json_decode(file_get_contents('http://localhost/tourisme/base/service_informatique/base_de_donnee/index_table_json.php?table='.$_GET['table']));

$ligne = 5;

foreach ($json as $key => $object)
{
	$spreadsheet->getActiveSheet()->setCellValue('A'.$ligne,(string)($key+1));
	$spreadsheet->getActiveSheet()->setCellValue('B'.$ligne,$object->field);
	$spreadsheet->getActiveSheet()->setCellValue('C'.$ligne,$object->type);
	$spreadsheet->getActiveSheet()->setCellValue('D'.$ligne,$object->null);
	$spreadsheet->getActiveSheet()->setCellValue('E'.$ligne,$object->referenced_table_name.".".$object->referenced_column_name);

	// Clé primaire
	if ($object->key == "PRI")
	{
		$spreadsheet->getActiveSheet()->getStyle('B'.$ligne)->applyFromArray($styleBold);
		$spreadsheet->getActiveSheet()->getStyle('B'.$ligne)->applyFromArray($styleUnderline);
	}
	// Clé étrangere
	elseif ($object->key == "MUL")
	{
		$spreadsheet->getActiveSheet()->getStyle('B'.$ligne)->applyFromArray($styleItalic);
		$spreadsheet->getActiveSheet()->setCellValue('B'.$ligne,$object->field." #");

	}
	else
		$spreadsheet->getActiveSheet()->setCellValue('F'.$ligne,$object->key);


	$ligne++;
}


$spreadsheet->getActiveSheet()->getStyle('A5:E'.($ligne-1))->applyFromArray($styleDoubleBorder);
$spreadsheet->getActiveSheet()->getStyle('A5:E'.($ligne-1))->applyFromArray($styleInsideBorder);

$spreadsheet->getActiveSheet()->getStyle('D5:D'.($ligne-1))->applyFromArray($styleCenter);



// -------------------
// Format : Excel 2007
// -------------------
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$xls_file_without_extension.'.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
$objWriter->save('php://output');