<?php

function extension($file)
{
	$path_parts = pathinfo($file);

	if (isset($path_parts['extension']))
		return $path_parts['extension'];
}

function file_without_extension($file)
{
	$path_parts = pathinfo($file);
	return $path_parts['filename'];
}

function imagesize($file)
{
	if (extension($file) == "png" || extension($file) == "jpg")
		list($width_px, $height_px, $type, $attr) = getimagesize($file);

	if (extension($file) == "svg")
	{
		$xml = simplexml_load_file($file);
		$svg = $xml->attributes();
		$width_px	= substr($svg->width,0,-2);
		$height_px	= substr($svg->height,0,-2);
	}

	$return = array();
	$return['width']	= $width_px;
	$return['height']	= $height_px;

	return $return;
}


function file_type($folder_file,$extension)
{
	if ($folder_file == "folder")
		$file_type = "Dossier";
	else
	{
		$file_type = "Fichier ".$extension;
	}

	return $file_type;
}


function icone_bootstrap_icon($folder_file,$extension)
{
	if ($folder_file == "folder")
		$bootstrap_icon_html = "<i style='color:#F9D56F' class='bi bi-folder-fill fa-2x'></i>";
	else
	{
		$file_type = "Fichier ".$extension;

		$sql_icon = dbquery("SELECT type,color,bootstrap_icon
				FROM file
				WHERE file_extension ='".$extension."'");

		if (dbnumrows($sql_icon)>0)
		{
			$file_type		= dbresult($sql_icon,0,"type");
			$color			= dbresult($sql_icon,0,"color");
			$bootstrap_icon	= dbresult($sql_icon,0,"bootstrap_icon");
			$bootstrap_icon_html = "<i style='color:".$color."' class='".$bootstrap_icon." fa-2x' aria-hidden='true'></i>";
		}
		else
			$bootstrap_icon_html = "<i style='color:black' class='bi bi-file-earmark fa-2x' aria-hidden='true'></i>";
	}

	return $bootstrap_icon_html;
}



function get_bootstrap_icon_from_file($file)
{
	$extension = extension($file);
	
	$sql_icon = dbquery("SELECT type,color,bootstrap_icon
		FROM file
		WHERE file_extension ='".$extension."'");
	if (dbnumrows($sql_icon)>0)
	{
		$file_type		= dbresult($sql_icon,0,"type");
		$color			= dbresult($sql_icon,0,"color");
		$bootstrap_icon	= dbresult($sql_icon,0,"bootstrap_icon");
		$bootstrap_icon_html = "<i style='color:".$color."' class='".$bootstrap_icon." fa-2x' aria-hidden='true'></i>";
	}
	else
		$bootstrap_icon_html = "<i style='color:black' class='bi bi-file-earmark fa-2x' aria-hidden='true'></i>";

	return $bootstrap_icon_html;
}


function real_file_size($f)
{
	if (filesize($f) < 0)
		return 4294967296+filesize($f);
	else
		return filesize($f);
}

// =================
// Taille des octets
// =================
function size_file_format($octets) {
    $resultat = $octets;
    for ($i=0; $i < 8 && $resultat >= 1024; $i++) {
        $resultat = $resultat / 1024;
    }
    if ($i > 0) {
        return preg_replace('/,00$/', '', number_format($resultat, 2, ',', '')) 
. ' ' . substr('KMGTPEZY',$i-1,1) . 'o';
    } else {
        if ($resultat <> "")
			return $resultat . ' o';
    }
}