<?php
// ===========
// MODULE CRUD
// --> Liste
// ===========

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");


require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/crud/global.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/header.inc.php");

// TinyMCE
libraries(array('tinymce'));

// Exemple : 3
function nb_primary_key($bd_data_table)
{
	// Nb de primary key
	$sql_table_count_nb_primary_key = dbquery("SELECT * FROM ".$_GET['table_name']);

	$nb_primary_key = 0;
					
	if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
	{
		foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
		{
			if (isset($value['index']) && $value['index']=='primary')
				$nb_primary_key++;
		}
	}

	return $nb_primary_key;
}

/*Array
(
    [0] => id_personnel
    [1] => date_from
    [2] => date_to
)*/

function tab_primary_key($bd_data_table)
{		
	$tab_primary_key = array();

	if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
	{
		foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
		{
			if (isset($value['index']) && $value['index']=='primary')
				$tab_primary_key[] = $key;
		}
	}

	return $tab_primary_key;
}


function id_for_tab_column($bd_data_table)
{		
	$id_for_tab_column = "";

	if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
	{
		foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
		{
			if (isset($value['tabs']))
			{
				$id_for_tab_column = $key;
			}
		}
	}
	
	return $id_for_tab_column;
}

$nb_primary_key = nb_primary_key($bd_data_table);
?>

<script type="text/javascript"> 

function date_iso_fr(date)
{
	if (date != null)
	{
		var tab = date.split('-');
	
		return tab[2]+"/"+tab[1]+"/"+tab[0];
	}
	else
		return "";
}

function datetime_iso_fr(date)
{
	if (date != null)
	{
		var tab = date.split(' ');

		var date = tab[0].split('-')
		var time = tab[1].split(':')
	
		return date[2]+"/"+date[1]+"/"+date[0]+" "+time[0]+":"+time[1];
	}
	else
		return "";
}

function boolean(boolean)
{
	if (boolean == "0")
		return "Non";
	else
		return "Oui";
}

function get_json(tablebody,query_string)
{
	// Chargement initial
	$.getJSON('json.php?'+query_string, function(data){
		
		
		<?php
		$checkbox		= false;
		$link_connexe	= "";
		
		// Recupere id_for_tab_column s'il existe
		$id_for_tab_column = id_for_tab_column($bd_data_table);
		
		
		// Checkbox ?
		if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
		{
			foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
			{
				if (isset($value['checkbox']) && $value['checkbox'])
				{
					$checkbox = true;
				}

				if (isset($value['link_connexe']) )
				{
					$link_connexe = $value['link_connexe'];
				}
			}
		}		
		?>
		
		$(tablebody).html("");

		/* console.log(data); */
		$(data).each(function(i, data_from_json){

			<!-- LES CLES PRIMAIRES -->
			var url_primary_string		 = "";
			var url_primary_string_array = "";
			
			<?php
			foreach(tab_primary_key($bd_data_table) as $val_pk)
			{
				?>
				url_primary_string		 += "&<?php echo $val_pk ?>="+data_from_json.<?php echo $val_pk ?>;
				url_primary_string_array += "&<?php echo $val_pk ?>[0]="+data_from_json.<?php echo $val_pk ?>;
				<?php
			}
			?>
			
			/*
			Exemple :
			$('#tablebody').append($("<tr>")
				.append($("<td>").append("<a data-fancybox data-type='ajax' href='update_form.php?"+url_primary_string+"&nb_primary_key=3&table_name=creche_personnel_conges&title=Cong%C3%A9'><i class='bi bi-pencil-fill text-warning'></i></a>"))
				.append($("<td>").append("<a target='_new' href='"+link+"?"+url_primary_string_array+"'><i style='background-color:white;color:red' class='bi "+bootstrapicon+" fa-2x'></i></a>"))
				.append($("<td>").append(data_from_json.id_personnel))
				.append($("<td>").append(data_from_json.date_from))
				.append($("<td>").append(data_from_json.date_to))
				.append($("<td>").append(data_from_json.AM_PM))
				.append($("<td>").append(data_from_json.classique_maladie))
				);
			});
			*/			

			<?php
			if (isset($bd_data_table[$_GET['table_name']]['options']) && is_array($bd_data_table[$_GET['table_name']]['options']))
			{
				foreach($bd_data_table[$_GET['table_name']]['options'] as $key => $value)
				{
					if ($key == "link")
					{
						?>
						var link = "<?php echo $value ?>";
						<?php
					}

					if ($key == "query_string")
					{
						?>
						var query_string = "<?php echo $value ?>";
						
						<?php
					}

					if ($key == "row_name")
					{
						?>
						var row_name = "<?php echo $value ?>";
						<?php
					}

					if ($key == "bootstrapicon")
					{
						?>
						var bootstrapicon = "<?php echo $value ?>";
						<?php
					}
				}
			}
			?>

			$(tablebody).append($("<tr>")
				<?php
				// Checkbox
				if ($checkbox)
				{
					?>
					.append($("<td style='text-align:center;width:50px'>").append("<input class='checkbox' type='checkbox' name='<?php echo $val_pk ?>[]' value='"+data_from_json.<?php echo $val_pk ?>+"'>"))
					<?php
				}
				?>
				
				.append($("<td style='width:50px'>").append("<a data-fancybox data-type='ajax' href='update_form.php?"+url_primary_string+"&nb_primary_key=<?php echo $nb_primary_key ?>&table_name=<?php echo $_GET['table_name'] ?>&title=<?php echo ucfirst(urlencode($_GET['title'])) ?>'><i class='bi bi-pencil-fill text-warning'></i></a>"))
				
				<?php
				// Lien
				if (isset($bd_data_table[$_GET['table_name']]['options']) && is_array($bd_data_table[$_GET['table_name']]['options']))
				{
					?>

					.append($("<td>").append("<a target='_new' href='"+link+"?"+url_primary_string_array+"'><i style='background-color:white;color:red' class='bi "+bootstrapicon+" fa-2x'></i></a>"))
					<?php
				}
				
				if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
				{
					foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
					{
						// $value['type'] --> text / date / radio / 
					
						// Ne pas afficher les display=none
						if (isset($value['display']) && $value['display'] == "none")
							continue;

						if ($id_for_tab_column <> "" && $id_for_tab_column == $key)
							continue;

						// Date
						if (@$value['type'] == "date")
						{
							?>
							.append($("<td>").append(date_iso_fr(data_from_json.<?php echo $key ?>)))
							<?php
						}
						// Date Time
						elseif (@$value['type'] == "datetime")
						{
							?>
							.append($("<td>").append(datetime_iso_fr(data_from_json.<?php echo $key ?>)))
							<?php
						}
						// Boolean
						elseif (@$value['type'] == "boolean")
						{
							?>
							.append($("<td>").append(boolean(data_from_json.<?php echo $key ?>)))
							<?php
						}
						
						// Color
						elseif (@$value['type'] == "color")
						{
							?>
							.append($("<td>").append("<span style='width:50px;background-color:"+data_from_json.<?php echo $key ?>+"'>&nbsp;"+data_from_json.<?php echo $key ?>+"&nbsp;</span>"))
							<?php
						}
						
						// Alternative
						// id_personnel = 12
						// devient
						// id_personnel_alt = Claite Marie Sandra Isabelle 	
						else if (@$value['relation'] <> "")
						{
							?>
							.append($("<td>").append(data_from_json.<?php echo $key ?>_alt))
							<?php
						}

						// Normal
						else
						{
							?>
							.append($("<td>").append(data_from_json.<?php echo $key ?>))
							<?php
						}
					}
				}
				
				// $link_connexe
				if ($link_connexe <> "")
				{
					?>
					.append($("<td style='text-align:center;width:50px'>").load("<?php echo $link_connexe ?>"+"?"+url_primary_string))
					<?php
				}	
				?>

			);
		});
	})
	.done(function(){
	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}

$(document).ready(function()
{
	Fancybox.bind('[data-type="ajax"]', {
		closeButton: true,
		dragToClose: false,
		closeButton : "inside",
		click: false,
		on: {
			closing: function (fancybox, event) {
				document.location.reload();
			},
		},
	});


	$(".checkbox").click( function(){

		var nb_checkbox			= $(".checkbox").length;
		var nb_checkbox_checked = $("input:checked[class=checkbox]").length;

		if (nb_checkbox_checked > 0)
		{
			$("#submit_selection").show();

			if (nb_checkbox != nb_checkbox_checked)
				$("#check_uncheck_all").prop("indeterminate", true);
			else
			{
				$("#check_uncheck_all").prop("indeterminate", false);
				$("#check_uncheck_all").prop("checked", true);
			}
		}
		else
		{
			$("#submit_selection").hide();
			$("#check_uncheck_all").prop("indeterminate", false);
			$("#check_uncheck_all").prop("checked", false);
		}
	});

	// ---------------------
	// Coche ou décoche tout
	// ---------------------
	$("#check_uncheck_all").click(function()				
	{
		if (this.checked)
			$("#submit_selection").show();
		else
			$("#submit_selection").hide();
		
		var checked_status = this.checked;
		$("input.checkbox").each(function()
		{
			this.checked = checked_status;
		});

	});

	$(".form_search").submit(function()
	{
		get_json('#tablebody',$(this).serialize());

		return false;
	});

	<?php
	if (id_for_tab_column($bd_data_table) == "")
	{
		?>
		// Initiation
		$(".form_search").submit();
		<?php
	
	}
	// Recupere id_for_tab_column s'il existe
	else
	{
		?>
		$( "#tabs" ).tabs({ active: 0 });
		<?php
	}
	?>

});	
</script>

<div class='title'><?php echo ucfirst($_GET['title']) ?></div>

<!-- Bouton AJOUT -->
<a class='btn btn-secondary' data-fancybox data-type='ajax' style='color:white' href='add_form.php?table_name=<?php echo $_GET['table_name'] ?>&title=<?php echo ucfirst(urlencode($_GET['title'])) ?>&nb_primary_key=<?php echo $nb_primary_key ?>'><i class='bi bi-plus-circle'></i> <?php echo ucfirst($_GET['title']) ?></a>

<!-- Export Excel -->
<table style='position:absolute;top:50px;left:300px;z-index:1'>
<tr>
	<td style='text-align:center'><a href='xls_export.php?title=<?php echo $_GET['title'] ?>&table_name=<?php echo $_GET['table_name'] ?>'><i style='background-color:white;color:green' class='bi bi-file-earmark-excel fa-2x'></i></a>
	<td style='text-align:center;padding:10px'><a href='csv_export.php?title=<?php echo $_GET['title'] ?>&table_name=<?php echo $_GET['table_name'] ?>'><i style='background-color:white;color:green' class='bi bi-file-earmark-excel fa-2x'></i></a></td>
</tr>
<tr>
	<td style='text-align:center;padding-left:5px;padding-right:10px;font-weight:bold'>Export excel</td>
	<td style='text-align:center;padding-left:5px;padding-right:10px;font-weight:bold'>Export CSV</td>
</tr>
</table>



<!-- FORMULAIRE DE RECHERCHE -->
<form class='form_search' style='width:900px'>
	<input type="hidden" name="title"		value="<?php echo $_GET['title'] ?>">
	<input type="hidden" name="table_name"	value="<?php echo $_GET['table_name'] ?>">

	<?php
	$tab_search = array();

	if (is_array($bd_data_table[$_GET['table_name']]['keys']))
	{
		foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
		{
			if (isset($value['search']) && $value['search'] == "1")
			{
				if (is_array($value['enum']))
					$tab_search[$value['type']][$key] = $value['enum'];
				else
					$tab_search[$value['type']][$key] = '1';
			}
		}
	}

	/*
	$tab_search

	Array
	(
		[text] => Array
			(
				[nom] => 1
				[prenom] => 1
			)

		[radio] => Array
			(
				[type] => Array
					(
						[0] => Creche
						[1] => After School
					)
			)
	)
	*/
	
	// -----
	// TEXT 
	// -----

	$display_search = false;

	if (isset($tab_search['text']) && is_array($tab_search['text']))
	{
		foreach($tab_search['text'] as $name_input => $value)
		{
			$display_search = true;
		
			// name_input : nom / prenom
			// value      : non utilisé

			/*
			+----------------+  +-----------+
			| nom            |  | Recherche |
			+----------------+  +-----------+	

			+----------------+  +-----------+
			| prenom         |  | Recherche |
			+----------------+  +-----------+	
			*/
			?>
		
			<input class='form-control' style='width:200px;display:inline' type='text' name='<?php echo $name_input ?>' placeholder='<?php echo ucfirst(str_replace("_"," ",$name_input)) ?>' value="<?php echo $_GET[$name_input] ?>">
			<?php
		}
	}


	// -----
	// RADIO 
	// 🔘 Crèche    o After school
	// -----
	if (isset($tab_search['radio']) && is_array($tab_search['radio']))
	{
		foreach($tab_search['radio'] as $name_input => $value)
		{
			$display_search = true;
		
			// name_input : type
	
			foreach( $value as $value => $value_display)
			{
				// value : 0 / 1
				// value_display : Employee / Resigned


				// Value 0 : SELECT * FROM creche_personnel WHERE `resigned` = '0'
				// Value 1 : SELECT * FROM creche_enfants   WHERE `resigned` = '1'
		
				$sql_table_specific = dbquery("SELECT * FROM ".$_GET['table_name']." WHERE `".$name_input."` = '".addslashes($value)."'");

				//echo "SELECT * FROM ".$_GET['table_name']." WHERE `".$name_input."` = '".addslashes($value)."'";
		
				$checked = " ";
				if ($_GET['type'] == $value)
					$checked = " checked";
				?>

				<input type='radio' name='<?php echo $name_input ?>' value='<?php echo $value ?>' <?php echo $checked ?>> <b><?php echo $value_display ?></b>&nbsp;(<?php echo dbnumrows($sql_table_specific) ?>)&nbsp;&nbsp;&nbsp;
		
				<?php
			}
		}
	}
	
	if ($display_search)
	{
		?>
		<button type="submit" style='display:inline' class='btn btn-secondary'>Recherche</button>
		<?php
	}
	?>
</form>


<!-- FORMULAIRE CHECKBOX -->
<?php
if (isset($bd_data_table[$_GET['table_name']]['options']) && is_array($bd_data_table[$_GET['table_name']]['options']))
{
	foreach($bd_data_table[$_GET['table_name']]['options'] as $key => $value)
	{
		if ($key == "link")
			$link = $value;

		if ($key == "bootstrapicon")
			$font_awesome = $value;
	}
}
?>

<form class='form_checkbox' style='width:900px' method="GET" action="<?php echo @$link ?>">
	<input type="hidden" name="table_name"	value="<?php echo $_GET['table_name'] ?>">

	<?php
	if ($checkbox)
	{
		?>
		<button id="submit_selection" class='btn btn-primary' type="submit"><i class="bi <?php echo $font_awesome ?>" aria-hidden="true"></i> Export de la selection</button>
		<?php
	}

	// =====================
	// CRUD SANS TABULATIONS
	// =====================
	if ($id_for_tab_column == "")
	{
		?>

		<table style="position:absolute;top:120px" class="table table-striped">
		<thead>
		<tr>
			<?php
			// Checkbox ?
			if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
			{
				foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
				{
					if (isset($value['checkbox']) && $value['checkbox'])
					{
						?>
						<th style='text-align:center'><input type='checkbox' name='check_uncheck_all' id='check_uncheck_all'>
						<?php
					}
				}
			}
			?>
			<th></th>
			<?php
			// Lien si disponible
			if (isset($bd_data_table[$_GET['table_name']]['options']))
			{
				?>
				<th>Lien</th>
				<?php
			}
			
			if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
			{
				foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
				{
					if (isset($value['display']) && $value['display'] == "none")
						continue;
					?>
					<th>
						<?php
						if (isset($value['label']))
							echo $value['label'];
						else
							echo ucfirst(str_replace("_"," ",$key))
						?>
					</th>
					<?php
				}
			}

			// link_connexe ?
			if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
			{
				foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
				{
					if (isset($value['link_connexe']) )
					{
						$link_connexe = $value['link_connexe'];
						?>
						<th>En relation</th>
						<?php
						
					}
				}
			}
			?>
		</tr>
		</thead>
		<tbody id="tablebody"></tbody>
		</table>

		<?php
	}
	else
	// =====================
	// CRUD AVEC TABULATIONS
	// =====================
	{
		$relation = array();
		if (isset($bd_data_table[$_GET['table_name']]['keys'][$id_for_tab_column]['relation']))
			$relation = $bd_data_table[$_GET['table_name']]['keys'][$id_for_tab_column];
		
			// $relation['display_field']		array("immobilier_biens.adresse_1","immobilier_biens.adresse_2");
		?>
		
		<div style='position:relative;top:10px; left:0px;width:900px;z-index:1;' id="tabs">
			<ul>
				<?php
				// SELECT DISTINCT(id_bien) FROM immobilier_travaux		
				$sql_table_tab = dbquery("SELECT DISTINCT(".$id_for_tab_column.") FROM ".$_GET['table_name']);

				for ($i=0;$i<dbnumrows($sql_table_tab);$i++)
				{
					$id_for_tab = dbresult($sql_table_tab,$i,$id_for_tab_column);

					// Pas de relation
					if (count($relation) == 0)
						$value_tab = $id_for_tab;
					else
					{
						$sql_displayed_field = "";
						
						foreach($relation['display_field'] as $displayed_field)
						{
							$sql_displayed_field .= $displayed_field.",";
						}

						$table_name = explode(".",$relation['relation']);

						// SELECT immobilier_biens.adresse_1,immobilier_biens.adresse_2 FROM immobilier_biens WHERE immobilier_biens.id_bien='2'
						$sql_field_name = dbquery("SELECT ".substr($sql_displayed_field,0,-1)." FROM ".$table_name[0]." WHERE ".$relation['relation']."='".$id_for_tab."'");
						if (dbnumrows($sql_field_name) > 0)
						{
							$value_tab = "";
							foreach($relation['display_field'] as $displayed_field)
							{
								$value_tab .= dbresult($sql_field_name,0,$displayed_field)." ";
							}
						}
					}
					?>
					<li><a href="#tabs-<?php echo $i ?>"><?php echo $value_tab ?></a></li>
					<?php
				}
				?>
			</ul>

			<?php
			for ($i=0;$i<dbnumrows($sql_table_tab);$i++)
			{
				$id_for_tab = dbresult($sql_table_tab,$i,$id_for_tab_column);


				// =======
				// Clients
				// =======

				// Exemple : SELECT * FROM immobilier_charges WHERE `id_bien`='1'
				$sql_table = dbquery("SELECT * FROM ".$_GET['table_name']." WHERE `".$id_for_tab_column."`='".$id_for_tab."'");
				?>
				<script type="text/javascript">
				<!--
				get_json('#tablebody-<?php echo $i ?>','title=<?php echo $_GET['title'] ?>&table_name=<?php echo $_GET['table_name'] ?>&<?php echo $id_for_tab_column ?>=<?php echo $id_for_tab ?>');
				//-->
				</script>

				<div id="tabs-<?php echo $i ?>">

					<table style="position:absolute;top:120px" class="table table-striped">
					<thead>
					<tr>
						<?php
						// Checkbox ?
						if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
						{
							foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
							{
								if (isset($value['checkbox']) && $value['checkbox'])
								{
									?>
									<th><input type="checkbox" name=""></th>
									<?php
								}
							}
						}
						?>
						<th></th>
						<?php
						// Lien si disponible
						if (isset($bd_data_table[$_GET['table_name']]['options']))
						{
							?>
							<th>Lien</th>
							<?php
						}
						
						if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
						{
							foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
							{
								// Ne pas afficher display=none
								// Ne pas afficher les key corresondant aux onglets le cas échéant
								if ((isset($value['display']) && $value['display'] == "none") || $id_for_tab_column == $key)
									continue;
								?>
								<th>
									<?php
									if (isset($value['label']))
										echo $value['label'];
									else
										echo ucfirst(str_replace("_"," ",$key))
									?>
								</th>
								<?php
							}
						}
						?>
					</tr>
					</thead>
					<tbody id="tablebody-<?php echo $i ?>"></tbody>
					</table>

				</div>
				<?php
			}
			?>
		</div>

		<?php
	}
	?>
</form>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/footer.inc.php");