<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");
libraries(array('PhpSpreadsheet'));
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/excel/xls_style_spreadsheet.inc.php");

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/crud/global.inc.php");

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;



function num2alpha($n)
{
	return \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($n);
}

// -------------------------------------
// Annnee universitaires
// --> Selection
// --> Ex: 2009-2010 2010-2011 2011-2012
// -------------------------------------

$xls_file_without_extension = $_GET['title'];



// Create new PHPExcel object
$spreadsheet = new Spreadsheet();


// ---------------------
// Name of the worksheet
// ---------------------
$spreadsheet->setActiveSheetIndex(0);



// ----------------
// Une seul feuille
// ----------------

$spreadsheet->getActiveSheet()->setTitle($_GET['title']);



// ------
// Header
// ------
$col = 0;

if (is_array($bd_data_table[$_GET['table_name']]['keys']))
{
	foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
	{
		if (isset($value['display']) && $value['display'] == "none")
			continue;
		
		if (isset($value['label']))
			$column_name = $value['label'];
		else
			$column_name =  ucfirst(str_replace("_"," ",$key));
		
		$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col++, $row=1, $column_name);
	}
}


// ----
// DATA
// ----
$sql_table = dbquery("SELECT * FROM ".$_GET['table_name']);

$row = 2;
for ($i=0;$i<dbnumrows($sql_table);$i++)
{
	$col = 0;
	foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
	{
		if (isset($value['display']) && $value['display'] == "none")
			continue;

		$display = "";
				
		if (isset($value['relation']) && $value['relation'] <> '' && dbresult($sql_table,$i,$key) <> '')
		{
			list($table,$field) = explode(".",$value['relation']);
					
			$sql_relation = dbquery("SELECT * FROM ".$table." WHERE ".$field."='".dbresult($sql_table,$i,$key)."'");

			$display = "";
			foreach($value['display_field'] as $value)
			{
				if (dbnumrows($sql_relation) > 0)
				{
					$display .= dbresult($sql_relation,0,$value)." ";
				}
			}
		}
		// Date
		elseif (isset($value['type']) && $value['type']=='date' && dbresult($sql_table,$i,$key) <> "")
		{
			$date_value = new DateTime(dbresult($sql_table,$i,$key));
			$display = $date_value->format('d/m/Y');
		}
		else
			$display = dbresult($sql_table,$i,$key);

		$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col++, $row, $display);
	}
	$row++;
}


$spreadsheet->setActiveSheetIndex(0);


// -------------------
// Format : Excel 2007
// -------------------
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$xls_file_without_extension.'.csv"');
header('Cache-Control: max-age=0');

$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Csv');
$objWriter->save('php://output');