<?php
// ============
// CRUD
// --> Add Form
// ============

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/crud/global.inc.php");

// TinyMCE
libraries(array('tinymce'));

// Si la table n'est pas defini dans le fichier global.inc.php
if (!array_key_exists($_GET['table_name'], $bd_data_table))
	die("ATTENTION : La table ".$_GET['table_name']." n'existe pas dans le fichier global.inc.php");
?>

<script> 
$(function() {


	// TINYMCE
	tinymce.init({
		relative_urls : false,
		remove_script_host : false,
		mode : "specific_textareas",
        editor_selector : "tinymce",
		language : 'fr_FR',
		language_url : "/lib/tinymce/6.0.1/js/tinymce/langs/fr_FR.js",
		plugins: [
			"advlist autolink lists link image charmap print preview hr anchor pagebreak",
			"searchreplace wordcount visualblocks visualchars code fullscreen",
			"insertdatetime media nonbreaking save table directionality",
			"emoticons template paste"
		],
		
		toolbar1: "formatselect | bold italic | forecolor backcolor |  alignleft aligncenter alignright | bullist numlist outdent indent | preview code ",
		image_advtab: true,
		templates: [
			{title: 'Test template 1', content: 'Test 1'},
			{title: 'Test template 2', content: 'Test 2'}
		]
	});

	// -------------------------------
	// Permet de valider le formulaire
	// avant de l'envoyer
	// -------------------------------
	$("#form_add").submit(function()
	{
		$.ajax({
			type:		"GET",
			url:		"/tourisme/base/config/crud/add.php",
			data:		$(this).serialize(),
			beforeSend:	function(){
				$('#form_add').html("Ajout en cours <span class='spinner-border spinner-border-sm' role='status' aria-hidden='true'></span>");
			},
			complete:	function(){	
			},
			success:	function(response){
				if (response == "ok")
					$('#form_add').html("Fiche ajoutée <i style='color:green' class='bi bi-check-lg' aria-hidden='true'></i>");
				else
					$('#form_add').html("Erreur : "+response);
			}
		});

		return false;
	});
});
//-->
</script> 


<form id="form_add" class="form-inline">
	<div class="title">Ajouter un <?php echo $_GET['title']?></div>

	<input type="hidden" name="table_name"		value="<?php echo $_GET['table_name']?>">
	<input type="hidden" name="nb_primary_key"	value="<?php echo $_GET['nb_primary_key']?>">


	<table cellspacing='0' cellpadding='5'>
	<?php
	foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
	{
		if (isset($value['display']) && $value['display'] == "none")
			continue;
		?>
		<tr>
			<td style='text-align:right'>
				<?php
				if (isset($value['label']))
					echo $value['label'];
				else
					echo ucfirst(str_replace("_"," ",$key))
				?>
			</td>
			<td align='left'>
				<?php
				if (isset($value['enum']) && $value['enum'] <> '')
				{
					?>
					<select class='form-select' name='<?php echo $key ?>' style='width:<?php echo $value['width'] ?>' <?php if ($value['required']) echo "required" ?>>
						<option value=''></option>
						
						<?php
						foreach($value['enum'] as $key_ => $value_)
						{
							//	<option value="Monday">Monday</option>
							//	<option value="Tuesday">Tuesday</option>
							//	<option value="Wednesday">Wednesday</option>
							//	<option value="Thurday">Thurday</option>
							//	<option value="Friday">Friday</option>
							//	<option value="Saturday">Saturday</option>
							//	<option value="Sunday">Sunday</option>
							?>
							<option value="<?php echo $key_ ?>"><?php echo $value_ ?></option>
							<?php
						}
						?>
					</select>
					<?php
				}
				elseif (isset($value['relation']) && $value['relation'] <> '')
				{
					list($table,$field) = explode(".",$value['relation']);
					
					// Existance d'une valeur					
					$this_value = "";
					if (isset($key) && isset($_GET[$key]))
						$this_value = $_GET[$key];
					?>
					
					<select class='form-select' name='<?php echo $key ?>' style='width:<?php echo $value['width'] ?>' <?php if ($value['required']) echo "required" ?>>
						<option value=''></option>
						<?php					
						$order_by = "";
						foreach($value['display_field'] as $value_)
						{
							$order_by .= $value_.",";
						}
						$order_by = substr($order_by,0,-1);
					
						$sql_relation = dbquery("SELECT * FROM ".$table." ORDER BY ".$order_by);
						for ($i=0;$i<dbnumrows($sql_relation);$i++)
						{
							$id_option = dbresult($sql_relation,$i,$field);
							
							$display = "";
							if (isset($value['display_field']) && is_array($value['display_field']))
							{
								foreach($value['display_field'] as $value_)
								{
									if (dbnumrows($sql_relation) > 0)
									{
										$display .= dbresult($sql_relation,$i,$value_)." ";
									}
								}
							}
							
							$selected = "";
							if ($this_value == $id_option)
								$selected = " selected";
					
							echo "<option value='".$id_option."'".$selected.">".$display."</option>";
						}
						?>
					</select>

					<?php
				}
				elseif (isset($value['type']) && $value['type'] == 'boolean')
				{
					?>
					<input type="checkbox"	name="<?php echo $key ?>" value="1">
					<?php
				}
				elseif (isset($value['type']) && $value['type'] == 'textarea')
				{
					?>
					<textarea class='<?php echo $value['class'] ?> form-control' name='<?php echo $key ?>' style='width:<?php echo $value['width'] ?>;height:<?php echo $value['height'] ?>'></textarea>
					<?php
				}
				elseif (isset($value['type']) && $value['type'] == "datetime")
				{
					?>
					<!-- Date + Time -->
					<input class='form-control' style='width:170px;display:inline' type="date" id="<?php echo $key ?>[date]" name="<?php echo $key ?>[date]" value="" <?php if ($value['required']) echo "required" ?>>
					<input class='form-control' style='width:100px;display:inline' type="time" id="<?php echo $key ?>[time]" name="<?php echo $key ?>[time]" value="" <?php if ($value['required']) echo "required" ?> >
					<?php
				}
				else
				{
					// Existance d'une valeur					
					$this_value = "";
					if (isset($key) && isset($_GET[$key]))
						$this_value = $_GET[$key];
					?>
					<!-- Date - Text - Email -->
					<input class='form-control' style='width:<?php echo $value['width'] ?>' type="<?php echo $value['type'] ?>" id="<?php echo $key ?>" name="<?php echo $key ?>" value="<?php echo addslashes($this_value) ?>" <?php if (@$value['required']) echo "required" ?>>
					<?php
				}
				?>	
			</td>
		</tr>
		<?php
	}
	?>
	</table>

	<table cellspacing='0' cellpadding='5' style='width:100%'>
	<tr>
		<td colspan="2" style="padding-top:15px;text-align:center">
		<?php
		$multiple_add = false;
		
		if (isset($bd_data_table[$_GET['table_name']]['options']) && is_array($bd_data_table[$_GET['table_name']]['options']))
		{
			foreach($bd_data_table[$_GET['table_name']]['options'] as $key => $value)
			{				
				if ($key == "multiple_add")
					$multiple_add = true;
			}
		}

		if ($multiple_add)
		{
			?>
			<input class="form-control" type="text" name="nb_rows_add" value="1" style="width:50px;display:inline">
			<button type='submit' class="btn btn-primary" style="width:200px;display:inline">Ajouter multiple lignes</button>
			<?php
		}
		else
		{
			?>
			<input type="hidden" name="nb_rows_add" value="1">
			<button type='submit' class="btn btn-primary" style="width:100px">Ajouter</button>
			<?php
		}
		?>
		
		</td>
	</tr>
	</table>
</form>