<!doctype html>

<html lang="fr">

<head>
	<meta charset="utf-8">
	<title>Cnam R&#233;union - Responsive Design</title>
	<script src="http://cdn.jquerytools.org/1.2.7/full/jquery.tools.min.js"></script>
	<link href='http://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css'>

	<style>
	
	img {
		border:0;
	}

	html,body{
		width:100%;
		height:100%;
		margin:0;
		padding:0;
		font-family: 'Open Sans', sans-serif;
		font-size:0.9em;
	}

	#scroll {
		position:relative;
		height:;
		overflow:hidden;
		width:100%;
		height:auto;
		-moz-border-radius:5px;
		-webkit-border-radius:5px;
	}

	#tools {
		width:9999em;
		position:relative;
		height:auto;
	}

	.tool {
		float:left;
		width:100%;
		height:2110px;
		text-align:center;
		position:relative;
	}

	.details {
		font-size:18px;
		color:#555;
		margin-top:-20px;
		background-color:transparent;
		padding:5px 148px;
	}

	#thumbs {
		position:fixed;
		bottom:0;
		left:0;
		width:100%;
		height:80px;
		background:#373736;
		z-index:90;
		text-align:center;
		-webkit-box-shadow:0 0 20px #000;
		box-shadow:0 0 20px #000;
	}

	.t {
		padding:0 !important;
		border:0 !important;
	}

	.t a.active {
		cursor:default !important;
		background:#fff;
		color:#fff !important;
		font-weight:bold;
	}

	.slide-btn	{
		height:13px;
		width:13px;
		margin-right:7px;
		border-radius:13px;
		display:inline-block;
		border:1px solid #eee;
		cursor:pointer !important;
		}

	.browse{
		position:fixed;
		bottom:7px;z-index:100;
	}

	.browse:hover{
		cursor:pointer !important;
	}

	.navi{
		width:800px;
		margin:0 auto;
		line-height:88px;
		height:80px;
		z-index:190;
		position:absolute;
		top:0;
		left:50%;
		margin-left:-400px;
		text-align:left;
		}

	#numerotation {
		width:800px;
		position:relative;
		z-index:100;
		height:80px;
		margin:0 auto;
		line-height:88px;
		text-align:left;
		padding-left:190px;
	}

	#numerotation a{
		height:34px;
		width:34px;
		line-height:34px;
		border-radius:18px;
		display:inline-block;
		text-align:center;
		margin-right:230px;
		font-size:18px;
		border:1px solid #000;
		color:#000;
		}

	.tool img{
		vertical-align:middle;
		}

	</style>

</head>

<body>
	
<!-- root element for everything -->	 
<div id="scroll">
 
<!-- scrollable items -->
	<div id="tools">
		
		<div class="tool">
			<img src="img/page-de-garde.png" style="width:100%"/>
		</div>

	<!-- 1 -->
		
		<div class="tool">
			<img src="img/rd-1.jpg" />
		</div>
		<div class="tool">
			<img src="img/rd-2.jpg">
		</div>
		<div class="tool">
			<img src="img/rd-3.jpg">
		</div>
		<div class="tool">
			<img src="img/rd-4.jpg">
		</div>
		<div class="tool">
			<img src="img/rd-5.jpg">
		</div>

	<!-- 2 -->
		
		<div class="tool">
			<a target="_blank" href="http://www.microsoft.com/fr-fr/default.aspx"><img src="img/logo-01.png"/></a>
			<a target="_blank" href="http://svds.com/"><img src="img/logo-02.png"/></a>
			<a target="_blank" href="http://teamtreehouse.com/"><img src="img/logo-03.png" style="height:60px"/></a>
		</div>
					
		<div class="tool">
			<img src="img/page-logos.png" style="width:100%"/>
		</div>

	<!-- 3 -->
		
		<div class="tool">
			<div id="menu-page-standard" class="menu" style="position:absolute;top:0;left:0;width:100%;height:150px;z-index:1000;background:url(img/menu-page-standard.png) center bottom no-repeat;"></div>
			<div id="corps-page-standard" style="position:absolute;top:80px;left:0;width:100%;height:2295px;background:url(img/corps-page-standard.png) center top no-repeat"></div>
		</div>

		<div class="tool">
			<div id="menu-accueil" class="menu" style="position:absolute;top:0;left:0;width:100%;height:150px;z-index:1000;background:url(img/menu-accueil.png) center bottom no-repeat;"></div>
			<div id="corps-accueil" style="position:absolute;top:80px;left:0;width:100%;height:1455px;background:url(img/corps-accueil.png) center top no-repeat"></div>
			<img src="img/bouton-slider-gauche.png" style="position:absolute;top:280px;left:50px;" />
			<img src="img/bouton-slider-droite.png" style="position:absolute;top:280px;right:50px;" />
		</div>

		<div class="tool">
			<img class="content" src="img/apercu-mobile.png" style="height:80%"/>
		</div>
		
		<div class="tool">
			<img class="content" src="img/apercu-tout-support.png" style="height:80%"/>
		</div>

	</div>


<a class="prev browse left" style="left:2%"><img src="img/bouton-nav-gauche.png" /></a>
<a class="next browse right" style="right:2%;"><img src="img/bouton-nav-droite.png" /></a>

<!-- thumbnails -->
<div id="thumbs" class="t" style="">
	
	<div id="numerotation">
		   <a id="num1">1</a><!--
		--><a id="num2">2</a><!--
		--><a id="num3">3</a>
	</div>

<!-- scrollable navigator root element -->
	<div class="navi">

		<!-- navigator items for the rest of the scrollable items -->

		   <a class="slide-btn active" style="margin-left:140px"></a><!--
		--><a class="slide-btn"></a><!--
		--><a class="slide-btn"></a><!--
		--><a class="slide-btn"></a><!--
		--><a class="slide-btn"></a><!--
		--><a class="slide-btn"></a><!--

		--><a class="slide-btn" style="margin-left:135px;"></a><!--
		--><a class="slide-btn"></a><!--
		
		--><a class="slide-btn" style="margin-left:220px;"></a><!--		
		--><a class="slide-btn"></a><!--
		--><a class="slide-btn"></a><!--
		--><a class="slide-btn"></a>			
	</div>

</div>
 
	

<script>
	function height_adjust(){
		var window_height	= $(window).height();
		$('.tool').css("height",window_height+1+"px");
		$('.tool').css("line-height",window_height-100+"px");
	}

	function tool(){
		var window_width	= $(window).width();
		$(".tool").width(window_width);
	}


	function menu_scroll(){
		var interval = setInterval(function() {

			var menu_height		= $("#menu-page-standard").css("height");
			tool();

			if ( $(window).scrollTop() >= 150 ) {
				if( menu_height == "150px"){
					$(".menu").animate({height: "110px"});
				}
			}
			else{
				if( menu_height == "110px"){
					$(".menu").animate({height: "150px"});
				}
			}	
		}, 250);
	}
	
$(window).bind("keypress",function(e){
    var value = e.keyCode;
	if( value == 0 ){

		var index = $("#scroll").scrollable().getIndex();
		var hgt = $('.tool').height();
		var bottom = $('#thumbs').css('bottom');

		//alert(bottom);
		
		if( bottom == '0px'){
			$('.browse').animate({bottom: '-80px'});
			$('#thumbs').animate({bottom: '-80px'});

			if(index == 9 || index == 8){
				$('.tool').animate({height: hgt-80+'px'});
			}
		}
		else{
			$('.browse').animate({bottom: '0px'});
			$('#thumbs').animate({bottom: '0px'});

			if(index == 9 || index == 8){
				$('.tool').animate({height: hgt+80+'px'});

				 var $win = $(window);

				if ($win.height() + $win.scrollTop() == $(document).height()) 
					$('html, body').animate({scrollTop:$(document).height()}, 'slow');
			}
		}
						
	}

});
	$(window).load(tool(),menu_scroll(),height_adjust());

	$("#scroll").scrollable({ 
		items: '#tools' , 
		circular: true, 
		onBeforeSeek: function(){ 
				$('html,body').animate({scrollTop: 0}, 0);
				$("#menu-accueil").css('position','absolute');
				$("#menu-page-standard").css('position','absolute');
			},
		onSeek: function(){
					var window_height	= $(window).height();
					var index = $("#scroll").scrollable().getIndex();
					var bottom = $('#thumbs').css('bottom');

					if(index < 7 ){
						height_adjust();
					}	
					if(index == 8){
						if( bottom == '0px')
							$('.tool').css("height","2455px");
						else 
							$('.tool').css("height","2375px");
						$("#menu-page-standard").css({'position':'fixed'});
					}
					if(index == 9 ){
						if( bottom == '0px')
							$('.tool').css("height","1615px");
						else 
							$('.tool').css("height","1535px");
						$("#menu-accueil").css({'position':'fixed'});
					}
					if(index == 10 ){
						height_adjust();
					}
					if(index == 11 ){
						height_adjust();
					}

				}
	}).navigator();

</script>

</body>

</html>

