$(document).ready(function() {
	
	redrawDotNav();
	
	/* Scroll event handler */
    $(window).bind('scroll',function(e){
    	parallaxScroll();
		redrawDotNav();
    });

	/* Next/prev and primary nav btn click handlers */
	$('a.presentation').click(function(){
    	$('html, body').animate({
    		scrollTop:0
    	}, 2400, function() {
	    	parallaxScroll(); // Callback is required for iOS
		});
    	return false;
	});
    $('a.formations').click(function(){
    	$('html, body').animate({
    		scrollTop:$('#formations').offset().top
    	}, 2400, function() {
	    	parallaxScroll();
		});
    	return false;
    });
    $('a.experiences').click(function(){
    	$('html, body').animate({
    		scrollTop:$('#experiences').offset().top
    	}, 2400, function() {
	    	parallaxScroll(); 
		});
    	return false;
    });
	$('a.competences').click(function(){
    	$('html, body').animate({
    		scrollTop:$('#competences').offset().top
    	}, 2400, function() {
	    	parallaxScroll(); 
		});
    	return false;
    });
	$('a.realisations').click(function(){
    	$('html, body').animate({
    		scrollTop:$('#realisations').offset().top
    	}, 2400, function() {
	    	parallaxScroll(); 
		});
    	return false;
    });     
});

/* Scroll the background layers */
function parallaxScroll(){
	var scrolled = $(window).scrollTop();
	$('#parallax-bg2').css('top',(0+(scrolled*.25))+'px');
	$('#parallax-bg3').css('top',(0+(scrolled*.5))+'px');
	$('#parallax-bg5').css('top',(0+(scrolled*.25))+'px');
	$('#parallax-bg6').css('top',(0+(scrolled*.5))+'px');
	$('#parallax-bg8').css('top',(0+(scrolled*.5))+'px');
}

/* Set navigation dots to an active state as the user scrolls */
function redrawDotNav(){
	var section1Top =  0;
	// The top of each section is offset by half the distance to the previous section.
	var section2Top =  $('#formations').offset().top - (($('#experiences').offset().top - $('#formations').offset().top) / 2);
	var section3Top =  $('#experiences').offset().top - (($('#competences').offset().top - $('#experiences').offset().top) / 2);
	var section4Top =  $('#competences').offset().top - (($('#realisations').offset().top - $('#competences').offset().top) / 2);
	var section5Top =  $('#realisations').offset().top - (($(document).height() - $('#realisations').offset().top) / 2);
	$('nav#primary a').removeClass('active');
	if($(document).scrollTop() >= section1Top && $(document).scrollTop() < section2Top){
		$('nav#primary a.presentation').addClass('active');
	} else if ($(document).scrollTop() >= section2Top && $(document).scrollTop() < section3Top){
		$('nav#primary a.formations').addClass('active');
	} else if ($(document).scrollTop() >= section3Top && $(document).scrollTop() < section4Top){
		$('nav#primary a.experiences').addClass('active');
	} else if ($(document).scrollTop() >= section4Top && $(document).scrollTop() < section5Top){
		$('nav#primary a.competences').addClass('active');
	} else if ($(document).scrollTop() >= section5Top){
		$('nav#primary a.realisations').addClass('active');
	}	
}