<?php
// =============
// CONSULTATIONS
// --> pdf
// =============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
libraries(array('TCPDF'));



// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)



// $_GET['orientation'] prend les valeurs
// --> portrait
// --> landscape

// extend TCPF with custom functions
class MYPDF extends TCPDF
{
    // Table Landscape
    public function TableLandscape($header,$data) {
        // Colors, line width and bold font
        $this->SetFillColor(255);
        $this->SetTextColor(0);
        $this->SetDrawColor(0);
        $this->SetLineWidth(0.2);
        $this->SetFont('', 'B',10);
        // Header
        $w = array(8, 40, 35, 10, 25, 15, 47, 40, 43);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $this->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $this->Ln();
        // Color and font restoration
        $this->SetFillColor(255);
        $this->SetTextColor(0);
        $this->SetFont('');

		// Data
        foreach($data as $row) {
   			// Numéro
			$this->Cell($w[0], 15, $row[0], 'LRTB', 0, 'C', true);
            
			// Nom + Prénom
			$this->Cell($w[1], 15, $row[1], 'LRTB', 0, 'L', true);
            $this->Cell($w[2], 15, $row[2], 'LRTB', 0, 'L', true);

			// Age
			$this->MultiCell($w[3], 15, $row[3], 1, "C", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false );
 			
			// Horaire
			$this->Cell($w[4], 15, $row[4], 'LRTB', 0, 'C', true);

			// ====================================
			// COULEUR
			// Type (Cs, Depr, EFR, PV, PSG, Autre)
			// ====================================
			$sql_background_color = dbquery("SELECT background_color
				FROM type_rendez_vous
				WHERE abrege='".$row[5]."'");
			if (dbnumrows($sql_background_color) > 0)
			{
				$background_color = new Color();
				$background_color->Hex(dbresult($sql_background_color,0,"background_color"));
				$background_color->adjustColorLightenDarken(0);
				
				$this -> setFillColor($background_color->red,$background_color->green,$background_color->blue);
			}
			$this -> Cell($w[5], 15, $row[5], 'LRTB', 0, 'C', true);
			$this -> setFillColor(255,255,255);
			
			
			// Médecin traitant
			$this->MultiCell($w[6], 15, $row[6], 1, "L", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false);
			
			// Adresse
			$this->MultiCell($w[7], 15, $row[7], 1, "L", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false);

			// ---------
			// TELEPHONE
			// ---------
			$this -> setFillColor(255,255,255);
			$this->MultiCell($w[8], 15, $row[8], 1, "L", true,$ln=1,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false);
        }
    }

	// Table Portrait
    public function TablePortrait($header,$data) {
        // Colors, line width and bold font
        $this->SetFillColor(255);
        $this->SetTextColor(0);
        $this->SetDrawColor(0);
        $this->SetLineWidth(0.2);
        $this->SetFont('', 'B',10);
        // Header
        $w = array(8, 35, 30, 10, 15, 10, 20,25,28);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $this->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $this->Ln();
        // Color and font restoration
        $this->SetFillColor(255);
        $this->SetTextColor(0);
        $this->SetFont('');

		// Data
        foreach($data as $row)
		{
			// Numéro
			$this->Cell($w[0], 15, $row[0], 'LRTB', 0, 'C', true);
			
			// Nom + Prénom
			$this->MultiCell($w[1], 15, $row[1], 1, "L", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false);
			$this->Cell($w[2], 15, $row[2], 'LRTB', 0, 'L', true);

			// Age
			$this->MultiCell($w[3], 15, $row[3], 1, "C", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false );
   			
			// Horaire
			$this->MultiCell($w[4], 15, $row[4], 1, "C", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false );
   			
			// ====================================
			// COULEUR
			// Type (Cs, Depr, EFR, PV, PSG, Autre)
			// ====================================
			$sql_background_color = dbquery("SELECT background_color
				FROM type_rendez_vous
				WHERE abrege='".$row[5]."'");
			if (dbnumrows($sql_background_color) > 0)
			{
				$background_color = new Color();
				$background_color->Hex(dbresult($sql_background_color,0,"background_color"));
				$background_color->adjustColorLightenDarken(0);
				
				$this -> setFillColor($background_color->red,$background_color->green,$background_color->blue);
			}
			$this -> Cell($w[5], 15, $row[5], 'LRTB', 0, 'C', true);
			$this -> setFillColor(255,255,255);

			// -------
			// SOCIETE
			// -------
			$this->MultiCell($w[6], 15, $row[6], 1, "L", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false);


			// -----------
			// COMMENTAIRE
			// -----------
			$this->MultiCell($w[7], 15, $row[7], 1, "L", true,$ln=0,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false);


			// ---------
			// TELEPHONE
			// ---------
			$this->MultiCell($w[8], 15, $row[8], 1, "L", true,$ln=1,$x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 15, $valign = 'M',$fitcell = false);
        }
    }
}




// create new PDF document
$pdf = new MYPDF($_GET['orientation'], 'mm', 'A4', true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Tanguy');
$pdf->SetTitle('Consultation Dr Tanguy');
$pdf->SetSubject('Consultation Dr Tanguy');
$pdf->SetKeywords('Consultation Dr Tanguy');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(50);
$pdf->SetLeftMargin(14);
$pdf->SetRightMargin(14);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetTextColor(0,0,0);





// ============================
// A partir de 1E DE COUVERTURE
// ============================


$table_date = array_values($_GET['date']);


// $table_date
//Array
//(
//	[0] => 2012-09-01
//	[1] => 2012-11-01
//	[2] => 2012-12-01
//)
// --> Septembre
// --> Novembre
// --> Decembre

foreach($table_date as $value)
{
	$date	= new DateTime($value);

	// ----
	// Mois
	// ----
	$mois = $date->format('F');
	
	// Si page impaire : ajoute une page
	if ($pdf->getPage() %2 == 1)	$pdf -> AddPage($_GET['orientation']);
	

	// Premiere page avec le mois
	if ($_GET['orientation'] == 'landscape')
	{
		$pdf -> AddPage('landscape');

		$pdf -> SetFont('Helvetica', '', 30);
		$pdf -> setColor('text',38,127,0);
		$pdf -> SetXY(90,105);
		$pdf -> Cell(117,0, ucfirst($dico[$date->format('F')])." ".$date->format('Y'),     1, $ln=0,'C', false,'', $stretch=0, false, 'C','C');
	}

	// Tant qu'on reste dans le meme mois
	while($date->format('F') == $mois )
	{
		if ($date->format('l') <> "Saturday" && $date->format('l') <> "Sunday")
		{
			$pdf -> AddPage($_GET['orientation']);

			// Les jours
			$pdf -> SetFont('Helvetica', '', 20);

			
			$date_du_jour = ucfirst($dico[$date->format('l')])." ".$date->format('j')." ".ucfirst($dico[$date->format('F')])." ".$date->format('Y');

			if (isset($_GET['type']))
			{
				$date_du_jour = "Semaine du ".$date_du_jour." (";
			
				$sql_type_rendez_vous = dbquery("SELECT type_rendez_vous.abrege
					FROM type_rendez_vous,personnel_type_rendez_vous
					WHERE personnel_type_rendez_vous.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
						AND personnel_type_rendez_vous.id_personnel = '".$_SESSION['id_personnel']."'");

				for ($i=0;$i<dbnumrows($sql_type_rendez_vous);$i++)
				{
					$date_du_jour .= " ".dbresult($sql_type_rendez_vous,$i,"type_rendez_vous.abrege")." ";
				}

				$date_du_jour = $date_du_jour.")";
			}
			
			// ------
			// Congés
			// ------
			$sql_personnel_conges = dbquery("SELECT *
				FROM personnel,personnel_conges
				WHERE personnel.id_personnel=personnel_conges.id_personnel
					AND DATE(personnel_conges.datetime_debut) <= '".$date->format('Y-m-d')."'
					AND DATE(personnel_conges.datetime_fin) >= '".$date->format('Y-m-d')."'
				ORDER BY personnel_conges.datetime_debut ASC");
			
			if (dbnumrows($sql_personnel_conges) > 0)$en_conges = "En congé : ";
			
			for ($i=0;$i<dbnumrows($sql_personnel_conges);$i++)
			{
				$id_personnel		= dbresult($sql_personnel_conges,$i,"personnel.id_personnel");
				$personnel_nom		= dbresult($sql_personnel_conges,$i,"personnel.nom");
				$personnel_prenom	= dbresult($sql_personnel_conges,$i,"personnel.prenom");
				$datetime_debut		= new DateTime(dbresult($sql_personnel_conges,$i,"personnel_conges.datetime_debut"));
				$datetime_fin		= new DateTime(dbresult($sql_personnel_conges,$i,"personnel_conges.datetime_fin"));

				$periode_conge		= format_periode_horaire($datetime_debut,$datetime_fin);
				$en_conges .= $personnel_prenom." ".$personnel_nom." (".$periode_conge.")\n";
			}
			$en_conges = trim($en_conges);
			$pdf -> setColor('text',255,0,0);
			$pdf -> SetFont('Helvetica','B',11);
			$pdf -> MultiCell(200,12, $en_conges, $border='', 'R', $fill=false,$ln=2, 0,15);
			

			// ------------
			// Date du jour
			// ------------
			$pdf -> setColor('text',0,0,0);
			$pdf -> SetXY(15,20);
			$pdf -> Cell(0,0, $date_du_jour,     0, $ln=0,'L', false,'', $stretch=0, false, 'C','C');


			// -----------
			// Rendez vous
			// -----------
			if (isset($_GET['type']))
			{				
				// Semaine entiere
				// Type selectionné
				$sql_agenda = dbquery("SELECT *
					FROM clients,agenda,type_rendez_vous,personnel_type_rendez_vous
					WHERE clients.id_client = agenda.id_client
						AND agenda.id_type_rendez_vous = personnel_type_rendez_vous.id_type_rendez_vous
						AND personnel_type_rendez_vous.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
						AND personnel_type_rendez_vous.id_personnel = '".$_SESSION['id_personnel']."'
						AND deces = '0'
					AND DATE(agenda.datetime_debut) >= '".$date->format('Y-m-d')."'
					AND DATE(agenda.datetime_debut) <= '".$date->modify('+6 day')->format('Y-m-d')."'
					ORDER BY datetime_debut ASC, clients.nom ASC, clients.prenom ASC");
			}
			else
			{
				// Jour uniquement
				// Tout type
				$sql_agenda = dbquery("SELECT *
					FROM clients,agenda,type_rendez_vous
					WHERE clients.id_client = agenda.id_client
						AND agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
						AND deces = '0'
						AND DATE(agenda.datetime_debut)='".$date->format('Y-m-d')."'
					ORDER BY datetime_debut ASC, clients.nom ASC, clients.prenom ASC");
			}			

			$rendez_vous = array();
			
			$_date = new DateTime();
			for ($i=0;$i<dbnumrows($sql_agenda);$i++)
			{
				$id_client		= dbresult($sql_agenda,$i,"clients.id_client");
				$id_agenda		= dbresult($sql_agenda,$i,"agenda.id_agenda");
				
				$datetime_debut	= new datetime(dbresult($sql_agenda,$i,"agenda.datetime_debut"));
				$datetime_fin	= new datetime(dbresult($sql_agenda,$i,"agenda.datetime_fin"));
				
				$rendez_vous[$i]['nom']					= dbresult($sql_agenda,$i,"clients.nom");
				$rendez_vous[$i]['prenom']				= dbresult($sql_agenda,$i,"clients.prenom");
				$date_naissance							= new DateTime(dbresult($sql_agenda,$i,"clients.date_naissance"));

				$rendez_vous[$i]['age']					= $date_naissance->diff($_date)->format('%y');
				
				if (isset($_GET['type']))
					// Type précisé : Lundi 
					$rendez_vous[$i]['horaire']			= ucfirst($dico_abrege[$datetime_debut->format('l')])." ".$datetime_debut->format('j')." ".$dico_abrege[$datetime_debut->format('F')]." ".$datetime_debut->format('H:i');
				else
					// Heure (hh:mm)
					$rendez_vous[$i]['horaire']			= $datetime_debut->format('H:i');
				
				$rendez_vous[$i]['type_rendez_vous']	= dbresult($sql_agenda,$i,"type_rendez_vous.abrege");
				$rendez_vous[$i]['societe']				= dbresult($sql_agenda,$i,"agenda.societe");
				$rendez_vous[$i]['commentaire']			= dbresult($sql_agenda,$i,"agenda.commentaire");
		

				$rendez_vous[$i]['medecin_traitant']	= dbresult($sql_agenda,$i,"clients.medecin_traitant");
				$rendez_vous[$i]['adresse']				= dbresult($sql_agenda,$i,"clients.code_postal")." ".dbresult($sql_agenda,$i,"clients.ville");
				
				// --------------
				// Les téléphones
				// --------------
				$rendez_vous[$i]['telephone']			= "";
				$sql_client_telephone = dbquery("SELECT *
					FROM clients_telephone
					WHERE id_client = '".$id_client."'
					ORDER BY type_telephone ASC");
				for ($j=0;$j<dbnumrows($sql_client_telephone);$j++)
				{
					$type_telephone	= dbresult($sql_client_telephone,$j,"type_telephone");
					$telephone		= dbresult($sql_client_telephone,$j,"telephone");
					$contact		= dbresult($sql_client_telephone,$j,"contact");
					
					$rendez_vous[$i]['telephone']	.= " ".$telephone;
					if ($contact <> '')	$rendez_vous[$i]['telephone']	.= " (".$contact.")";
					$rendez_vous[$i]['telephone']	.= "\n";
				}
			}


			//Column titles
			if ($_GET['orientation'] == 'landscape')
			{
				$header = array('N°', 'Nom', 'Prénom', 'Âge', 'Horaire', 'Type', 'Société', 'Commentaire', 'Médecin traitant', 'Adresse', 'Téléphone');
				$nb_lignes = 10;
			}
			else
			{
				$header = array('N°', 'Nom', 'Prénom', 'Âge', 'Horaire', 'Type', 'Société', 'Commentaire', 'Téléphone');
				$nb_lignes = 16;
			}

			$nb_pages = floor(dbnumrows($sql_agenda)/$nb_lignes);

			for ($i=0;$i<=$nb_pages;$i++)
			{
				// Ajoute une page sauf la premiere
				if ($i > 0)
					$pdf -> AddPage($_GET['orientation']);


				// Tout les jours de la semaine : Page 1
				$data = array();
				
				for ($j=1;$j<=$nb_lignes;$j++)
				{	
					if ($i*$nb_lignes+$j-1 <= count($rendez_vous)-1)
						$data[$j] = array (
							$i*$nb_lignes+$j,
							$rendez_vous[$i*$nb_lignes+$j-1]['nom'],
							$rendez_vous[$i*$nb_lignes+$j-1]['prenom'],
							$rendez_vous[$i*$nb_lignes+$j-1]['age'],
							$rendez_vous[$i*$nb_lignes+$j-1]['horaire'],
							$rendez_vous[$i*$nb_lignes+$j-1]['type_rendez_vous'],
							$rendez_vous[$i*$nb_lignes+$j-1]['societe'],
							$rendez_vous[$i*$nb_lignes+$j-1]['commentaire'],
							//$rendez_vous[$i*$nb_lignes+$j-1]['medecin_traitant'],
							//$rendez_vous[$i*$nb_lignes+$j-1]['adresse'],
							$rendez_vous[$i*$nb_lignes+$j-1]['telephone']);
				}

				$pdf -> SetY(30);
				
				if ($_GET['orientation'] == 'landscape')
					$pdf->TableLandscape($header, $data);
				else
					$pdf->TablePortrait($header, $data);
			}
		}

		// PORTRAIT
		// --> Un seul jour
		if ($_GET['orientation'] == 'portrait')
			break;

	
		$date->modify("+ 1 day");
	}
}


// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('consultation.pdf', 'I');