<?php
// ==========================
// Bibliotheques de fonctions
// ==========================

function libraries($tab_libraries)
{
	if (is_array($tab_libraries))
	{
		// --------
		// JS + css
		// --------
		
		$in_libraires = "";
		foreach ($tab_libraries as $name_library)
		{
			$in_libraires .= "'".$name_library."',";
		}
		$in_libraires = substr($in_libraires,0,-1);

		$sql_libraries = dbquery("SELECT *
			FROM libraries,libraries_files,libraries_version
			WHERE libraries.id_library = libraries_files.id_library
				AND libraries_files.id_library_file = libraries_version.id_library_file
				AND libraries.name IN (".$in_libraires.")
				AND libraries_version.active='1'
			ORDER BY libraries_files.id_library_file ASC");
		
		for ($i=0;$i<dbnumrows($sql_libraries);$i++)
		{
			$name			= dbresult($sql_libraries,$i,"libraries.name");
			$type_library	= dbresult($sql_libraries,$i,"libraries.type");
			$description	= dbresult($sql_libraries,$i,"libraries_files.description");
			$type			= dbresult($sql_libraries,$i,"libraries_files.type");
			$src			= dbresult($sql_libraries,$i,"libraries_version.src");
			$version		= dbresult($sql_libraries,$i,"libraries_version.version");
			$integrity		= dbresult($sql_libraries,$i,"libraries_version.integrity");

			if ($type_library == "JS+CSS")
			{
				if ($type == "js")
				{
					?>
					<!-- <?php echo $name." ".$description ?> (JS) -->
					<script src="<?php echo $src ?>" <?php if ($integrity <> "") echo "integrity='".$integrity."'" ?> crossorigin="anonymous"></script>
					<?php
				}
				else if ($type == "css")
				{
					?>
					<!-- <?php echo $name." ".$description ?> (CSS) -->
					<link rel="stylesheet" href="<?php echo $src ?>" <?php if ($integrity <> "") echo "integrity='".$integrity."'" ?> crossorigin="anonymous">
					<?php
				}
			}
			else
			{
				// Bibliotheque PHP
				// Exemple : /lib/tcpdf/6.2.13/tcpdf.php
				require($_SERVER['DOCUMENT_ROOT'].$src);
			}
		}
	}
}

class Color
{
	var $red;
	var $green;
	var $blue;
	
	function Hex($hex)
	{
		$this->hex		= str_replace("#", "", $hex);

		$this->red		= hexdec(substr($this->hex,0,2));
		$this->green	= hexdec(substr($this->hex,2,2));
		$this->blue		= hexdec(substr($this->hex,4,2));
    }

	function RGB($red,$green,$blue)
	{
		$this->hex		= $red.$green.$blue;

		$this->red		= $red;
		$this->green	= $green;
		$this->blue		= $blue;
    }

	function adjustColorLightenDarken($percentage_adjuster)
	{
		$percentage_adjuster = round($percentage_adjuster/100,2);
		$r = $this->red		- (round($this->red)*$percentage_adjuster);
		$g = $this->green	- (round($this->green)*$percentage_adjuster);
		$b = $this->blue	- (round($this->blue)*$percentage_adjuster);

		$this->red		= round(max(0,min(255,$r)));
		$this->green	= round(max(0,min(255,$g)));
		$this->blue		= round(max(0,min(255,$b)));
	}
}


// Nous créons une classe « Personnage ».
class NumeroNIR
{
	public $numero_nir;

	public function __construct($numero_nir)
	{
		$this->numero_nir = $numero_nir;
	}

	// Format avec espace
	public function format_espace()
	{
		$this -> numero_nir = preg_replace('/[^0-9]/','',$this -> numero_nir);  // supression sauf chiffres

		$regex = '([0-9]{1})([0-9]{1,2})([0-9]{1,2})([0-9]{1,2})([0-9]{1,3})([0-9]{1,3})([0-9]{1,2})';
		return ereg_replace($regex, '\\1 \\2 \\3 \\4 \\5 \\6 \\7',$this -> numero_nir);
		// Exemple : 1 77 11 57 672 101 64
	}
 
	// Format avec espace
	public function format_espace_cle()
	{
		return substr($this -> numero_nir,0,13)." ".substr($this -> numero_nir,-2);
	}

	// Format avec espace
	public function cle()
	{
		return substr($this -> numero_nir,-2);
	}

	// Format avec espace
	public function sans_cle()
	{
		return substr($this -> numero_nir,0,13);
	}
}

// Affiche le rubban
function affiche($ribbon,$libelle,$top)
{
	$left_block = 2;
	echo "<div style='position:absolute;top:".$top."px'>";
	foreach($ribbon as $key => $value)
	{	
		$width = count($value)*60+10;
		$top_cadre = 6;
		$top_libelle = 44;
		$top_libelle_global = 76;
		?>
		<div style='position:absolute;top:<?php echo $top_cadre ?>px;left:<?php echo $left_block ?>px;width:<?php echo $width ?>px;height:96px;background-image:url(/images/icones/ribbon_background/middle.png)'>

			<span style='position:absolute;text-align:center;top:<?php echo $top_libelle_global ?>px;width:<?php echo $width ?>px;font-size:8pt;color:#340030;font-weight:bold'><?php echo $libelle[$key] ?></span>

			<img style='position:absolute;top:0px;left:0px;height:96px' src="/images/icones/ribbon_background/left.png" border="0">
 
			<?php
			$left_icon = 5;
			foreach($value as $key2 => $value2)
			{	
				echo "<div style='position:absolute;top:10px;left:".$left_icon."px;width:60px;text-align:center;font-size:8pt;padding:0px'>";

				if ($value2['url'] <> '')
					echo "<a ".$value2['href_default_option']." href='".$value2['url']."'>";
				
				if (preg_match('/48px/',$value2['icone']))
					echo "<img id='".$value2['id']."' class='".$value2['image_default_class']."' style='position:absolute;top:0px;left:6px' src='".$value2['icone']."' width='48' height='48' border='0' alt='Ajouter'>";
				else
					echo "<i id='".$value2['id']."' style='position:relative;top:10px;color:".$value2['icone_color'].";background-color:white' class='fa ".$value2['icone']." fa-3x' aria-hidden='true'></i>";

				if ($value2['url'] <> '')	echo "</a>";

				echo "<div style='position:absolute;top:".$top_libelle."px;left:0px;width:60px;color:#340030;font-weight:bold'>".$value2['libelle']."</div>";

				echo "</div>";

				$left_icon += 60;
			}
			?>

			<img style='position:absolute;top:0px;right:0px;height:96px' src="/images/icones/ribbon_background/right.png" border="0">

		</div>

		<?php
		$left_block += $width+4;
	}
	echo "</div>";
}


// extend DateTime with custom functions
class MyDateTime extends DateTime
{
	// Premier lundi de la semaine
	public function change_to_last_monday() {
		while ($this->format('l') <> 'Monday')
		{
			$this->modify('-1 day');
		}
	}

	// Premier lundi de la semaine
	public function change_to_next_monday() {
		while ($this->format('l') <> 'Monday')
		{
			$this->modify('+1 day');
		}
	}
}


// ------------------------------------
// Format datetime_debut / datetime_fin
// --> Ex : 7h - 8h30
// ------------------------------------
function format_periode_horaire($datetime_debut,$datetime_fin) 
{
	if ($datetime_debut->format('H:i').$datetime_fin->format('H:i') == '00:0023:59')
		return "Journ. complete";
	else
	{
		$string = $datetime_debut->format('G')."h".$datetime_debut->format('i')." - ".$datetime_fin->format('G')."h".$datetime_fin->format('i');

		return str_replace('h00','h',$string);
	}
}



// -----------------------------------
// Format date SQL --> Format francais
// --> Ex : 2007-12-25 --> 25/12/2007
// -----------------------------------
function date_iso_fr($date) 
{
	if ($date <> "" && $date <> "0000-00-00")
	{
		$date_tab = array();
		$date_tab = explode("-",$date);
		$date_fr = $date_tab[2]."/".$date_tab[1]."/".$date_tab[0];
	}	

	return $date_fr;
}


// -------------------------------------------------
// Format ISO --> Format francais
// --> Ex : 2007-12-25 --> Mercredi 25 décembre 2007
// -------------------------------------------------
function date_iso_fr_complete($date) 
{
	global $dico;
	
	if ($date <> "")
	{
		$date = new datetime($date);

		$year		= $date->format("Y");
		$mois		= $dico[$date->format("F")];
		$day		= $date->format("j");
		$day_week	= $dico[$date->format("l")];

		$date_fr_complete = $day_week." ".$day." ".$mois." ".$year;
	}	

	return $date_fr_complete;
}


// ----------------------------------
// Format SQL --> Format francais
// --> Ex : 25/12/2007 --> 2007-12-25
// ----------------------------------
function date_fr_iso($date) 
{
	if ($date <> "")
	{
		$date_tab = explode("/",$date);
		$date = $date_tab[2]."-".$date_tab[1]."-".$date_tab[0];
	}
	return $date;
}


// -----------------------------
// Fonction d'affichage d'erreur
// -----------------------------
function error( $libelle_erreur )
{
	?>
	<div class="ui-widget" style="margin-top:60px">
		<div class="ui-state-error ui-corner-all" style="padding: 0 .7em;">
			<p><span class="ui-icon ui-icon-alert" style="float: left; margin-right: .3em;"></span>
			<strong>Erreur :</strong> <?php echo $libelle_erreur ?></p>
		</div>
	</div>
	<?php
	
	$sql_query = "INSERT INTO log_error
		VALUES ('".date("Y-m-d H:i:s")."',
				'".addslashes($libelle_erreur)."',
				'".$_SESSION['id_personnel']."',
				'".$_SERVER['REMOTE_ADDR']."',
				'".$_SERVER["REQUEST_URI"]."')";
	dbquery($sql_query);
	exit;
}

// --------------------
// Affiche des messages
// --------------------
function display_message_box($text,$type)
{
	// type = notice / warning / error / ok
	// Fonctionne avec Twitter Bootstrap
	// $type = danger / success / info
	
	if ($text <> "")	echo "<div class='alert alert-".$type."' style='width:266px'>".$text."</div>";
}



// -----------------
// Est ferié ?
// renvoi un booleen
// -----------------
function is_ferie($date)
{
	$date = new datetime($date);

	$sql_date = dbquery("SELECT * FROM jours_feries WHERE date='".$date."'");

	if (dbnumrows($sql_date) > 0)	return true;
	else return false;
}

// ----------------------------
// Renvoie le nom du jour ferié
// ----------------------------
function nom_jour_ferie($date)
{
	$date = new datetime($date);

	$mois_jour	= $date->format("m-d");
	$annee		= $date->format("Y");
	
	$sql_date = dbquery("SELECT nom FROM jours_feries WHERE mois_jour='".$mois_jour."' AND (annee=".$annee." OR annee='0000')");

	if (dbnumrows($sql_date) > 0)	return dbresult($sql_date,0,"nom");
	else return "";
}


function numero_telephone($tel)
{
	$tel = preg_replace('/[^0-9]/',"",$tel);	// supression sauf chiffres

	$regex = '([0-9]{1,2})([0-9]{1,2})([0-9]{1,2})([0-9]{1,2})([0-9]{1,2})';
	return ereg_replace($regex, '\\1 \\2 \\3 \\4 \\5',$tel); // Exemple : 02 62 12 23 45
}



// -----------------------------
// Verifie si l'email est valide
// renvoi un booleen
// -----------------------------
function check_mail($email)
{
	if (eregi("^[_\.0-9a-z-]+@([0-9a-z][-0-9a-z\.]+)\.([a-z]{2,4}$)", $email, $check))	return true;
	else	return false;
}


function param($id_param)
{	
	$sql_param = dbquery("SELECT * FROM params WHERE id_param='".$id_param."'");

	if (dbnumrows($sql_param) > 0)	return dbresult($sql_param,0,"texte");
}

function wd_remove_accents($str, $charset='utf-8')
{
    $str = htmlentities($str, ENT_NOQUOTES, $charset);
    
    $str = preg_replace('#&([A-za-z])(?:acute|cedil|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str);
    $str = preg_replace('#&([A-za-z]{2})(?:lig);#', '\1', $str); // pour les ligatures e.g. '&oelig;'
    $str = preg_replace('#&[^;]+;#', '', $str); // supprime les autres caractères
    
    return $str;
}

function background_color($indice)
{
	$background_color_tab = array(
		"#F2C931",
		"#216EB4",
		"#9A9940",
		"#BB4D98",
		"#FF8B53",
		"#79BB92",
		"#DF9AB1",
		"#C5A3CA",
		"#CDC83F",
		"#DFB039",
		"#8E6538",
		"#328E5B",
		"#89C7D6",
		"#67328E",
		"#A90F32",
		"#EC7CAE",
		"#95BF32");

	return $background_color_tab[$indice%count($background_color_tab)];
}