<?php

function extension($file)
{
	$path_parts = pathinfo($file);
	return $path_parts['extension'];
}

function file_without_extension($file)
{
	$path_parts = pathinfo($file);
	return $path_parts['filename'];
}

function imagesize($file)
{
	if (extension($file) == "png")
		list($width_px, $height_px, $type, $attr) = getimagesize($file);

	if (extension($file) == "svg")
	{
		$xml = simplexml_load_file($file);
		$svg = $xml->attributes();
		$width_px	= substr($svg->width,0,-2);
		$height_px	= substr($svg->height,0,-2);
	}

	$return = array();
	$return['width']	= $width_px;
	$return['height']	= $height_px;

	return $return;
}


function file_type($folder_file,$extension)
{
	if ($folder_file == "folder")
		$file_type = "Dossier";
	else
	{
		$file_type = "Fichier ".$extension;
	}

	return $file_type;
}


function icone_font_awesome($folder_file,$extension)
{
	if ($folder_file == "folder")
		$font_awesome_html = "<i style='color:#F9D56F' class='bi bi-folder-fill fa-2x'></i>";
	else
	{
		$file_type = "Fichier ".$extension;

		$sql_icon = dbquery("SELECT type,color,font_awesome
				FROM file
				WHERE file_extension ='".$extension."'");

		if (dbnumrows($sql_icon)>0)
		{
			$file_type		= dbresult($sql_icon,0,"type");
			$color			= dbresult($sql_icon,0,"color");
			$font_awesome	= dbresult($sql_icon,0,"font_awesome");
			$font_awesome_html = "<i style='color:".$color."' class='".$font_awesome." fa-2x' aria-hidden='true'></i>";
		}
		else
			$font_awesome_html = "<i style='color:black' class='fa fa-file-o fa-2x' aria-hidden='true'></i>";
	}

	return $font_awesome_html;
}


// =================
// Taille des octets
// =================
function size_of_file($octets) {
    $resultat = $octets;
    for ($i=0; $i < 8 && $resultat >= 1024; $i++) {
        $resultat = $resultat / 1024;
    }
    if ($i > 0) {
        return preg_replace('/,00$/', '', number_format($resultat, 2, ',', '')) 
. ' ' . substr('KMGTPEZY',$i-1,1) . 'o';
    } else {
        if ($resultat <> "")
			return $resultat . ' o';
    }
}

