<?php
// ====
// HOME
// ====

// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/home/header.inc.php");

// Conversion temperature
function temperature_conversion($temperature_from,$unit_from,$unit_to)
{
	$temperature_to = 0;

	if ($unit_from == $unit_to) $temperature_to = $temperature_from;
	if ($unit_from == "kelvin"  && $unit_to == "celcius")	$temperature_to = bcsub($temperature_from,273.15);
	if ($unit_from == "celcius" && $unit_to == "kelvin")	$temperature_to = bcadd($temperature_from,273.15);
	
	return $temperature_to;
}

// Conversion vitesse
function vitesse_conversion($vitesse_from,$unit_from,$unit_to)
{
	$vitesse_to = "xx";

	if ($unit_from == $unit_to) $vitesse_to = $vitesse_from;
	if ($unit_from == "m_s"  && $unit_to == "km_h")	$vitesse_to = $vitesse_from*3.6 ;
	if ($unit_from == "km_h" && $unit_to == "m_s")	$vitesse_to = $vitesse_from/3.6;

	return $vitesse_to;
}

// Lundi : on conserve le meme jour
// Samedi PM ou dimanche : on va au prochain lundi
// Mardi / Mercredi / Jeudi / Vendredi / Samedi AM : on va au precedent lundi


$date_next_jour_ouvrable = new mydatetime();

if ($date_next_jour_ouvrable->format("l") == "Saturday" || $date_next_jour_ouvrable->format("l") == "Sunday")
$date_next_jour_ouvrable -> change_to_next_monday();


$tab_librairies = array('moment.js');
libraries($tab_librairies);
?>

<script type="text/javascript"> 
class myDate extends Date {
	constructor() {
		super();
	}

	/*
		   _                  
		  | |                 
		  | | ___  _   _ _ __ 
	  _   | |/ _ \| | | | '__|
	 | |__| | (_) | |_| | |   
	  \____/ \___/ \__,_|_|   
							  
	*/

	jour_display()
	{
		// Dates
		var date_today			= moment();
		var date_selectionne	= moment(this.toISOString());
		var date_en_cours		= moment(this.toISOString());

		// Affiche le jour
		$("#planning_jour").load("/cabinet/agenda/mobile/planning_ajax.php?date="+date_en_cours.format("YYYY-MM-DD")+"&home=1&load=1");



		// Lundi
		date_en_cours.startOf('isoWeek');

		// Lundi au Dimanche
		for (var jour=0; jour <= 6; jour++)
		{
			$("#jour_"+jour).html(date_en_cours.format('D'));
			$("#jour_"+jour).attr('value',date_en_cours.format("YYYY-MM-DD"));
			
			
			// Date selectionnée
			if (date_en_cours.format("YYYY-MM-DD") == date_selectionne.format("YYYY-MM-DD"))
				$("#jour_"+jour).addClass('date_selected');
			else
				$("#jour_"+jour).removeClass('date_selected');

			
			// Aujourd'hui
			if (date_en_cours.format("YYYY-MM-DD") == date_today.format("YYYY-MM-DD"))
				$("#jour_"+jour).addClass('date_today');
			else
				$("#jour_"+jour).removeClass('date_today');
			
	
			date_en_cours.add(1, 'days');
		}

		// Semaine precedent
		var date_prev = moment(this.toISOString());
		date_prev.subtract(1, 'weeks');
	

		// Semaine Suivant
		var date_suiv = moment(this.toISOString());
		date_suiv.add(1, 'weeks');



		$("#previous").attr('value',date_prev.format('YYYY-MM-DD'));
		$("#next").attr('value',date_suiv.format('YYYY-MM-DD'));
	}
}




$(document).ready(function()
{		
	$("#planning_jour").load("/cabinet/agenda/mobile/planning_ajax.php?date=<?php echo $date_next_jour_ouvrable->format('Y-m-d')?>&home=1&load=1");


	$("#choix_type_rendez_vous").load("/cabinet/agenda/mobile/choix_type_rendez_vous/index.php?date=<?php echo $date_next_jour_ouvrable->format('Y-m-d')?>");


	
	var date_ = new Date();
	date = new myDate();
	date.setTime(date_.getTime());



	// Chargement initial (Jour)
	date.jour_display();



	// --------------
	// GO DAY
	// --------------
	$(".go_day").click(function() {

		var date_ = new Date($(this).attr('value'));
		date = new myDate();
		date.setTime(date_.getTime());

		date.jour_display();
					
	});

});	
</script> 

<link rel="stylesheet" href="/cabinet/agenda/mobile/planning.css" type="text/css">


<?php
/*
<current>
	<city id="935264" name="">
		<coord lon="55.471000671387" lat="-20.892700195312"/>
		<country>Reunion Island</country>
		<sun rise="2013-08-11T02:42:59" set="2013-08-11T14:03:28"/>
	</city>
	<temperature value="296.15" min="296.15" max="296.15" unit="kelvin"/>
	<humidity value="60" unit="%"/>
	<pressure value="1019" unit="hPa"/>
	<wind>
		<speed value="6.7" name="Moderate breeze"/>
		<direction value="160" code="SSE" name="South-southeast"/>
	</wind>
	<clouds value="75" name="broken clouds"/>
	<precipitation mode="no"/>
	<weather number="803" value="nuages éparses" icon="04d"/>
	<lastupdate value="2013-08-11T11:30:00"/>
</current>
*/

//$xml_today = new SimpleXMLElement(file_get_contents('http://api.openweathermap.org/data/2.5/weather?q=Reunion&mode=xml&lang=fr'));
$xml_today = new 
SimpleXMLElement(file_get_contents('weather/weather.xml'));

$datetime_sun_rise	= new datetime($xml_today->city->sun['rise'],new DateTimeZone("UTC"));
$datetime_sun_set	= new datetime($xml_today->city->sun['set'],new DateTimeZone("UTC"));
$datetime_sun_rise->setTimezone(new DateTimeZone('Indian/Reunion'));
$datetime_sun_set->setTimezone(new DateTimeZone('Indian/Reunion'));

$temperature_celcius= floor(temperature_conversion($xml_today->temperature['value'],$xml_today->temperature['unit'],"celcius"));
$wind_km_h			= floor(vitesse_conversion($xml_today->wind->speed['value'],"m_s","km_h"));

$icon				= $xml_today->weather['icon'];

$date_jour		= new DateTime();
$date_jour_1_day = clone $date_jour;
$date_jour_2_day = clone $date_jour;
$date_jour_1_day->modify('+1 day');
$date_jour_2_day->modify('+2 day');




/*
<weatherdata>
	<location>
		<name/>
		<type/>
		<country>Reunion Island</country>
		<timezone/>
		<location altitude="0" latitude="-20.892700195312" longitude="55.471000671387" geobase="geonames" geobaseid="0"/>
	</location>
	<credit/>
	<meta>
		<lastupdate>2013-08-11T12:30:00</lastupdate>
		<calctime>0.0168</calctime>
		<nextupdate>2013-08-11T15:30:00</nextupdate>
	</meta>
	<sun rise="2013-08-11T02:42:59" set="2013-08-11T14:03:28"/>
	<forecast>
		<time day="2013-08-11">
			<symbol number="500" name="légères pluies" var="10d"/>
			<precipitation value="0.5" type="rain"/>
			<windDirection deg="88" code="E" name="East"/>
			<windSpeed mps="3.8" name="Gentle Breeze"/>
			<temperature day="25" min="23.82" max="25.08" night="23.82" eve="25.08" morn="25"/>
			<pressure unit="hPa" value="1008.06"/>
			<humidity value="99" unit="%"/>
			<clouds value="broken clouds" all="56" unit="%"/>
		</time>
		<time day="2013-08-12">
			<symbol number="800" name="ciel dégagé" var="01d"/>
			<precipitation/>
			<windDirection deg="61" code="ENE" name="East-northeast"/>
			<windSpeed mps="3.03" name="Light breeze"/>
			<temperature day="25.2" min="20.81" max="25.36" night="20.81" eve="23.54" morn="22.03"/>
			<pressure unit="hPa" value="1006.37"/>
			<humidity value="86" unit="%"/>
			<clouds value="sky is clear" all="0" unit="%"/>
		</time>
		<time day="2013-08-13">
			<symbol number="800" name="ciel dégagé" var="02d"/>
			<precipitation/>
			<windDirection deg="67" code="ENE" name="East-northeast"/>
			<windSpeed mps="2.51" name="Light breeze"/>
			<temperature day="23.97" min="19.22" max="23.97" night="19.22" eve="21.83" morn="19.79"/>
			<pressure unit="hPa" value="1004.65"/>
			<humidity value="82" unit="%"/>
			<clouds value="sky is clear" all="8" unit="%"/>
		</time>
		<time day="2013-08-14">
			<symbol number="800" name="ciel dégagé" var="01d"/>
			<precipitation/>
			<windDirection deg="72" code="ENE" name="East-northeast"/>
			<windSpeed mps="2.11" name="Light breeze"/>
			<temperature day="23.41" min="18.42" max="23.41" night="18.63" eve="21.06" morn="18.42"/>
			<pressure unit="hPa" value="1003.72"/>
			<humidity value="78" unit="%"/>
			<clouds value="sky is clear" all="0" unit="%"/>
		</time>
		<time day="2013-08-15">
			<symbol number="800" name="ciel dégagé" var="01d"/>
			<precipitation/>
			<windDirection deg="89" code="E" name="East"/>
			<windSpeed mps="3.46" name="Gentle Breeze"/>
			<temperature day="23.63" min="18.16" max="23.63" night="20.01" eve="21.98" morn="18.16"/>
			<pressure unit="hPa" value="1005.91"/>
			<humidity value="79" unit="%"/>
			<clouds value="sky is clear" all="0" unit="%"/>
		</time>
		<time day="2013-08-16">
			<symbol number="500" name="légères pluies" var="10d"/>
			<precipitation value="0.59" type="rain"/>
			<windDirection deg="116" code="ESE" name="East-southeast"/>
			<windSpeed mps="5.66" name="Moderate breeze"/>
			<temperature day="22.22" min="21.9" max="22.7" night="22.02" eve="22.7" morn="21.9"/>
			<pressure unit="hPa" value="1028.88"/>
			<humidity value="0" unit="%"/>
			<clouds value="sky is clear" all="1" unit="%"/>
		</time>
		<time day="2013-08-17">
			<symbol number="500" name="légères pluies" var="10d"/>
			<precipitation value="0.56" type="rain"/>
			<windDirection deg="100" code="E" name="East"/>
			<windSpeed mps="5.31" name="Gentle Breeze"/>
			<temperature day="21.89" min="21.38" max="22.9" night="22.52" eve="22.9" morn="21.38"/>
			<pressure unit="hPa" value="1026.87"/>
			<humidity value="0" unit="%"/>
			<clouds value="sky is clear" all="0" unit="%"/>
		</time>
	</forecast>
</weatherdata>
*/

?>
<!-- DATE DU JOUR + METEO-->
<div style='position:relative;top:10px;left:10px;width:200px; height:110px;border:solid 1px red;padding:10px'>
	<?php
	try {
		//$xml_forecast = new SimpleXMLElement(file_get_contents('http://api.openweathermap.org/data/2.5/forecast/daily?q=Reunion&mode=xml&units=metric&cnt=7&lang=fr'));
		$xml_forecast = new SimpleXMLElement(file_get_contents('weather/forecast_daily.xml'));

		$temperature_1_day	= floor($xml_forecast->forecast->time[1]->temperature['day']);
		$icon_1_day			= $xml_forecast->forecast->time[1]->symbol['var'];

		$temperature_2_day	= floor($xml_forecast->forecast->time[2]->temperature['day']);
		$icon_2_day			= $xml_forecast->forecast->time[2]->symbol['var'];
		?>

		<span style='color:grey;font-weight:bold;font-size:11pt;'><?php echo date_iso_fr_complete($date_jour->format('Y-m-d'))?></span>

		<span style='position:absolute;top:30px;left:5px'><img src="/images/weather_icones/50px/<?php echo $icon ?>.png" width="50" height="50" border="0" alt=""></span>

		<span style='position:absolute;top:40px;left:70px;color:blue;font-weight:bold;font-size:15pt'><?php echo $temperature_celcius ?></span>
		<span style='position:absolute;top:38px;left:94px;color:black;font-weight:bold;font-size:12pt'>°C</span>

		<span style='position:absolute;top:62px;left:62px;color:grey;font-weight:bold;font-size:8pt;'>Vent <?php echo $wind_km_h ?> km/h</span>

		<table style='border:0px;position:absolute;top:26px;left:140px'>
		<tr>
			<td style='text-align:center'><?php echo substr($dico[$date_jour_1_day->format('l')],0,3) ?></td>
			<td style='text-align:center'><?php echo substr($dico[$date_jour_2_day->format('l')],0,3) ?></td>
		</tr>
		<tr>
			<td style='text-align:center'><img src="/images/weather_icones/50px/<?php echo $icon_1_day ?>.png" width="25" height="25" border="0" alt=""></td>
			<td style='text-align:center'><img src="/images/weather_icones/50px/<?php echo $icon_2_day ?>.png" width="25" height="25" border="0" alt=""></td>
		</tr>
		<tr>
			<td style='text-align:center'><?php echo $temperature_1_day ?>°</td>
			<td style='text-align:center'><?php echo $temperature_2_day ?>°</td>
		</tr>
		</table>
		<?php
	}
	catch(Exception $e) {
	?>

	<div class="ui-state-error ui-corner-all" style="padding: 0 .7em;">
		<p><span class="ui-icon ui-icon-alert" style="float: left; margin-right: .3em;"></span>
		<strong>Erreur :</strong> Erreur de recupération des données de météo</p>
	</div>

	<?php
	}
	?>
</div>


<!-- CONGES -->
<div style="position:absolute;top:10px;left:222px;width:164px; height:110px;border:solid 1px red;padding:10px;overflow-y:scroll">

	<?php
	$date_now = new datetime();
	
	// CONGES POSTERIEURS
	$sql_conges = dbquery("SELECT *
		FROM personnel,personnel_conges
		WHERE personnel.id_personnel=personnel_conges.id_personnel
			AND personnel.id_personnel = '".$_SESSION['id_personnel']."'
			AND personnel_conges.datetime_debut >= NOW()
		ORDER BY personnel_conges.datetime_debut ASC");
	if (dbnumrows($sql_conges)>0)
	{
		for ($i=0;$i<dbnumrows($sql_conges);$i++)
		{
			$id_personnel_conge	= dbresult($sql_conges,$i,"personnel_conges.id_personnel_conge");

			$personnel_nom		= dbresult($sql_conges,$i,"personnel.nom");
			$personnel_prenom	= dbresult($sql_conges,$i,"personnel.prenom");
			$nom_conge			= dbresult($sql_conges,$i,"personnel_conges.nom");
			$date_debut			= new datetime(dbresult($sql_conges,$i,"personnel_conges.datetime_debut"));
			$date_fin			= new datetime(dbresult($sql_conges,$i,"personnel_conges.datetime_fin"));

			$interval = $date_debut->diff($date_now);

			echo "<p><b>".$nom_conge."</b> le ".$date_debut->format('d/m/Y')." (dans ".$interval->format('%a')." jours)</p>";
		}
	}
	else echo "<p>Pas de futur congés</p>";
	?>
</div>



<!-- PDF DES PLANNING -->
<div style='position:absolute;top:10px;left:398px;width:80px; height:110px;border:solid 1px red;padding:10px'>

	<div id='choix_type_rendez_vous'>
		<div class='spinner-border spinner-border-sm' role='status'></div>
	</div>
</div>

<!-- NB DE CLIENTS -->
<div style='position:absolute;top:10px;left:490px;width:230px; height:110px;border:solid 1px red;padding:10px'>
	<?php
	$sql_client = dbquery("SELECT COUNT(*) AS nb_clients FROM clients");
	?>
	<span style='position:absolute;top:8px;left:5px'><img src="/images/icones/clients.png" width="141" height="114" border="0" alt=""></span>

	<span style='position:absolute;top:30px;left:160px;color:blue;font-weight:bold;font-size:18pt'><?php echo dbresult($sql_client,0,"nb_clients") ?></span>
	<span style='position:absolute;top:50px;left:160px;color:black;font-weight:bold;font-size:12pt'>PATIENTS</span>
</div>

<!-- PLANNING -->
<div id='planning_jour_encapsulation' style='position:relative;top:30px;left:10px;width:710px; height:1600px;border:solid 1px red;padding:10px'>


	<!-- Precedent -->
	<i id='previous' value="" style='position:absolute;top:40px;left:0px;color:#FF3D33;' class="go_day bi bi-chevron-left fa-2x"></i>

	<!-- Suivant -->
	<i id='next'     value="" style='position:absolute;top:40px;right:0px;color:#FF3D33;' class="go_day bi bi-chevron-right fa-2x"></i>


	<?php
	$tab = array('L','M','M','J','V','S','D');
	
	for ($i=0;$i<=6;$i++)
	{
		$left =  $i*(96/7)+6;


		// Options 
		//$date_class = "date_selected";
		//$date_class = "date_today";


		// Week end (Samedi et dimanche)
		if ($i == 5  || $i == 6)
			$day_week_class = "day_weekend";
		else
			$day_week_class = "day_week";

		// L  M  M  J  V  S  D
		echo "<span class='".$day_week_class."' style='width:40px;position:absolute;top:10px;left:".$left."%;font-size:0.7em'>".$tab[$i]."</span>";

		// (15) (16) (17) (18) (19) (20) (21)
		echo "<span id='jour_".$i."' class='go_day ".$date_class." ".$day_week_class."' style='width:40px;position:absolute;top:32px;left:".$left."%;font-size:20px;cursor:pointer' value=''></span>";
	}
	?>

	<div id='planning_jour' style='position:relative;top:70px;left:-10px;margin:0px;width:710px; height:1600px;padding:10px'><i style='color:red' class="fa fa-refresh fa-lg fa-spin"></i></div>

</div>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/home/footer.inc.php");
?>