<?php
// ==================
// FICHES RENDEZ VOUS
// --> pdf
// ==================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));

$vcard = "BEGIN:VCARD
VERSION:3.0
FN:Cabinet Dr TANGUY
N:Cabinet Dr TANGUY;;;;
TEL;TYPE=WORK:0262417753
ADR;TYPE=HOME:;;49 allée des topazes;Saint Denis;;;
END:VCARD";


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


// extend TCPF with custom functions
class MYPDF extends TCPDF
{
	// Nb de lignes / colonnes
	var $nb_lignes;
	var $nb_colonnes;

	
	// Etiquette
	public function etiquette($position)
	{
		$margin = $this -> getMargins();

		$x = ($this->getPageWidth() - $margin['left'] - $margin['right'])/$this->nb_colonnes*($position%$this -> nb_colonnes);
		$y = ($this->getPageHeight()- 2*$margin['top'])/$this->nb_lignes*(floor($position/$this->nb_colonnes)%$this->nb_lignes);

		$this->SetXY($x,$y);
	}
}

$sql_personnel = dbquery("SELECT * FROM personnel
	WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)	die('Erreur : Personnel non identifié');


// create new PDF document
$pdf = new MYPDF($_GET['orientation'], 'mm', $_GET['format'], true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Etiquettes');
$pdf->SetSubject('Etiquettes');
$pdf->SetKeywords('Etiquettes');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(0);
$pdf->SetLeftMargin(0);
$pdf->SetRightMargin(0);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetTextColor(0,0,0);


$pdf->nb_lignes		= $_GET['nb_lignes'];
$pdf->nb_colonnes	= $_GET['nb_colonnes'];


// ==========
// ETIQUETTES
// ==========
foreach($_GET['id_type_rendez_vous'] as $id_type_rendez_vous => $value)
{
	for ($i=0;$i<$value['nb_fiches'];$i++)
	{	
		// SAUT DE PAGE : RECTO
		$pdf->AddPage($_GET['orientation']);

		for ($j=0;$j<=7;$j++)
		{
			// Docteur ** nom ** ** specialité **
			$pdf -> etiquette($j);
			$pdf -> SetFont('Helvetica','B',14);
			$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+8);
			$pdf -> Cell(($pdf->getPageWidth()/$pdf->nb_colonnes)-10,0, 'Docteur '.param('nom_docteur').' '.param('specialite'),     0, $ln=0,'R', $fill=false,'', $stretch=4, false, 'C','C');


			// Ligne 1 et 2
			$pdf -> etiquette($j);
			$pdf -> SetFont('','',9);
			$pdf -> MultiCell($pdf->getPageWidth()/$pdf->nb_colonnes,12, param('qualite_ligne_1')."\n".param('qualite_ligne_2')."\n".param('qualite_ligne_3') , 0, 'L', $fill=false,$ln=2, $pdf -> GetX()+5,$pdf -> GetY()+13,true,0,false,true,0,'T',true);


			// Telephone
			$pdf -> etiquette($j);
			$pdf -> SetFont('','B',11);
			$pdf -> MultiCell($pdf->getPageWidth()/$pdf->nb_colonnes-10,10, param('telephone_1')."\n".param('telephone_2') , 0, 'R', $fill=false,$ln=2, $pdf -> GetX()+5,$pdf -> GetY()+20,true,0,false,true,0,'T',true);


			// Rendez-vous
			$sql_type_rendez_vous = dbquery("SELECT * FROM type_rendez_vous
				WHERE id_type_rendez_vous='".$id_type_rendez_vous."'");
				
			if (dbnumrows($sql_type_rendez_vous) > 0)
			{
				$intutule_type_rendez_vous		= dbresult($sql_type_rendez_vous,0,"intitule");
			}
					
			$pdf -> etiquette($j);
			$pdf -> SetFont('','B',14);
			$pdf -> MultiCell($pdf->getPageWidth()/$pdf->nb_colonnes-9,10, 'Rendez-vous '.$intutule_type_rendez_vous , 0, 'L', $fill=false,$ln=2, $pdf -> GetX()+8,$pdf -> GetY()+27,true,0,false,true,0,'T',true);

			// Complément
			$pdf -> etiquette($j);
			$pdf -> SetFont('','B',12);
			$pdf -> MultiCell($pdf->getPageWidth()/$pdf->nb_colonnes-63,10, $value['complement'] , $border=0, 'R', $fill=false,$ln=2, $pdf -> GetX()+58,$pdf -> GetY()+27,true,$stretch=3,false,true,0,'T',true);



			// --> Italique 10 pt
			$pdf -> SetFont('','I',10);
			
			// Nom
			$pdf -> etiquette($j);
			$pdf -> SetXY($pdf->GetX()+8,$pdf->GetY()+38);
			$pdf -> Cell(20,0, 'Nom :', 0 , $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');


			// Date
			$pdf -> etiquette($j);
			$pdf -> SetXY($pdf->GetX()+8,$pdf->GetY()+45);
			$pdf -> Cell(20,0, 'Date :', 0 , $ln=0,'L', $fill=false,'', $stretch=3, false, 'C','C');


			// Heure
			$pdf -> etiquette($j);
			$pdf -> SetXY($pdf->GetX()+68,$pdf->GetY()+45);
			$pdf -> Cell(20,0, 'Heure :', 0 , $ln=0,'L', $fill=false,'', $stretch=3, false, 'C','C');


			// --> Normal 10 pt
			$pdf -> SetFont('','',10);
			
			// Lieu
			$pdf -> etiquette($j);
			$pdf -> SetXY($pdf->GetX()+8,$pdf->GetY()+52);
			$pdf -> Cell($pdf->getPageWidth()/$pdf->nb_colonnes-14,0, param('lieu'), $border=0 , $ln=0,'L', $fill=false,'', $stretch=3, false, 'C','C');


			// Commentaire
			$pdf -> etiquette($j);
			$pdf -> SetFont('','I');
			$pdf -> MultiCell($pdf->getPageWidth()/$pdf->nb_colonnes,11, param('commentaire') , $border=0, 'C', $fill=false,$ln=2, $pdf -> GetX(),$pdf -> GetY()+58,true,0,false,true,0,'T',true);
		}

		// SAUT DE PAGE : VERSO
		$pdf->AddPage($_GET['orientation']);

		for ($j=0;$j<=7;$j++)
		{
			// Docteur ** nom ** ** specialité **
			$pdf -> etiquette($j);

			// set style for barcode
			$style = array(
				'border' => 2,
				'vpadding' => 'auto',
				'hpadding' => 'auto',
				'fgcolor' => array(0,0,0),
				'bgcolor' => false, //array(255,255,255)
				'module_width' => 1, // width of a single module in points
				'module_height' => 1 // height of a single module in points
			);

			
			// QRCODE,L : QR-CODE Low error correction
			$pdf->write2DBarcode($vcard, 'QRCODE,L', $pdf->GetX() + ($pdf->getPageWidth()/$pdf->nb_colonnes-40)/2, $pdf->GetY() + ($pdf->getPageHeight()/$pdf->nb_lignes-40)/2, 40, 40, $style, 'N');
			$pdf -> SetFont('','',10);


			// Notice
			$pdf -> etiquette($j);
			$pdf -> MultiCell($pdf->getPageWidth()/$pdf->nb_colonnes,10, "Coordonnées du cabinet - Format vCard" , 0, 'C', $fill=false,$ln=2, $pdf -> GetX(),$pdf -> GetY()+8,true,0,false,true,0,'T',true);

			$pdf -> etiquette($j);
			$pdf -> MultiCell($pdf->getPageWidth()/$pdf->nb_colonnes,10, "Flashez ce code QR" , 0, 'C', $fill=false,$ln=2, $pdf -> GetX(),$pdf -> GetY()+62,true,0,false,true,0,'T',true);

		}
	}
}


// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('fiche_rendez_vous.pdf', 'I');