<?php
// =============
// ETIQUETTE DOS
// --> pdf
// =============

session_start();


require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));
libraries(array('phpColors'));
use phpColors\Color;


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


// extend TCPF with custom functions
class MYPDF extends TCPDF
{
	// Nb de lignes / colonnes
	var $nb_lignes;
	var $nb_colonnes;
	
	// Etiquette
	public function etiquette($position)
	{
		$margin = $this -> getMargins();

		$x = $margin['left'] + ($this->getPageWidth() - $margin['left'] - $margin['right'])/$this->nb_colonnes*($position%$this -> nb_colonnes);
		$y = $margin['top']  + ($this->getPageHeight()- 2*$margin['top'])/$this->nb_lignes*(floor($position/$this->nb_colonnes)%$this->nb_lignes);

		$this->SetXY($x,$y);
	}
}


// ==============
// Couleur paris
// --> text
// --> background
// ==============

function paris_color($text_background,$lettre_nom)
{
	$sql_paris_metro_nb = dbquery("SELECT COUNT(*) AS nb
	FROM paris_metro");

	$numero_partie2 = ord($lettre_nom) - 65;

	$numero = $numero_partie2 % dbresult($sql_paris_metro_nb,0,"nb") + 1;

	$sql_paris_metro = dbquery("SELECT *
		FROM  paris_metro
		WHERE numero = '".$numero."'");

	if (dbnumrows($sql_paris_metro) == 0)
		die("Couleur non reconnu");

	if ($text_background == "text")
		$color	= new Color(dbresult($sql_paris_metro,0,"text_color"));
	else
		$color	= new Color(dbresult($sql_paris_metro,0,"background_color"));
	
	return $color->getRgb();
}


// ==========
// ETIQUETTES
// ==========


// create new PDF document
$pdf = new MYPDF();

// Sur chaque page
$id_format_papier	= "A4";
$orientation		= "landscape";

// Parametres generaux

// -> Nb de lignes et de colonnes
$pdf->nb_lignes		= 8;
$pdf->nb_colonnes	= 3;

// Marges
$pdf->SetTopMargin(5);
$pdf->SetLeftMargin(5);
$pdf->SetRightMargin(5);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cnam');
$pdf->SetTitle('Etiquette Dossier Suspendu');
$pdf->SetSubject('Etiquette Dossier Suspendu');
$pdf->SetKeywords('Etiquette,Dossier Suspendu');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');


$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetTextColor(0,0,0);
$pdf -> SetFontSize(10);

$margin = $pdf -> getMargins();

$sql_date_dossier_suspendu = dbquery("SELECT *
	FROM clients
	WHERE date_dossier_suspendu = '".$_GET['date']."'
	ORDER BY nom, prenom ASC");

for ($i=0;$i<dbnumrows($sql_date_dossier_suspendu);$i++)
{
	// SAUT DE PAGE
	// --> Tous les nb_lignes x nb_colonnes etiquettes
	if ($i%($pdf->nb_lignes*$pdf->nb_colonnes)==0)		$pdf->AddPage($orientation,$id_format_papier);


	$id_client	= dbresult($sql_date_dossier_suspendu,$i,"id_client");
	$prenom		= dbresult($sql_date_dossier_suspendu,$i,"prenom");
	$nom		= dbresult($sql_date_dossier_suspendu,$i,"nom");

	$label	= "\n\n".$nom." ".$prenom;
	
	/*
	+----------------------------------+----------------------------------+
 	|                                  |                                  |
 	|  AMACOUTY Marie Angele           |  ASENSIO Jacqueline              |
	|                                  |                                  |
	+----------------------------------+----------------------------------+
 	|                                  |                                  |
 	|  BADOURALY Dilavarhoussen        |  BELAIR Paul                     |
	|                                  |                                  |
	+----------------------------------+----------------------------------+
    */

	$pdf -> etiquette($i);
	$x_encours = $pdf->getX();
	$y_encours = $pdf->getY();
	
	
	// ----------------------
	// Couleur des caracteres
	// ----------------------
	$text_color			= paris_color("text",substr($nom,0,1));
	$background_color	= paris_color("background",substr($nom,0,1));
	
	
	$pdf -> setFillColor($background_color['R'],$background_color['G'],$background_color['B']);
	$pdf -> setColor('text',$text_color['R'],$text_color['G'],$text_color['B']);

	// ---------------
	// Premiere lettre
	// ---------------	
	$pdf -> StartTransform();
	$pdf -> SetFont('Helvetica','',15);

	$pdf -> Rotate(90,$x_encours+3.5,$y_encours+11);

	$pdf -> SetXY($x_encours,$y_encours+11);
	$pdf -> Cell(7,7, substr($nom,0,1),   $border=1, $ln=0,'C', $fill=true,'', $stretch=1, false, 'C','C');
	$pdf -> StopTransform();

	// ---------------
	// Deuxieme lettre
	// ---------------	

	$pdf -> StartTransform();
	$pdf -> SetFont('Helvetica','',10);

	$pdf -> Rotate(90,$x_encours+10.5,$y_encours+11);

	$pdf -> SetXY($x_encours+7,$y_encours+11);
	$pdf -> Cell(7,7, substr($nom,1,1),   $border=1, $ln=0,'C', $fill=true,'', $stretch=1, false, 'C','C');
	$pdf -> StopTransform();


	// Civilité, Nom Prénom
	// Adresse
	// Code postal et commune
	$pdf -> setColor('text',0,0,0);

	$pdf -> writeHTMLCell( ($pdf->getPageWidth() - $margin['left'] - $margin['right'])/$pdf->nb_colonnes -5,
			70,
			$x_encours+15,
			$y_encours+9,
			"<b>".$nom."</b> ".$prenom,
			$border = 0,
			$ln = 0,
			$fill = false,
			$reseth = true,
			$align = 'L',
			$autopadding = false 
		);
}

// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('etiquettes_dos.pdf', 'I');