<?php
// ========================
// ENVELOPPE / CARTE VISITE
// --> pdf
// ========================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)



if (!isset($_SESSION['id_personnel']))
{
	header("Location:/cabinet/authentification/login_form.php?message=Fin de session. Veuillez vous reconnecter.");
	exit;
}

$sql_personnel		= dbquery("SELECT * FROM personnel WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)
	die('Attention : Personnel non reconnu');


// create new PDF document
if (isset($_GET['width']) && isset($_GET['height']))
	$pdf = new TCPDF($_GET['orientation'], 'mm', array($_GET['width'],$_GET['height']), true ,'utf-8' , false);
else
	$pdf = new TCPDF($_GET['orientation'], 'mm', $_GET['format'], true ,'utf-8' , false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Carte de visite');
$pdf->SetSubject('Carte de visite');
$pdf->SetKeywords('Carte,visite');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(0);
$pdf->SetLeftMargin(0);
$pdf->SetRightMargin(0);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Marges
$pdf->SetMargins(10,10,10,10);


$pdf->SetTextColor(0,0,0,100);


// ======
// ENTETE
// ======

// Ajout d'un debord le cas échéant
$pdf -> addPage($_GET['orientation'],array($pdf->getPageWidth()+$_GET['debord']*2,$pdf->getPageHeight()+$_GET['debord']*2));

// COULEUR PANTONE
$sql_couleur_1 = dbquery("SELECT * FROM couleurs WHERE pantone='".param('pantone_enveloppe')."'");

$p_enveloppe = dbresult($sql_couleur_1,0,"C");
$C_enveloppe = dbresult($sql_couleur_1,0,"C");
$M_enveloppe = dbresult($sql_couleur_1,0,"M");
$Y_enveloppe = dbresult($sql_couleur_1,0,"Y");
$K_enveloppe = dbresult($sql_couleur_1,0,"K");

$pdf->AddSpotColor('Pantone '.param('pantone_enveloppe').' C', $C_enveloppe, $M_enveloppe, $Y_enveloppe, $K_enveloppe);



// --> Texte
// COULEUR PANTONE
$sql_couleur_1 = dbquery("SELECT * FROM couleurs WHERE pantone='".param('pantone_enveloppe')."'");

$p_enveloppe = dbresult($sql_couleur_1,0,"C");
$C_enveloppe = dbresult($sql_couleur_1,0,"C");
$M_enveloppe = dbresult($sql_couleur_1,0,"M");
$Y_enveloppe = dbresult($sql_couleur_1,0,"Y");
$K_enveloppe = dbresult($sql_couleur_1,0,"K");

$pdf->AddSpotColor('Pantone '.param('pantone_enveloppe').' C', $C_enveloppe, $M_enveloppe, $Y_enveloppe, $K_enveloppe);

// Couleur pantone
if (dbresult($sql_personnel,0,"quadrichromie") == 1) 
	$pdf->SetTextSpotColor('Pantone '.param('pantone_enveloppe').' C', 100);


// ---------------
//  Debut du texte
// ---------------
if (isset($_GET['width']) && $_GET['width'] <= 100)
{
	$x_encours = 5+$_GET['debord'];
	$width = 77;
}
else
{
	$x_encours = 15+$_GET['debord'];
	$width = 100;
}


// Bordure verte
if (dbresult($sql_personnel,0,"quadrichromie") == 1) 
{	$pdf->SetDrawSpotColor('Pantone '.param('pantone_enveloppe').' C', 100);
	$pdf->SetFillSpotColor('Pantone '.param('pantone_enveloppe').' C', 100);

	$pdf->Rect(0, 0, 4+$_GET['debord'], $pdf->getPageHeight(), 'DF');
}


$sql_papeterie_contact = dbquery("SELECT *
	FROM papeterie_contact
	WHERE id_papeterie_contact = '".$_GET['id_papeterie_contact']."'");

if (dbnumrows($sql_papeterie_contact) == 0)
	die ("Contact papeterie non trouvé");

$titre				= dbresult($sql_papeterie_contact,0,"titre");
$nom				= dbresult($sql_papeterie_contact,0,"nom");
$prenom				= dbresult($sql_papeterie_contact,0,"prenom");
$telephone			= dbresult($sql_papeterie_contact,0,"telephone");
$fax				= dbresult($sql_papeterie_contact,0,"fax");
$email				= dbresult($sql_papeterie_contact,0,"email");
$qualite_ligne_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_1");
$qualite_ligne_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_1");
$qualite_ligne_2	= dbresult($sql_papeterie_contact,0,"qualite_ligne_2");
$qualite_ligne_3	= dbresult($sql_papeterie_contact,0,"qualite_ligne_3");
$qualite_ligne_cv_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_1");
$qualite_ligne_cv_2	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_2");
$qualite_ligne_cv_3	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_3");
$qualite_ligne_cv_4	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_4");
$qualite_ligne_cv_5	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_5");
$qualite_ligne_cv_6	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_6");
$lieu_cv_1			= dbresult($sql_papeterie_contact,0,"lieu_cv_1");
$lieu_cv_2			= dbresult($sql_papeterie_contact,0,"lieu_cv_2");
$QRCode				= dbresult($sql_papeterie_contact,0,"QRCode");




//Carte de visite 
// (width = 85)
if ($_GET['width'] == 85)
{
	$vcard = "BEGIN:VCARD
	VERSION:3.0
	FN:".trim($titre." ".$prenom." ".$nom)."
	N:".$nom.";".$prenom.";;".$titre.";
	TEL;TYPE=WORK:".$telephone."
	ADR;TYPE=HOME:;;".$lieu_cv_1.";".$lieu_cv_2.";;;
	END:VCARD";

	
	// Titre (Pantone 1)
	$pdf -> SetFont('Helvetica','B',11);
	$pdf -> SetXY($x_encours,5+$_GET['debord']);
	$pdf -> Cell($width,0, trim($titre." ".$prenom." ".$nom),     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Reste du texte en Noir + Bold + Italique
	$pdf -> SetFont('Helvetica','BI',9);
	$pdf -> SetTextColor(0,0,0,100);

	// Ligne 1
	$pdf -> SetXY($x_encours,12+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_cv_1,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');


	// Ligne 1bis
	$pdf -> SetXY($x_encours,12+$_GET['debord']);
	$pdf -> Cell($width,0, $telephone,     0, $ln=0,'R', false,'', $stretch=1, false, 'C','C');


	// Reste du texte en Noir + italique
	$pdf -> SetFont('Helvetica','I',9);

	// Ligne 2
	$pdf -> SetXY($x_encours,18+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_cv_2,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 3
	$pdf -> SetXY($x_encours,23+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_cv_3,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 4
	$pdf -> SetXY($x_encours,28+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_cv_4,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 5
	$pdf -> SetXY($x_encours,33+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_cv_5,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 6
	$pdf -> SetXY($x_encours,38+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_cv_6,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 7
	$pdf -> SetXY($x_encours,46+$_GET['debord']);
	$pdf -> Cell($width,0, $lieu_cv_1,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 8
	$pdf -> SetXY($x_encours,50+$_GET['debord']);
	$pdf -> Cell($width,0, $lieu_cv_2,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 7 bis
	$pdf -> SetXY($x_encours,46+$_GET['debord']);
	if ($fax <> "")
		$pdf -> Cell($width,0, "Fax : ".$fax,     0, $ln=0,'R', false,'', $stretch=1, false, 'C','C');

	// Ligne 8 bis
	$pdf -> SetXY($x_encours,50+$_GET['debord']);
	$pdf -> Cell($width,0, $email,     0, $ln=0,'R', false,'', $stretch=1, false, 'C','C');


	// New Page
	if ($QRCode == "verso")
		$pdf->AddPage();


	// QRCODE,L : QR-CODE Low error correction
	$pdf->write2DBarcode($vcard, 'QRCODE,L', 30 , 18 , 30, 30, $style, 'N');
	$pdf -> SetFont('','',10);

	// Notice
	if ($QRCode == "verso")
	{
		$pdf -> MultiCell($pdf->getPageWidth(),10, "Coordonnées au format vCard" , 0, 'C', $fill=false,$ln=2, 0,10,true,0,false,true,0,'T',true);
	
		$pdf -> MultiCell($pdf->getPageWidth(),10, "Flashez ce code QR" , 0, 'C', $fill=false,$ln=2, 0,50,true,0,false,true,0,'T',true);
	}
}
else
{
	// Titre (Pantone 1)
	$pdf -> SetXY($x_encours,12+$_GET['debord']);
	$pdf -> Cell($width,0, trim($titre." ".$prenom." ".$nom),     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Reste du texte en Noir
	$pdf -> SetFont('Helvetica','I',10);
	$pdf -> SetTextColor(0,0,0,100);

	// Ligne 1
	$pdf -> SetXY($x_encours,20+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_1,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 2
	$pdf -> SetXY($x_encours,26+$_GET['debord']);
	$pdf -> Cell($width,0, $qualite_ligne_2,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 3
	$pdf -> SetXY($x_encours,32+$_GET['debord']);
	$pdf -> Cell($width,0, param('lieu'),     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 4
	$pdf -> SetXY($x_encours,38+$_GET['debord']);
	$pdf -> Cell($width,0, 'Tel : '.$telephone.' - Fax : '.$fax,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');
}




$pdf -> SetFontSize(10);


// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('carte_visite_'.$_GET['format'].'_pantone_'.param('pantone_enveloppe').'.pdf', 'I');