<?php
// ===============
// CHEMISE A RABAT
// --> pdf
// ===============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.geo.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));
libraries(array('phpColors'));
use phpColors\Color;


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)





if (!isset($_SESSION['id_personnel']))
{
	header("Location:/cabinet/authentification/login_form.php?message=Fin de session. Veuillez vous reconnecter.");
	exit;
}

$sql_personnel		= dbquery("SELECT * FROM personnel WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)
	die('Attention : Personnel non reconnu');


// create new PDF document
if (isset($_GET['width']) && isset($_GET['height']))
	$pdf = new TCPDF($_GET['orientation'], 'mm', array($_GET['width'],$_GET['height']), true ,'utf-8' , false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Courrier');
$pdf->SetSubject('Courrier');
$pdf->SetKeywords('Courrier');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(0);
$pdf->SetLeftMargin(0);
$pdf->SetRightMargin(0);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Marges
$pdf->SetMargins(10,10,10,10);


$pdf->SetTextColor(0,0,0,100);


// ======
// ENTETE
// ======

// Ajout d'un debord le cas échéant
$pdf -> addPage($_GET['orientation'],array($pdf->getPageWidth()+$_GET['debord']*2,$pdf->getPageHeight()+$_GET['debord']*2));


// ------------
// Prescripteur
//	--> Cadre
// ------------
list($r,$v,$b) = explode(',',$_GET['couleur']);



// Header
$pdf -> SetFont('Helvetica','B',11);


// --> Texte
// COULEUR PANTONE
$sql_couleur_1 = dbquery("SELECT * FROM couleurs WHERE pantone='".param('pantone_enveloppe')."'");

$p_enveloppe = dbresult($sql_couleur_1,0,"C");
$C_enveloppe = dbresult($sql_couleur_1,0,"C");
$M_enveloppe = dbresult($sql_couleur_1,0,"M");
$Y_enveloppe = dbresult($sql_couleur_1,0,"Y");
$K_enveloppe = dbresult($sql_couleur_1,0,"K");

$pdf->AddSpotColor('Pantone '.param('pantone_enveloppe').' C', $C_enveloppe, $M_enveloppe, $Y_enveloppe, $K_enveloppe);

// Couleur pantone
if (dbresult($sql_personnel,0,"quadrichromie") == 1) 
	$pdf->SetTextSpotColor('Pantone '.param('pantone_enveloppe').' C', 100);


$sql_papeterie_contact = dbquery("SELECT *
	FROM papeterie_contact
	WHERE id_papeterie_contact = '".$_GET['id_papeterie_contact']."'");

if (dbnumrows($sql_papeterie_contact) == 0)
	die ("Contact papeterie non trouvé");

$titre				= dbresult($sql_papeterie_contact,0,"titre");
$nom				= dbresult($sql_papeterie_contact,0,"nom");
$prenom				= dbresult($sql_papeterie_contact,0,"prenom");
$telephone			= dbresult($sql_papeterie_contact,0,"telephone");
$fax				= dbresult($sql_papeterie_contact,0,"fax");
$email				= dbresult($sql_papeterie_contact,0,"email");
$qualite_ligne_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_1");
$qualite_ligne_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_1");
$qualite_ligne_2	= dbresult($sql_papeterie_contact,0,"qualite_ligne_2");
$qualite_ligne_3	= dbresult($sql_papeterie_contact,0,"qualite_ligne_3");
$qualite_ligne_cv_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_1");
$qualite_ligne_cv_2	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_2");
$qualite_ligne_cv_3	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_3");
$qualite_ligne_cv_4	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_4");
$qualite_ligne_cv_5	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_5");
$qualite_ligne_cv_6	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_6");
$lieu_cv_1			= dbresult($sql_papeterie_contact,0,"lieu_cv_1");
$lieu_cv_2			= dbresult($sql_papeterie_contact,0,"lieu_cv_2");


// -------
//  Page 1
// -------
$x_encours = 80+$_GET['debord'];
$width = 215;


// Bas
$pdf -> SetXY($x_encours,295+$_GET['debord']);
$pdf -> Cell($width,0, "Cabinet du Docteur Tanguy",     0, $ln=0,'C', false,'', $stretch=1, false, 'C','C');

$pdf -> SetXY($x_encours,302+$_GET['debord']);
$pdf -> Cell($width,0, param('lieu'),     0, $ln=0,'C', false,'', $stretch=1, false, 'C','C');

// Photo en bas
if (file_exists('ble_2.jpg'))
	$pdf->Image('ble_2.jpg', $x_encours-2,$_GET['debord']+110, 215,0 , 'JPG', '', '', true, 300, '', false, false, 0, false, false, false);


// -------
//  Page 2
// -------
$x_encours = 295+$_GET['debord'];
$width = 100;



// Titre (Pantone 1)
$pdf -> SetXY($x_encours+5,12+$_GET['debord']);
$pdf -> Cell($width,0, $titre." ".$prenom." ".$nom,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

// Reste du texte en Noir
$pdf -> SetFont('Helvetica','I',10);
$pdf -> SetTextColor(0,0,0,100);

// Ligne 1
$pdf -> SetXY($x_encours+5,20+$_GET['debord']);
$pdf -> Cell($width,0, $qualite_ligne_1,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

// Ligne 2
$pdf -> SetXY($x_encours+5,26+$_GET['debord']);
$pdf -> Cell($width,0, $qualite_ligne_2,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

// Ligne 3
$pdf -> SetXY($x_encours+5,32+$_GET['debord']);
$pdf -> Cell($width,0, param('lieu'),     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

// Ligne 4
$pdf -> SetXY($x_encours+5,38+$_GET['debord']);
$pdf -> Cell($width,0, 'Tel : '.$telephone.' - Fax : '.$fax,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');


// ---------------
// DOSSIER MÉDICAL
// ---------------
$pdf -> SetFont('Helvetica','',15);
$pdf -> SetXY($x_encours+70,70);
$pdf -> Cell(70,0, 'DOSSIER MÉDICAL',     'TB', $ln=0,'R', $fill=false,'', $stretch=4, false, 'C','C');

// Nom et prénom sexe
$pdf->SetFont('helvetica', '', 12);
	$pdf -> writeHTMLCell( $pdf->getPageWidth()-48,
		70,
		$x_encours+10,
		$pdf->getY()+30,
		"<b>Patient : ...........................................................<br><br><br>
		Téléphone fixe: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;......................................<br><br>
		Téléphone portable : ......................................<br><br><br>
		Numéro NIR : ..................................................<br><br><br>
		Médecin traitant : ...........................................",
		$border = 0,
		$ln = 0,
		$fill = false,
		$reseth = true,
		$align = 'L',
		$autopadding = false 
	);



// Photo en bas
if (file_exists('ble_1.jpg'))
	$pdf->Image('ble_1.jpg', $x_encours,$_GET['debord']+245, 100,0 , 'JPG', '', '', true, 300, '', false, false, 0, false, false, false);

if (isset($_GET['mode_debug']))
{
	$A = new Point(0,   10);
	$B = new Point(80,  0);
	$C = new Point(80,  310);
	$D = new Point(0,   300);

	$E = new Point(295, 0);
	$F = new Point(295, 310);

	$G = new Point(509, 0);
	$H = new Point(509, 310);

	$I = new Point(285, 390);
	$J = new Point(120, 390);


	// 1er quadrilatere ABCD
	$building_polygon = new Polygon(array($A,$B,$C,$D));
	$pdf->Polygon($building_polygon->GD_TcPDF_Polygon($_GET['debord'],$_GET['debord']), 'D','' , Color::hexToRgb('#FFFFFF'),$closed = true);
	
	// 2e quadrilatere BEFC
	// On se limite a la ligne BE
	$pdf->line($B->x+$_GET['debord'], $B->y+$_GET['debord'], $E->x+$_GET['debord'], $E->y+$_GET['debord']);

	// 3e quadrilataire EGHF
	$building_polygon = new Polygon(array($E,$G,$H,$F));
	$pdf->Polygon($building_polygon->GD_TcPDF_Polygon($_GET['debord'],$_GET['debord']), 'D','' , Color::hexToRgb('#FFFFFF'),$closed = true);

	// 4e quadrilatere CFIJ
	$building_polygon = new Polygon(array($C,$F,$I,$J));
	$pdf->Polygon($building_polygon->GD_TcPDF_Polygon($_GET['debord'],$_GET['debord']), 'D','' , Color::hexToRgb('#FFFFFF'),$closed = true);
}

// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('chemise_a_rabat_pantone_'.param('pantone_enveloppe').'.pdf', 'I');