<?php
// ================
// CARTES DE VISITE
// --> pdf
// ================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


// extend TCPF with custom functions
class MYPDF extends TCPDF
{
	// Nb de lignes / colonnes
	var $nb_lignes;
	var $nb_colonnes;

	
	// Etiquette
	public function etiquette($position)
	{
		$margin = $this -> getMargins();

		$x = ($this->getPageWidth() - $margin['left'] - $margin['right'])/$this->nb_colonnes*($position%$this -> nb_colonnes);
		$y = ($this->getPageHeight()- 2*$margin['top'])/$this->nb_lignes*(floor($position/$this->nb_colonnes)%$this->nb_lignes);

		$this->SetXY($x,$y);
	}
}

$sql_personnel = dbquery("SELECT * FROM personnel
	WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)	die('Erreur : Personnel non identifié');


// create new PDF document
$pdf = new MYPDF($_GET['orientation'], 'mm', $_GET['format'], true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Cartes de visites');
$pdf->SetSubject('Cartes de visites');
$pdf->SetKeywords('Cartes de visites');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(0);
$pdf->SetLeftMargin(0);
$pdf->SetRightMargin(0);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetTextColor(0,0,0);


$pdf->nb_lignes		= $_GET['nb_lignes'];
$pdf->nb_colonnes	= $_GET['nb_colonnes'];


// --> Texte
// COULEUR PANTONE
$sql_couleur_1 = dbquery("SELECT * FROM couleurs WHERE pantone='".param('pantone_enveloppe')."'");

$p_enveloppe = dbresult($sql_couleur_1,0,"C");
$C_enveloppe = dbresult($sql_couleur_1,0,"C");
$M_enveloppe = dbresult($sql_couleur_1,0,"M");
$Y_enveloppe = dbresult($sql_couleur_1,0,"Y");
$K_enveloppe = dbresult($sql_couleur_1,0,"K");

$pdf->AddSpotColor('Pantone '.param('pantone_enveloppe').' C', $C_enveloppe, $M_enveloppe, $Y_enveloppe, $K_enveloppe);



$sql_papeterie_contact = dbquery("SELECT *
	FROM papeterie_contact
	WHERE id_papeterie_contact = '".$_GET['id_papeterie_contact']."'");

if (dbnumrows($sql_papeterie_contact) == 0)
	die ("Contact papeterie non trouvé");

$titre				= dbresult($sql_papeterie_contact,0,"titre");
$nom				= dbresult($sql_papeterie_contact,0,"nom");
$prenom				= dbresult($sql_papeterie_contact,0,"prenom");
$telephone			= dbresult($sql_papeterie_contact,0,"telephone");
$fax				= dbresult($sql_papeterie_contact,0,"fax");
$email				= dbresult($sql_papeterie_contact,0,"email");
$qualite_ligne_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_1");
$qualite_ligne_2	= dbresult($sql_papeterie_contact,0,"qualite_ligne_2");
$qualite_ligne_3	= dbresult($sql_papeterie_contact,0,"qualite_ligne_3");
$qualite_ligne_cv_1	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_1");
$qualite_ligne_cv_2	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_2");
$qualite_ligne_cv_3	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_3");
$qualite_ligne_cv_4	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_4");
$qualite_ligne_cv_5	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_5");
$qualite_ligne_cv_6	= dbresult($sql_papeterie_contact,0,"qualite_ligne_cv_6");
$lieu_cv_1			= dbresult($sql_papeterie_contact,0,"lieu_cv_1");
$lieu_cv_2			= dbresult($sql_papeterie_contact,0,"lieu_cv_2");
$QRCode				= dbresult($sql_papeterie_contact,0,"QRCode");


// SAUT DE PAGE : VERSO
$vcard = "BEGIN:VCARD
VERSION:3.0
FN:".trim($titre." ".$prenom." ".$nom)."
N:".$nom.";".$prenom.";;".$titre.";
TEL;TYPE=WORK:".$telephone."
ADR;TYPE=HOME:;;".$lieu_cv_1.";".$lieu_cv_2.";;;
END:VCARD";


// ==========
// ETIQUETTES
// ==========
$width_carte_visite = 85;
$height_carte_visite = 55;

// SAUT DE PAGE : RECTO
$pdf->AddPage($_GET['orientation']);

for ($j=0;$j<=7;$j++)
{
	$pdf -> etiquette($j);

	
	// Crop Haut + Droite
	$pdf->cropMark($pdf->GetX()+$width_carte_visite, $pdf->GetY(), 3, 3, 'T', array(0,0,0));
	$pdf->cropMark($pdf->GetX()+$width_carte_visite, $pdf->GetY(), 3, 3, 'R', array(0,0,0));

	// Crop Haut + Gauche
	$pdf->cropMark($pdf->GetX(), $pdf->GetY(), 3, 3, 'T', array(0,0,0));
	$pdf->cropMark($pdf->GetX(), $pdf->GetY(), 3, 3, 'L', array(0,0,0));


	// Crop Bas + Droite
	$pdf->cropMark($pdf->GetX()+$width_carte_visite, $pdf->GetY()+$height_carte_visite, 3, 3, 'F', array(0,0,0));
	$pdf->cropMark($pdf->GetX()+$width_carte_visite, $pdf->GetY()+$height_carte_visite, 3, 3, 'R', array(0,0,0));

	// Crop Bas + Gauche
	$pdf->cropMark($pdf->GetX(), $pdf->GetY()+$height_carte_visite, 3, 3, 'F', array(0,0,0));
	$pdf->cropMark($pdf->GetX(), $pdf->GetY()+$height_carte_visite, 3, 3, 'L', array(0,0,0));

	



	// Titre (Pantone 1)
	$pdf -> SetFont('Helvetica','B',11);
	// Couleur pantone
	if (dbresult($sql_personnel,0,"quadrichromie") == 1) 
		$pdf->SetTextSpotColor('Pantone '.param('pantone_enveloppe').' C', 100);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+6);
	$pdf -> Cell($width_carte_visite-10,0, trim($titre." ".$prenom." ".$nom),     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Reste du texte en Noir + Bold + Italique
	$pdf -> SetFont('Helvetica','BI',9);
	$pdf -> SetTextColor(0,0,0,100);

	// Ligne 1
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+12);
	if ($QRCode == "verso")
		$align = "L";
	else
		$align = "R";
	$pdf -> Cell($width_carte_visite-10,0, $qualite_ligne_cv_1,     0, $ln=0,$align, false,'', $stretch=1, false, 'C','C');


	// Ligne 1bis
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+12);
	if ($QRCode == "verso")
		$align = "R";
	else
		$align = "L";

	$pdf -> Cell($width_carte_visite-10,0, $telephone,     0, $ln=0,$align, false,'', $stretch=1, false, 'C','C');


	// Reste du texte en Noir + italique
	$pdf -> etiquette($j);
	$pdf -> SetFont('Helvetica','I',9);

	// Ligne 2
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+18);
	$pdf -> Cell($width_carte_visite-10,0, $qualite_ligne_cv_2,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 3
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+23);
	$pdf -> Cell($width_carte_visite-10,0, $qualite_ligne_cv_3,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 4
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+28);
	$pdf -> Cell($width_carte_visite-10,0, $qualite_ligne_cv_4,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 5
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+33);
	$pdf -> Cell($width_carte_visite-10,0, $qualite_ligne_cv_5,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 6
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+38);
	$pdf -> Cell($width_carte_visite-10,0, $qualite_ligne_cv_6,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 7
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+46);
	$pdf -> Cell($width_carte_visite-10,0, $lieu_cv_1,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 8
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+50);
	$pdf -> Cell($width_carte_visite-10,0, $lieu_cv_2,     0, $ln=0,'L', false,'', $stretch=1, false, 'C','C');

	// Ligne 7 bis
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+46);
	if ($fax <> "")
		$pdf -> Cell($width_carte_visite-10,0, "Fax : ".$fax,     0, $ln=0,'R', false,'', $stretch=1, false, 'C','C');

	// Ligne 8 bis
	$pdf -> etiquette($j);
	$pdf -> SetXY($pdf->GetX()+5,$pdf->GetY()+50);
	$pdf -> Cell($width_carte_visite-10,0, $email,     0, $ln=0,'R', false,'', $stretch=1, false, 'C','C');
}



if ($QRCode == "verso")
	$pdf->AddPage($_GET['orientation']);

for ($j=0;$j<=7;$j++)
{
	// Docteur ** nom ** ** specialité **
	$pdf -> etiquette($j);

	// set style for barcode
	$style = array(
		'border' => 2,
		'vpadding' => 'auto',
		'hpadding' => 'auto',
		'fgcolor' => array(0,0,0),
		'bgcolor' => false, //array(255,255,255)
		'module_width' => 1, // width of a single module in points
		'module_height' => 1 // height of a single module in points
	);

	$width_QRCode = 30;

	// QRCODE,L : QR-CODE Low error correction
	$x_encours = $pdf->GetX() +($width_carte_visite-$width_QRCode)/2;
	if ($QRCode == "verso")
		$x_encours += $pdf->getPageWidth()/$pdf->nb_colonnes-$width_carte_visite;
	
	$pdf->write2DBarcode($vcard, 'QRCODE,L',  $x_encours , $pdf->GetY() + ($pdf->getPageHeight()/$pdf->nb_lignes-40)/2, $width_QRCode, $width_QRCode, $style, 'N');
	$pdf -> SetFont('','',10);


	// Notice
	if ($QRCode == "verso")
	{
		$pdf -> etiquette($j);
		$pdf -> MultiCell($width_carte_visite,10, "Coordonnées au format vCard" , 0, 'C', $fill=false,$ln=2, $pdf -> GetX() + $pdf->getPageWidth()/$pdf->nb_colonnes-$width_carte_visite,$pdf -> GetY()+8,true,0,false,true,0,'T',true);

		$pdf -> etiquette($j);
		$pdf -> MultiCell($width_carte_visite,10, "Flashez ce code QR" , 0, 'C', $fill=false,$ln=2, $pdf -> GetX() + $pdf->getPageWidth()/$pdf->nb_colonnes-$width_carte_visite,$pdf -> GetY()+50,true,0,false,true,0,'T',true);
	}
}


// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('cartes_visites.pdf', 'I');