<?php
// Connection a la base de donnée
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// JPGraph
require("../../../lib/jpgraph-4.2.6/src/jpgraph.php");
require("../../../lib/jpgraph-4.2.6/src/jpgraph_pie.php");
require("../../../lib/jpgraph-4.2.6/src/jpgraph_pie3d.php");
require("../../../lib/jpgraph-4.2.6/src/jpgraph_bar.php");


// Hommes / Femmes / Total
$sql_hommes = dbquery("SELECT COUNT(*) AS nb_hommes
	FROM clients
	WHERE sexe='H'");

$sql_femmes = dbquery("SELECT COUNT(*) AS nb_femmes
	FROM clients
	WHERE sexe='F'");


// Some data
$data = array(dbresult($sql_hommes,0,"nb_hommes"),dbresult($sql_femmes,0,"nb_femmes"));

// Create the Pie Graph.
$graph = new PieGraph($_GET['width'],$_GET['height'],"auto");
$graph->SetAntiAliasing();
$graph->SetShadow();


// Legend
$graph->legend->SetFont(FF_VERDANA,FS_NORMAL,$_GET['font_size']-2);
$graph->legend->SetVColMargin($_GET['font_size']-2); 
$graph->legend->Pos(0.05,0.15);

// Create pie plot
$p1 = new PiePlot3d($data);
$p1->SetSliceColors(array('dodgerblue','pink'));
$p1->SetCenter(0.4);
$p1->SetAngle(30);
$p1->value->SetFont(FF_ARIAL,FS_NORMAL,12);
$p1->SetLegends(array("Hommes","Femmes"));


$graph->Add($p1);
$graph->Stroke();

?>