<?php
// =====================================
// Formulaire de recherche d'un auditeur
// =====================================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");


function affiche_graphique($image,$width,$height,$font_size)
{
	echo "<a class='popup fancybox.iframe' href='".$image."&width=".$width*1.4."&height=".$height*1.4."&font_size=".$font_size*1.2."'><img src='".$image."&width=".$width."&height=".$height."&font_size=".$font_size."' border='0'></a>";
}
?>


<script type="text/javascript"> 
$(document).ready(function()
{		
	$(".popup").fancybox({
		afterClose : function() {         
			parent.location.reload(true);
		}
	});

	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	$( "#tabs" ).tabs({ active: 1 });

	$.datepicker.setDefaults( $.datepicker.regional[ "fr" ] );
	$("#date_from").datepicker();
	$("#date_to").datepicker();

});
</script>


<div class='title'>Statistiques</div>


<div id="tabs">
	<ul>
		<li><a href="#tabs-1">Homme Femmes</a></li>
		<li><a href="#tabs-2">Type consultaton</a></li>
		<li><a href="#tabs-3">Dernières consultations</a></li>
	</ul>
	<div id="tabs-1">
		<?php
		// Hommes / Femmes / Total
		$sql_hommes = "SELECT COUNT(*) AS nb_hommes
			FROM clients
			WHERE sexe='H'";

		$sql_femmes = "SELECT COUNT(*) AS nb_femmes
			FROM clients
			WHERE sexe='F'";

		$sql_all = "SELECT COUNT(*) AS nb_total
			FROM clients";
		?>

		<table cellpadding='10' cellspacing='0' border='1' style='position:relative;top:30px;left:10px'>
		<tr>
			<td>Hommes</td>
			<td><a href="/cabinet/consultations/gestion_clients/xlsx_clients.php?sexe=H"><?php echo dbresult(dbquery($sql_hommes),0,"nb_hommes")?></a></td>
		</tr>
		<tr>
			<td>Femmes</td>
			<td><a href="/cabinet/consultations/gestion_clients/xlsx_clients.php?sexe=F"><?php echo dbresult(dbquery($sql_femmes),0,"nb_femmes")?></a></td>
		</tr>
		<tr>
			<td><font color='red'><b>Total</b></font></td>
			<td><font color='red'><b><?php echo dbresult(dbquery($sql_all),0,"nb_total")?></b></font></td>
		</tr>
		</table>

		<div style='position:absolute;top:40px;left:240px'><?php if (dbresult(dbquery($sql_all),0,"nb_total") > 0) affiche_graphique("pie_3d_hommes_femmes.php?".$_SERVER['QUERY_STRING'],350,240,10) ?></div>

	
	
	
		<!-- Hommes / Femmes par age -->
		<?php
		// Retourne la date d'il y a -- années
		function years_ago($nb)
		{
			return date("Y")-$nb."-".date("d")."-".date("m");
		}

		// Calcul entre 2 dates
		function calcul($nb_years_ago_from,$nb_years_ago_to,$data)
		{
			$sql_hommes = "SELECT COUNT(*) AS nb_hommes
				FROM clients
				WHERE date_naissance>='".years_ago($nb_years_ago_to)."'
					AND date_naissance<'".years_ago($nb_years_ago_from)."'
					AND sexe='H'";

			$sql_femmes = "SELECT COUNT(*) AS nb_femmes
				FROM clients
				WHERE date_naissance>='".years_ago($nb_years_ago_to)."'
					AND date_naissance<'".years_ago($nb_years_ago_from)."'
					AND sexe='F'";


			$sql_age['hommes'][$nb_years_ago]=dbquery($sql_hommes);
			$sql_age['femmes'][$nb_years_ago]=dbquery($sql_femmes);

			$data['hommes'][]=dbresult($sql_age['hommes'][$nb_years_ago],0,"nb_hommes");
			$data['femmes'][]=dbresult($sql_age['femmes'][$nb_years_ago],0,"nb_femmes");

			return $data;
		}

		// Legende
		$legende2 = array('<20','20-30','30-40','40-50','50-60','60-70','70-80','>80');

		// Data
		$data2=calcul(0,20,$data2);
		$data2=calcul(20,30,$data2);
		$data2=calcul(30,40,$data2);
		$data2=calcul(40,50,$data2);
		$data2=calcul(50,60,$data2);
		$data2=calcul(60,70,$data2);
		$data2=calcul(70,80,$data2);
		$data2=calcul(80,120,$data2);
		?>

		<table cellpadding='10' cellspacing='0' border='1' style='position:relative;top:140px;left:10px'>
		<tr>
			<td></td>
			<?php
			foreach($legende2 as $value)
			{
				echo "<td><b>".$value."</b></td>";		
			}
			?>
		</tr>
		<tr>
			<td>Hommes</td>
			<?php
			foreach($data2['hommes'] as $value)
			{
				echo "<td>".$value."</td>";		
			}
			?>
		</tr>
		<tr>
			<td>Femmes</td>
			<?php
			foreach($data2['femmes'] as $value)
			{
				echo "<td>".$value."</td>";		
			}
			?>
		</tr>
		<tr>
			<td><font color='red'><b>Total</b></font></td>
			<?php
			foreach($data2['hommes'] as $key=>$value)
			{
				$total = $data2['hommes'][$key]+$data2['femmes'][$key];
				echo "<td>".$total."</td>";		
			}
			?>
		</tr>
		</table>

		<div style='position:relative;top:0px;left:490px'>
			<?php if (dbresult(dbquery($sql_all),0,"nb_total") > 0)  affiche_graphique("bar_plot_hommes_femmes_age.php?".$_SERVER['QUERY_STRING'],400,240,10) ?></div>
	
	</div>
	
	<div id="tabs-2">
		<?php
		$sql_min_max_datetime_debut = dbquery("SELECT MIN(datetime_debut) AS min_datetime_debut, MAX(datetime_debut) AS max_datetime_debut
			FROM agenda
			WHERE YEAR(datetime_debut) = '".date('Y')."'");
		?>
		<table class="tablesorter"> 
		<thead> 
		<tr>
			<th style='width:160px'>Type consultation <?php echo date('Y') ?></th>
			<?php
			$date = new datetime(dbresult($sql_min_max_datetime_debut,0,"min_datetime_debut"));
			$date_max = new datetime(dbresult($sql_min_max_datetime_debut,0,"max_datetime_debut"));
			$date_max->modify('+1 month');
			

			while ($date->format('m-Y') <> $date_max->format('m-Y'))
			{					
				echo "<td style='width:90px;text-align:center'>";
				echo ucfirst($dico[$date->format('F')]);
				echo "</td>";

				$date->modify('+1 month');
			}
			?>
			<td>PU</td>
		</tr>
		</thead>
		<tbody>

		<?php
		$sql_type_consultation = dbquery("SELECT *
			FROM type_rendez_vous
			ORDER BY id_type_rendez_vous ASC");
			
		$tab_previsionnel = array();
		for ($i=0;$i<dbnumrows($sql_type_consultation);$i++)
		{
			$id_type_rendez_vous	= dbresult($sql_type_consultation,$i,"id_type_rendez_vous");
			$intitule				= dbresult($sql_type_consultation,$i,"intitule");
			$previsionnel			= dbresult($sql_type_consultation,$i,"previsionnel");
			$background_color		= dbresult($sql_type_consultation,$i,"background_color");
			$border_color			= dbresult($sql_type_consultation,$i,"border_color");

			echo "<tr>";
			echo "<td style='border-color:#".$border_color.";background-color:#".$background_color."'>".$intitule."</td>";
			
			$date = new datetime(dbresult($sql_min_max_datetime_debut,0,"min_datetime_debut"));

			while ($date->format('m-Y') <> $date_max->format('m-Y'))
			{
				$sql_nb_rendez_vous = dbquery("SELECT COUNT(*) AS nb_rendez_vous
					FROM agenda,clients
					WHERE agenda.id_client = clients.id_client
						AND agenda.id_type_rendez_vous = '".$id_type_rendez_vous."'
						AND MONTH(datetime_debut )= '".$date->format('m')."'
						AND YEAR(datetime_debut )= '".$date->format('Y')."'
						AND clients.deces = '0'");

				$nb_rendez_vous = dbresult($sql_nb_rendez_vous,0,"nb_rendez_vous");

				echo "<td style='width:60px;text-align:center'>";
				echo "<a href='/cabinet/consultations/gestion_clients/xlsx_clients.php?id_type_rendez_vous=".$id_type_rendez_vous."&month=".$date->format('m')."&year=".$date->format('Y')."'>".$nb_rendez_vous."</a>";
				
				echo "</td>";

				$tab_previsionnel[$date->format('Y-m')] = $tab_previsionnel[$date->format('Y-m')] + $nb_rendez_vous*$previsionnel;
				$date->modify('+1 month');
			}

			echo "<td style='text-align:right'><a class='popup fancybox.iframe' href='update_form.php?id_type_rendez_vous=".$id_type_rendez_vous."'>".$previsionnel."&nbsp;€</a></td>";

			echo "</tr>";
		}
		?>
		</tbody>

		<tfoot>
		<tr>
			<td style='font-weight:bold'>Prévisionnel</td>
			<?php
			$date = new datetime(dbresult($sql_min_max_datetime_debut,0,"min_datetime_debut"));

			while ($date->format('m-Y') <> $date_max->format('m-Y'))
			{
				echo "<td style='text-align:center;font-weight:bold'>";
				echo number_format($tab_previsionnel[$date->format('Y-m')], 0, ',', ' ')." €";
				echo "</td>";

				$date->modify('+1 month');
			}
			?>
			</td><td>
		</tr>
		</tfoot>
		</table>

		
		<?php
		$sql_min_max_datetime_debut = dbquery("SELECT MIN(datetime_debut) AS min_datetime_debut, MAX(datetime_debut) AS max_datetime_debut
			FROM agenda
			WHERE YEAR(datetime_debut) <> '0000'");

		$date_min = new datetime(dbresult($sql_min_max_datetime_debut,0,"min_datetime_debut"));
		$date_max = new datetime(dbresult($sql_min_max_datetime_debut,0,"max_datetime_debut"));
		?>


		<form method='get' action='xlsx_previsionnel.php'>
			<table border="0" cellpadding="5">
			<tr>
				<td style='text-align:center; padding-left:10px; padding-right:10px; padding-top:0px; padding-bottom:0px; color:#555555; font-weight:bold; font-size:10px'>Prévisionnel<br>par année</td>
				<td style='text-align:center' valign='middle'><input type="text" id="date_from" name="date_from" value="<?php echo $date_min->format('d/m/Y') ?>" style='width:80px'></td>
				<td style='text-align:center' valign='middle'>à</td>
				<td style='text-align:center' valign='middle'><input type="text" id="date_to"   name="date_to"   value="<?php echo $date_max->format('d/m/Y') ?>" style='width:80px'></td>
				<td style='text-align:center' valign='middle'><button type='submit'><i style='background-color:white;color:green' class='bi bi-file-earmark-excel-fill fa-2x'></i></button></td>
			</tr>
			</table>
		</form>

	</div>

	<div id="tabs-3">

	</div>
</div>



<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>