<?php
// Connection a la base de donnée
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// JPGraph
require("../../../lib/jpgraph-4.2.6/src/jpgraph.php");
require("../../../lib/jpgraph-4.2.6/src/jpgraph_pie.php");
require("../../../lib/jpgraph-4.2.6/src/jpgraph_pie3d.php");
require("../../../lib/jpgraph-4.2.6/src/jpgraph_bar.php");


// Retourne la date d'il y a -- années
function years_ago($nb)
{
	return date("Y")-$nb."-".date("d")."-".date("m");
}

// Calcul entre 2 dates
function calcul($nb_years_ago_from,$nb_years_ago_to,$data)
{
	$sql_hommes = "SELECT COUNT(*) AS nb_hommes
		FROM clients
		WHERE date_naissance>='".years_ago($nb_years_ago_to)."'
			AND date_naissance<'".years_ago($nb_years_ago_from)."'
			AND sexe='H'";

	$sql_femmes = "SELECT COUNT(*) AS nb_femmes
		FROM clients
		WHERE date_naissance>='".years_ago($nb_years_ago_to)."'
			AND date_naissance<'".years_ago($nb_years_ago_from)."'
			AND sexe='F'";


	$sql_age['hommes'][$nb_years_ago]=dbquery($sql_hommes);
	$sql_age['femmes'][$nb_years_ago]=dbquery($sql_femmes);

	$data['hommes'][]=dbresult($sql_age['hommes'][$nb_years_ago],0,"nb_hommes");
	$data['femmes'][]=dbresult($sql_age['femmes'][$nb_years_ago],0,"nb_femmes");

	return $data;
}

// Legende
$legende2[0]  = '<20';
$legende2[1]  = '20-30';
$legende2[2]  = '30-40';
$legende2[3]  = '40-50';
$legende2[4]  = '50-60';
$legende2[5]  = '60-70';
$legende2[6]  = '70-80';
$legende2[7]  = '>80';

// Data
$data2 = calcul(0,20,$data2);
$data2 = calcul(20,30,$data2);
$data2 = calcul(30,40,$data2);
$data2 = calcul(40,50,$data2);
$data2 = calcul(50,60,$data2);
$data2 = calcul(60,70,$data2);
$data2 = calcul(70,80,$data2);
$data2 = calcul(80,120,$data2);


// Create the graph. These two calls are always required
$graph = new Graph($_GET['width'],$_GET['height'],"auto");    
$graph->SetScale("textlin");

$graph->SetShadow();
$graph->img->SetMargin(40,30,20,40);

// Legende
$graph->xaxis->SetTickLabels($legende2);

// Create the bar plots
$b1plot = new BarPlot($data2['hommes']);
//$b1plot->SetFillColor("blue");
$b1plot->SetFillGradient("dodgerblue","navy",GRAD_HOR);
$b1plot->SetLegend("Hommes");

$b2plot = new BarPlot($data2['femmes']);
//$b2plot->SetFillColor("pink");
$b2plot->SetFillGradient("pink","hotpink",GRAD_HOR);
$b2plot->SetLegend("Femmes");

// Create the grouped bar plot
$gbplot = new GroupBarPlot(array($b1plot,$b2plot));

// ...and add it to the graPH
$graph->Add($gbplot);

$graph->title->Set("Hommes / Femmes par age");

$graph->title->SetFont(FF_FONT1,FS_BOLD);
$graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
$graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);

// Display the graph
if ($_GET['generate_image'] == 1)	$graph->Stroke("generated_images/bar_plot_hommes_femmes_age.png");
else	$graph->Stroke();

?>