<?php
// ============
// ENVELOPPE DL
// --> pdf
// ============

session_start();


require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


// create new PDF document
$pdf = new TCPDF('landscape', 'mm', 'DL', true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Etiquettes');
$pdf->SetSubject('Etiquettes');
$pdf->SetKeywords('Etiquettes');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(54);
$pdf->SetLeftMargin(94);
$pdf->SetRightMargin(15);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetTextColor(0,0,0);



$sql_mutuelles = dbquery("SELECT *
	FROM mutuelles
	ORDER BY raison_sociale ASC");

// ==========
// ETIQUETTES
// ==========

$pdf -> SetFontSize(15);
for ($i=0;$i<dbnumrows($sql_mutuelles);$i++)
{
	$pdf->AddPage('Landscape');

	$raison_sociale		= strtoupper(dbresult($sql_mutuelles,$i,"raison_sociale"));
	$adresse			= dbresult($sql_mutuelles,$i,"adresse");
	$boite_postale		= dbresult($sql_mutuelles,$i,"boite_postale");
	$code_postal		= dbresult($sql_mutuelles,$i,"code_postal");
	$commune			= dbresult($sql_mutuelles,$i,"commune");

	
	// Raison sociale
	// Adresse
	$libelle = $raison_sociale."\n". stripslashes(str_replace(",","",$adresse))."\n".$boite_postale;
	$pdf -> MultiCell(100,12, $libelle , 0, 1, $fill=false,$ln=2, $pdf -> GetX(),$pdf -> GetY(),true,0,false,true,0,'T',true);

	// Code postal
	$pdf -> SetXY(94,84);
	$pdf -> Cell(33,0, $code_postal,     0, $ln=0,'R', $fill=false,'', $stretch=4, false, 'C','C');

	// Commune
	$pdf -> MultiCell(65,12, $commune , 0, 1, $fill=false,$ln=2, 135,81,true,0,false,true,0,'T',true);
}


// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('enveloppe_mutuelle.pdf', 'I');