<?php
// =====================================
// Formulaire de recherche d'un auditeur
// =====================================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");
?>

<script type="text/javascript">
<!--
$(document).ready(function()
{
	$('[data-fancybox]').fancybox({
		afterClose : function() {
			document.location.reload(true);
		}
	});

	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	$( "#tabs" ).tabs({ active: 0 });
});
//-->
</script>


<div id="tabs" style="position:absolute; top: 20px">
	<ul>
		<li><a href="#tabs-1">Médicaments</a></li>
		<li><a href="#tabs-2">Laboratoires</a></li>
	</ul>

	<div id="tabs-1">

		<div class='title'>Médicaments</div>

		<a style="position:absolute; top: 50px; left: 100px" data-fancybox data-type='ajax' id='add' href='add_form.php'><i class="fa fa-plus-circle fa-lg"></i></a>

		<form method='get'>
			<input type="text" name="medicament" value="<?php echo $_GET['medicament'] ?>">
			<input type="submit" class="btn btn-primary" value="Recherche">
		</form>

		<table id="table_client" class="tablesorter" style='margin-top:10px;width:600px'> 
		<thead> 
		<tr>
			<th style='width:40px'></th>
			<th style='width:100px'>CIS</th>
			<th style='width:300px'>Dénomination médicament</th>	
			<th style='width:100px'>AMM</th>	
			<th style='width:300px'>Présentation</th>
			<th>Composition</th>
			<th>Condition presc.</th>
			<th>Info Importantes</th>
		</tr>
		</thead>
		<tbody>

		<?php
		$tab_medicament = explode(' ',$_GET['medicament']);

		$where_sql = "(1=1 ";
		foreach ($tab_medicament as $medicament)
		{
			$where_sql .= "AND (denomination_medicament LIKE '%".$medicament."%' OR id_code_CIS LIKE '%".$medicament."%')";
		}
		$where_sql .= ")";		
		
		$sql_medicaments = dbquery("SELECT *
			FROM medicaments
			WHERE ".$where_sql."
				AND etat_commercialisation='Commercialisée'
			ORDER BY denomination_medicament ASC
			LIMIT 0,50");
			
		for ($i=0;$i<dbnumrows($sql_medicaments);$i++)
		{
			$id_code_CIS				= dbresult($sql_medicaments,$i,"id_code_CIS");
			$denomination_medicament	= dbresult($sql_medicaments,$i,"denomination_medicament");
			$date_AMM	= dbresult($sql_medicaments,$i,"date_AMM");


			echo "<tr id='".$i."'><td style='text-align:center'><a data-fancybox data-type='ajax'  href='update_form.php?id_code_CIS=".$id_code_CIS."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
			echo "<td>".$id_code_CIS."</td>";
			echo "<td>".$denomination_medicament."</td>";
			echo "<td>".date_iso_fr($date_AMM)."</td>";
			
			
			// ------------
			// Présentation
			// ------------
			echo "<td>";

			echo "<table><thead><tr><th>CIP7</th><th>CIP13</th><th>Taux rembour.</th><th>Prix</th></tr></thead><tbody>";
			$sql_medicaments_presentation = dbquery("SELECT *
				FROM medicaments_presentation
				WHERE id_code_CIS = '".$id_code_CIS."'");
				
			for ($j=0;$j<dbnumrows($sql_medicaments_presentation);$j++)
			{
				$id_code_CIP7	= dbresult($sql_medicaments_presentation,$j,"id_code_CIP7");
				$id_code_CIP13	= dbresult($sql_medicaments_presentation,$j,"id_code_CIP13");
				$taux_remboursement	= dbresult($sql_medicaments_presentation,$j,"taux_remboursement");
				$prix_medicament_euro	= dbresult($sql_medicaments_presentation,$j,"prix_medicament_euro");

				echo "<tr id='".$i."'><td style='text-align:center'>".$id_code_CIP7."</td>";
				echo "<td style='text-align:center'>".$id_code_CIP13."</td>";
				echo "<td style='text-align:center'>".$taux_remboursement."</td>";
				echo "<td style='text-align:right'>".$prix_medicament_euro." €</td></tr>";
			}
			echo "</tbody></table>";

			echo "</td>";

			// ------------------------
			// Medicaments COMPOSITIONS
			// ------------------------
			echo "<td>";

			echo "<table><thead><tr><th>Substance</th><th>Dosage</th></tr></thead><tbody>";
			$sql_medicaments_compositions = dbquery("SELECT *
				FROM medicaments_compositions
				WHERE id_code_CIS = '".$id_code_CIS."'");
				
			for ($j=0;$j<dbnumrows($sql_medicaments_compositions);$j++)
			{
				$denomination_substance	= dbresult($sql_medicaments_compositions,$j,"denomination_substance");
				$dosage_substance	= dbresult($sql_medicaments_compositions,$j,"dosage_substance");

				echo "<tr id='".$i."'><td style='text-align:left'>".$denomination_substance."</td>";
				echo "<td style='text-align:right'>".$dosage_substance."</td></tr>";
			}
			echo "</tbody></table>";

			echo "</td>";

			// -----------------------
			// Conditions prescription
			// -----------------------
			echo "<td>";

			echo "<table><thead></thead><tbody>";
			$sql_conditions_prescription = dbquery("SELECT *
				FROM medicaments_conditions_prescription
				WHERE id_code_CIS = '".$id_code_CIS."'");
				
			for ($j=0;$j<dbnumrows($sql_conditions_prescription);$j++)
			{
				$conditions_prescription	= dbresult($sql_conditions_prescription,$j,"conditions_prescription");

				echo "<tr id='".$i."'><td style='text-align:left'>".$conditions_prescription."</td></tr>";
			}
			echo "</tbody></table>";

			echo "</td>";


			// ------------------------
			// Informations importantes
			// ------------------------
			echo "<td>";

			echo "<table><thead></thead><tbody>";
			$sql_medicaments_informations_importantes = dbquery("SELECT *
				FROM medicaments_informations_importantes
				WHERE id_code_CIS = '".$id_code_CIS."'");
				
			for ($j=0;$j<dbnumrows($sql_medicaments_informations_importantes);$j++)
			{
				$lien	= dbresult($sql_medicaments_informations_importantes,$j,"lien");

				echo "<tr id='".$i."'><td style='text-align:left'>".$lien."</td></tr>";
			}
			echo "</tbody></table>";

			echo "</td>";



			echo "</tr>";
		}
		?>
		</tbody>
		</table>
	</div>

	<div id="tabs-2">

		<div class='title'>Laboratoires</div>

		<a style="position:absolute; top: 50px; left: 100px" class='popup fancybox.iframe' id='add' href='laboratoires/add_form.php'><i class="fa fa-plus-circle fa-lg"></i></a>

		<table id="table_client" class="tablesorter" style='width:470px'> 
		<thead> 
		<tr>
			<th style='width:40px'></th>
			<th style='width:100px'>Id Laboratoire</th>
			<th style='width:300px'>Nom</th>	
		</tr>
		</thead>
		<tbody>

		<?php
		$sql_laboratoires = dbquery("SELECT *
			FROM laboratoires
			ORDER BY id_laboratoire ASC");
			
		for ($i=0;$i<dbnumrows($sql_laboratoires);$i++)
		{
			$id_laboratoire	= dbresult($sql_laboratoires,$i,"id_laboratoire");
			$nom			= dbresult($sql_laboratoires,$i,"nom");

			echo "<tr id='".$i."'><td style='text-align:center'><a class='popup fancybox.iframe'  href='laboratoires/update_form.php?id_laboratoire=".$id_laboratoire."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
			echo "<td>".$id_laboratoire."</td>";
			echo "<td>".$nom."</td>";
			echo "</tr>";
		}
		?>
		</tbody>
		</table>
	</div>

</div>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>