<?php
// =====================================
// Formulaire de recherche d'un auditeur
// =====================================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");
?>

<!-- jQuery UI DatePicker français -->
<script type="text/javascript" src="/lib/jquery-ui/jquery.ui.datepicker-fr.js"></script>


<script type="text/javascript"> 
$(document).ready(function()
{		
	$('[data-fancybox]').fancybox({
		afterClose : function() {
			document.location.reload(true);
		}
	});
	

	// --------------------------------------
	// Selectionne ou deselectionne une ligne
	// --------------------------------------
	$("tr").click(function()				
	{
		$(this).toggleClass("choix");
	});


	// ----------------------
	// Initialize tablesorter
	// ----------------------
	$("table").tablesorter({
		headers : { 0 : { sorter: false } },
		theme : "bootstrap",
		widthFixed: true,
	    headerTemplate : '{content} {icon}', // new in v2.7. Needed to add the bootstrap icon!
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

});	
</script> 

<div class='title'>Alertes doublons EFR</div>

<?php
$sql = dbquery("SELECT clients.*, COUNT( * ) AS nb
	FROM clients,agenda
	WHERE clients.id_client = agenda.id_client
		AND agenda.id_type_rendez_vous =  '2'
	GROUP BY clients.id_client
	HAVING nb >=2");

if (dbnumrows($sql)>0)
{
	?>
	
	<!-- Réponses -->
	<div style="position:absolute; top: 60px; left: 10px">
	
		<div style="color:green"><b><?php echo dbnumrows($sql)?></b> réponse<?php if (dbnumrows($sql)>1) echo "s"?></div>

		<table id="table_client" class="tablesorter" style='width:600px'> 
		<thead> 
		<tr>
			<th></th>
			<th>Nom</th>
			<th>Prénom</th>
			<th>Agenda</th>
		</tr>
		</thead>
		<tbody>

		<?php
		for ($i=0;$i<dbnumrows($sql);$i++)
		{
			$id_client		= dbresult($sql,$i,"id_client");
			$nom			= strtoupper(dbresult($sql,$i,"nom"));
			$prenom			= dbresult($sql,$i,"prenom");
			$code_postal	= dbresult($sql,$i,"code_postal");
			$ville			= dbresult($sql,$i,"ville");

			echo "<tr id='".$i."'><td style='text-align:center'><a href='/cabinet/consultations/gestion_clients/index.php?id_client=".dbresult($sql,$i,"id_client")."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
			echo "<td>".$nom."</td>";
			echo "<td>".$prenom."</td>";
			echo "<td>";

			echo "<table style='border:0px'>";
			
			echo "<tr><td><a data-fancybox data-type='ajax' href='/cabinet/agenda/add_form.php?id_client=".$id_client."'><i class='fa fa-plus-circle fa-lg'></i></a></td></tr>";
			
			$sql_agenda = dbquery("SELECT *
				FROM agenda,type_rendez_vous
				WHERE agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
					AND agenda.id_client='".$id_client."'
				ORDER BY agenda.datetime_debut ASC");
			
			for ($j=0;$j<dbnumrows($sql_agenda);$j++)
			{
				$id_agenda				= dbresult($sql_agenda,$j,"agenda.id_agenda");
				$datetime_debut			= new datetime(dbresult($sql_agenda,$j,"agenda.datetime_debut"));
				$datetime_fin			= new datetime(dbresult($sql_agenda,$j,"agenda.datetime_fin"));
				$type_rendez_vous		= dbresult($sql_agenda,$j,"type_rendez_vous.intitule");
				$background_color		= dbresult($sql_agenda,$j,"type_rendez_vous.background_color");

				echo "<tr><td style='width:20px'><a data-fancybox data-type='ajax' href='/cabinet/agenda/update_form.php?id_agenda=".$id_agenda."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
				echo "<td style='width:70px'>".$datetime_debut->format('d/m/Y')."</td>";
				echo "<td style='width:40px'>".$datetime_debut->format('H:i')."</td>";
				echo "<td style='background-color:#".$background_color."'>".$type_rendez_vous."</td></tr>";

				if ($type_rendez_vous == "EFR")
				{
					// Ecart entre aujourd'hui et EFR + param('delai_mois_entre_2_efr') mois
					$datetime_now = new datetime(dbresult($sql_agenda,$j,"datetime_debut"));
					$datetime_debut_4_mois	= clone $datetime_debut;
					$datetime_debut_4_mois->modify('-'.param('delai_mois_entre_2_efr').' month');

					$sql_agenda_date = dbquery("SELECT * FROM agenda,type_rendez_vous
						WHERE agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
							AND type_rendez_vous.intitule='EFR'
							AND agenda.id_agenda <> '".$id_agenda."'
							AND agenda.id_client = '".$id_client."'
							AND DATE(datetime_debut) > '".$datetime_debut_4_mois->format('Y-m-d')."'
							AND DATE(datetime_debut) <= '".$datetime_debut->format('Y-m-d')."'");
				
					if (dbnumrows($sql_agenda_date) > 0)	echo "<tr><td></td><td colspan='4'><img src='/images/icones/32px/failed.png' width='16' height='16' border='0' alt=''> <span style='color:red'>Trop d'EFR.</span> Délai : ".param('delai_mois_entre_2_efr')." mois</td></tr>";
				}
			}
			echo "</table>";
			echo "</td></tr>";
		}
		?>
		</tbody>
		</table>
	</div>
	<?php
}
else
{
	echo "<div style='position:absolute; top: 20px; left: 10px; width:200px; color:green'><b>Aucun résultat</b> trouvé ...</div>";
}

?>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>