<?php
// ==============================
// REORGANISE LA TABLE PAR NIVEAU
// ==============================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");


// ------------------------------------------------------------------------------
// Verifie si les fichiers dans la base correspondent aux fichiers sur le serveur
// ------------------------------------------------------------------------------
$sql_documentation_file = dbquery("SELECT id_documentation_file,file
	FROM documentation_files
	ORDER BY id_documentation,file ASC");

$all_file_found = true;

$array = array();

for ($i=0;$i<dbnumrows($sql_documentation_file);$i++)
{
	$id_documentation_file	= dbresult($sql_documentation_file,$i,"id_documentation_file");
	$file					= dbresult($sql_documentation_file,$i,"file");

	// Suppression du fichier
	if (!is_file('files/'.$file))
	{
		$all_file_found = false;
		$array[] = $file;
	}
}

// -----------------------------------
// Si tout les fichiers ont t trouv
// -----------------------------------
if ($all_file_found)
{
	/*
	+-----------------+--------+
	| id_documentaire | niveau |
	+-----------------+--------+
	|               1 | 1      |
	|               2 | 1.1    |
	|               3 | 1.2.1  |
	|               4 | 1.2.2  |
	|               5 | 1.2.3  |
	|               6 | 2      |
	|               7 | 3      |
	+-----------------+--------+
	*/

	$sql_documentation_min = dbquery("SELECT MIN(id_documentation) AS min
		FROM documentation");

	$sql_documentation_max = dbquery("SELECT MAX(id_documentation) AS max
		FROM documentation");

	$difference = dbresult($sql_documentation_max,0,"max") - dbresult($sql_documentation_min,0,"min")+1;

	dbquery("UPDATE documentation
		SET id_documentation =  id_documentation - ".$difference."
		ORDER BY id_documentation ASC");

	$sql_documentation = dbquery("SELECT id_documentation,niveau
		FROM documentation");

	$tab = array();

	for ($i=0;$i<dbnumrows($sql_documentation);$i++)
	{
		$id_documentation	= dbresult($sql_documentation,$i,"id_documentation");
		$niveau				= dbresult($sql_documentation,$i,"niveau");

		$tab[$id_documentation] =  $niveau;
	}

	natsort($tab);

	$i=1;
	foreach($tab as $id_documentation => $niveau)
	{
		dbquery("UPDATE documentation
			SET id_documentation =  '".$i."'
			WHERE id_documentation='".$id_documentation."'");
		
		$i++;
	}



	/*
	+----------------------+-----------------+
	| id_documentaire_file | id_documentaire |
	+----------------------+-----------------+
	|                    1 | 1               |
	|                    2 | 1               |
	|                    3 | 2               |
	|                    4 | 3               |
	|                    5 | 3               |
	|                    6 | 3               |
	|                    7 | 4               |
	|                    8 | 4               |
	|                    9 | 4               |
	|                   10 | 5               |
	|                   11 | 5               |
	|                   12 | 6               |
	|                   13 | 7               |
	+----------------------+-----------------+
	*/

	$sql_documentation_file_min = dbquery("SELECT MIN(id_documentation_file) AS min
		FROM documentation_files");

	$sql_documentation_file_max = dbquery("SELECT MAX(id_documentation_file) AS max
		FROM documentation_files");

	$difference = dbresult($sql_documentation_file_max,0,"max") - dbresult($sql_documentation_file_min,0,"min")+1;

	dbquery("UPDATE documentation_files
		SET id_documentation_file =  id_documentation_file - ".$difference."
		ORDER BY id_documentation,file ASC");

	$sql_documentation_file = dbquery("SELECT id_documentation_file,file
		FROM documentation_files
		ORDER BY id_documentation,file ASC");

	for ($i=0;$i<dbnumrows($sql_documentation_file);$i++)
	{
		$id_documentation_file = dbresult($sql_documentation_file,$i,"id_documentation_file");
		
		dbquery("UPDATE documentation_files
			SET id_documentation_file =  '".($i+1)."'
			WHERE id_documentation_file='".$id_documentation_file."'");
	}



	$sql_documentation_file = dbquery("SELECT id_documentation_file,file
		FROM documentation_files
		ORDER BY id_documentation,file ASC");

	for ($i=0;$i<dbnumrows($sql_documentation_file);$i++)
	{
		$id_documentation_file	= dbresult($sql_documentation_file,$i,"id_documentation_file");
		$file					= dbresult($sql_documentation_file,$i,"file");

		$number = sprintf('%03d',$id_documentation_file);
		
		$new_file = $number."_".substr(file_without_extension($file),4).".".extension($file);


		// Suppression du fichier
		if (is_file('files/'.$file))
		{
			if (rename('files/'.$file,'files/'.$new_file))
				dbquery("UPDATE documentation_files
					SET file =  '".$new_file."'
					WHERE id_documentation_file='".$id_documentation_file."'");
			else
				echo "Erreur de renommage du fichier files/".$file.".";
		}
		else
			echo "Le fichier files/".$file." n'existe pas.";
	}

	echo "ok";
}
else
{
	echo "Attention : des fichiers n'ont pas t trouv";

	foreach($array as $file)
		echo "<li>".$file." non trouv";
}