<?php
// =============
// Consultations
// =============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");


// ==========
// ORDONNANCE
// ==========

$sql_ordonnance = dbquery("SELECT *
	FROM clients,ordonnances
	WHERE clients.id_client = ordonnances.id_client
		AND ordonnances.id_ordonnance='".$_GET['id_ordonnance']."'");


if (dbnumrows($sql_ordonnance) == 0)
	die("Attention, cette ordonnance n'existe pas ou a été effacé. Merci.");

$id_client						= dbresult($sql_ordonnance,0,"clients.id_client");
$nom							= dbresult($sql_ordonnance,0,"clients.nom");
$prenom							= dbresult($sql_ordonnance,0,"clients.prenom");
$sexe							= dbresult($sql_ordonnance,0,"clients.sexe");
$date_naissance					= dbresult($sql_ordonnance,0,"clients.date_naissance");
$date_ordonnance				= new DateTime(dbresult($sql_ordonnance,0,"ordonnances.date"));

$QSP_affection_exonerante		= dbresult($sql_ordonnance,0,"ordonnances.QSP_affection_exonerante");
$QSP_maladies_intercurrentes	= dbresult($sql_ordonnance,0,"ordonnances.QSP_maladies_intercurrentes");

$e_feminin = "";
if ($sexe == 'F')	
	$e_feminin = "e";


// Info docteur
$sql_docteur = dbquery("SELECT docteurs.*
	FROM docteurs,ordonnances
	WHERE docteurs.id_docteur = ordonnances.id_docteur
		AND ordonnances.id_ordonnance='".$_GET['id_ordonnance']."'");

$nom_docteur	= dbresult($sql_docteur,0,"nom_docteur");
$specialite		= dbresult($sql_docteur,0,"specialite");
$entete			= dbresult($sql_docteur,0,"entete");
?>


<script type="text/javascript">
<!--
$(document).ready(function()
{
	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	/*
	+---------+-------------------------------------+-----------------------------+-----------+
	| 1. save | 2. save_and_courrier_ordonnance_pdf | 3. save_and_ordonnance_pdf  | 4. delete |
	+---------+-------------------------------------+-----------------------------+-----------+
	*/
	// 1. Enregistrer
	$( "#save" ).click( function() {
		$.ajax({
			type : 'POST',
			url : '/cabinet/consultations/ordonnance/update.php',
			beforeSend:	function(){
				$( "#save" ).css("color", "#999");
			},
			data : $("#form_ordonnance").serialize(),
			success : function(data){
				$( "#save" ).css("color", "#000");

				// Chargement initial
				$("#ajax").load("update_ajax_form.php?id_client=<?php echo $_GET['id_client'] ?>&id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>");


			}
		});
	});

	// 2. Enregistrer + PDF
	$( "#save_and_courrier_ordonnance_pdf" ).click( function() {

	
		$.ajax({
			type : 'POST',
			url : '/cabinet/consultations/ordonnance/update.php',
			data : $("#form_ordonnance").serialize(),
			success : function(data){
				
				
				$.fancybox.open({
					src  : '/cabinet/consultations/courrier_ordonnance/index.php?id_client=<?php echo $_GET['id_client'] ?>&date=<?php echo $date_ordonnance->format('Y-m-d') ?>',
					type : 'ajax',
					opts : {
						afterClose : function() {
							//$('#calendar').fullCalendar( 'refetchEvents' );
						}
					}

				});	
				
			}
		});
	});

	// 3. Enregistrer + PDF
	$( "#save_and_ordonnance_pdf" ).click( function() {
		$.ajax({
			type : 'POST',
			url : '/cabinet/consultations/ordonnance/update.php',
			data : $("#form_ordonnance").serialize(),
			success : function(data){
				document.location='/cabinet/pdf/pdf.php?ordonnance[<?php echo $_GET['id_ordonnance'] ?>]=1';
			}
		});
	});

	// 4. Suppr.
	$('#delete').click(function() {

		if ($('#delete').html() == "Voulez vous vraiment supprimer cette ordonnance ?")
		{
			$.ajax({
				type:		"GET",
				url:		"delete.php",
				data:		"id_ordonnance=<?php echo $_GET['id_ordonnance']?>",
				beforeSend:	function(){
					$('#delete').html("Supprimer cette ordonnance <div class='spinner-border spinner-border-sm' role='status'></div>");
				},
				complete:	function(){	
				},
				success:	function(response){
					if (response == "ok")
						document.location.href = "/cabinet/consultations/gestion_clients/index.php?id_client=<?php echo $_GET['id_client']?>"
				}
			 });
		 }
		
		// Changer la valeur du boutton
		$('#delete').html("Voulez vous vraiment supprimer cette ordonnance ?");

	});


	// (+) Ajout affection_exonorante
	$( "#type_prescription_affection_exonorante_add" ).click( function() {
		
		$.ajax({
			type : 'POST',
			url : '/cabinet/consultations/ordonnance/update.php',
			beforeSend:	function(){
				$( "#save" ).css("color", "#999");
			},
			data : $("#form_ordonnance").serialize(),
			success : function(data){
				$( "#save" ).css("color", "#000");
				$( "#type_prescription_affection_exonorante_add" ).attr("style","color:red");
				$( "#type_prescription_affection_exonorante_add" ).attr("class","fa fa-refresh fa-spin fa-lg");
				
				// Ajout
				$.ajax({
					type : 'GET',
					url : '/cabinet/consultations/ordonnance/add_ordonnance_ligne.php',
					data : "id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>&type_prescription=affection_exonorante",
					success : function(data){

						// Chargement initial
						$("#ajax").load("update_ajax_form.php?id_client=<?php echo $_GET['id_client'] ?>&id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>");

					}
				});

			}
		});
		
	});

	// (+) Ajout affection_intercurrentes
	$( "#type_prescription_maladies_intercurrentes_add" ).click( function() {

		$.ajax({
			type : 'POST',
			url : '/cabinet/consultations/ordonnance/update.php',
			beforeSend:	function(){
				$( "#save" ).css("color", "#999");
			},
			data : $("#form_ordonnance").serialize(),
			success : function(data){
				$( "#save" ).css("color", "#000");
				$( "#type_prescription_maladies_intercurrentes_add" ).attr("style","color:red");
				$( "#type_prescription_maladies_intercurrentes_add" ).attr("class","fa fa-refresh fa-spin fa-lg");
				
				// Ajout
				$.ajax({
					type : 'GET',
					url : '/cabinet/consultations/ordonnance/add_ordonnance_ligne.php',
					data : "id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>&type_prescription=maladies_intercurrentes",
					success : function(data){

						// Chargement initial
						$("#ajax").load("update_ajax_form.php?id_client=<?php echo $_GET['id_client'] ?>&id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>");

					}
				});

			}
		});		
		
	});



	// -----------------------
	// AFFECTION EXONÉRANTE
	//          ||
	//          ||
	//          \/
	// MALADIES INTERCURRENTES
	// -----------------------
	$( ".fa-caret-square-o-down" ).click( function() {
		
		var id = $(this).attr('id');
		
		$.ajax({
			type : 'GET',
			url : '/cabinet/consultations/ordonnance/change_type_prescription.php',
			data : "id_ordonnance_ligne="+id+"&type_prescription_to=maladies_intercurrentes",
			success : function(data){

				// Chargement initial
				$("#ajax").load("update_ajax_form.php?id_client=<?php echo $_GET['id_client'] ?>&id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>");
			}
		});
	});



	// -----------------------
	// MALADIES INTERCURRENTES
	//          ||
	//          ||
	//          \/
	// AFFECTION EXONÉRANTE
	// -----------------------
	$( ".fa-caret-square-o-up" ).click( function() {
		
		var id = $(this).attr('id');
		
		$.ajax({
			type : 'GET',
			url : '/cabinet/consultations/ordonnance/change_type_prescription.php',
			data : "id_ordonnance_ligne="+id+"&type_prescription_to=affection_exonorante",
			success : function(data){

				// Chargement initial
				$("#ajax").load("update_ajax_form.php?id_client=<?php echo $_GET['id_client'] ?>&id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>");
			}
		});
	});

	// --
	// <
	// --
	$( ".fa-chevron-left" ).click( function() {
		
		var id_client		= $(this).attr('id_client');
		var id_ordonnance	= $(this).attr('id_ordonnance');
		
		// Chargement initial
		$("#ajax").load("update_ajax_form.php?id_client="+id_client+"&id_ordonnance="+id_ordonnance);
	});

	// --
	// >
	// --
	$( ".fa-chevron-right" ).click( function() {
		
		var id_client		= $(this).attr('id_client');
		var id_ordonnance	= $(this).attr('id_ordonnance');
		
		// Chargement initial
		$("#ajax").load("update_ajax_form.php?id_client="+id_client+"&id_ordonnance="+id_ordonnance);
	});



	$( ".medicament" ).autocomplete({
		source: "/cabinet/gestion/medicaments/bdd/autocomplete_medicament.php",
		minLength: 2,
		dataType: "jsonp",

		select: function( event, ui ) {
			$( "#medicament" ).text( ui.item.value )
		}
	});


	// Close
	$('#close').mouseover(function() {
		$('#close').css( "color","#EC6C60" );
	});

	$('#close').mouseout(function() {
		$('#close').css( "color","#C35A50" );
	});


	$('[data-fancybox]').fancybox({
		afterClose : function() {
			document.location.reload(true);
		}
	});

});	
</script>



<div id='ordonnance' style='position:absolute;top:0px;left:20px;border:1px #EFC377 solid;width:auto;height:auto;padding:5px;background-color:#F9EBD0;width:800px'>

	<form id='form_ordonnance' method='post' action='/cabinet/consultations/ordonnance/update.php'>
		
		<input type="hidden" name="id_client"		value="<?php echo $_GET['id_client'] ?>">
		<input type="hidden" name="id_ordonnance"	value="<?php echo $_GET['id_ordonnance'] ?>">
		
		<!-- Fermer la fenetre -->
		<div style='text-align:right;position:relative;top:-6px;right:-2px'><a href='/cabinet/consultations/gestion_clients/index.php?id_client=<?php echo $_GET['id_client'] ?>'><i id="close" style='color:#C35A50' class="fa fa-window-close fa-2x"></i></a></div>

		
		<table border="0" style="width:100%">
		<tbody>
		<tr>
			<td rowspan='2' style='width:150px;font-weight:bold;padding-bottom:20px'>
			<a data-fancybox data-type='ajax'  href='update_docteur/update_form.php?id_ordonnance=<?php echo $_GET['id_ordonnance'] ?>'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a>
			
			Docteur <?php echo $nom_docteur."<br>".strtoupper($specialite) ?></td>
			<td colspan='3' style='text-align:center'>

			<div class="btn-group" role="group" aria-label="...">
				<button type="button" id="save"			class="btn btn-default"><i class="fa fa-floppy-o fa-lg"></i></button>

				<button type="button" id="save_and_courrier_ordonnance_pdf"			class="btn btn-default"><i style='color:red' class="fa fa-file-pdf-o fa-lg"></i> Cour+Ordo</button>
				
				<button type="button" id="save_and_ordonnance_pdf"	class="btn btn-default" class="btn btn-primary"><i style='color:red' class='fa fa-file-pdf-o fa-lg'></i> PDF</button>
				
				<button type="button" id="delete"			class="btn btn-default"><i style='color:red' class='fa fa-trash-o fa-lg'></i></button>
			</div>


			</td>
			<td rowspan='2' style='width:150px;text-align:right'><b>Patient<?php echo $e_feminin ?> : </b><span style='font-weight:bold;color:blue'><?php echo $nom." ".$prenom ?></span><br>
			<b>Né<?php echo $e_feminin ?> le </b><span style='font-weight:bold;color:blue'><?php echo date_iso_fr($date_naissance) ?></span>
			</td>
		</tr>
		<?php
		$sql_nb_ordonnance_client = dbquery("SELECT *
			FROM ordonnances
			WHERE id_client
				AND id_client='".$_GET['id_client']."'");

		$sql_numero_ordonnance_client = dbquery("SELECT COUNT(*) AS numero
			FROM ordonnances
			WHERE id_ordonnance <= '".$_GET['id_ordonnance']."'
				AND id_client='".$_GET['id_client']."'");

		$sql_ordonnance_client_prev = dbquery("SELECT id_ordonnance
			FROM ordonnances
			WHERE id_ordonnance < '".$_GET['id_ordonnance']."'
				AND id_client='".$_GET['id_client']."'
			ORDER BY id_ordonnance DESC
			LIMIT 0,1");

		$sql_ordonnance_client_suiv = dbquery("SELECT id_ordonnance
			FROM ordonnances
			WHERE id_ordonnance > '".$_GET['id_ordonnance']."'
				AND id_client='".$_GET['id_client']."'
			ORDER BY id_ordonnance ASC
			LIMIT 0,1");
		?>
		<tr>
			<td style='text-align:right;width:100px'>
			<?php
			if (dbnumrows($sql_ordonnance_client_prev)>0)
			{
				echo "<i id_client='".$_GET['id_client']."' id_ordonnance='".dbresult($sql_ordonnance_client_prev,0,"id_ordonnance")."' class='bi bi-chevron-left fa-2x'></i>";
			}
			?>
			</td>
			<td style='text-align:center;width:100px'>
			<b>Ordonnance <span style='font-weight:bold;color:blue'><?php echo dbresult($sql_numero_ordonnance_client,0,"numero") ?> / <?php echo dbnumrows($sql_nb_ordonnance_client) ?></span></b><br>
			<?php echo $date_ordonnance->format('d/m/Y') ?></td>
			<td style='text-align:left;width:100px'>

			<?php
			if (dbnumrows($sql_ordonnance_client_suiv)>0)
			{
				echo "<i id_client='".$_GET['id_client']."' id_ordonnance='".dbresult($sql_ordonnance_client_suiv,0,"id_ordonnance")."' class='bi bi-chevron-right fa-2x'></i>";
			}
			?>
			</td>
		</tr>
		<tr>
			<td colspan='5' style='text-align:center;font-weight:bold;border-top:1px red solid;border-bottom:1px red solid'>Prescriptions relatives au traitement de l'affection de longue durée reconnue (liste ou hors liste)<br>(AFFECTION EXONÉRANTE)</td>
		</tr>
		<tr>
			<td colspan='5' style='text-align:center;padding-bottom:20px;padding-top:10px'>
			<?php
			$sql_medicaments = dbquery("SELECT *
				FROM ordonnances_lignes
				WHERE id_ordonnance='".$_GET['id_ordonnance']."'
					AND type_prescription = 'affection_exonorante'
				ORDER BY id_ordonnance_ligne ASC");
			?>
			<table>
			<thead>
			<tr>
				<td style='width:20px'></td>
				<td>Médicament</td>
				<td>Posologie</td>
				<td>Non substit.</td>
				<td></td>
			</tr>
			</thead>
			<tbody>
			<?php
			for ($j=0;$j<dbnumrows($sql_medicaments);$j++)
			{
				$id_ordonnance_ligne	= dbresult($sql_medicaments,$j,"id_ordonnance_ligne");
				$medicament				= dbresult($sql_medicaments,$j,"medicament");
				$posologie				= dbresult($sql_medicaments,$j,"posologie");
				
				if (dbresult($sql_medicaments,$j,"non_substituable") == 1)
					$non_substituable_checked = "checked";
				else
					$non_substituable_checked = "";

				$numero = $j+1;
				?>

				<tr>
					<td><?php echo $numero ?></td>
					<td><input type='text' class='medicament' style='width:320px;color:red' name="ordonnances_lignes[<?php echo $id_ordonnance_ligne?>][medicament]" value="<?php echo htmlentities($medicament) ?>"></td>
					<td><input type='text' style='width:180px' name="ordonnances_lignes[<?php echo $id_ordonnance_ligne?>][posologie]"			value="<?php echo htmlentities($posologie) ?>"></td>
					<td><input type='checkbox' value='1'	   name="ordonnances_lignes[<?php echo $id_ordonnance_ligne?>][non_substituable]" <?php echo $non_substituable_checked ?>></td>
					<td><i id='<?php echo $id_ordonnance_ligne ?>' style='color:green' class='fa fa-caret-square-o-down fa-lg'></i></td>

				</tr>
				<?php
			}
			?>
			<tr>
				<td><i id='type_prescription_affection_exonorante_add' style='color:#84C600' class='fa fa-plus-circle fa-lg'></i></a></td>
				<td colspan='4'></td>
			</tr>
			<tr><td style='font-weight:bold;color:green'>QSP</td>
			<td colspan='4' style='text-align:left'><input style='width:300px' type="text" name="QSP_affection_exonerante" value="<?php echo htmlentities($QSP_affection_exonerante)?>"></td></tr>
			</tbody>
			</table>
			</td>
		</tr>
		<tr>
			<td colspan='5' style='text-align:center;font-weight:bold;border-top:1px red solid;border-bottom:1px red solid'>Prescriptions SANS RAPPORT avec l’affection de longue durée<br>(MALADIES INTERCURRENTES)</td>
		</tr>
		<tr>
			<td colspan='5' style='text-align:center;padding-bottom:20px;padding-top:10px'>
			<?php
			$sql_medicaments = dbquery("SELECT *
				FROM ordonnances_lignes
				WHERE id_ordonnance='".$_GET['id_ordonnance']."'
					AND type_prescription = 'maladies_intercurrentes'
				ORDER BY id_ordonnance_ligne ASC");
			?>

			<table>
			<thead>
			<tr>
				<td style='width:20px'></td>
				<td>Médicament</td>
				<td>Posologie</td>
				<td>Non substit.</td>
				<td></td>
			</tr>
			</thead>
			<tbody>
			<?php
			for ($j=0;$j<dbnumrows($sql_medicaments);$j++)
			{
				$id_ordonnance_ligne	= dbresult($sql_medicaments,$j,"id_ordonnance_ligne");
				$medicament				= dbresult($sql_medicaments,$j,"medicament");
				$posologie				= dbresult($sql_medicaments,$j,"posologie");

				if (dbresult($sql_medicaments,$j,"non_substituable") == 1)
					$non_substituable_checked = "checked";
				else
					$non_substituable_checked = "";

				$numero = $j+1;

				echo "<tr>";
				echo "<td>".$numero."</td>";
				echo "<td><input class='medicament' type='text' style='width:320px;color:red' name='ordonnances_lignes[".$id_ordonnance_ligne."][medicament]' value='".$medicament."'></td>";
				echo "<td><input type='text' style='width:180px' name='ordonnances_lignes[".$id_ordonnance_ligne."][posologie]' value='".$posologie."'></td>";
				echo "<td><input type='checkbox' value='1' name=ordonnances_lignes[".$id_ordonnance_ligne."][non_substituable]' ".$non_substituable_checked."></td>";
				echo "<td><i id='".$id_ordonnance_ligne."' style='color:green' class='fa fa-caret-square-o-up fa-lg'></i></td>";

				echo "</tr>";
			}
			?>
			<tr>
				<td><i id='type_prescription_maladies_intercurrentes_add' style='color:#84C600' class='fa fa-plus-circle fa-lg'></i></a></td>
				<td colspan='4'></td>
			</tr>
			<tr><td style='font-weight:bold;color:green'>QSP</td>
			<td colspan='4' style='text-align:left'><input style='width:300px' type="text" name="QSP_maladies_intercurrentes" value="<?php echo htmlentities($QSP_maladies_intercurrentes)?>"></td></tr>
		</tbody>
		</table>
	</form>
</div>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>