<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('PHPExcel'));


$objWriter = new PHPExcel();

$sheet = $objWriter->getActiveSheet();


// ======
// STYLES
// ======
$styleEntete = array(
	'font'=>array(
		'bold'=>true,
		'size'=>12,
		'name'=>Arial,
		'color'=>array(
			'rgb'=>'6666CC')),

		'alignment' => array(
			'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
			'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER),

		'fill' => array(
			'type'       => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
			'rotation'   => 90,
			'startcolor' => array(
				'argb' => 'FFFFCC00'),
			'endcolor'   => array(
				'argb' => 'FFFFFFFF')));


$styleDoubleBorderOutline = array(
	'borders' => array(
		'outline' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
	),
);

// Style
$sheet->getStyle('A1:E1')->applyFromArray($styleEntete);



// Cellule A1
$sheet->setCellValue('A1','Liste des clients sélectionnés');

// Fusionnne des cellules
$sheet->mergeCells('A1:E1');

// Largeur des colonne A - E
$sheet->getColumnDimension('A')->setWidth(6);
$sheet->getColumnDimension('B')->setWidth(20);
$sheet->getColumnDimension('C')->setWidth(20);
$sheet->getColumnDimension('D')->setWidth(12);
$sheet->getColumnDimension('E')->setWidth(20);


// Hauteur de la ligne 1
$sheet->getRowDimension('1')->setRowHeight(30);


// Entete
$sheet->setCellValue('A3','Sexe');
$sheet->setCellValue('B3','Nom');
$sheet->setCellValue('C3','Prénom');
$sheet->setCellValue('D3','Code postal');
$sheet->setCellValue('E3','Ville');

// Style
$sheet->getStyle('A3:E3')->applyFromArray($styleDoubleBorderOutline);

// Filtre
$sheet->setAutoFilter('A3:E3');

$ligne = 4;

// Creation de la requete SQL
$where = "1=1 ";

// Par sexe
if (isset($_GET['sexe']))
{
	$where .= "AND sexe='".$_GET['sexe']."' "; 
}

// Par id_client
if (is_array($_GET['id_client']))
{
	$where .= " AND (0=1 "; 
	foreach($_GET['id_client'] as $key=>$value)
	{
		$where .= "OR id_client='".$value."'";
	}
	$where .= ") "; 
}

// Par id_type_consultation
if (isset($_GET['id_type_rendez_vous']))
{

	$where .= "AND id_client IN (SELECT id_client FROM agenda
					WHERE agenda.id_type_rendez_vous = '".$_GET['id_type_rendez_vous']."'
						AND MONTH(datetime_debut )= '".$_GET['month']."'
						AND YEAR(datetime_debut )= '".$_GET['year']."')";
}

echo "SELECT * FROM clients WHERE ".$where;
exit;

$sql_client = dbquery("SELECT * FROM clients WHERE ".$where);

for ($i=0;$i<dbnumrows($sql_client);$i++)
{
	$id_client		= dbresult($sql_client,$i,"id_client");
	$sexe			= dbresult($sql_client,$i,"sexe")." ";
	$nom			= strtoupper(dbresult($sql_client,$i,"nom"));
	$prenom			= dbresult($sql_client,$i,"prenom");
	$code_postal	= dbresult($sql_client,$i,"code_postal");
	$ville			= dbresult($sql_client,$i,"ville");

	$sheet->setCellValueByColumnAndRow(0,$ligne,$sexe);
	$sheet->setCellValueByColumnAndRow(1,$ligne,$nom);
	$sheet->setCellValueByColumnAndRow(2,$ligne,$prenom);
	$sheet->setCellValueByColumnAndRow(3,$ligne,$code_postal);
	$sheet->setCellValueByColumnAndRow(4,$ligne,$ville);

	$ligne++;
}

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="clients.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objWriter, 'Excel2007');
$objWriter->save('php://output');

?>