<?php
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

/** 
 * my_bcmod - get modulus (substitute for bcmod) 
 * string my_bcmod ( string left_operand, int modulus ) 
 * left_operand can be really big, but be carefull with modulus :( 
 * by Andrius Baranauskas and Laurynas Butkus :) Vilnius, Lithuania 
 **/ 
function my_bcmod( $x, $y ) 
{ 
    // how many numbers to take at once? carefull not to exceed (int) 
    $take = 5;     
    $mod = ''; 

    do 
    { 
        $a = (int)$mod.substr( $x, 0, $take ); 
        $x = substr( $x, $take ); 
        $mod = $a % $y;    
    } 
    while ( strlen($x) ); 

    return (int)$mod; 
}


// ----------------------------------------------------------
// Verification de la cohérence du numero de securité sociale
// ----------------------------------------------------------
dbquery("UPDATE clients
	SET sexe					= '".$_GET['sexe']."',
		nom						= '".addslashes(strtoupper(trim($_GET['nom'])))."',
		prenom					= '".addslashes(trim($_GET['prenom']))."',
		date_naissance			= '".$_GET['date_naissance']."',
		adresse					= '".addslashes(trim($_GET['adresse']))."',
		code_postal				= '".addslashes($_GET['code_postal'])."',
		ville					= '".addslashes($_GET['ville'])."',
		pays					= '".addslashes($_GET['pays'])."',
		medecin_traitant		= '".addslashes($_GET['medecin_traitant'])."',
		marie					= '".addslashes($_GET['marie'])."',
		nb_enfants				= '".addslashes($_GET['nb_enfants'])."',
		retraite				= '".addslashes($_GET['retraite'])."',
		fumeur					= '".addslashes($_GET['fumeur'])."',
		conjoint_fumeur			= '".addslashes($_GET['conjoint_fumeur'])."',
		echelle_dyspnee_MMRC	= '".addslashes($_GET['echelle_dyspnee_MMRC'])."',
		score_epworth			= '".addslashes($_GET['score_epworth'])."',
		score_mallampati		= '".addslashes($_GET['score_mallampati'])."',
		perimetre_cervical		= '".addslashes($_GET['perimetre_cervical'])."',
		perimetre_abdominal		= '".addslashes($_GET['perimetre_abdominal'])."',
		TA						= '".addslashes($_GET['TA'])."',
		pouls					= '".addslashes($_GET['pouls'])."',
		SaO2					= '".addslashes($_GET['SaO2'])."',
		deces					= '".$_GET['deces']."',
		affection_longue_duree	= '".$_GET['affection_longue_duree']."',
		motif_ALD				= '".addslashes($_GET['motif_ALD'])."',
		date_expiration_ALD		= '".date_fr_iso($_GET['date_expiration_ALD'])."',
		mutuelle				= '".addslashes($_GET['mutuelle'])."'
	WHERE id_client		= '".$_GET['id_client']."'");

$tab_active = 0;
if (isset($_GET['clients_telephone']) && is_array($_GET['clients_telephone']))
{
	foreach($_GET['clients_telephone'] as $id_client_telephone => $value)
	{
		if (trim($value['telephone']) == '' && trim($value['contact']) == '')
		{
			dbquery("DELETE FROM clients_telephone
				WHERE id_client_telephone='".$id_client_telephone."'");
			$tab_active = 1;
		}
		else
		{
			$sql_client_tel_affected = dbquery("SELECT *
				FROM clients_telephone
				WHERE (type_telephone <> '".addslashes($value['type_telephone'])."'
						OR telephone	<> '".addslashes($value['telephone'])."'
						OR contact		<> '".addslashes($value['contact'])."')
					AND id_client_telephone='".$id_client_telephone."'");

			// Au moins un telephone changé
			if (dbnumrows($sql_client_tel_affected) > 0)
				$tab_active = 1;
			
			dbquery("UPDATE clients_telephone
			SET type_telephone	= '".addslashes($value['type_telephone'])."',
				telephone		= '".addslashes($value['telephone'])."',
				contact			= '".addslashes($value['contact'])."'
			WHERE id_client_telephone='".$id_client_telephone."'");
		}
	}		
}

// ======
// N° NIR
// ======
if ($_GET['numero_nir_1'] == "" || $_GET['numero_nir_2'] == 97 - my_bcmod( $_GET['numero_nir_1'], 97 ))
{	
	if ($_GET['numero_nir_1'] == "")
		$numero_nir = "NULL";
	else
		$numero_nir = "'".$_GET['numero_nir_1'].$_GET['numero_nir_2']."'";

	dbquery("UPDATE clients
		SET numero_nir		= ".$numero_nir ."
		WHERE id_client		= '".$_GET['id_client']."'");


	$return = array(
		'return_code' 		=> 'ok',
		'return_message'	=> '',
		'tab_active'		=> $tab_active);
}
else
	$return = array(
		'return_code' 		=> 'failed',
		'return_message'	=> 'Numero NIR incohérant. Il a été effacé. Appuyer sur F5 pour recharger.',
		'tab_active'		=> $tab_active);

echo json_encode($return);