<?php
// =============
// Consultations
// =============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");


// Formatage d'une date
function dd($date)
{
	return date("d/m/Y H:i",$date);
}


function tab_file($id_document_scan)
{
	$rep_base = "../../documents_scan";

	$sql_document_scan = dbquery("SELECT *
		FROM documents_scan
		WHERE id_document_scan='".$id_document_scan."'");

	if (dbnumrows($sql_document_scan) > 0)
	{
		$id_document_scan	= dbresult($sql_document_scan,$j,"id_document_scan");
		$fichier		= dbresult($sql_document_scan,$j,"fichier");

	
		// Fichier
		if(is_file($rep_base."/".$fichier) && $fichier <> "desktop.ini")
		{
			$icon = "<i style='background-color:white;color:black' class='fa fa-file-o fa-2x'></i>";
			if (extension($fichier) == "pdf")	$icon = "<i style='background-color:white;color:red' class='fa fa-file-pdf-o fa-2x'></i>";
			if (extension($fichier) == "doc" || extension($fichier) == "docx")	$icon = "<i style='background-color:white;color:blue' class='fa fa-file-word-o fa-2x'></i>";
			if (extension($fichier) == "xls" || extension($fichier) == "xlsx")	$icon = "<i style='background-color:white;color:green' class='bi bi-file-earmark-excel-fill fa-2x'></i>";

			$display['icon'] = $icon;
			$display['link'] = '/cabinet/documents_scan/'.urlencode($fichier);
			$display['link_name'] = $fichier;
			$display['creation_date'] = dd(filectime($rep_base."/".$fichier));
			$display['modified_date'] = dd(filemtime($rep_base."/".$fichier));
			$display['filesize'] = filesize($rep_base."/".$fichier);
		}
	}

	return $display;
}


$libelle = array('Dossier Client','États','Consult.');

$ribbon = array();

// --------------
// Dossier Client
// --------------
$ribbon[0][0]['icone']					= "/images/icones/48px/add_form.png";
$ribbon[0][0]['libelle']				= "Nouveau";
$ribbon[0][0]['id']						= "add_client";
$ribbon[0][0]['url']					= "";
$ribbon[0][0]['image_default_class']	= "";
$ribbon[0][0]['href_default_option']	= "popup fancybox.iframe";


$ribbon[0][1]['icone']					= "fa-floppy-o";
$ribbon[0][1]['icone_color']			= "#999";
$ribbon[0][1]['libelle']				= "Sauv.";
$ribbon[0][1]['id']						= "update_client";
$ribbon[0][1]['url']					= "";
$ribbon[0][1]['image_default_class']	= "disable";
$ribbon[0][1]['href_default_option']	= "popup fancybox.iframe";


$ribbon[0][2]['icone']					= "/images/icones/48px/delete_form.png";
$ribbon[0][2]['libelle']				= "Supprimer";
$ribbon[0][2]['id']						= "confirm_delete";
$ribbon[0][2]['url']					= "confirm_delete.php?id_client=".$_GET['id_client'];
$ribbon[0][2]['image_default_class']	= "";
$ribbon[0][2]['href_default_option']	= "popup fancybox.iframe";

// -----
// États
// -----
$ribbon[1][0]['icone']					= "fa-file-pdf-o";
$ribbon[1][0]['icone_color']			= "red";
$ribbon[1][0]['libelle']				= "D. médic.";
$ribbon[1][0]['id']						= "dossier_medical";
$ribbon[1][0]['url']					= "/cabinet/consultations/etats/pdf_dossier_medical.php?id_client[0]=".$_GET['id_client'];
$ribbon[1][0]['image_default_class']	= "popup fancybox.iframe";
$ribbon[1][0]['href_default_option']	= "popup fancybox.iframe";

$ribbon[1][1]['icone']					= "fa-file-pdf-o";
$ribbon[1][1]['icone_color']			= "red";
$ribbon[1][1]['libelle']				= "Cour+Ordo.";
$ribbon[1][1]['id']						= "dossier_medical";
$ribbon[1][1]['url']					= "/cabinet/consultations/courrier_ordonnance/index.php?id_client=".$_GET['id_client']."&date=".date('Y-m-d');
$ribbon[1][1]['image_default_class']	= "";
$ribbon[1][1]['href_default_option']	= "data-fancybox data-type='ajax'";


// ------------
// Consultation
// ------------
$ribbon[2][0]['icone']					= "/images/icones/48px/add_folder.png";
$ribbon[2][0]['libelle']				= "Nouvelle";
$ribbon[2][0]['id']						= "add_consultation";
$ribbon[2][0]['url']					= "/cabinet/agenda/add_form.php?id_client=".$_GET['id_client'];
$ribbon[2][0]['image_default_class']	= "";
$ribbon[2][0]['href_default_option']	= "data-fancybox data-type='ajax'";
?>


<!-- jQuery UI DatePicker français -->
<script type="text/javascript" src="/lib/jqueryui/jquery.ui.datepicker-fr.js"></script>


<script type="text/javascript"> 
$(document).ready(function()
{		
	$("#add_client").click(function()
	{
		$.ajax({
			type:		"GET",
			url:		"/cabinet/consultations/gestion_clients/add.php",
			data:		"",
			beforeSend:	function(){
			},
			complete:	function(){	
			},
			success:	function(id_client){
				if (id_client != "")
				{
					$("#ajax").load("index_ajax.php?id_client="+id_client);
				}
			}
		 });

	});

	$("#update_client").click(function()
	{
		$.ajax({
			type:		"GET",
			url:		"update.php",
			data:		$("#form1").serialize(),
			beforeSend:	function(){
				$( "#update_client" ).css({color: "#999" });
			},
			complete:	function(){	
			},
			success:	function(response){
				var obj = JSON.parse( response );
				
				if (obj.return_code == "ok")
				{
					$("#ajax").load("index_ajax.php?id_client=<?php echo $_GET['id_client'] ?>&tab_active="+obj.tab_active);
					$( "#update_client" ).css({color: "#999" });
				}
				else
					$("#ajax").html("Erreur : Code : "+obj.return_code+" Message : "+obj.return_message);
			}
		 });
	});




	
	// Icone modifier : descativée par défault
	$( "#add_client" ).addClass( "disable" );

	$(".edit").editable( '/cabinet/consultations/antecedent/update.php', {
		submit : "OK",
		tooltip  : 'Cliquez pour modifier',
		submitdata : function(value, settings) {
			document.location.reload();
			}
	});

	
	$('[data-fancybox]').fancybox({
		afterClose : function() {
		    $("#ajax").load("index_ajax.php?id_client=<?php echo $_GET['id_client'] ?>");
		}
	});

	<?php
	$tab_active=0;
	if (isset($_GET['tab_active']) && $_GET['tab_active'] <> '')
	{
		$tab_active = $_GET['tab_active'];
	}
	?>

	$( "#tabs_dossier_client" ).tabs({
		active: <?php echo $tab_active ?>,
		
		activate: function(event ,ui){
		
				/*	01 #5982CF
					02 #50DA63
					03 #FF9900
					04 #FF0033
				*/
				if (ui.newTab.index() == 0)
				{
					$( "#tabs-1_icon" ).css("color","white");
					
					$( "#tabs-2_icon" ).css("color","#50DA63");
					$( "#tabs-3_icon" ).css("color","#FF9900");
					$( "#tabs-4_icon" ).css("color","#FF0033");
				}
				
				if (ui.newTab.index() == 1)
				{
					$( "#tabs-2_icon" ).css("color","white");
					
					$( "#tabs-1_icon" ).css("color","#5982CF");
					$( "#tabs-3_icon" ).css("color","#FF9900");
					$( "#tabs-4_icon" ).css("color","#FF0033");
				}

				if (ui.newTab.index() == 2)
				{
					$( "#tabs-3_icon" ).css("color","white");
					
					$( "#tabs-1_icon" ).css("color","#5982CF");
					$( "#tabs-2_icon" ).css("color","#50DA63");
					$( "#tabs-4_icon" ).css("color","#FF0033");
				}
				
				if (ui.newTab.index() == 3)
				{
					$( "#tabs-4_icon" ).css("color","white");
					
					$( "#tabs-1_icon" ).css("color","#5982CF");
					$( "#tabs-2_icon" ).css("color","#50DA63");
					$( "#tabs-3_icon" ).css("color","#FF9900");
				}
			
			}
		}
	).addClass( "ui-tabs-vertical ui-helper-clearfix" );


	$( "#tabs_dossier_client li" ).removeClass( "ui-corner-top" ).addClass( "ui-corner-left" );


	<?php
	$active = "";
	
	// Ordonnance
	if (isset($_GET['id_ordonnance']))
		$active = "active: 1,";

	// Courrier au antécédent
	if (isset($_GET['id_client_antecedent']))
		$active = "active: 2,";

	// Courrier au medecin
	if (isset($_GET['id_courrier']))
		$active = "active: 3,";
	?>
    
	$( "#tabs_consultation" ).tabs({
		<?php echo $active ?>
		activate: function(event ,ui){

				/*
				05 #E6564E
				06 #53B15B
				07 #ff0099
				08 #5982CF
				09 #5982CF
				*/
				
				if (ui.newTab.index() == 0)
				{
					$( "#tabs-5_icon" ).css("color","white");

					$( "#tabs-6_icon" ).css("color","#53B15B");
					$( "#tabs-7_icon" ).css("color","#ff0099");
					$( "#tabs-8_icon" ).css("color","#5982CF");
					$( "#tabs-9_icon" ).css("color","#5982CF");
				}
				
				if (ui.newTab.index() == 1)
				{
					$( "#tabs-6_icon" ).css("color","white");

					$( "#tabs-5_icon" ).css("color","#E6564E");
					$( "#tabs-7_icon" ).css("color","#ff0099");
					$( "#tabs-8_icon" ).css("color","#5982CF");
					$( "#tabs-9_icon" ).css("color","#5982CF");
				}
				
				if (ui.newTab.index() == 2)
				{
					$( "#tabs-7_icon" ).css("color","white");

					$( "#tabs-5_icon" ).css("color","#E6564E");
					$( "#tabs-6_icon" ).css("color","#53B15B");
					$( "#tabs-8_icon" ).css("color","#5982CF");
					$( "#tabs-9_icon" ).css("color","#5982CF");
				}
				
				if (ui.newTab.index() == 3)
				{
					$( "#tabs-8_icon" ).css("color","white");

					$( "#tabs-5_icon" ).css("color","#E6564E");
					$( "#tabs-6_icon" ).css("color","#53B15B");
					$( "#tabs-7_icon" ).css("color","#ff0099");
					$( "#tabs-9_icon" ).css("color","#5982CF");
				}

				if (ui.newTab.index() == 4)
				{
					$( "#tabs-9_icon" ).css("color","white");

					$( "#tabs-5_icon" ).css("color","#E6564E");
					$( "#tabs-6_icon" ).css("color","#53B15B");
					$( "#tabs-7_icon" ).css("color","#ff0099");
					$( "#tabs-8_icon" ).css("color","#5982CF");
				}
			}

		}).addClass( "ui-tabs-vertical ui-helper-clearfix" );
    $( "#tabs_consultation li" ).removeClass( "ui-corner-top" ).addClass( "ui-corner-left" );


	// Modification des champs : sauvegarde possible
	$( ".allow_save_keydown" ).keydown( function() {
		$( "#update_client" ).css({color: "#000" });
	});

	$( ".allow_save_change" ).change( function() {
		$( "#update_client" ).css({color: "#000" });
	});


	// Date
	$.datepicker.setDefaults( $.datepicker.regional[ "fr" ] );
	$("#date").datepicker();

	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})


	// Ajout affection_exonorante
	$( "#add_telephone" ).click( function() {		
		$.ajax({
			type : 'GET',
			url : '/cabinet/consultations/gestion_clients/update.php',
			data : $("#form1").serialize(),
			success : function(response){

				var obj = JSON.parse( response );
				
				if (obj.return_code == "ok")
				{					
					$.ajax({
						type : 'GET',
						url : '/cabinet/consultations/gestion_clients/add_client_telephone.php',
						data : "id_client=<?php echo $_GET['id_client'] ?>",
						success : function(response){
							
							if (response == "ok")
								$("#ajax").load("index_ajax.php?id_client=<?php echo $_GET['id_client'] ?>&tab_active=1");
							else
								alert('Probleme de mise à jour de la fiche.');
						}
					});
				}
				else
					alert('Probleme de mise à jour de la fiche.');

			}
		});
	});


	// Color of icons
	// -> Init
	<?php
	if ($_GET['tab_active'] == 1)
	{
		?>
			$( "#tabs-2_icon" ).css("color","white");
		<?php
	}
	else
	{
		?>
			$( "#tabs-1_icon" ).css("color","white");
		<?php
	}	?>

	$( "#tabs-5_icon" ).css("color","white");
});
</script> 

<style>
.ui-tabs-vertical { width: 55em; }
.ui-tabs-vertical .ui-tabs-nav { padding: .2em .1em .2em .2em; float: left; width: 12em; }
.ui-tabs-vertical .ui-tabs-nav li { clear: left; width: 100%; border-bottom-width: 1px !important; border-right-width: 0 !important; margin: 0 -1px .2em 0; }
.ui-tabs-vertical .ui-tabs-nav li a { display:block; }
.ui-tabs-vertical .ui-tabs-nav li.ui-tabs-active { padding-bottom: 0; padding-right: .1em; border-right-width: 1px; border-right-width: 1px; }
.ui-tabs-vertical .ui-tabs-panel { padding: 1em; float: right; width: 40em;}


table.dossier_patient
{
	border:0px;
	width:280px;
	height:255px;
	border-collapse:collapse;
	margin:0px;
}

table.dossier_patient td
{
	padding:0px;
	height:10px;
}

</style>

<?php

$sql_client = dbquery("SELECT *
	FROM clients
	WHERE id_client='".$_GET['id_client']."'");

if (dbnumrows($sql_client) == 0)
	die("Client inexistant");

$nom				=  htmlentities(dbresult($sql_client,0,"nom"),ENT_QUOTES);
$prenom				=  htmlentities(dbresult($sql_client,0,"prenom"),ENT_QUOTES);
$adresse			=  htmlentities(dbresult($sql_client,0,"adresse"),ENT_QUOTES);
$code_postal		=  htmlentities(dbresult($sql_client,0,"code_postal"),ENT_QUOTES);
$ville				=  htmlentities(dbresult($sql_client,0,"ville"),ENT_QUOTES);
$pays				=  htmlentities(dbresult($sql_client,0,"pays"),ENT_QUOTES);
$date_naissance		=  dbresult($sql_client,0,"date_naissance");

$numero_nir			=  new NumeroNIR(dbresult($sql_client,0,"numero_nir"));
$medecin_traitant	=  dbresult($sql_client,0,"medecin_traitant");


if (dbresult($sql_client,0,"marie") == 1)
	$checked_marie = " checked";
else
	$checked_marie = "";

$nb_enfants				=  dbresult($sql_client,0,"nb_enfants");

if (dbresult($sql_client,0,"retraite") == 1)
	$checked_retraite = " checked";
else
	$checked_retraite = "";

$fumeur					=  dbresult($sql_client,0,"fumeur");

if (dbresult($sql_client,0,"conjoint_fumeur") == 1)
	$checked_conjoint_fumeur = " checked";
else
	$checked_conjoint_fumeur = "";

$affection_longue_duree	=  dbresult($sql_client,0,"affection_longue_duree");
$motif_ALD				=  dbresult($sql_client,0,"motif_ALD");
$date_expiration_ALD	=  dbresult($sql_client,0,"date_expiration_ALD");

if ($date_expiration_ALD == "0000-00-00")
	$date_expiration_ALD = "";
else
	$date_expiration_ALD = date_iso_fr($date_expiration_ALD);


$mutuelle				=  dbresult($sql_client,0,"mutuelle");


$echelle_dyspnee_MMRC	=  dbresult($sql_client,0,"echelle_dyspnee_MMRC");
$score_epworth			=  dbresult($sql_client,0,"score_epworth");
$score_mallampati		=  dbresult($sql_client,0,"score_mallampati");
$perimetre_cervical		=  dbresult($sql_client,0,"perimetre_cervical");
$perimetre_abdominal	=  dbresult($sql_client,0,"perimetre_abdominal");
$TA						=  dbresult($sql_client,0,"TA");
$pouls					=  dbresult($sql_client,0,"pouls");
$SaO2					=  dbresult($sql_client,0,"SaO2");

if (dbresult($sql_client,0,"deces") == 1)
	$checked_deces = " checked";
else
	$checked_deces = "";



$checked = array('homme'=>'','femme'=>'');
if (dbresult($sql_client,0,"sexe") == 'H')
	$checked['homme'] = "checked";
else
	$checked['femme'] = "checked";


//Affiche ruban top:0px
affiche($ribbon,$libelle,0);
?>

<form id="form1" method='post' class="form-inline">
	<input type="hidden" name="id_client" value="<?php echo $_GET['id_client']?>">
	<input type="hidden" name="id_ordonnance" value="<?php echo $_GET['id_ordonnance']?>">
	
	<!--
	// ==============
	// DOSSIER CLIENT
	// ============== -->	
	<div id="tabs_dossier_client" style='position:absolute;top:114px;left:4px;border:1px #EFC377 solid;width:672px;height:276px'>
		<ul>
			<li><a href="#tabs-1" style='position:relative;left:-2px'><i id='tabs-1_icon' style='color:#5982CF' class='fa fa-user fa-2x'></i></a></li>
			<li><a href="#tabs-2" style='position:relative;left:-2px'><i id='tabs-2_icon' style='color:#50DA63' class="fa fa-phone fa-2x"></i></a></li>
			<li><a href="#tabs-3" style='position:relative;left:-2px'><i id='tabs-3_icon' style='color:#FF9900' class="fa fa-child fa-2x"></i></a></li>
			<li><a href="#tabs-4" style='position:relative;left:-6px'><i id='tabs-4_icon' style='color:#FF0033' class="fa fa-tachometer fa-2x"></i></a></li>
		</ul>
		<div id="tabs-1" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:610px;height:274px;padding:8px;margin:0px'>

			<table class='dossier_patient' cellpadding='0' style='margin:1px'>
			<tr>
				<td style='text-align:center' colspan='5'>
					<input class='allow_save_change' type="radio" name="sexe" value="H" <?php echo $checked['homme'] ?>> Homme&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					<input class='allow_save_change' type="radio" name="sexe" value="F" <?php echo $checked['femme'] ?>> Femme
				</td>
			</tr>
			<tr>
				<td style='width:50px'>Nom</td>
				<td colspan='4'><input class='form-control allow_save_keydown' id='nom' name='nom' type='text' style='width:170px' value="<?php echo $nom ?>"></td>
			</tr>
			<tr>
				<td>Prénom&nbsp;</td>
				<td colspan='4'><input class='form-control allow_save_keydown' id='prenom' name='prenom' type='text' style='width:170px' value="<?php echo $prenom?>"></td>
			</tr>
			<tr>
				<td colspan='2'>Date&nbsp;de&nbsp;naissance&nbsp;</td>
				<td colspan='3'><input class='form-control allow_save_keydown' id='date_naissance' name='date_naissance' type='date' style='width:130px' value="<?php echo $date_naissance?>"></td>
			</tr>
			<tr>
				<td colspan='2'>Numéro NIR</td>
				<td colspan='3'><input class='form-control allow_save_keydown' id='numero_nir_1' name='numero_nir_1' type='text' style='width:120px' maxlength='13' value="<?php echo $numero_nir->sans_cle()?>"> <input class='form-control allow_save_keydown' id='numero_nir_2' name='numero_nir_2' type='text' style='width:42px' maxlength='2' value="<?php echo $numero_nir->cle()?>"></td>
			</tr>
			<tr>
				<td colspan='2'>Médecin traitant</td>
				<td colspan='3'><input class='form-control allow_save_keydown' style='width:200px' id='medecin_traitant' name='medecin_traitant' type='text' value="<?php echo $medecin_traitant?>"></td>
			</tr>
			</table>

			<table style="position:absolute;top:10px;left:330px" class='dossier_patient' cellpadding='0' style='margin:1px'>
			<tr>
				<td colspan='2'>ALD</td>
				<td colspan='3'><input class='allow_save_change' type="checkbox" name="affection_longue_duree" value="1" <?php if ($affection_longue_duree == 1) echo "checked" ?>></td>
			</tr>
			<tr>
				<td colspan='2'>Motif ALD</td>
				<td colspan='3'><input class='form-control allow_save_keydown' type="text" name="motif_ALD" value="<?php echo $motif_ALD ?>"></td>
			</tr>
			<tr>
				<td colspan='2'>Date expiration ALD</td>
				<td colspan='3'><input class='form-control allow_save_keydown' type="text" name="date_expiration_ALD" value="<?php echo $date_expiration_ALD ?>" style="width:86px" maxlength="10"></td>
			</tr>
			<tr>
				<td colspan='2'>Mutuelle</td>
				<td colspan='3'><input class='form-control allow_save_keydown' style='width:200px' id='mutuelle' name='mutuelle' type='text' value="<?php echo $mutuelle?>"></td>
			</tr>
			</table>

		</div>
		<div id="tabs-2" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:610px;height:274px;padding:8px;margin:0px'>

			<table style='width:110px' cellpadding='5'>
			<tbody>
			
			<?php
			// --------------
			// Les téléphones
			// --------------
			$sql_clients_telephone = dbquery("SELECT *
				FROM clients_telephone
				WHERE id_client='".$_GET['id_client']."'
				ORDER BY id_client_telephone ASC");

			for ($j=0;$j<dbnumrows($sql_clients_telephone);$j++)
			{
				$id_client_telephone	= dbresult($sql_clients_telephone,$j,"id_client_telephone");
				$telephone				= dbresult($sql_clients_telephone,$j,"telephone");
				$contact				= dbresult($sql_clients_telephone,$j,"contact");
				$type_telephone			= dbresult($sql_clients_telephone,$j,"type_telephone");

				echo "<tr><td colspan='2'>";
				echo "<select class='form-select allow_save_change' style='width:100px' name='clients_telephone[".$id_client_telephone."][type_telephone]'>";

				$selected_fixe		= "";
				$selected_portable	= "";
				if ($type_telephone == "fixe")		$selected_fixe		= " selected";
				if ($type_telephone == "portable")	$selected_portable	= " selected";
						
				echo "<option value='portable'	".$selected_portable.">Portable</option>";
				echo "<option value='fixe'		".$selected_fixe.">Fixe</option>";
				echo "</select>";
				echo "</td>";

				echo "<td colspan='2'><input class='form-control allow_save_keydown' type='text' style='width:120px' name='clients_telephone[".$id_client_telephone."][telephone]' value='".$telephone."'></td>";
				
				echo "<td><input class='form-control allow_save_keydown' type='text' style='width:120px' name='clients_telephone[".$id_client_telephone."][contact]' value='".$contact."'></td>";
				echo "</tr>";
			}
			?>
			<tr>
				<td colspan='5'><button type='button' class='btn' style='width:220px' id='add_telephone'><i style='color:#84C600' class='fa fa-plus-circle fa-lg'></i> Ajouter un numéro de téléphone </button></td>
			</tr>
			</tr>
			<tr>
				<td style='text-align:right'>Adresse :</td>
				<td colspan='4'><textarea class='form-control allow_save_keydown' style='width:220px' name="adresse" rows="2"><?php echo $adresse?></textarea></td>
			</tr>
			<tr>
				<td style='text-align:right'>CP :</td>
				<td colspan='2'><input class='form-control allow_save_keydown' style='width:64px' id='code_postal' name='code_postal' type='text' size='5' maxlength='5' value="<?php echo $code_postal?>"></td>
				<td style='width:50px;text-align:right'>Ville :</td>
				<td><input class='form-control allow_save_keydown' id='ville' name='ville' type='text' style='width:120px' value="<?php echo $ville?>"></td>
			</tr>
			<tr>
				<td style='text-align:right'>Pays :</td>
				<td colspan='4'><input class='form-control allow_save_keydown' id='pays' name='pays' type='text' style='width:140px' value="<?php echo $pays?>"></td>
			</tr>
			</table>

		</div>

		<div id="tabs-3" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:610px;height:274px;padding:8px;margin:0px'>

			<table class='dossier_patient' style="width:200px">
			<tr>
				<td style='width:100px'>Marié</td>
				<td><input class='allow_save_change' type="checkbox" name="marie" value="1"<?php echo $checked_marie ?>></td>
			</tr>
			<tr>
				<td>Nb enfants</td>
				<td><input class='form-control allow_save_keydown' style='width:50px' id='nb_enfants' name='nb_enfants' type='text' maxlength='2' value="<?php echo $nb_enfants?>"></td>
			</tr>
			<tr>
				<td>Retraite</td>
				<td><input class='allow_save_change' type="checkbox" name="retraite" value="1"<?php echo $checked_retraite ?>></td>
			</tr>
			<tr>
				<td>Fumeur</td>
				<td>
					<select class='form-select allow_save_change' id='fumeur' name='fumeur'>
						<option value='' ></option>
						<option value='jamais'	<?php if ($fumeur == 'jamais') echo " selected"?>>Jamais</option>
						<option value='arret'	<?php if ($fumeur == 'arret') echo " selected"?>>Arret</option>
						<option value='en cours' <?php if ($fumeur == 'en cours') echo " selected"?>>En cours</option>
					</select>
				</td>
			</tr>
			<tr>
				<td>Conjoint fumeur</td>
				<td><input class='allow_save_change' type="checkbox" name="conjoint_fumeur" value="1"<?php echo $checked_conjoint_fumeur ?>></td>
			</tr>
			</table>

		</div>
		<div id="tabs-4" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:610px;;height:274px;padding:8px;margin:0px'>
			<table border='0' style='width:300px;margin:10px' cellpadding='3'>
			<tr>
				<td colspan='2' style='width:150px'>Échelle dyspnée MMRC</td>
				<td colspan='2'>
					<select class='form-select allow_save_change' id='echelle_dyspnee_MMRC' name='echelle_dyspnee_MMRC'>
						<option value='' ></option>
						<option value='Grade 1'	<?php if ($echelle_dyspnee_MMRC == 'Grade 1') echo " selected"?>>Grade 1</option>
						<option value='Grade 2'	<?php if ($echelle_dyspnee_MMRC == 'Grade 2') echo " selected"?>>Grade 2</option>
						<option value='Grade 3' <?php if ($echelle_dyspnee_MMRC == 'Grade 3') echo " selected"?>>Grade 3</option>
						<option value='Grade 4'	<?php if ($echelle_dyspnee_MMRC == 'Grade 4') echo " selected"?>>Grade 4</option>
						<option value='Grade 5' <?php if ($echelle_dyspnee_MMRC == 'Grade 5') echo " selected"?>>Grade 5</option>
					</select>
				</td>
			</tr>
			<tr>
				<td>Score epworth</td>
				<td><input class='form-control allow_save_keydown' style='width:50px' id='score_epworth' name='score_epworth' type='text' maxlength='2' value="<?php echo $score_epworth?>"></td>
				<td>Score Mallampati</td>
				<td>
					<select class='form-select allow_save_change' id='score_mallampati' name='score_mallampati' style='width:100px'>
						<option value='' ></option>
						<option value='Classe 1'	<?php if ($score_mallampati == 'Classe 1') echo " selected"?>>Classe 1</option>
						<option value='Classe 2'	<?php if ($score_mallampati == 'Classe 2') echo " selected"?>>Classe 2</option>
						<option value='Classe 3'	<?php if ($score_mallampati == 'Classe 3') echo " selected"?>>Classe 3</option>
						<option value='Classe 4'	<?php if ($score_mallampati == 'Classe 4') echo " selected"?>>Classe 4</option>
					</select>
				</td>
			</tr>
			<tr>
				<td style='width:75px'>Perimètre cervical</td>
				<td><input class='form-control allow_save_keydown' style='width:50px' id='perimetre_cervical' name='perimetre_cervical' type='text' maxlength='3' value="<?php echo $perimetre_cervical?>"></td>
				<td style='width:75px'>Périmètre abdominal</td>
				<td><input class='form-control allow_save_keydown' style='width:50px' id='perimetre_abdominal' name='perimetre_abdominal' type='text' maxlength='3' value="<?php echo $perimetre_abdominal?>"></td>
			</tr>
			<tr>
				<td>TA</td>
				<td colspan='3'><input class='form-control allow_save_keydown' style='width:80px' id='TA' name='TA' type='text'  maxlength='10' value="<?php echo $TA?>"></td>
			</tr>
			<tr>
				<td>Pouls</td>
				<td colspan='3'><input class='form-control allow_save_keydown' style='width:50px' id='pouls' name='pouls' type='text' maxlength='3' value="<?php echo $pouls?>"></td>
			</tr>
			<tr>
				<td>SaO2 (%)</td>
				<td colspan='3'><input class='form-control allow_save_keydown' style='width:50px' id='SaO2' name='SaO2' type='text' maxlength='3' value="<?php echo $SaO2?>"></td>
			</tr>
			<tr>
				<td>Decès</td>
				<td colspan='3'><input class='allow_save_change' type="checkbox" name="deces" value="1"<?php echo $checked_deces ?>></td>
			</tr>
			</table>
		
		</div>

	</div>

	<!--
	// =============
	// CONSULTATIONS
	// ============= -->	
	<div id="tabs_consultation" style='position:absolute;top:398px;left:4px;border:1px #EFC377 solid;width:580px;height:260px'>
		<ul>
			<li><a href="#tabs-5" style='position:relative;left:-2px'><i id='tabs-5_icon' style='color:#E6564E' class="fa fa-calendar fa-2x"></i></a></li>
			<li><a href="#tabs-6" style='position:relative;left:-2px'><i id='tabs-6_icon' style='color:#53B15B' class="fa fa-th-large fa-2x"></i></a></li>
			<li><a href="#tabs-7" style='position:relative;left:-2px'><i id='tabs-7_icon' style='color:#ff0099' class="fa fa-history fa-2x"></i></a></li>
			<li><a href="#tabs-8" style='position:relative;left:-2px'><i id='tabs-8_icon' style='color:#5982CF' class="fa fa-file-text-o fa-2x"></i></a></li>
			<li><a href="#tabs-9" style='position:relative;left:-2px'><i id='tabs-9_icon' style='color:#5982CF' class="fa fa-files-o fa-2x"></i></a></li>
		</ul>
		<!--
		// =========
		// 5. AGENDA
		// ========= -->	
		<div id="tabs-5" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:518px;height:258px;padding:8px;margin:0px'>

			<div style='margin-left:20px;margin-bottom:5px;font-weight:bold;color:red'>Agenda</div>

			<?php
			echo "<table style='width:370px'>";
			echo "<thead></thead>";
			echo "<tbody><tr><td style='text-align:center'><a data-fancybox data-type='ajax' href='/cabinet/agenda/add_form.php?id_client=".$_GET['id_client']."'><i style='color:#84C600' class='fa fa-plus-circle fa-lg'></i></a></td></tr>";
			
			$sql_agenda = dbquery("SELECT *
				FROM agenda,type_rendez_vous
				WHERE agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
					AND agenda.id_client='".$_GET['id_client']."'
				ORDER BY agenda.datetime_debut ASC");
			
			for ($j=0;$j<dbnumrows($sql_agenda);$j++)
			{
				$id_agenda			= dbresult($sql_agenda,$j,"agenda.id_agenda");
				$datetime_debut		= new datetime(dbresult($sql_agenda,$j,"agenda.datetime_debut"));
				$datetime_fin		= new datetime(dbresult($sql_agenda,$j,"agenda.datetime_fin"));
				$type_rendez_vous	= dbresult($sql_agenda,$j,"type_rendez_vous.intitule");
				$background_color	= dbresult($sql_agenda,$j,"type_rendez_vous.background_color");
				$commentaire		= dbresult($sql_agenda,$j,"agenda.commentaire");

				echo "<tr><td style='text-align:center;min-width:40px'><a data-fancybox data-type='ajax' href='/cabinet/agenda/update_form.php?id_agenda=".$id_agenda."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
				echo "<td style='width:80px;text-align:center'>".$datetime_debut->format('d/m/Y')."</td>";
				echo "<td style='text-align:center'>".$datetime_debut->format('H:i')."</td>";
				echo "<td style='padding-left:5px;padding-right:5px;text-align:center;background-color:#".$background_color."'>".$type_rendez_vous."</td>";
				echo "<td style='text-align:center;font-weight:bold'>".$commentaire."</td>";
				
				$sql_agenda_ccam = dbquery("SELECT *
					FROM agenda_ccam
					WHERE id_agenda='".$id_agenda."'
					ORDER BY code_ccam ASC");

				if (dbnumrows($sql_agenda_ccam) > 0)
				{
					echo "<td style='padding-left:5px;padding-right:5px;background-color:#".$background_color.";text-align:center'><a href='/cabinet/consultations/etats/pdf_facture.php?id_agenda=".$id_agenda."' target='_new'><i style='color:red;background-color:white' class='fa fa-file-pdf-o fa-2x'></i></a><br><span style='color:grey;font-weight:bold'>Facture</span></td>";
					echo "<td style='padding-left:5px;padding-right:5px;background-color:#".$background_color.";text-align:center'><a href='/cabinet/consultations/etats/pdf_feuille_soin_medecin.php?id_agenda=".$id_agenda."' target='_new'><i style='color:red;background-color:white' class='fa fa-file-pdf-o fa-2x'></i></a><br><span style='color:grey;font-weight:bold'>FSP</span></td>";
					
					echo "<td style='padding-left:5px;padding-right:5px;font-size:8pt;color:grey;font-weight:bold''>";
					for ($k=0;$k<dbnumrows($sql_agenda_ccam);$k++)
					{
						echo dbresult($sql_agenda_ccam,$k,"code_ccam")."<br>";
					}
					echo "</td>";
				}
				echo "</tr>";

				if ($type_rendez_vous == "EFR")
				{
					// Ecart entre aujourd'hui et EFR + param('delai_mois_entre_2_efr') mois
					$datetime_now = new datetime(dbresult($sql_agenda,$j,"datetime_debut"));
					$datetime_debut_4_mois	= clone $datetime_debut;
					$datetime_debut_4_mois->modify('-'.param('delai_mois_entre_2_efr').' month');

					$sql_agenda_date = dbquery("SELECT * FROM agenda,type_rendez_vous
						WHERE agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
							AND type_rendez_vous.intitule='EFR'
							AND agenda.id_agenda <> '".$id_agenda."'
							AND agenda.id_client = '".$id_client."'
							AND DATE(datetime_debut) > '".$datetime_debut_4_mois->format('Y-m-d')."'
							AND DATE(datetime_debut) <= '".$datetime_debut->format('Y-m-d')."'");
				
					if (dbnumrows($sql_agenda_date) > 0)	echo "<tr><td></td><td colspan='4'><img src='/images/icones/32px/failed.png' width='16' height='16' border='0' alt=''> <span style='color:red'>Trop d'EFR.</span> Délai : ".param('delai_mois_entre_2_efr')." mois</td></tr>";
				}
			}
			echo "</tbody></table>";
			?>
		</div>

		<!--
		// ==============
		// 6. ORDONNANCES
		// ============== -->	

		<div id="tabs-6" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:518px;height:258px;padding:8px;margin:0px'>

			<div style='margin-left:20px;margin-bottom:5px;font-weight:bold;color:red'>Ordonnances</div>

			<?php
			echo "<table style='width:300px'>";
			echo "<thead></thead>";
			echo "<tbody><th<tr><td style='text-align:center'><a href='../ordonnance/add.php?id_client=".$_GET['id_client']."&id_docteur=1'><i style='color:#84C600' class='fa fa-plus-circle fa-lg'></i></a></td></tr>";
			
			$sql_ordonnance = dbquery("SELECT *
				FROM clients,ordonnances
				WHERE clients.id_client = ordonnances.id_client
					AND clients.id_client='".$_GET['id_client']."'
				ORDER BY ordonnances.date ASC");
		
			for ($j=0;$j<dbnumrows($sql_ordonnance);$j++)
			{
				$id_ordonnance	= dbresult($sql_ordonnance,$j,"ordonnances.id_ordonnance");
				$date			= new datetime(dbresult($sql_ordonnance,$j,"ordonnances.date"));

				$sql_clients_affection_exonorante = dbquery("SELECT *
					FROM ordonnances_lignes
					WHERE id_ordonnance='".$id_ordonnance."'
						AND type_prescription = 'affection_exonorante'
					ORDER BY id_ordonnance ASC");

				$sql_clients_maladies_intercurrentes = dbquery("SELECT *
					FROM ordonnances_lignes
					WHERE id_ordonnance='".$id_ordonnance."'
						AND type_prescription = 'maladies_intercurrentes'
					ORDER BY id_ordonnance ASC");

				
				// Type de l'ordonnance
				if (dbnumrows($sql_clients_affection_exonorante) == 0 && dbnumrows($sql_clients_maladies_intercurrentes) == 0)
					$type_ordonnance	= "Vide";

				if (dbnumrows($sql_clients_affection_exonorante) <> 0)
					$type_ordonnance	= "Bizone (".dbnumrows($sql_clients_affection_exonorante)."+".dbnumrows($sql_clients_maladies_intercurrentes).")";

				if (dbnumrows($sql_clients_affection_exonorante) == 0 && dbnumrows($sql_clients_maladies_intercurrentes) <> 0)
					$type_ordonnance	= "Simple (".dbnumrows($sql_clients_maladies_intercurrentes).")";


				$numero_ordonnance = $j+1;
				
				$sql_nb_ordonnance_client = dbquery("SELECT *
					FROM ordonnances
					WHERE id_client
						AND id_client='".$_GET['id_client']."'");



				echo "<tr><td style='text-align:center;padding:8px'><a href='../ordonnance/update_form.php?id_client=".$_GET['id_client']."&id_ordonnance=".$id_ordonnance."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
				echo "<td style='text-align:center'><span style='color:#330066'>".$date->format('d/m/Y')."</span></td>";
				echo "<td style='text-align:center;color:grey;font-weight:bold'>".ucfirst($type_ordonnance)."</td>";
				echo "<td>".$numero_ordonnance."/".dbnumrows($sql_nb_ordonnance_client)."</td>";
				echo "<td><a href='../../pdf/pdf.php?ordonnance[".$id_ordonnance."]=1' target='_new'><i style='color:red;background-color:white' class='fa fa-file-pdf-o fa-2x'></i></a></td>";
				echo "</tr>";
			}
			echo "</tbody></table>";

			?>
		</div>

		<!--
		// ==============
		// 7. ANTECEDENT
		// ============== -->	

		<div id="tabs-7" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:518px;height:258px;padding:8px;margin:0px'>

			<!-- Utilise JEditable -->
			<div style='margin-left:20px;margin-bottom:5px;font-weight:bold;color:red'>Antécédents</div>
			
			<table style='width:300px'>
			<thead></thead>
			<tbody>
			<tr>
			<td style='text-align:center'><a href='../antecedent/add.php?id_client=<?php echo $_GET['id_client'] ?>'><i style='color:#84C600' class='fa fa-plus-circle fa-lg'></i></a></td></tr>
			
			<?php
			$sql_antecedent = dbquery("SELECT *
				FROM clients,clients_antecedent
				WHERE clients.id_client = clients_antecedent.id_client
					AND clients.id_client='".$_GET['id_client']."'
				ORDER BY clients_antecedent.id_client_antecedent ASC");
		
			for ($j=0;$j<dbnumrows($sql_antecedent);$j++)
			{
				$id_client_antecedent		= dbresult($sql_antecedent,$j,"clients_antecedent.id_client_antecedent");
				$antecedent			= dbresult($sql_antecedent,$j,"clients_antecedent.antecedent");
				
				$numero_ordonnance = $j+1;
				
				echo "<tr>";
				echo "<td style='text-align:center'>".$numero_ordonnance."</td>";
				echo "<td><div class='edit' id=\"".$id_client_antecedent."\">".$antecedent."</div></td>";
				echo "</tr>";
			}
			?>
			</tbody>
			</table>

		</div>

		<!--
		// ===========
		// 8. COURRIER
		// =========== -->	
		<div id="tabs-8" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:518px;height:258px;padding:8px;margin:0px'>

			<div style='margin-left:20px;margin-bottom:5px;font-weight:bold;color:red'>Courrier au médecin</div>

			<?php
			echo "<table style='width:300px'>";
			echo "<thead></thead>";
			echo "<tbody><td style='text-align:center'><a href='../courrier/add.php?id_client=".$_GET['id_client']."&id_docteur=1'><i style='color:#84C600' class='fa fa-plus-circle fa-lg'></i></a></td></tr>";
			
			$sql_courrier = dbquery("SELECT *
				FROM clients,courrier_client
				WHERE clients.id_client = courrier_client.id_client
					AND clients.id_client='".$_GET['id_client']."'
				ORDER BY courrier_client.date ASC");
		
			for ($j=0;$j<dbnumrows($sql_courrier);$j++)
			{
				$id_courrier	= dbresult($sql_courrier,$j,"courrier_client.id_courrier");
				$date			= new datetime(dbresult($sql_courrier,$j,"courrier_client.date"));

				echo "<tr><td style='text-align:center;padding:8px'><a href='../courrier/update_form.php?id_client=".$_GET['id_client']."&id_courrier=".$id_courrier."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
				echo "<td style='text-align:center'><span style='color:#330066'>".$date->format('d/m/Y')."</span></td>";
				echo "<td style='text-align:center;color:grey;font-weight:bold'>Lettre au médecin</td>";
				echo "<td><a href='../../pdf/pdf.php?courrier[".$id_courrier."]=1' target='_new'><i style='color:red;background-color:white' class='fa fa-file-pdf-o fa-2x'></i></a></td>";
				echo "</tr>";
			}
			echo "</tbody></table>";
			?>

		</div>
		<!--
		// =======
		// 9. SCAN
		// ======= -->	
		<div id="tabs-9" style='background-color:#F9EBD0;position:absolute;top:0px;left:60px;width:518px;height:258px;padding:8px;margin:0px'>

			<div style='margin-left:20px;margin-bottom:5px;font-weight:bold;color:red'>Documents scannés</div>

			<table border='0' cellpadding='10' cellpadding='0'>
			<thead>
			<tr>
				<td></td>
				<td></td>
				<td>xNom</td>
				<td>Fichier</td>
				<td>Uploadé le</td>
				<td>Modifié le</td>
				<td>Taille</td>
				<td></td>
			</tr>
			</thead>
			<tbody>
			<?php
			$sql_document_scan = dbquery("SELECT *
				FROM documents_scan
				WHERE id_client='".$_GET['id_client']."'
				ORDER BY id_document_scan ASC");

			for ($j=0;$j<dbnumrows($sql_document_scan);$j++)
			{
				$id_document_scan	= dbresult($sql_document_scan,$j,"id_document_scan");
				$nom				= dbresult($sql_document_scan,$j,"nom");
				$fichier			= dbresult($sql_document_scan,$j,"fichier");

				$tab_file = tab_file($id_document_scan);

				echo "<tr><td style='text-align:right'><a data-fancybox data-type='ajax' href='docs_scan/update_form.php?id_document_scan=".$id_document_scan."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
				echo "<td>".$tab_file['icon']."</td>";
				echo "<td><a style='color:black' href='".$tab_file['link']."'>".$nom."</a></td>";
				echo "<td><a style='color:black' href='".$tab_file['link']."'>".$fichier."</a></td>";
				echo "<td>".$tab_file['creation_date']."</td>";
				echo "<td>".$tab_file['modified_date']."</td>";
				echo "<td style='text-align:right'>".formatBytes($tab_file['filesize'])."</td>";
				echo "<td style='text-align:right'><a data-fancybox data-type='ajax' href='docs_scan/confirm_delete.php?id_document_scan=".$id_document_scan."'><i style='color:red' class='fa fa-trash-o fa-lg'></i></a></td></tr>";
			}
			?>
			<tr>
				<td><a data-fancybox data-type='ajax' href='docs_scan/upload_form.php?id_client=<?php echo  $_GET['id_client'] ?>'><i style='color:green;background-color:white' class='fa fa-plus-circle fa-2x'></i></a></td>
				<td><a data-fancybox data-type='ajax' href='docs_scan/download_form.php?id_client=<?php echo  $_GET['id_client'] ?>'><i style='color:orange;background-color:white' class='bi bi-download fa-2x'></i></a></td>
			</tr>
			</tbody>
			</table>

		</div>

	</div>

</form>


<?php
// ==========
// ANTECEDENT
// ==========

if (isset($_GET['id_antecedent']))
{
	echo "<div id='antecedent' style='position:absolute;top:150px;left:360px;border:1px #EFC377 solid;width:706px;height:564px;padding:5px;background-color:#F9EBD0'>";
	require($_SERVER['DOCUMENT_ROOT']."/cabinet/consultations/antecedent/update_form.inc.php");
	echo "</div>";
}


// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>