<?php
// =============
// Recup fichier
// --> Form
// =============

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header_fancybox.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");


// Formatage d'une date
function dd($date)
{
	return date("d/m/Y H:i",$date);
}



/**
 * Copy $src to $dest, renaming it if the desired destination already exists.  The
 * string '.versionX' is inserted before the file extension if a file must be
 * renamed, with X incremented as needed.
 *
 * @return boolean true if copy was successful, false otherwise.
 */
function rename_with_rename($src, $dest)
{
	if (file_exists($dest))
	{		
		// See if it's the same.
		$existing_file_hash	= sha1_file($dest);
		$new_file_hash		= sha1_file($src);
		
		if ($existing_file_hash != $new_file_hash)
		{		
			// File of same name exists, but is different.
			$last_dot_pos = strrpos($dest,'.');
			$file_count = 2;
			// So find a new name.
			do
			{		
				$base_name	= substr($dest, 0, $last_dot_pos);
				$ext		= substr($dest, strlen($base_name)); // with dot
				$new_name = $base_name.'_version_'.$file_count.$ext;
				$file_count++;
			}
			while (file_exists($new_name) && sha1_file($src)!=sha1_file($new_name));
			// And then try the copy again, with the new name.
			return rename_with_rename($src, $new_name);
		}
		else
		{
			return false;
		}
	}
	else
	{		
		$dest_dir = dirname($dest);
		// Create (to any depth) the destination directory, if required.
		if (!file_exists($dest_dir))
		{
			mkdir($dest_dir, 0777, true);
		}

		dbquery("INSERT INTO documents_scan
			VALUES ('',
					'".$_POST['id_client']."',
					'Document médical',
					'".addslashes(basename($dest))."')");
		
		// And finally do the actual copy.
		return rename($src, $dest);
	}
}






$sql_client = dbquery("SELECT *
	FROM clients
	WHERE id_client = '".$_POST['id_client']."'");

if (dbnumrows($sql_client) == 0)
	die("Client inexistant");
{
	$nom	=  dbresult($sql_client,0,"nom");
	$prenom	=  dbresult($sql_client,0,"prenom");
}
?>

<script type="text/javascript"> 
$(document).ready(function()
{
	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})
});
</script>

<div class='title'>Document scanné : Récupération de fichier</div>

<form id='form1' name='form1' method='post'  enctype="multipart/form-data" action='recup_fichiers.php'>
	<input type="hidden" name="id_client" value="<?php echo $_GET['id_client'] ?>">
	
	<table>
	<thead>
	<tr>
		<th>Fichier original</th>
		<th>Résultat</th>
	</tr>
	</thead>
	<tbody>

	
	<?php
	foreach($_POST['files'] as $file)
	{
		echo "<tr><td>".$file."</td>";

		// Reussite
		if ( rename_with_rename('../../../documents_scan/'.$_POST['ss_repertoire'].'/'.urldecode($file),'../../../documents_scan/'.wd_remove_accents(str_replace(' ','_',$nom."_".$prenom."_".urldecode($file)))) )
		{
			echo "<td><div class='alert alert-success'><i style='color:green' class='fa fa-check fa-lg'></i> Fichier uploadé</div></td>";
		}
		else
		// Echec
		{
			echo "<td><div class='alert alert-danger'><i style='color:red' class='fa fa-times fa-lg'></i> Le fichier a déjà été uploadé.</div></td>";
		}
		echo "</td></tr>";

	}
	?>
	</tbody>
	</table>

</form>

<center>
	<p><button class="btn btn-primary" name="fermer" value='Fermer' onClick='parent.jQuery.fancybox.close();'>Fermer</button></p>
</center>


<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>