<?php
// ===================
// Merge PDF avec FPDI
// ===================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

libraries(array('TCPDF'));
require($_SERVER['DOCUMENT_ROOT']."/lib/FPDI/1.5.2/fpdi.php");


// Verigie la presence d'un tableau
if (is_array($_POST['files']))
{
	// initiate FPDI
	$pdf = new FPDI();

	// Pour chaque fichier
	foreach ($_POST['files'] AS $file)
	{
		// Ajoute le fichier PDF
		try {
			// get the page count
			$page_count = $pdf->setSourceFile('../../../documents_scan/'.$file);
		}
		catch(Exception $e) {
			
			echo "<div class='title'>Erreur lors de la concaténation des fichiers</div>";

			echo "<p><b>Fichier ".$file."</b></p>";
			echo nl2br($e);
			echo "<p><button class='btn btn-primary' value='Fermer' onClick='parent.jQuery.fancybox.close();'>Fermer</button></p>";
		}

		// iterate through all pages
		for ($page_no = 1; $page_no <= $page_count; $page_no++)
		{
			// import a page
			$template = $pdf->importPage($page_no);
			// get the size of the imported page
			$size = $pdf->getTemplateSize($template);

			// create a page (landscape or portrait depending on the imported page size)
			if ($size['w'] > $size['h'])
				$pdf->AddPage('L', array($size['w'], $size['h']));
			else
				$pdf->AddPage('P', array($size['w'], $size['h']));

			// use the imported page
			$pdf->useTemplate($template);
		}
	}

	ob_end_clean();
	$pdf->Output('pdf_merge.pdf', 'I');
}
else
	echo "<b>Erreur</b> : Aucun fichier selectionné";