<?php
// =================
// ETIQUETTES
// --> pdf
// =================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


if (!isset($_SESSION['id_personnel']))
{
	header("Location:/cabinet/authentification/login_form.php?message=Fin de session. Veuillez vous reconnecter.");
	exit;
}


// create new PDF document
$pdf = new TCPDF('portrait', 'mm', 'A4', true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Courrier');
$pdf->SetSubject('Courrier');
$pdf->SetKeywords('Courrier');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(0);
$pdf->SetLeftMargin(0);
$pdf->SetRightMargin(0);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Marges
$pdf->SetMargins(20,20,20,20);


$pdf->SetTextColor(0,0,0);


// ======
// ENTETE
// ======

$pdf -> addPage();
$pdf -> SetFont('Helvetica','B',11);

$sql_facture = dbquery("SELECT * FROM agenda,clients
	WHERE agenda.id_client = clients.id_client
		AND agenda.id_agenda='".$_GET['id_agenda']."'");

if (dbnumrows($sql_facture) > 0)
{
	$prenom			= dbresult($sql_facture,0,"clients.prenom");
	$nom			= dbresult($sql_facture,0,"clients.nom");
	$date_naissance	= new datetime(dbresult($sql_facture,0,"clients.date_naissance"));
	$adresse		= dbresult($sql_facture,0,"clients.adresse");
	$code_postal	= dbresult($sql_facture,0,"clients.code_postal");
	$ville			= dbresult($sql_facture,0,"clients.ville");
	$numero_nir		= dbresult($sql_facture,0,"clients.numero_nir");

	
	// DATE
	$pdf -> SetFont('Helvetica','',11);
	$pdf -> SetXY(174,14);
	$pdf -> Cell(30,0, date('dmy'), '', $ln=0,'R', $fill=false,'', $stretch=4, false, 'C','C');


	// PERSONNE RECEVANT LES SOINS
	$pdf -> SetXY(30,28);
	$pdf -> Cell(200,0, $nom." ".$prenom, '', $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');

	// NUMERO NIR
	$pdf -> SetXY(56,36);
	$pdf -> Cell(66,0, substr($numero_nir,0,13), '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');
	$pdf -> SetXY(125,36);
	$pdf -> Cell(9,0, substr($numero_nir,13,2), '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');

	// DATE NAISSANCE
	$pdf -> SetXY(56,46);
	$pdf -> Cell(40,0, $date_naissance->format('dmY'), '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');


	// ADRESSE
	$pdf -> SetXY(7,74);
	$pdf -> Cell(200,0, trim($adresse." ".$code_postal." ".$ville), '', $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');


	// ACTES EFFECTUES
	$sql_agenda_ccam = dbquery("SELECT *
		FROM agenda_ccam,ccam,agenda
		WHERE agenda_ccam.code_ccam = ccam.code_ccam
			AND agenda_ccam.id_agenda = agenda.id_agenda
			AND agenda_ccam.id_agenda='".$_GET['id_agenda']."'
		ORDER BY ccam.code_ccam ASC
		LIMIT 0,4");

	$montant_total = 0;
	for ($i=0;$i<dbnumrows($sql_agenda_ccam);$i++)
	{
		$datetime_debut				= new datetime(dbresult($sql_agenda_ccam,$i,"agenda.datetime_debut"));
		$code_ccam				= dbresult($sql_agenda_ccam,$i,"ccam.code_ccam");
		$prix_acte				= dbresult($sql_agenda_ccam,$i,"ccam.prix_acte");
		$coefficiant_2e_acte	= dbresult($sql_agenda_ccam,$i,"ccam.coefficiant_2e_acte");

		if ($i >= 1)	$prix_acte = $prix_acte * $coefficiant_2e_acte;

		$montant_total += $prix_acte;

		
		// Date
		$pdf -> SetXY(6,214+9*$i);
		$pdf -> Cell(31,0,$datetime_debut->format('dmY'), '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');

		// Acte
		$pdf -> SetXY(38,214+9*$i);
		$pdf -> Cell(35,0,  sprintf("%-10s",$code_ccam), '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');

		// Montant total
		$pdf -> SetXY(125,214+9*$i);
		$pdf -> Cell(30,0,  sprintf("%6s", number_format($prix_acte,2,'','')), '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');
		
		// ... et virgule
		$pdf -> SetXY(143,214+9*$i);
		$pdf -> Cell(30,0,',', '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');
	}

	// Montant total
	$pdf -> SetFont('Helvetica','B',11);
	$pdf -> SetXY(109,251);
	$pdf -> Cell(30,0,  sprintf("%6s", number_format($montant_total,2,'','')), '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');

	// ... et virgule
	$pdf -> SetXY(127,251);
	$pdf -> Cell(30,0,',', '', $ln=0,'L', $fill=false,'', $stretch=4, false, 'C','C');


}

// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('facture_'.$_GET['id_agenda'].'.pdf', 'I');