<?php
// =================
// ETIQUETTES
// --> pdf
// =================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.nuts.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)

// extend TCPF with custom functions
class MYPDF extends TCPDF
{
	// Table UE
	public function TableActe($header,$footer,$data,$x,$y)
	{
		$this->SetXY($x,$y);

		$this->SetLeftMargin($x);
			
		// Colors, line width and bold font
		$this->SetFillColor(255, 255, 255);
		$this->SetTextColor(0,0,0);
		$this->SetDrawColor(0, 100, 80, 20);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		
		// Header
		$w = array(22, 130, 22);
		$num_headers = count($header);
		for($i = 0; $i < $num_headers; ++$i)
		{
			$this->Cell($w[$i], 10, $header[$i], 1, 0, 'C', 1);
		}
		$this->Ln();
		
		// Color and font restoration
		$this->SetFillColor(224, 235, 255);
		$this->SetTextColor(0);
		$this->SetFont('');
		
		// Data
		$fill = 0;
		foreach($data as $row)
		{
			// Hauteur de la ligne
			$hauteur_ligne = $this -> getStringHeight($w[1], $row[1],$reseth = true, $autopadding = true, $cellpadding = '',$border = 1 ) + 5;
			
			// Acte
			$this -> Cell($w[0], $hauteur_ligne, $row[0], 'LR', 0, 'C', $fill,0,1);
			
			// Libellé de l'acte
			$this -> MultiCell($w[1],$hauteur_ligne, $row[1] , 0, 'LR', $fill,$ln=2, $this ->getX(),$this->getY(),$reseth=true,$stretch=0,false,$autopadding=true,$maxh=0,$valign='M',$fitcell = true);


			// Prix
			$this -> setXY($this ->getX(),$this->getY()-$hauteur_ligne);
			$this -> Cell($w[2], $hauteur_ligne, $row[2], 'LR', 0, 'C', $fill,0,1);
			$this -> Ln();
			$fill=!$fill;
		}
		
		// Colors, line width and bold font
		$this->SetFillColor(255, 255, 255);
		$this->SetTextColor(0,0,0);
		$this->SetDrawColor(0, 100, 80, 20);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		
		// Footer
		$w = array(120, 32, 22);
		for($i = 0; $i < $num_headers; ++$i)
		{
			if ($i == 0)	$border = 'T';
			else $border = 1;
			$this->Cell($w[$i], 10, $footer[$i], $border, 0, 'C', 1);
		}
	}
}



if (!isset($_SESSION['id_personnel']))
{
	header("Location:/cabinet/authentification/login_form.php?message=Fin de session. Veuillez vous reconnecter.");
	exit;
}

// create new PDF document
$pdf = new MYPDF('portrait', 'mm', 'A4', true ,'UTF-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Courrier');
$pdf->SetSubject('Courrier');
$pdf->SetKeywords('Courrier');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(0);
$pdf->SetLeftMargin(0);
$pdf->SetRightMargin(0);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Marges
$pdf->SetMargins(20,20,20,20);


$pdf->SetTextColor(0,0,0);


// ======
// ENTETE
// ======

$pdf -> addPage();

// Image header
$pdf->Image('../../images/header.png', 0,0, $pdf->getPageWidth(),0 , 'PNG', '', '', true, 300, '', false, false, 0, false, false, false);


$pdf -> SetFont('Helvetica','B',11);
$pdf -> MultiCell(85,12, 'Docteur '.param('nom_docteur').'
'.strtoupper(param('specialite')), $border='', 'C', $fill=false,$ln=1, 10,20);

$pdf -> SetFont('Helvetica','',9);
$pdf -> MultiCell(85,12, param('entete'), $border='', 'C', $fill=false,$ln=1, 10,31);

$pdf -> SetFont('Helvetica','',11);

$sql_facture = dbquery("SELECT * FROM agenda,clients,type_rendez_vous
	WHERE agenda.id_client = clients.id_client
		AND agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
		AND agenda.id_agenda='".$_GET['id_agenda']."'");

if (dbnumrows($sql_facture) > 0)
{
	$prenom			= dbresult($sql_facture,0,"clients.prenom");
	$nom			= dbresult($sql_facture,0,"clients.nom");
	$sexe			= dbresult($sql_facture,0,"clients.sexe");
	$date_naissance	= new datetime(dbresult($sql_facture,0,"clients.date_naissance"));
	$numero_nir			= new NumeroNIR(dbresult($sql_facture,0,"numero_nir"));
	$id_etablissement	= dbresult($sql_facture,0,"clients.id_etablissement");

	$e_feminin = "";
	if ($sexe == 'F')	
		$e_feminin = "e";

	$date			= new datetime(dbresult($sql_facture,0,"agenda.datetime_debut"));

	$type_rendez_vous	= dbresult($sql_facture,0,"type_rendez_vous.intitule");


	$sql_numero_facture = dbquery("SELECT * FROM agenda
		WHERE YEAR(datetime_debut) = '".$date->format('Y')."'
			AND MONTH(datetime_debut) = '".$date->format('m')."'
			AND id_agenda <= '".$_GET['id_agenda']."'
		");
	
	
	// -------
	// FACTURE
	// -------
	// -->Texte
	$pdf -> SetFont('Helvetica','B',12);
	$pdf -> SetXY(142,25);
	$pdf -> Cell(20,0, 'Facture n° '.$date->format('Y/m/').sprintf('%03s',dbnumrows($sql_numero_facture)),     '', $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');

	$pdf -> SetFont('Helvetica','',11);
	$pdf -> SetXY(142,32);
	$pdf -> Cell(20,0, 'Date : '.date('d/m/Y'),     '', $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');

	// --> Cadre arrondi
	$pdf->RoundedRect(140, 20, 50, 20, 1.50, '1111');

	
	// ----------------
	// A L'INTENTION DE
	// ----------------	
	// -->Texte
	$destinataire = "";
	
	// Existance d'un etablissement associé
	$sql_etablissement = dbquery("SELECT * FROM clients,etablissements
	WHERE clients.id_etablissement = etablissements.id_etablissement
		AND clients.id_etablissement='".$id_etablissement."'");

	if (dbnumrows($sql_etablissement) > 0)
	{
		$destinataire = dbresult($sql_etablissement,0,"etablissements.nom")."\n";
		$destinataire .= dbresult($sql_etablissement,0,"etablissements.service")."\n";
		$destinataire .= dbresult($sql_etablissement,0,"etablissements.adresse")."\n";
		$destinataire .= dbresult($sql_etablissement,0,"etablissements.code_postal")." ".dbresult($sql_etablissement,0,"etablissements.ville")."\n\n";
		$destinataire .= "concernant\n\n";
	}

	$destinataire .= $prenom." ".$nom."\n";
	$destinataire .= "né".$e_feminin." le ".$date_naissance->format('d/m/Y')."\n";
	$destinataire .= "NIR : ".$numero_nir->format_espace();
	
	$pdf -> MultiCell(56,0, $destinataire, 0, 'L', $fill=false,$ln=2, 132,47,true,0,false,true,0,'T',true);


	// --> Cadre arrondi
	$height = $pdf->getY()-43;
	$pdf->RoundedRect(130, 45, 60, $height, 1.50, '1111');


	// -----
	// ACTES
	// -----	
	// Entete de table
	$header = array('Acte', 'Intitulé','Prix');

	$sql_agenda_ccam = dbquery("SELECT *
		FROM agenda_ccam,ccam
		WHERE agenda_ccam.code_ccam = ccam.code_ccam
			AND agenda_ccam.id_agenda='".$_GET['id_agenda']."'
		ORDER BY ccam.code_ccam ASC");

	if (dbnumrows($sql_agenda_ccam) > 0)
	{
		$pdf -> SetFont('Helvetica','',14);
		$pdf -> MultiCell($pdf->getPageWidth(),16, $type_rendez_vous.' du '.date_iso_fr_complete($date->format('Y-m-d')), $border='', 'C', $fill=false,$ln=1, 0,$pdf->getY()+10);


		$data_ue = array();
		$montant_total = 0;
		for ($j=0;$j<dbnumrows($sql_agenda_ccam);$j++)
		{
			$code_ccam	= dbresult($sql_agenda_ccam,$j,"ccam.code_ccam");
			$libelle	= dbresult($sql_agenda_ccam,$j,"ccam.libelle");
			$prix_acte	= dbresult($sql_agenda_ccam,$j,"ccam.prix_acte");
			
			$coefficiant_2e_acte	= dbresult($sql_agenda_ccam,$j,"ccam.coefficiant_2e_acte");

			if ($j >= 1)	$prix_acte = $prix_acte * $coefficiant_2e_acte;

			
			$data_ue[$j][0] = $code_ccam;
			$data_ue[$j][1]	= $libelle;
			$data_ue[$j][2]	= number_format($prix_acte,2,',',' ').' €';

			$montant_total += $prix_acte;
		}

		// Total
		$footer = array('', 'Net à payer :', number_format($montant_total,2,',',' ').' €');


		// Affiche le tableau
		$pdf -> SetFont('Helvetica','',12);
		$pdf -> TableActe($header, $footer,$data_ue, 20, $pdf->getY());


		$montant_total_nuts = new nuts($montant_total, "EUR");

		$pdf -> SetFont('Helvetica','',12);
		$pdf -> SetXY(20,$pdf->getY()+20);
		$pdf -> Cell(20,12, "Soit la somme de ".$montant_total_nuts->convert("fr-FR").".",  0, $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');

		// Existance d'un etablissement associé ==> RIB Bnacaire
		if (dbnumrows($sql_etablissement) > 0)
		{
			$pdf -> SetFont('Helvetica','B',12);
			$pdf -> SetXY(20,$pdf->getY()+10);
			$pdf -> Cell(20,12, "Mode de paiement : Virement bancaire (RIB ci-joint).",  0, $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');
		}
	}

	// Signature
	$pdf -> SetFont('Helvetica','',12);
	$pdf -> SetXY($pdf->getPageWidth()-70,250);
	$pdf -> Cell(50,10, 'Docteur '.param('nom_docteur'),  0, $ln=0,'R', $fill=false,'', $stretch=0, false, 'C','C');


	// --------
	// Code 128 
	// --------
	$pdf -> SetFont('Helvetica','',10);

	// --> AM
	$pdf -> SetXY(30,276);
	$pdf->Cell(0, 0, 'N° AM', 0, 1);
	$pdf->write1DBarcode(param('AM'), 'C128', 30, '', 35, 4, '', $style, 'N');
	$pdf -> SetXY(30,285);
	$pdf->Cell(0, 0, param('AM'), 0, 1);


	// --> RPPS
	$pdf -> SetXY(120,276);
	$pdf->Cell(0, 0, 'N° RPPS', 0, 1);
	$pdf->write1DBarcode(param('RPPS'), 'C128', 120, '', 35, 4, '', $style, 'N');
	$pdf -> SetXY(120,285);
	$pdf->Cell(0, 0, param('RPPS'), 0, 1);
}

// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('facture_'.$_GET['id_agenda'].'.pdf', 'I');