<?php
// =============
// Consultations
// =============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");

$tab_librairies = array('tinymce');
libraries($tab_librairies);
?>


<script type="text/javascript"> 
$(document).ready(function()
{
	// Date
	$.datepicker.setDefaults( $.datepicker.regional[ "fr" ] );
	$("#date").datepicker();

	// Close
	$('#close').mouseover(function() {
		$('#close').css( "color","#EC6C60" );
	});

	$('#close').mouseout(function() {
		$('#close').css( "color","#C35A50" );
	});

	$('#delete').click(function() {

		if ($('#delete').html() == "Voulez vous vraiment supprimer cette fiche ?")
		{
			$.ajax({
				type:		"GET",
				url:		"/cabinet/consultations/courrier/delete.php",
				data:		"id_courrier=<?php echo $_GET['id_courrier']?>",
				beforeSend:	function(){
					$('#delete').html("Supprimer cette fiche <div class='spinner-border spinner-border-sm' role='status'></div>");
				},
				complete:	function(){	
				},
				success:	function(response){
					if (response == "ok")
						document.location.href = "/cabinet/consultations/gestion_clients/index.php?id_client=<?php echo $_GET['id_client']?>";

				}
			 });
		
		}

		// Changer la valeur du boutton
		$('#delete').html("Voulez vous vraiment supprimer cette fiche ?");

	});


	$('[data-fancybox]').fancybox({
		afterClose : function() {
			document.location.reload(true);
		}
	});

});
</script> 

<?php
$sql_client = dbquery("SELECT *
	FROM clients
	WHERE id_client='".$_GET['id_client']."'");

if (dbnumrows($sql_client) == 0)
	die("Client inexistant");

$nom				=  htmlentities(dbresult($sql_client,0,"nom"),ENT_QUOTES);
$prenom				=  htmlentities(dbresult($sql_client,0,"prenom"),ENT_QUOTES);
$adresse			=  htmlentities(dbresult($sql_client,0,"adresse"),ENT_QUOTES);
$code_postal		=  htmlentities(dbresult($sql_client,0,"code_postal"),ENT_QUOTES);
$ville				=  htmlentities(dbresult($sql_client,0,"ville"),ENT_QUOTES);
$pays				=  htmlentities(dbresult($sql_client,0,"pays"),ENT_QUOTES);
$date_naissance		=  date_iso_fr(dbresult($sql_client,0,"date_naissance"));

$numero_nir			=  new NumeroNIR(dbresult($sql_client,0,"numero_nir"));
$medecin_traitant	=  dbresult($sql_client,0,"medecin_traitant");


if (dbresult($sql_client,0,"marie") == 1)	$checked_marie = " checked";
else $checked_marie = "";

$nb_enfants				=  dbresult($sql_client,0,"nb_enfants");

if (dbresult($sql_client,0,"retraite") == 1)	$checked_retraite = " checked";
else $checked_retraite = "";

$fumeur					=  dbresult($sql_client,0,"fumeur");

if (dbresult($sql_client,0,"conjoint_fumeur") == 1)	$checked_conjoint_fumeur = " checked";
else $checked_conjoint_fumeur = "";

$echelle_dyspnee_MMRC	=  dbresult($sql_client,0,"echelle_dyspnee_MMRC");
$score_epworth			=  dbresult($sql_client,0,"score_epworth");
$score_mallampati		=  dbresult($sql_client,0,"score_mallampati");
$perimetre_cervical		=  dbresult($sql_client,0,"perimetre_cervical");
$perimetre_abdominal	=  dbresult($sql_client,0,"perimetre_abdominal");
$TA						=  dbresult($sql_client,0,"TA");
$pouls					=  dbresult($sql_client,0,"pouls");
$SaO2					=  dbresult($sql_client,0,"SaO2");

if (dbresult($sql_client,0,"deces") == 1)	$checked_deces = " checked";
else $checked_deces = "";



$checked = array('homme'=>'','femme'=>'');
if (dbresult($sql_client,0,"sexe") == 'H')	$checked['homme'] = "checked";
else	$checked['femme'] = "checked";



// ========
// COURRIER
// ========

$sql_courrier = dbquery("SELECT *
	FROM clients,courrier_client
	WHERE clients.id_client = courrier_client.id_client
		AND courrier_client.id_courrier='".$_GET['id_courrier']."'");


if (dbnumrows($sql_courrier) > 0)
{	
	$id_client			= dbresult($sql_courrier,0,"clients.id_client");
	$nom				= dbresult($sql_courrier,0,"clients.nom");
	$prenom				= dbresult($sql_courrier,0,"clients.prenom");
	$sexe				= dbresult($sql_courrier,0,"clients.sexe");
	$date_naissance		= dbresult($sql_courrier,0,"clients.date_naissance");

	$date				= new datetime(dbresult($sql_courrier,0,"courrier_client.date"));
	$destinataires		= dbresult($sql_courrier,0,"destinataires");
	$corps				= dbresult($sql_courrier,0,"corps");

	if ($sexe == 'F')
	{
		$e_feminin = "e";
		$il_elle = "Elle";
		$madame_monsieur = "Mme";
	}
	else
	{
		$e_feminin = "";
		$il_elle = "Il";
		$madame_monsieur = "M.";
	}
	?>

	<div id='courrier' style='position:absolute;top:0px;left:20px;border:1px #EFC377 solid;width:716px;height:660px;padding:5px;background-color:#F9EBD0'>


		<!-- Place inside the <head> of your HTML -->
		<script type="text/javascript">
		tinymce.init({
			selector: "textarea.tinymce",
			language : 'fr_FR',
			language_url : "/lib/tinymce/5.7.0/js/tinymce/langs/fr_FR.js",
			height:600,
			width: 700,
			plugins: [
				"advlist autolink lists link image charmap print preview hr anchor pagebreak",
				"searchreplace wordcount visualblocks visualchars code fullscreen",
				"insertdatetime media nonbreaking save table directionality",
				"emoticons template paste"
			],
			menubar : false,
			toolbar : ["save | cut copy paste | myprint | undo redo | link image | code | myclose",
				"|bold italic underline alignleft aligncenter alignright bullist numlist outdent indent | forecolor backcolor|",
				"cher_confrere  vu_a_ce_jour  remerciements_avis | mallampati | dyspnee | salutations"],
			setup: function(editor) {
				function myPrint() {
					window.open('../../pdf/pdf.php?courrier[<?php echo $_GET['id_courrier'] ?>]=1','_newtab');
				}
				
				function closeDocument() {
					document.location.href='../gestion_clients/index.php?id_client=<?php echo $_GET['id_client'] ?>';
				}
				
				editor.ui.registry.addButton('myprint', {
					title: 'Affiche le document en pdf',
					icon:  'print',
					onAction: myPrint
				});
				editor.ui.registry.addButton('myclose', {
					title: 'Fermer le document (sans enregistrement!)',
					text: 'Fermer',
					onAction: closeDocument
				});

				// Messages
				editor.ui.registry.addButton('cher_confrere', {
					title: 'Cher Confrère',
					text: 'Cher Confrère',
					onAction: function() {
						editor.insertContent('<p>Cher Confrère</p>');
					}
				});

				editor.ui.registry.addButton('vu_a_ce_jour', {
					title: 'Vu a ce jour',
					text: 'Vu a ce jour',
					onAction: function() {
						editor.insertContent("<p>J'ai vu ce jour <?php echo $madame_monsieur." ".$nom." ".$prenom ?> né<?php echo $e_feminin ?> le <?php echo date_iso_fr($date_naissance) ?>.</p>");
					}
				});

				editor.ui.registry.addButton('remerciements_avis', {
					title: 'Remerciements pour avis',
					text: 'Remerciements pour avis',
					onAction: function() {
						editor.insertContent("<p>Je vous remercie de m'avoir adressé pour avis <?php echo $madame_monsieur." ".$nom." ".$prenom ?>, né<?php echo $e_feminin ?> le <?php echo date_iso_fr($date_naissance) ?></p>");
					}
				});
				
				editor.ui.registry.addButton('mallampati', {
					title: 'Score de Mallampati',
					text: 'Mallampati',
					onAction: function() {
						editor.insertContent("<p> Le score de Mallampati est de __ /4.</p>");
					}
				});


				editor.ui.registry.addButton('dyspnee', {
					title: 'Dyspnée',
					text: 'Dyspnée',
					onAction: function() {
						editor.insertContent("<p><?php echo $il_elle ?> présente une dyspnée grade  de l'échelle du Modified Medical Research Council.</p>");
					}
				});


				editor.ui.registry.addButton('salutations', {
					title: 'Salutations',
					text: 'Salutations',
					onAction: function() {
						editor.insertContent("<p>Avec mes remerciements, veuillez agréer, cher Confrère, l'assurance de mes sentiments distingués,</p><p>Dr. B. TANGUY</p>");
					}
				});

			},
			image_advtab: true,
			templates: [
				{title: 'Test template 1', content: 'Test 1'},
				{title: 'Test template 2', content: 'Test 2'}
			],
			save_enablewhendirty: true,
			save_onsavecallback: function() {

				$.ajax({
					type: "POST",
					dataType: "html",
					url: "/cabinet/consultations/courrier/update.php",

					data: {
						id_courrier: <?php echo $_GET['id_courrier'] ?>,
						destinataires: $( "#destinataires" ).val(),
						date: $( "#date" ).val(),
						corps: $( "#corps" ).val()
						},

					success: function(msg){
					}
				});
			}
		 });
		</script>


		<!-- Fermer la fenetre -->
		<div style='text-align:right;position:relative;top:-6px;right:-2px'><a href='/cabinet/consultations/gestion_clients/index.php?id_client=<?php echo $_GET['id_client'] ?>'><i id="close" style='color:#C35A50' class="fa fa-window-close fa-2x"></i></a></div>

		<?php
		// Info docteur
		$sql_docteur = dbquery("SELECT docteurs.* FROM docteurs,courrier_client
			WHERE docteurs.id_docteur = courrier_client.id_docteur
				AND courrier_client.id_courrier='".$_GET['id_courrier']."'");

		$nom_docteur	= dbresult($sql_docteur,0,"nom_docteur");
		$specialite		= dbresult($sql_docteur,0,"specialite");
		$entete			= dbresult($sql_docteur,0,"entete");
		?>

		
		<table border='0' style="width:432px">
		<tbody>
		<tr>
			<td style='width:10px;text-align:center'><a data-fancybox data-type='ajax'  href='update_docteur/update_form.php?id_courrier=<?php echo $_GET['id_courrier'] ?>'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>
			<td style='width:130px;font-weight:bold'>Docteur <?php echo $nom_docteur."<br>".strtoupper($specialite) ?></td>
			<td style='width:100px;text-align:center'><button style="width:200px" class="btn btn-light" id="delete" type="button"> <i style='color:red' class='fa fa-trash-o'></i> Supprimer ce courrier</button></center></b></td>
			<td style='width:160px;text-align:right'><b>Saint-Denis le </b><input class='form-control' type="text" id="date" name="date" style='width:110px;display:inline' maxlength='10' value='<?php echo $date->format('d/m/Y') ?>'></td>
		</tr>
		<tr>
			<td colspan='3'></td>
			<td style='text-align:right'><textarea class='form-control' style='width:260px' id="destinataires" name="destinataires" rows="2"><?php echo htmlentities($destinataires,ENT_QUOTES); ?></textarea>
			</td>
		</tr>
		<tr>
			<td colspan='4'><textarea class="tinymce" name="corps" ><?php echo htmlentities($corps,ENT_QUOTES); ?></textarea></td>
		</tr>
		</tbody>
		</table>
	</div>	
	<?php
}
else
	die("Attention, ce courrier n'existe pas ou a été effacé. Merci.");

// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>