<?php
// ========================
// LIRE FICHIER SYLK
// --> CA20140327_1057.SYLK
// ========================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('PHPExcel'));


// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");

function partial_array_search($string, $table)
{
	foreach ($table as $element)
	{
		if (strpos($string, $element))	return true;
	}
	return false;
}

$tab_mois = array(
	"01" => "Jan",
	"02" => "Fév",
	"03" => "Mar",
	"04" => "Avr",
	"05" => "Mai",
	"06" => "Jun",
	"07" => "Jul",
	"08" => "Aoû",
	"09" => "Sep",
	"10" => "Oct",
	"11" => "Nov",
	"12" => "Déc");
?>

<script type="text/javascript"> 
<!--
$(document).ready(function()
{
	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	$( "#tabs" ).tabs({ active: 0 });
});
//-->
</script> 

<?php
if (isset($_GET['fichier']))
{	
	// ---------------------
	// Calcul de la date min
	// ---------------------
	$sql_compte_bancaire_releve_date_max = dbquery("SELECT MAX(date) AS max_date
		FROM compte_bancaire_releve");
	
	if (dbnumrows($sql_compte_bancaire_releve_date_max) > 0)
	$date_max = dbresult($sql_compte_bancaire_releve_date_max,0,"max_date");

	if ($date_max == '')
		$date_max = '0000-00-00';

	// On efface la ligne de la date la plus recente des anciens enregistrement
	dbquery("DELETE FROM compte_bancaire_releve
			WHERE date = '".$date_max."'");
	
	dbquery("UPDATE comptes_bancaires
			SET import = '1'
			WHERE fichier = '".$_GET['fichier']."'");


	$inputFileName = "files/".$_GET['fichier'];

	echo "<div class='title'>Import dans la base du fichier ".$inputFileName." à partir de ".$date_max."</div>";


	$objReader = new PHPExcel_Reader_SYLK();
	$objPHPExcel = $objReader->load($inputFileName);


	// --------------
	// Feuille unique
	// --------------
	$sheet = $objPHPExcel->getSheet(0);

	$table = array();

	$i=0;
	foreach($sheet->getRowIterator() as $row)
	{
		$j=0;
		foreach ($row->getCellIterator() as $cell)
		{
			// Recuperation d'une chaine
			// Liste des opérations du compte entre le 29/06/2013 et le 18/01/2014
			if ($j== 0 && preg_match("/Liste des/",$cell->getValue()))
			{
				$liste_operation = trim($cell->getValue());
				continue;
			}

			if ($j == 0 && !partial_array_search($cell->getValue(), $tab_mois) )
				continue;

			$table[$i][$j] = $cell->getValue();
			$j++;
		}
		$i++;
	}

	$table = array_reverse($table);
}

// -------------------------------------------------------------------
// Extraction de l'anne a partir de $liste_operation
// Liste des opérations du compte entre le 29/06/2013 et le 18/01/2014
// --> 2014
// -------------------------------------------------------------------

$year = substr($liste_operation,47,4);


// =================
// $tab_liste_mois
//Array
//(
//    [0] => 11-2014
//    [1] => 12-2014
//    [2] => 01-2015
//    [3] => 02-2015
//)
// =================

$tab_liste_mois = array();

$i=0;
$compteur = 0;
foreach($table as $key => $value)
{
	foreach($value as $key2 => $value2)
	{
		if ($key2 == 0)
		{
			$mois = array_search(substr($value2,3,4),$tab_mois);
			
			// Changement d'année
			if (substr($tab_liste_mois[$i-1],5,2)." ".$mois == "12 01")
				$year++;
			
			if (substr($tab_liste_mois[$i-1],5,2) <> $mois)
				$tab_liste_mois[$i++] = $year."-".$mois;


			// Date
			$table2[$year."-".$mois][$key][0]	= $year."-".$mois."-".substr($value2,0,2);

			// Date valeur
			$table2[$year."-".$mois][$key][1]	= $table[$compteur][1];
			
			// Libellé
			$table2[$year."-".$mois][$key][2]	= $table[$compteur][2];

			// Débit Euros
			$table2[$year."-".$mois][$key][3]	= $table[$compteur][3];

			// Crédit Euros
			$table2[$year."-".$mois][$key][4]	= $table[$compteur][4];
			

			// Date debut / Fin
			if ($compteur == 0)
				dbquery("UPDATE comptes_bancaires
					SET date_debut = '".$year."-".$mois."-".substr($value2,0,2)."'
					WHERE fichier = '".$_GET['fichier']."'");

			dbquery("UPDATE comptes_bancaires
				SET date_arret_releve = '".$year."-".$mois."-".substr($value2,0,2)."'
				WHERE fichier = '".$_GET['fichier']."'");		

			$compteur++;
		}
	}
}
?>

<div id="tabs">
	
<?php
$i=1;
echo "<ul>";
foreach($table2 as $annee_mois => $value2)
{
	list($annee,$mois) = explode("-",$annee_mois);

	echo "<li><a href='#tabs-".$i++."'>".$tab_mois[$mois]." ".$annee."</a></li>";
}
echo "</ul>";




$i=1;
foreach($table2 as $annee_mois => $value2)
{
	list($annee,$mois) = explode("-",$annee_mois);

	?>
	<div id='tabs-<?php echo $i ?>'>

		<table>
		<thead>
		<tr>
			<td>Date</td>
			<td>Date valeur</td>
			<td>Libellé</td>
			<td>Débit Euros</td>
			<td>Crédit Euros</td>
			<td>Import dans la base</td>
		</tr>
		</thead>
		<tbody>
		<?php
		foreach($value2 as $key3 => $value3 )
		{
			echo "<tr><td>".$value3[0]."</td>";
			echo "<td>".$value3[1]."</td>";
			echo "<td>".str_replace(' :','<br>',$value3[2])."</td>";
			
			if ($value3[3] == "")
				echo "<td style='text-align:center'>-</td>";
			else
				echo "<td style='text-align:right'>".number_format((double)$value3[3], 2, '.', ' ')." €</td>";
			
			
			if ($value3[4] == "")
				echo "<td style='text-align:center'>-</td>";
			else
				echo "<td style='text-align:right'>".number_format((double)$value3[4], 2, '.', ' ')." €</td>";

			echo "<td style='text-align:center'>";
			


			// On insere a partir de la date max
			if ($value3[0] >= $date_max)
			{
				echo "<i style='color:green' class='fa fa-plus fa-lg'></i>";

				dbquery("INSERT INTO compte_bancaire_releve
					VALUES ('',
						'".$value3[0]."',
						'".$value3[1]."',
						'".addslashes(str_replace(' :','
',$value3[2]))."',
						'".$value3[3]."',
						'".$value3[4]."')");
			}
			else
				echo "<i style='color:red' class='fa fa-remove fa-lg'></i>";


			echo "</td></tr>";
		}
		?>
		</tbody>
		</table>
	</div>
	<?php
	$i++;
}

/*
Array
(
    [2014-11] => Array
        (
            [0] => Array
                (
                    [0] => 2014-11-25
                    [1] => 25-Nov
                    [2] => Almerys Virt 25/11/2013 97140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 19.56
                )

            [1] => Array
                (
                    [0] => 2014-11-25
                    [1] => 25-Nov
                    [2] => Smam Smam 221113 0009802790 ) 97    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 9.78
                )

            [2] => Array
                (
                    [0] => 2014-11-26
                    [1] => 26-Nov
                    [2] => Mgen 112 Ow974p372313974owrq7233    :Virement En Votre Faveur            :Ow974p372313974owrq72339908bf52 Ow2 :1/11/13-5237/5237 :Ow974p372313974owrq72339908bf52
                    [3] => 
                    [4] => 32.6
                )

            [3] => Array
                (
                    [0] => 2014-11-26
                    [1] => 26-Nov
                    [2] => La Mutuelle Generale Mg974 97140    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 22.82
                )

            [4] => Array
                (
                    [0] => 2014-11-26
                    [1] => 26-Nov
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 468.6
                )

            [5] => Array
                (
                    [0] => 2014-11-26
                    [1] => 27-Nov
                    [2] => Rgf Mfp Mfp-Sli Rgf974 381 25/11    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 80.64
                )

            [6] => Array
                (
                    [0] => 2014-11-26
                    [1] => 27-Nov
                    [2] => Rgf Mfp Mfp-Sli Rgf974 427 25/11    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 151.91
                )

            [7] => Array
                (
                    [0] => 2014-11-27
                    [1] => 27-Nov
                    [2] => Apria Rsa Eei.2013-11-25.1412       :Virement En Votre Faveur            :D  C N  1300012will-971404397 :Eei.2013-11-25.1412
                    [3] => 
                    [4] => 9.78
                )

            [8] => Array
                (
                    [0] => 2014-11-27
                    [1] => 27-Nov
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 632.04
                )

            [9] => Array
                (
                    [0] => 2014-11-27
                    [1] => 27-Nov
                    [2] => 00001006203 Cnmss Toul0000009714    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 115.2
                )

            [10] => Array
                (
                    [0] => 2014-11-27
                    [1] => 27-Nov
                    [2] => Smam Smam 261113 0009825442 ) 97    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 9.78
                )

            [11] => Array
                (
                    [0] => 2014-11-28
                    [1] => 28-Nov
                    [2] => Ram Prestation Reunion Eei.2013-    :Virement En Votre Faveur            :Rsi031781102611 :Eei.2013-11-26.306
                    [3] => 
                    [4] => 32.6
                )

            [12] => Array
                (
                    [0] => 2014-11-28
                    [1] => 28-Nov
                    [2] => Union Mutualite Solidaunion Mutu    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 9.78
                )

            [13] => Array
                (
                    [0] => 2014-11-28
                    [1] => 28-Nov
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 450.46
                )

            [14] => Array
                (
                    [0] => 2014-11-28
                    [1] => 28-Nov
                    [2] => Almerys Virt 28/11/2013 97140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 34.56
                )

            [15] => Array
                (
                    [0] => 2014-11-28
                    [1] => 29-Nov
                    [2] => Rgf Mfp Mfp-Sli Rgf974 469 27/11    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 80.64
                )

            [16] => Array
                (
                    [0] => 2014-11-29
                    [1] => 29-Nov
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 396.34
                )

            [17] => Array
                (
                    [0] => 2014-11-29
                    [1] => 29-Nov
                    [2] => Udsmr Prest Udsmr Tiers 97140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 53.64
                )

            [18] => Array
                (
                    [0] => 2014-11-29
                    [1] => 29-Nov
                    [2] => 0000008                             :Cheque Emis                        
                    [3] => 181
                    [4] => 
                )

            [19] => Array
                (
                    [0] => 2014-11-29
                    [1] => 29-Nov
                    [2] => Almerys Virt 29/11/2013 97140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 35.79
                )

            [20] => Array
                (
                    [0] => 2014-11-29
                    [1] => 29-Nov
                    [2] => Smam Smam 281113 0009846761 ) 97    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 34.56
                )

        )

    [2014-01] => Array
        (
            [21] => Array
                (
                    [0] => 2014-01-02
                    [1] => 02-Jan
                    [2] => Apria Rsa Eei.2013-12-27.832        :Virement En Votre Faveur            :D  C N  1300012wvmt-971404397 :Eei.2013-12-27.832
                    [3] => 
                    [4] => 9.78
                )

            [22] => Array
                (
                    [0] => 2014-01-02
                    [1] => 02-Jan
                    [2] => Mgen 112 Ow974p374813974owrq7488    :Virement En Votre Faveur            :Ow974p374813974owrq74888374bg92 Ow2 :7/12/13-9239/9239 :Ow974p374813974owrq74888374bg92
                    [3] => 
                    [4] => 32.6
                )

            [23] => Array
                (
                    [0] => 2014-01-02
                    [1] => 02-Jan
                    [2] => 0000018                             :Cheque Emis                        
                    [3] => 10341
                    [4] => 
                )

            [24] => Array
                (
                    [0] => 2014-01-02
                    [1] => 02-Jan
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 326.24
                )

            [25] => Array
                (
                    [0] => 2014-01-02
                    [1] => 02-Jan
                    [2] => Mr Bricolage Saint Denis   31/12    :Paiement Par Carte                 
                    [3] => 88.9
                    [4] => 
                )

            [26] => Array
                (
                    [0] => 2014-01-03
                    [1] => 03-Jan
                    [2] => Ram Prestation Reunion Eei.2013-    :Virement En Votre Faveur            :Rsi031781103112 :Eei.2013-12-31.123
                    [3] => 
                    [4] => 22.82
                )

            [27] => Array
                (
                    [0] => 2014-01-03
                    [1] => 01-Jan
                    [2] => Com Tenu Compte  NN01400300051783    :Frais                              
                    [3] => 9
                    [4] => 
                )

            [28] => Array
                (
                    [0] => 2014-01-06
                    [1] => 06-Jan
                    [2] => Mgen 112 Ow974p375013974owrq7500    :Virement En Votre Faveur            :Ow974p375013974owrq75005941bh06 Ow3 :1/12/13-0622/0681 :Ow974p375013974owrq75005941bh06
                    [3] => 
                    [4] => 87.8
                )

            [29] => Array
                (
                    [0] => 2014-01-06
                    [1] => 06-Jan
                    [2] => Rgf Mfp Mfp-Sli Rgf974 385 02/01    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 65.2
                )

            [30] => Array
                (
                    [0] => 2014-01-06
                    [1] => 06-Jan
                    [2] => Smam Smam 030114 0010095475 ) 97    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 9.78
                )

            [31] => Array
                (
                    [0] => 2014-01-06
                    [1] => 06-Jan
                    [2] => Cael Action Pro  NN01400600191473    :Abonnement                         
                    [3] => 1.4
                    [4] => 
                )

            [32] => Array
                (
                    [0] => 2014-01-07
                    [1] => 07-Jan
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 175.82
                )

            [33] => Array
                (
                    [0] => 2014-01-07
                    [1] => 07-Jan
                    [2] => Udsmr Prest Udsmr Tiers 97140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 33.12
                )

            [34] => Array
                (
                    [0] => 2014-01-07
                    [1] => 07-Jan
                    [2] => 0000009                             :Cheque Emis                        
                    [3] => 27
                    [4] => 
                )

            [35] => Array
                (
                    [0] => 2014-01-08
                    [1] => 09-Jan
                    [2] => Rgf Mfp Mfp-Sli Rgf974 427 07/01    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 32.6
                )

            [36] => Array
                (
                    [0] => 2014-01-09
                    [1] => 09-Jan
                    [2] => C.P.A.M. De L'herault 0000009714    :Virement En Votre Faveur            :00000097140400000097140439700725401 :40108 :0000009714043970072540140108
                    [3] => 
                    [4] => 32.6
                )

            [37] => Array
                (
                    [0] => 2014-01-09
                    [1] => 09-Jan
                    [2] => 0000019                             :Cheque Emis                        
                    [3] => 2182
                    [4] => 
                )

            [38] => Array
                (
                    [0] => 2014-01-09
                    [1] => 09-Jan
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 407.24
                )

            [39] => Array
                (
                    [0] => 2014-01-09
                    [1] => 09-Jan
                    [2] => Almerys Virt 09/01/2014 97140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 34.56
                )

            [40] => Array
                (
                    [0] => 2014-01-09
                    [1] => 09-Jan
                    [2] => Smam Smam 080114 0010120577 ) 97    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 9.78
                )

            [41] => Array
                (
                    [0] => 2014-01-09
                    [1] => 10-Jan
                    [2] => Rgf Mfp Mfp-Sli Rgf974 321 08/01    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 115.2
                )

            [42] => Array
                (
                    [0] => 2014-01-10
                    [1] => 10-Jan
                    [2] => Mgen 112 Ow974p400414974owrq0041    :Virement En Votre Faveur            :Ow974p400414974owrq00412059bh26 Ow0 :7/01/14-2691/2691 :Ow974p400414974owrq00412059bh26
                    [3] => 
                    [4] => 18.8
                )

            [43] => Array
                (
                    [0] => 2014-01-10
                    [1] => 10-Jan
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 727.52
                )

            [44] => Array
                (
                    [0] => 2014-01-16
                    [1] => 16-Jan
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 485.77
                )

            [45] => Array
                (
                    [0] => 2014-01-16
                    [1] => 16-Jan
                    [2] => La Mutuelle Generale Mg974 97140    :Virement En Votre Faveur            :Sante - 737727945-20140114 :Mg974 971404397 001875 00052449
                    [3] => 
                    [4] => 22.82
                )

            [46] => Array
                (
                    [0] => 2014-01-16
                    [1] => 17-Jan
                    [2] => Rgf Mfp Mfp-Sli Rgf974 377 15/01    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 22.82
                )

            [47] => Array
                (
                    [0] => 2014-01-17
                    [1] => 17-Jan
                    [2] => Cgss Reunion Bred 00000097140439    :Virement En Votre Faveur           
                    [3] => 
                    [4] => 702.44
                )

        )

)*/