CREATE DATABASE  IF NOT EXISTS `base_cabinet` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `base_cabinet`;
-- MySQL dump 10.13  Distrib 5.6.13, for Win32 (x86)
--
-- Host: localhost    Database: base_cabinet
-- ------------------------------------------------------
-- Server version	5.5.24-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actes`
--

DROP TABLE IF EXISTS `actes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actes` (
  `id_acte` int(11) NOT NULL AUTO_INCREMENT,
  `acte` text NOT NULL,
  PRIMARY KEY (`id_acte`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actes`
--

LOCK TABLES `actes` WRITE;
/*!40000 ALTER TABLE `actes` DISABLE KEYS */;
INSERT INTO `actes` VALUES (1,'Consultation patient\r\n-16 ans'),(2,'Consultation spécialisée\r\navec majoration'),(3,'Consultation demandée\r\npar un autre confrère\r\npour avis'),(4,'Provocation'),(5,'EFR (pléthysmographie)'),(6,'EFR + B2 (Test aux\r\nbeta-2-mimétiques)'),(7,'EFR + B2 + DLCO\r\n(coefficient de diffusion)'),(8,'Polygraphie'),(9,'Polysomnographie 4h'),(10,'Polysomnographie 8h'),(11,'Polysomnographie 12h');
/*!40000 ALTER TABLE `actes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actes_ccam`
--

DROP TABLE IF EXISTS `actes_ccam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actes_ccam` (
  `id_acte` int(11) NOT NULL,
  `code_ccam` char(7) NOT NULL,
  PRIMARY KEY (`id_acte`,`code_ccam`),
  KEY `code_ccam` (`code_ccam`),
  CONSTRAINT `actes_ccam_ibfk_2` FOREIGN KEY (`code_ccam`) REFERENCES `ccam` (`code_ccam`) ON UPDATE CASCADE,
  CONSTRAINT `actes_ccam_ibfk_1` FOREIGN KEY (`id_acte`) REFERENCES `actes` (`id_acte`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actes_ccam`
--

LOCK TABLES `actes_ccam` WRITE;
/*!40000 ALTER TABLE `actes_ccam` DISABLE KEYS */;
INSERT INTO `actes_ccam` VALUES (9,'AMQP010'),(10,'AMQP012'),(11,'AMQP014'),(3,'C2'),(1,'CS'),(2,'CS'),(4,'GERD002'),(5,'GLQP002'),(6,'GLQP002'),(7,'GLQP002'),(8,'GLQP007'),(2,'MCS'),(2,'MPC'),(1,'MPJ'),(6,'YYYY006'),(7,'YYYY006'),(7,'YYYY076');
/*!40000 ALTER TABLE `actes_ccam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `agenda`
--

DROP TABLE IF EXISTS `agenda`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agenda` (
  `id_agenda` int(11) NOT NULL AUTO_INCREMENT,
  `id_personnel` int(11) NOT NULL DEFAULT '0',
  `id_client` int(11) DEFAULT NULL,
  `datetime_debut` datetime NOT NULL,
  `datetime_fin` datetime NOT NULL,
  `id_type_rendez_vous` int(11) NOT NULL,
  `masse` int(3) DEFAULT NULL,
  `commentaire` mediumtext NOT NULL,
  `checked` tinyint(1) NOT NULL,
  PRIMARY KEY (`id_agenda`),
  KEY `id_personnel` (`id_personnel`),
  KEY `id_client` (`id_client`),
  KEY `datetime_debut` (`datetime_debut`),
  KEY `datetime_fin` (`datetime_fin`),
  KEY `id_type_consultation` (`id_type_rendez_vous`),
  CONSTRAINT `agenda_ibfk_1` FOREIGN KEY (`id_personnel`) REFERENCES `personnel` (`id_personnel`) ON UPDATE CASCADE,
  CONSTRAINT `agenda_ibfk_2` FOREIGN KEY (`id_client`) REFERENCES `clients` (`id_client`) ON UPDATE CASCADE,
  CONSTRAINT `agenda_ibfk_3` FOREIGN KEY (`id_type_rendez_vous`) REFERENCES `type_rendez_vous` (`id_type_rendez_vous`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3249 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `agenda`
--

LOCK TABLES `agenda` WRITE;
/*!40000 ALTER TABLE `agenda` DISABLE KEYS */;
INSERT INTO `agenda` VALUES (1,1,1,'2013-07-19 13:00:00','2013-07-19 13:30:00',1,NULL,'',0),(2,1,2,'2013-07-19 14:00:00','2013-07-19 14:30:00',1,NULL,'',0),(3,1,3,'2013-07-19 14:30:00','2013-07-19 15:00:00',1,NULL,'',0),(4,1,4,'2013-07-19 15:30:00','2013-07-19 16:00:00',1,NULL,'',0),(5,1,5,'2013-07-19 16:30:00','2013-07-19 17:00:00',1,NULL,'',0),(6,1,6,'2013-07-19 17:30:00','2013-07-19 18:00:00',1,NULL,'',0),(14,1,25,'2013-07-22 13:00:00','2013-07-22 13:30:00',1,NULL,'',0),(16,1,26,'2013-07-22 13:30:00','2013-07-22 14:00:00',1,NULL,'',0),(17,1,27,'2013-07-22 14:30:00','2013-07-22 15:00:00',1,NULL,'',0),(18,1,28,'2013-07-22 15:00:00','2013-07-22 15:30:00',1,NULL,'',0),(19,1,29,'2013-07-22 15:30:00','2013-07-22 16:00:00',1,NULL,'',0),(20,1,30,'2013-07-22 16:00:00','2013-07-22 16:30:00',2,NULL,'',0),(21,1,31,'2013-07-22 16:30:00','2013-07-22 17:00:00',1,NULL,'',0),(23,1,1,'2013-07-22 16:30:00','2013-07-22 17:00:00',2,NULL,'',0),(24,1,32,'2013-07-23 08:00:00','2013-07-23 08:30:00',1,NULL,'',0),(25,1,33,'2013-07-23 08:30:00','2013-07-23 09:00:00',1,NULL,'',0),(27,1,29,'2013-07-23 09:00:00','2013-07-23 09:30:00',2,NULL,'',0),(28,1,34,'2013-07-23 09:30:00','2013-07-23 10:00:00',1,NULL,'',0),(29,1,35,'2013-07-23 10:00:00','2013-07-23 10:30:00',2,NULL,'',0),(30,1,36,'2013-07-23 10:30:00','2013-07-23 11:00:00',2,NULL,'',0),(31,1,37,'2013-07-23 11:00:00','2013-07-23 11:30:00',1,NULL,'',0),(32,1,38,'2013-07-23 11:00:00','2013-07-23 11:30:00',2,NULL,'',0),(33,1,39,'2013-07-23 11:30:00','2013-07-23 12:00:00',1,NULL,'',0),(34,1,40,'2013-07-23 13:00:00','2013-07-23 13:30:00',1,NULL,'',0),(35,1,41,'2013-07-23 13:30:00','2013-07-23 14:00:00',1,NULL,'',0),(36,1,42,'2013-07-23 14:30:00','2013-07-23 15:00:00',1,NULL,'',0),(37,1,43,'2013-07-23 15:30:00','2013-07-23 16:00:00',1,NULL,'',0),(38,1,44,'2013-07-29 13:00:00','2013-07-29 13:30:00',1,NULL,'',0),(39,1,45,'2013-07-29 13:30:00','2013-07-29 14:00:00',1,NULL,'',0),(40,1,46,'2013-07-29 14:00:00','2013-07-29 14:30:00',1,NULL,'',0),(41,1,47,'2013-07-29 14:00:00','2013-07-29 14:30:00',2,NULL,'',0),(42,1,48,'2013-07-29 14:30:00','2013-07-29 15:00:00',1,NULL,'',0),(43,2,49,'2013-08-01 14:00:00','2013-08-01 14:30:00',2,NULL,'Recherche SAS\r\nQuestionnaire Epworth + calendrier Sommeil',0),(45,2,255,'2013-08-01 15:00:00','2013-08-01 15:30:00',2,NULL,'',0),(46,2,52,'2013-08-01 15:30:00','2013-08-01 16:00:00',2,NULL,'',0),(47,2,272,'2013-08-02 15:30:00','2013-08-02 16:00:00',2,NULL,'',0),(48,1,54,'2013-08-01 10:00:00','2013-08-01 10:30:00',1,NULL,'',0),(49,1,55,'2013-08-01 10:30:00','2013-08-01 11:00:00',1,NULL,'',0),(50,1,57,'2013-08-01 11:30:00','2013-08-01 12:00:00',1,NULL,'',0),(51,1,58,'2013-08-22 11:00:00','2013-08-22 11:30:00',2,NULL,'',0),(53,1,59,'2013-08-05 11:30:00','2013-08-05 12:00:00',2,NULL,'',0),(54,1,2,'2013-08-05 15:00:00','2013-08-05 15:30:00',2,NULL,'',0),(55,1,60,'2013-08-05 15:45:00','2013-08-05 16:15:00',2,NULL,'',0),(56,1,61,'2013-08-06 08:30:00','2013-08-06 09:00:00',2,NULL,'',0),(57,1,34,'2013-08-06 09:00:00','2013-08-06 09:30:00',2,NULL,'',0),(58,1,42,'2013-08-06 10:00:00','2013-08-06 10:30:00',1,NULL,'',0),(59,1,270,'2013-08-06 11:00:00','2013-08-06 11:30:00',2,NULL,'',0),(60,1,63,'2013-08-06 11:30:00','2013-08-06 12:00:00',2,NULL,'',0),(61,1,64,'2013-08-06 14:00:00','2013-08-06 14:30:00',2,NULL,'',0),(62,1,65,'2013-08-06 15:00:00','2013-08-06 15:30:00',2,NULL,'',0),(63,1,66,'2013-08-06 15:30:00','2013-08-06 16:00:00',2,NULL,'',0),(64,1,67,'2013-08-21 14:45:00','2013-08-21 15:15:00',2,NULL,'',0),(66,1,54,'2013-08-07 08:15:00','2013-08-07 08:45:00',2,NULL,'Sommeil de mauvaise qualité\r\nprévoir polygraphie nocturne',0),(67,1,69,'2013-08-07 09:00:00','2013-08-07 09:30:00',2,NULL,'',0),(68,1,70,'2013-08-07 10:00:00','2013-08-07 10:30:00',2,NULL,'',0),(69,1,71,'2013-08-07 10:30:00','2013-08-07 11:00:00',2,NULL,'',0),(70,1,72,'2013-08-07 11:00:00','2013-08-07 11:30:00',2,NULL,'',0),(71,1,73,'2013-08-07 11:30:00','2013-08-07 12:00:00',2,NULL,'',0),(72,1,74,'2013-08-07 14:00:00','2013-08-07 14:30:00',2,NULL,'',0),(74,1,75,'2013-08-07 15:00:00','2013-08-07 15:30:00',2,NULL,'',0),(75,1,76,'2013-08-08 16:30:00','2013-08-08 17:00:00',2,NULL,'prévoir polygraphie nocturne',0),(76,1,283,'2013-08-13 16:00:00','2013-08-13 16:30:00',2,81,'sous OLD + PPC\r\npréparer un certificat pour Air Austral le 12 Septembre 2013.\r\nPréciser Aller/Retour le 18 nov. 2013\r\n+fauteuil roulant à Roissy aux aéroports',0),(77,1,78,'2013-08-08 15:00:00','2013-08-08 15:30:00',2,110,'Bonne soeur\r\ndonner RV CS + sommeil',0),(78,1,79,'2013-08-08 15:30:00','2013-08-08 16:00:00',2,78,'',0),(79,1,57,'2013-08-08 16:00:00','2013-08-08 16:30:00',2,NULL,'sous Xolair 450 mg ts les 2 sam\r\nSeretide 500 2x2, veut 2B + kiné\r\nAerosol (B-A)x3; Eludril',0),(80,1,80,'2013-08-09 14:00:00','2013-08-09 14:30:00',2,NULL,'',0),(81,1,55,'2013-08-09 15:00:00','2013-08-09 15:30:00',2,NULL,'',0),(82,1,81,'2013-08-09 15:30:00','2013-08-09 16:00:00',2,NULL,'Asthme\r\nmis sous XOLAIR\r\nAVP avec luxation épaule gauche\r\n\r\nAerosol (B-A)+P x 2 Foradil Miflonil',0),(83,1,82,'2013-08-09 16:00:00','2013-08-09 16:30:00',2,73,'Douleur abdominal\r\nadressé au Dr. Blais\r\nsous Tarceva',0),(84,1,83,'2013-08-12 09:00:00','2013-08-12 09:30:00',2,74,'',0),(85,1,84,'2013-08-12 09:30:00','2013-08-12 10:00:00',2,77,'',0),(86,1,41,'2013-08-12 14:30:00','2013-08-12 15:00:00',2,NULL,'',0),(87,1,85,'2013-09-03 15:20:00','2013-09-03 15:50:00',1,78,'',0),(88,1,86,'2013-08-12 16:30:00','2013-08-12 17:00:00',2,NULL,'',0),(89,1,29,'2013-08-07 16:00:00','2013-08-07 17:00:00',3,NULL,'',0),(91,1,35,'2013-08-08 16:00:00','2013-08-08 17:00:00',3,NULL,'',0),(92,1,38,'2013-08-12 14:00:00','2013-08-12 15:00:00',3,NULL,'',0),(94,1,40,'2013-08-12 14:00:00','2013-08-12 14:30:00',2,NULL,'',0),(95,1,43,'2013-08-14 14:00:00','2013-08-14 15:00:00',3,NULL,'',0),(96,1,275,'2013-08-22 14:00:00','2013-08-22 15:00:00',3,NULL,'',0),(97,1,277,'2013-09-10 16:00:00','2013-09-10 17:00:00',3,NULL,'',0),(98,1,90,'2013-08-09 14:30:00','2013-08-09 15:00:00',2,89,'',0),(99,1,91,'2013-08-21 09:00:00','2013-08-21 09:30:00',2,NULL,'',0),(100,1,30,'2013-08-19 14:00:00','2013-08-19 15:00:00',3,NULL,'',0),(101,1,258,'2013-08-28 16:00:00','2013-08-28 17:00:00',3,NULL,'',0),(103,1,54,'2013-09-24 16:00:00','2013-09-24 17:00:00',3,NULL,'',0),(104,1,93,'2013-08-26 14:30:00','2013-08-26 15:00:00',2,NULL,'',0),(105,1,36,'2013-08-09 17:20:00','2013-08-09 17:50:00',1,NULL,'Interprétation polygraphie nocturne',0),(106,1,49,'2013-09-04 16:00:00','2013-09-04 17:00:00',3,NULL,'Polygraphie nocturne',0),(107,1,254,'2013-09-09 14:00:00','2013-09-09 15:00:00',3,NULL,'',0),(108,1,95,'2013-09-12 16:00:00','2013-09-12 17:00:00',4,NULL,'PSG',0),(111,3,97,'2013-09-12 10:30:00','2013-09-12 11:00:00',2,NULL,'Cs le 07/08/2013\r\ndécortication mpleurale par Pr Reboul en Avril 1978.',0),(112,3,97,'2013-10-08 15:00:00','2013-10-08 15:30:00',1,NULL,'',0),(113,3,74,'2013-10-07 16:00:00','2013-10-07 17:00:00',3,NULL,'',0),(114,3,98,'2013-10-01 09:00:00','2013-10-01 09:30:00',2,NULL,'',0),(116,3,39,'2013-10-17 15:30:00','2013-10-17 16:00:00',1,NULL,'',0),(117,3,99,'2013-10-09 11:30:00','2013-10-09 12:00:00',1,NULL,'',0),(118,3,99,'2013-08-12 11:00:00','2013-08-12 11:30:00',2,NULL,'',0),(119,3,100,'2013-08-21 11:00:00','2013-08-21 11:30:00',2,NULL,'',0),(121,3,101,'2013-08-16 16:30:00','2013-08-16 17:00:00',2,NULL,'',0),(122,3,102,'2013-08-27 09:30:00','2013-08-27 10:00:00',2,NULL,'Demander RP + Echo-doppler + GDS\nDépressif, idées sucidaires',0),(123,3,103,'2013-08-27 10:00:00','2013-08-27 10:30:00',2,NULL,'Dr Pracisnore demande NFS+GDS',0),(124,3,103,'2013-10-01 08:00:00','2013-10-01 08:30:00',1,NULL,'',0),(125,3,104,'2013-08-27 10:30:00','2013-08-27 11:00:00',2,NULL,'demande :\r\n1/ TDM thorax sans injection\r\n2/CRP, TG x 3,\r\n0 692 20 32 93',0),(126,3,113,'2013-09-13 11:30:00','2013-09-13 12:00:00',2,NULL,'',0),(127,3,113,'2013-10-09 14:30:00','2013-10-09 15:00:00',1,NULL,'Dr a dit de ne pas venir !!!!',0),(128,3,114,'2013-08-29 14:00:00','2013-08-29 14:30:00',2,NULL,'Asthme',0),(129,3,115,'2013-08-19 16:30:00','2013-08-19 17:00:00',2,NULL,'forte suspicion SAS',0),(130,3,76,'2013-09-04 09:00:00','2013-09-04 09:30:00',1,NULL,'',0),(131,3,115,'2013-08-08 16:30:00','2013-08-08 17:00:00',1,NULL,'',0),(132,3,78,'2013-10-03 14:00:00','2013-10-03 15:00:00',3,NULL,'',0),(133,3,116,'2013-08-19 15:00:00','2013-08-19 15:30:00',2,NULL,'',0),(134,3,117,'2013-08-19 15:30:00','2013-08-19 16:00:00',2,NULL,'',0),(135,3,118,'2013-08-20 16:20:00','2013-08-20 16:50:00',1,NULL,'',0),(136,3,119,'2013-09-02 14:00:00','2013-09-02 14:30:00',2,NULL,'',0),(137,3,119,'2013-10-09 15:00:00','2013-10-09 15:30:00',1,NULL,'',0),(138,3,120,'2013-09-02 15:00:00','2013-09-02 15:30:00',2,NULL,'',0),(139,3,120,'2013-09-26 16:00:00','2013-09-26 17:00:00',3,NULL,'',0),(140,3,120,'2013-09-30 14:00:00','2013-09-30 14:30:00',1,NULL,'',0),(141,3,90,'2013-10-09 16:30:00','2013-10-09 17:30:00',3,NULL,'',0),(142,3,121,'2013-09-25 08:15:00','2013-09-25 08:45:00',2,NULL,'',0),(143,3,122,'2013-09-25 09:00:00','2013-09-25 09:30:00',2,NULL,'',0),(144,3,122,'2013-10-10 09:00:00','2013-10-10 09:30:00',1,NULL,'',0),(146,3,123,'2013-08-21 10:00:00','2013-08-21 10:30:00',2,NULL,'',0),(147,2,124,'2013-08-09 17:00:00','2013-08-09 17:30:00',2,69,'',0),(148,3,5,'2013-10-09 15:30:00','2013-10-09 16:00:00',1,NULL,'',0),(149,3,36,'2013-08-13 14:30:00','2013-08-13 15:00:00',1,NULL,'',0),(150,3,125,'2013-08-14 15:00:00','2013-08-14 15:30:00',2,NULL,'',0),(153,2,126,'2013-08-12 10:00:00','2013-08-12 10:30:00',2,84,'prévoir polygraphie nocturne\r\nGDS demandé\r\nAVC en 2008',0),(154,2,127,'2013-08-12 17:00:00','2013-08-12 17:30:00',2,NULL,'',0),(155,2,128,'2013-08-13 08:00:00','2013-08-13 08:30:00',2,NULL,'',0),(156,2,129,'2013-08-13 08:30:00','2013-08-13 09:00:00',2,NULL,'prévoir polygraphie nocturne\r\nfaire lettre pour Dr. Hossenboccus',0),(157,2,45,'2013-08-13 09:00:00','2013-08-13 09:30:00',2,NULL,'faire agenda de sommeil pour SAS',0),(158,2,131,'2013-08-13 09:30:00','2013-08-13 10:00:00',2,NULL,'',0),(159,2,132,'2013-08-13 10:00:00','2013-08-13 10:30:00',2,NULL,'',0),(161,2,134,'2013-08-14 11:00:00','2013-08-14 11:30:00',2,NULL,'',0),(162,2,35,'2013-08-13 16:45:00','2013-08-13 17:15:00',1,NULL,'polygraphie nocturne',0),(163,2,135,'2013-08-14 09:00:00','2013-08-14 09:30:00',2,NULL,'',0),(164,2,136,'2013-08-14 09:30:00','2013-08-14 10:00:00',2,NULL,'',0),(165,2,137,'2013-08-14 10:00:00','2013-08-14 10:30:00',2,NULL,'',0),(166,2,138,'2013-08-14 11:30:00','2013-08-14 12:00:00',2,NULL,'',0),(167,2,139,'2013-08-14 16:00:00','2013-08-14 16:30:00',2,NULL,'voir TDM Thorax + echocoeur mesure PAP',0),(168,2,95,'2013-08-14 17:00:00','2013-08-14 17:30:00',2,NULL,'',0),(169,2,33,'2013-08-16 09:00:00','2013-08-16 09:30:00',2,NULL,'',0),(170,2,46,'2013-08-16 09:30:00','2013-08-16 10:00:00',2,NULL,'',0),(171,2,48,'2013-08-16 10:00:00','2013-08-16 10:30:00',2,NULL,'prévoir agenda sommeil + polygraphie nocturne',0),(172,2,140,'2013-08-16 11:00:00','2013-08-16 11:30:00',2,NULL,'',0),(173,2,141,'2013-08-16 15:00:00','2013-08-16 15:30:00',2,NULL,'',0),(174,2,142,'2013-08-16 16:00:00','2013-08-16 16:30:00',2,NULL,'',0),(175,2,143,'2013-08-16 16:30:00','2013-08-16 17:00:00',2,NULL,'',0),(177,2,145,'2013-08-20 08:00:00','2013-08-20 08:30:00',2,NULL,'prévoir rendez-vous pour polygraphie nocturne à donner',0),(180,2,147,'2013-08-20 10:00:00','2013-08-20 10:30:00',2,NULL,'',0),(181,2,148,'2013-08-20 11:00:00','2013-08-20 11:30:00',2,NULL,'',0),(182,2,42,'2013-08-20 14:15:00','2013-08-20 14:45:00',2,NULL,'',0),(183,2,60,'2013-08-20 16:00:00','2013-08-20 17:00:00',3,NULL,'',0),(184,2,44,'2013-08-21 08:15:00','2013-08-21 08:45:00',2,74,'faire agenda de sommeil',0),(185,2,149,'2013-08-21 11:30:00','2013-08-21 12:00:00',2,NULL,'',0),(186,2,150,'2013-08-22 15:00:00','2013-08-22 15:30:00',2,NULL,'',0),(187,2,151,'2013-08-22 09:00:00','2013-08-22 09:30:00',2,NULL,'Donner RV pour exploration de sommeil\r\nvoir OLD Respidom',0),(188,2,152,'2013-08-22 10:00:00','2013-08-22 10:30:00',2,NULL,'Aérosol (B-A) + Foradil + Miflonil + kiné',0),(189,2,153,'2013-08-27 09:00:00','2013-08-27 09:30:00',2,NULL,'',0),(190,2,105,'2013-08-27 11:00:00','2013-08-27 11:30:00',2,NULL,'Aérosol (B-A) x 3 + pub x 2 + kiné + pneumo',0),(191,2,47,'2013-08-28 08:00:00','2013-08-28 08:30:00',2,NULL,'',0),(192,2,154,'2013-08-28 09:00:00','2013-08-28 09:30:00',2,NULL,'',0),(193,2,155,'2013-08-28 11:00:00','2013-08-28 11:30:00',2,NULL,'',0),(194,2,156,'2013-08-29 08:30:00','2013-08-29 09:00:00',2,NULL,'',0),(195,2,263,'2013-09-04 14:00:00','2013-09-04 14:30:00',2,NULL,'',0),(196,2,2,'2013-09-04 14:30:00','2013-09-04 15:00:00',2,NULL,'',0),(197,2,157,'2013-09-06 16:30:00','2013-09-06 17:00:00',2,NULL,'enfant de 2 ans',0),(198,2,86,'2013-09-16 14:00:00','2013-09-16 15:00:00',3,NULL,'',0),(199,2,145,'2013-10-01 16:00:00','2013-10-01 17:00:00',3,NULL,'',0),(200,3,84,'2013-10-07 10:00:00','2013-10-07 10:30:00',1,NULL,'',0),(201,3,126,'2013-10-07 14:15:00','2013-10-07 14:45:00',1,NULL,'',0),(202,3,126,'2013-10-21 16:00:00','2013-10-21 17:00:00',3,NULL,'',0),(203,3,158,'2013-10-01 15:30:00','2013-10-01 16:00:00',1,NULL,'',0),(204,3,158,'2013-08-22 15:00:00','2013-08-22 15:30:00',2,NULL,'',0),(205,2,159,'2013-08-22 16:00:00','2013-08-22 16:30:00',2,NULL,'Est venu en consultation le lundi 12/08/2013 Patient No 2.',0),(208,2,161,'2013-08-26 16:00:00','2013-08-26 16:30:00',2,NULL,'',0),(209,3,161,'2013-11-04 14:00:00','2013-11-04 14:30:00',1,NULL,'Est venue en consultation le 12/08/2013 Patiente No 4.',0),(210,2,40,'2013-10-14 16:00:00','2013-10-14 17:00:00',3,NULL,'',0),(211,3,40,'2013-10-15 08:00:00','2013-10-15 08:30:00',1,NULL,'',0),(212,3,41,'2013-10-15 08:30:00','2013-10-15 09:00:00',1,NULL,'',0),(215,3,127,'2013-10-07 16:30:00','2013-10-07 17:00:00',1,NULL,'',0),(218,2,164,'2013-09-03 17:00:00','2013-09-03 18:00:00',3,NULL,'',0),(219,2,164,'2013-08-12 18:00:00','2013-08-12 18:30:00',2,NULL,'',0),(221,3,165,'2013-08-26 15:20:00','2013-08-26 15:50:00',1,NULL,'Cf Cs du 13/08/2013 à 8:00',0),(223,3,166,'2013-08-29 09:00:00','2013-08-29 09:30:00',2,NULL,'Appareillé  avec ISIS Médical',0),(225,3,128,'2013-10-11 08:00:00','2013-10-11 08:30:00',1,NULL,'EFR du 13/08/2013',0),(226,3,167,'2013-09-05 14:00:00','2013-09-05 14:30:00',2,NULL,'Cs du 13/08/2013 patient No 3.',0),(227,3,167,'2013-10-11 10:00:00','2013-10-11 10:30:00',1,NULL,'',0),(228,2,129,'2013-10-23 16:00:00','2013-10-23 17:00:00',3,NULL,'',0),(230,3,168,'2013-10-08 09:15:00','2013-10-08 09:45:00',1,NULL,'',0),(231,3,169,'2013-09-03 08:00:00','2013-09-03 08:30:00',2,NULL,'Cs du 13/08/2013 pt4',0),(232,3,169,'2013-10-11 09:00:00','2013-10-11 09:30:00',1,NULL,'',0),(233,3,170,'2013-08-27 14:20:00','2013-08-27 14:50:00',1,NULL,'',0),(234,3,45,'2013-10-10 11:00:00','2013-10-10 11:30:00',1,NULL,'',0),(235,3,171,'2013-11-08 09:00:00','2013-11-08 09:30:00',1,NULL,'',0),(237,2,131,'2013-10-07 08:00:00','2013-10-07 08:30:00',1,NULL,'',0),(238,3,173,'2013-09-04 09:00:00','2013-09-04 09:30:00',2,NULL,'patiente n°7 du 13/08/2013',0),(239,3,173,'2013-10-16 09:00:00','2013-10-16 09:30:00',1,NULL,'',0),(240,3,132,'2013-10-31 09:00:00','2013-10-31 09:30:00',1,NULL,'avait rdv de sommeil en octobre. A preferé le faire à l\'hopital.',0),(241,3,174,'2013-08-28 14:00:00','2013-08-28 14:30:00',2,NULL,'Cs du 13/08/2013 pte No8',0),(242,3,174,'2013-10-18 14:00:00','2013-10-18 14:30:00',1,NULL,'',0),(244,3,175,'2013-09-03 09:00:00','2013-09-03 09:30:00',2,NULL,'Cs le 14/08/2013',0),(245,3,175,'2013-10-29 08:00:00','2013-10-29 08:30:00',1,NULL,'',0),(246,3,175,'2013-10-30 16:00:00','2013-10-30 17:00:00',3,NULL,'',0),(247,3,176,'2013-09-05 08:00:00','2013-09-05 08:30:00',2,NULL,'Cs le 14/08/2013',0),(249,3,177,'2013-09-03 10:00:00','2013-09-03 10:30:00',2,NULL,'Cs le 14/08/2013',0),(250,3,177,'2013-10-29 08:30:00','2013-10-29 09:00:00',1,NULL,'',0),(251,3,135,'2013-09-20 15:00:00','2013-09-20 15:30:00',1,NULL,'EFR le 14/08/2013',0),(252,3,178,'2013-09-09 11:00:00','2013-09-09 11:30:00',2,NULL,'Cs le 14/08/2013',0),(253,3,178,'2013-10-28 11:00:00','2013-10-28 11:30:00',1,NULL,'',0),(254,3,136,'2013-10-07 08:30:00','2013-10-07 09:00:00',1,NULL,'EFR du 14/08/2013',0),(256,3,137,'2013-09-04 10:00:00','2013-09-04 10:30:00',1,NULL,'EFR du 14/08/2013',0),(257,3,25,'2013-09-04 11:00:00','2013-09-04 11:30:00',2,NULL,'PSG  avec 31 IAH',0),(258,3,25,'2013-11-06 11:00:00','2013-11-06 11:30:00',1,NULL,'IAH à 31',0),(259,2,29,'2013-08-19 13:30:00','2013-08-19 14:30:00',3,NULL,'',0),(260,3,134,'2013-10-01 15:00:00','2013-10-01 15:30:00',1,NULL,'EFR le 14/08/2013',0),(263,3,138,'2013-10-15 10:00:00','2013-10-15 10:30:00',1,NULL,'',0),(264,3,179,'2013-09-03 15:45:00','2013-09-03 16:15:00',2,NULL,'Spondyle Ankylosante',0),(265,3,180,'2013-09-27 14:00:00','2013-09-27 14:30:00',2,NULL,'Tuberculose pulmonaire guéri',0),(266,3,181,'2013-09-10 09:00:00','2013-09-10 09:30:00',2,NULL,'Cs du 14/08/2013',0),(269,3,182,'2013-09-11 09:30:00','2013-09-11 10:00:00',2,NULL,'Cs du 14/08/2013',0),(270,3,182,'2013-11-05 09:30:00','2013-11-05 10:00:00',1,NULL,'',0),(271,2,183,'2013-08-20 15:00:00','2013-08-20 15:30:00',2,NULL,'60\'s',0),(272,3,184,'2013-09-05 15:00:00','2013-09-05 15:30:00',2,NULL,'',0),(273,3,184,'2013-11-07 08:30:00','2013-11-07 09:00:00',1,NULL,'',0),(274,3,185,'2013-09-06 15:00:00','2013-09-06 15:30:00',2,NULL,'Cs le 14/08/2013',0),(275,3,185,'2013-11-14 08:00:00','2013-11-14 08:30:00',1,NULL,'',0),(276,2,185,'2013-11-13 16:00:00','2013-11-13 17:00:00',3,NULL,'Sommeil leger, dort sous O2',0),(277,3,75,'2013-08-23 16:40:00','2013-08-23 17:10:00',1,NULL,'',0),(278,3,125,'2013-08-30 16:30:00','2013-08-30 17:00:00',1,NULL,'',0),(279,3,186,'2013-09-04 15:00:00','2013-09-04 15:30:00',2,NULL,'Cs le 14/08/2013',0),(280,2,186,'2013-11-20 16:00:00','2013-11-20 17:00:00',3,NULL,'',0),(282,3,187,'2013-09-10 08:15:00','2013-09-10 08:45:00',2,NULL,'Cs du 15/08/2013',0),(283,3,187,'2013-10-28 16:15:00','2013-10-28 16:45:00',1,NULL,'EFR le 10/09/2013',0),(284,3,188,'2013-09-24 10:00:00','2013-09-24 10:30:00',2,NULL,'Cs du 15/08/2013',0),(285,3,188,'2013-11-05 11:00:00','2013-11-05 11:30:00',1,NULL,'prevoir score d\'epworth',0),(286,3,189,'2013-09-24 10:30:00','2013-09-24 11:00:00',2,NULL,'',0),(287,3,189,'2013-11-05 11:30:00','2013-11-05 12:00:00',1,NULL,'Cs le 15/08/2013',0),(288,3,190,'2013-09-27 14:30:00','2013-09-27 15:00:00',1,NULL,'BPC0 Schizophénie AVC  Parkinson H',0),(289,3,33,'2013-11-07 10:00:00','2013-11-07 10:30:00',1,NULL,'',0),(291,3,48,'2013-09-10 10:00:00','2013-09-10 10:30:00',1,NULL,'',0),(293,3,140,'2013-09-13 14:00:00','2013-09-13 14:30:00',2,NULL,'',0),(294,3,191,'2013-08-20 08:30:00','2013-08-20 09:00:00',2,NULL,'',0),(295,3,192,'2013-09-02 16:15:00','2013-09-02 16:45:00',2,NULL,'Cs du 16/08/2013',0),(296,3,192,'2013-10-30 10:00:00','2013-10-30 10:30:00',1,NULL,'',0),(297,3,193,'2013-09-10 10:00:00','2013-09-10 10:30:00',2,NULL,'Cs du 16/08/2013',0),(298,3,193,'2013-10-31 10:00:00','2013-10-31 10:30:00',1,NULL,'',0),(299,3,194,'2013-09-04 10:00:00','2013-09-04 10:30:00',2,NULL,'cs du 16/08/2013',0),(300,3,194,'2013-10-23 09:00:00','2013-10-23 09:30:00',1,NULL,'',0),(301,3,195,'2013-09-03 10:30:00','2013-09-03 11:00:00',2,NULL,'',0),(302,3,195,'2013-10-17 14:00:00','2013-10-17 14:30:00',1,NULL,'',0),(303,3,196,'2013-09-05 09:00:00','2013-09-05 09:30:00',2,NULL,'Cs le 16/08/2013',0),(304,3,196,'2013-12-05 11:00:00','2013-12-05 11:30:00',1,NULL,'',0),(305,3,141,'2013-10-07 15:00:00','2013-10-07 15:30:00',1,NULL,'EFR du 16/08/2013',0),(306,3,36,'2013-08-23 13:45:00','2013-08-23 14:15:00',1,NULL,'',0),(307,3,197,'2013-09-04 08:30:00','2013-09-04 09:00:00',2,NULL,'',0),(309,3,142,'2013-09-03 15:40:00','2013-09-03 16:10:00',1,NULL,'EFR du 16/08/2013',0),(310,3,198,'2013-09-03 11:15:00','2013-09-03 11:45:00',2,NULL,'Cs du 2 et 16/08/2013',0),(311,3,198,'2013-10-29 10:00:00','2013-10-29 10:30:00',1,NULL,'',0),(312,3,143,'2013-09-13 10:30:00','2013-09-13 11:00:00',1,NULL,'EFR du 16/08/2013',0),(314,3,101,'2013-10-30 17:00:00','2013-10-30 17:30:00',1,NULL,'EFR à prévoir',0),(315,3,101,'2013-10-25 17:00:00','2013-10-25 17:30:00',2,NULL,'',0),(316,3,199,'2013-09-09 10:00:00','2013-09-09 10:30:00',2,NULL,'',0),(318,2,200,'2013-08-28 14:45:00','2013-08-28 15:15:00',2,NULL,'',0),(319,3,201,'2013-10-01 09:30:00','2013-10-01 10:00:00',2,NULL,'',0),(320,3,201,'2013-10-11 10:30:00','2013-10-11 11:00:00',1,NULL,'',0),(321,3,30,'2013-09-04 14:00:00','2013-09-04 14:30:00',1,NULL,'',0),(322,3,202,'2013-10-01 10:00:00','2013-10-01 10:30:00',2,NULL,'Cs le 19/08/2013\r\nNe pas oublier expliquer Polygraphie nocturne Décédé oct 2013',0),(325,3,117,'2013-10-14 10:00:00','2013-10-14 10:30:00',1,NULL,'',0),(326,3,203,'2013-09-03 14:00:00','2013-09-03 14:30:00',2,NULL,'',0),(327,3,203,'2013-10-29 14:00:00','2013-10-29 14:30:00',1,NULL,'',0),(328,2,203,'2013-11-19 16:30:00','2013-11-19 17:30:00',3,NULL,'',0),(329,2,115,'2013-08-29 17:30:00','2013-08-29 18:30:00',3,NULL,'',0),(331,1,191,'2013-08-19 17:00:00','2013-08-19 17:30:00',1,NULL,'',0),(332,3,145,'2013-10-17 08:00:00','2013-10-17 08:30:00',1,NULL,'rechercher une malformation cranio faciale',0),(333,3,204,'2013-09-24 11:00:00','2013-09-24 11:30:00',2,NULL,'Cs du 20/08/2013',0),(334,2,206,'2013-08-20 09:00:00','2013-08-20 09:30:00',2,NULL,'',0),(335,3,204,'2013-08-27 08:20:00','2013-08-27 08:50:00',1,NULL,'',0),(336,2,206,'2013-10-28 12:00:00','2013-10-28 12:30:00',1,NULL,'',0),(337,3,205,'2013-10-14 15:00:00','2013-10-14 15:30:00',1,NULL,'',0),(339,3,207,'2013-10-14 11:00:00','2013-10-14 11:30:00',1,NULL,'EFR le  14/10/2013 et cs le 20/08/2013. hospitalisée vers 12 nov : ne peut venir à son efr',0),(340,3,208,'2013-09-27 14:30:00','2013-09-27 15:00:00',2,NULL,'Cs le 20/08/2013',0),(341,3,208,'2013-10-15 10:30:00','2013-10-15 11:00:00',1,NULL,'',0),(342,3,147,'2013-10-16 09:30:00','2013-10-16 10:00:00',1,NULL,'EFR du 20/08/2013',0),(343,2,147,'2013-11-18 16:00:00','2013-11-18 17:00:00',3,NULL,'',0),(344,3,148,'2013-10-07 15:30:00','2013-10-07 16:00:00',1,NULL,'EFR du 20/08/2013',0),(345,3,209,'2013-08-21 14:00:00','2013-08-21 14:30:00',2,NULL,'',0),(346,3,210,'2013-09-25 14:00:00','2013-09-25 14:30:00',2,NULL,'',0),(347,3,210,'2013-11-06 14:00:00','2013-11-06 14:30:00',1,NULL,'Cs du 20/08/2013\r\nregarder aussi le 28/08/2013 (pas venue)',0),(348,3,42,'2013-09-19 14:20:00','2013-09-19 14:50:00',1,NULL,'EFR du 20/08/2013',0),(349,3,42,'2013-11-25 16:00:00','2013-11-25 17:00:00',3,NULL,'',0),(350,3,211,'2013-10-01 14:00:00','2013-10-01 14:30:00',2,NULL,'',0),(351,3,211,'2013-11-08 14:00:00','2013-11-08 14:30:00',1,NULL,'Cs du 20/08/2013',0),(353,3,212,'2013-09-26 09:00:00','2013-09-26 09:30:00',2,NULL,'Cs du 20/08/2013',0),(354,3,212,'2013-10-09 09:00:00','2013-10-09 09:30:00',1,NULL,'',0),(355,3,213,'2013-09-26 10:00:00','2013-09-26 10:30:00',2,NULL,'Cs le 20/08/2013',0),(357,2,213,'2013-11-27 16:00:00','2013-11-27 17:00:00',3,NULL,'',0),(358,3,43,'2013-08-28 08:40:00','2013-08-28 09:10:00',1,NULL,'sommeil',0),(359,3,214,'2013-09-25 10:30:00','2013-09-25 11:00:00',2,NULL,'Cs du 21/08/2013',0),(360,3,214,'2013-10-23 08:00:00','2013-10-23 08:30:00',1,NULL,'',0),(361,3,215,'2013-10-08 08:00:00','2013-10-08 08:30:00',2,NULL,'n\'est pasvenu chercher son résultat du efr ; rappellera.',0),(363,3,216,'2013-08-29 14:30:00','2013-08-29 15:00:00',2,NULL,'',0),(364,3,44,'2013-12-02 16:00:00','2013-12-02 17:00:00',3,NULL,'',0),(365,3,217,'2013-08-26 15:40:00','2013-08-26 16:10:00',1,NULL,'Cs du 21/08/2013\r\nPrévoir EFR',0),(366,3,218,'2013-09-27 15:00:00','2013-09-27 15:30:00',2,NULL,'Cs du 21/08/2013',0),(367,3,218,'2013-10-21 09:00:00','2013-10-21 09:30:00',1,NULL,'',0),(368,3,219,'2013-09-06 14:00:00','2013-09-06 14:30:00',2,NULL,'Cs du 21/08/2013',0),(369,3,219,'2013-10-18 15:00:00','2013-10-18 15:30:00',1,NULL,'EFR du 06/09/2013\r\nA refusé de venir en Cs le 18/10/2013.',0),(370,3,220,'2013-09-26 09:30:00','2013-09-26 10:00:00',2,NULL,'',0),(371,3,220,'2013-10-25 08:00:00','2013-10-25 08:30:00',1,NULL,'',0),(374,3,222,'2013-09-25 14:30:00','2013-09-25 15:00:00',2,NULL,'Cs du 21/08/2013\r\nSuspicion de SAS',0),(375,3,222,'2013-10-15 16:00:00','2013-10-15 17:00:00',3,NULL,'',0),(376,3,222,'2013-10-21 11:00:00','2013-10-21 11:30:00',1,NULL,'',0),(377,3,223,'2013-09-05 15:30:00','2013-09-05 16:00:00',2,NULL,'Cs du 21/08/2013',0),(378,3,223,'2013-10-16 15:00:00','2013-10-16 15:30:00',1,NULL,'',0),(379,3,224,'2013-09-05 16:00:00','2013-09-05 16:30:00',2,NULL,'Cs du 21/08/2013',0),(380,3,224,'2013-10-16 15:30:00','2013-10-16 16:00:00',1,NULL,'Cs du 21/08/2013',0),(381,3,225,'2013-09-03 15:00:00','2013-09-03 15:30:00',2,NULL,'Cs du 21/08/2013',0),(382,2,227,'2013-09-24 14:45:00','2013-09-24 15:15:00',2,NULL,'',0),(383,2,227,'2013-08-22 08:15:00','2013-08-22 08:45:00',1,NULL,'',0),(384,3,228,'2013-10-08 15:00:00','2013-10-08 15:30:00',2,NULL,'',0),(385,3,228,'2013-10-15 14:00:00','2013-10-15 14:30:00',1,NULL,'',0),(386,3,228,'2013-12-12 16:00:00','2013-12-12 17:00:00',3,NULL,'Cs du 22/08/2013',0),(387,3,229,'2013-10-08 15:00:00','2013-10-08 15:30:00',2,NULL,'cs du 22/08/2013',0),(388,3,229,'2013-10-23 15:00:00','2013-10-23 15:30:00',1,NULL,'',0),(389,3,230,'2013-10-09 08:00:00','2013-10-09 08:30:00',2,NULL,'',0),(390,3,230,'2013-10-30 08:00:00','2013-10-30 08:30:00',1,NULL,'Cs du 22/08/2013',0),(392,2,231,'2013-08-29 10:30:00','2013-08-29 11:00:00',2,NULL,'adressé par l\'hôpital psychiatrique',0),(394,3,232,'2013-09-25 15:00:00','2013-09-25 15:30:00',2,NULL,'',0),(395,3,232,'2013-11-06 15:00:00','2013-11-06 15:30:00',1,NULL,'Cs du 22/08/2013',0),(396,2,233,'2013-09-26 16:00:00','2013-09-26 17:00:00',3,NULL,'',0),(397,2,235,'2013-08-22 11:00:00','2013-08-22 11:30:00',1,NULL,'',0),(398,2,234,'2013-10-08 08:45:00','2013-10-08 09:15:00',2,NULL,'',0),(399,3,234,'2013-11-08 08:00:00','2013-11-08 08:30:00',1,NULL,'',0),(400,3,234,'2013-08-22 11:00:00','2013-08-22 11:30:00',1,NULL,'',0),(402,3,236,'2013-08-29 11:20:00','2013-08-29 11:50:00',1,NULL,'',0),(403,3,235,'2013-10-15 08:15:00','2013-10-15 08:45:00',2,NULL,'Scanner thoracique à voir .\r\ndossier à passer en RCP d\'Oncologie thoracique\r\nSous IRESSA.',0),(404,2,237,'2013-08-22 11:30:00','2013-08-22 12:00:00',1,NULL,'',0),(405,3,237,'2013-07-31 08:00:00','2013-07-31 08:30:00',2,NULL,'',0),(406,3,237,'2013-10-22 08:30:00','2013-10-22 09:00:00',1,NULL,'',0),(407,2,238,'2013-08-22 14:30:00','2013-08-22 15:00:00',1,NULL,'',0),(408,3,238,'2013-10-18 18:15:00','2013-10-18 19:15:00',4,NULL,'PSG',0),(409,3,238,'2013-10-17 08:15:00','2013-10-17 08:45:00',2,NULL,'',0),(410,3,238,'2013-10-23 08:30:00','2013-10-23 09:00:00',1,NULL,'',0),(411,3,150,'2013-10-07 09:00:00','2013-10-07 09:30:00',1,NULL,'EFr du 22/08/2013',0),(412,3,159,'2013-09-09 16:00:00','2013-09-09 16:30:00',1,NULL,'EFR du 22/08/2013',0),(413,3,66,'2013-08-23 13:30:00','2013-08-23 14:00:00',1,NULL,'',0),(415,4,1,'2013-08-23 14:40:00','2013-08-23 15:10:00',1,NULL,'cf 19/07/2013 a 14:00',0),(416,3,240,'2013-10-15 09:00:00','2013-10-15 09:30:00',2,NULL,'',0),(417,3,240,'2013-12-10 09:00:00','2013-12-10 09:30:00',1,NULL,'Cs du 23/08 et EFR du 15/10/2013',0),(418,3,241,'2013-10-02 14:00:00','2013-10-02 14:30:00',2,NULL,'Cs le 23/08',0),(419,3,241,'2013-10-23 14:00:00','2013-10-23 14:30:00',1,NULL,'',0),(420,3,242,'2013-09-06 15:30:00','2013-09-06 16:00:00',1,NULL,'',0),(421,3,243,'2013-09-26 11:00:00','2013-09-26 11:30:00',2,NULL,'Cs du 23/08/2013',0),(422,3,243,'2013-10-16 08:30:00','2013-10-16 09:00:00',1,NULL,'',0),(423,3,75,'2013-10-10 16:00:00','2013-10-10 17:00:00',3,NULL,'',0),(425,4,325,'2013-08-29 09:30:00','2013-08-29 10:00:00',1,NULL,'',0),(426,3,30,'2013-07-19 12:30:00','2013-07-19 13:00:00',1,NULL,'',0),(427,3,248,'2013-07-22 17:00:00','2013-07-22 17:30:00',1,NULL,'',0),(428,3,249,'2013-07-22 17:30:00','2013-07-22 18:00:00',1,NULL,'',0),(429,3,35,'2013-07-22 18:00:00','2013-07-22 18:30:00',1,NULL,'',0),(430,3,38,'2013-07-22 18:30:00','2013-07-22 19:00:00',1,NULL,'',0),(431,3,132,'2013-07-22 19:00:00','2013-07-22 19:30:00',1,NULL,'',0),(432,3,36,'2013-07-22 19:30:00','2013-07-22 20:00:00',1,NULL,'',0),(433,3,144,'2013-07-22 20:00:00','2013-07-22 20:30:00',1,NULL,'',0),(434,3,253,'2013-07-24 08:00:00','2013-07-24 08:30:00',1,NULL,'',0),(435,3,254,'2013-07-24 08:30:00','2013-07-24 09:00:00',1,NULL,'Astme sous xolair',0),(436,3,255,'2013-07-24 09:00:00','2013-07-24 09:30:00',1,NULL,'SAS  ARAR',0),(437,3,52,'2013-07-24 09:30:00','2013-07-24 10:00:00',1,NULL,'Adeno K TTF1 + lobectomie std 2b +CT adj',0),(438,3,47,'2013-07-24 10:00:00','2013-07-24 10:30:00',1,NULL,'Carci pulmr Primitif lobectomie sup Gche T1N0M0',0),(439,3,258,'2013-07-24 10:30:00','2013-07-24 11:00:00',1,NULL,'micro nodules LM',0),(440,3,259,'2013-07-24 11:00:00','2013-07-24 11:30:00',1,NULL,'',0),(441,3,260,'2013-07-24 11:30:00','2013-07-24 12:00:00',1,NULL,'',0),(442,3,261,'2013-07-24 12:00:00','2013-07-24 12:30:00',1,NULL,'',0),(443,3,262,'2013-07-24 14:00:00','2013-07-24 14:30:00',1,NULL,'',0),(444,3,263,'2013-07-24 14:30:00','2013-07-24 15:00:00',1,NULL,'Respidom',0),(445,3,153,'2013-07-25 08:00:00','2013-07-25 08:30:00',1,NULL,'',0),(446,3,131,'2013-07-25 08:30:00','2013-07-25 09:00:00',1,NULL,'',0),(447,3,165,'2013-07-25 09:00:00','2013-07-25 09:30:00',1,NULL,'',0),(448,3,135,'2013-07-25 09:30:00','2013-07-25 10:00:00',1,NULL,'',0),(449,3,136,'2013-07-25 10:00:00','2013-07-25 10:30:00',1,NULL,'Asthme sous Xolair',0),(450,3,83,'2013-07-25 10:30:00','2013-07-25 11:00:00',1,NULL,'',0),(451,3,270,'2013-07-25 11:00:00','2013-07-25 11:30:00',1,NULL,'',0),(452,3,271,'2013-07-25 11:30:00','2013-07-25 12:00:00',1,NULL,'AdenoK du LSD T2N0M1a\r\nsous IRESSA,ARIXTRA et OLD.',0),(453,3,272,'2013-07-25 12:00:00','2013-07-25 12:30:00',1,NULL,'',0),(454,3,273,'2013-07-25 14:00:00','2013-07-25 14:30:00',1,NULL,'agenda de sommeil',0),(455,3,80,'2013-07-25 14:30:00','2013-07-25 15:00:00',1,NULL,'Asthme grave ne prend pas de ttt de fond',0),(456,3,275,'2013-07-25 15:00:00','2013-07-25 15:30:00',1,NULL,'',0),(457,3,85,'2013-07-25 15:30:00','2013-07-25 16:00:00',1,NULL,'',0),(458,3,277,'2013-07-25 16:00:00','2013-07-25 16:30:00',1,NULL,'',0),(459,3,278,'2013-07-25 16:30:00','2013-07-25 17:00:00',1,NULL,'lobectomie Lm et tumorectomie le 04/07/2008 = 4 lignes de cT:1.CDDP NVB\r\n2.alimta 3..Tarceva 4.taxotere\r\nEn progression moderée.',0),(460,3,237,'2013-07-26 14:00:00','2013-07-26 14:30:00',1,NULL,'ARAR',0),(461,3,280,'2013-07-26 14:30:00','2013-07-26 15:00:00',1,NULL,'',0),(462,3,281,'2013-07-26 15:00:00','2013-07-26 15:30:00',1,NULL,'Sous anti TNF alpha.\r\nTub Latente',0),(463,3,282,'2013-07-26 15:30:00','2013-07-26 16:00:00',1,NULL,'ISIS sous VNI et OLD.',0),(464,3,283,'2013-07-26 16:00:00','2013-07-26 16:30:00',1,NULL,'ARAR PPC OLD',0),(465,3,139,'2013-07-26 16:30:00','2013-07-26 17:00:00',1,NULL,'SAS  ISIS',0),(466,3,143,'2013-07-26 17:00:00','2013-07-26 17:30:00',1,NULL,'',0),(467,3,124,'2013-07-29 15:00:00','2013-07-29 15:30:00',1,NULL,'AdenoK colorectal avec meta hepatique et pulmonaires',0),(468,3,287,'2013-07-29 15:30:00','2013-07-29 16:00:00',1,NULL,'Asthme',0),(470,3,293,'2013-10-07 14:00:00','2013-10-07 14:30:00',2,NULL,'Cs du 26/08/2013',0),(471,3,293,'2013-11-04 13:30:00','2013-11-04 14:00:00',1,NULL,'',0),(472,2,293,'2013-12-11 14:00:00','2013-12-11 15:00:00',3,NULL,'',0),(473,3,249,'2013-09-02 16:00:00','2013-09-02 16:30:00',1,NULL,'',0),(475,3,298,'2013-09-26 14:00:00','2013-09-26 14:30:00',2,NULL,'',0),(477,3,298,'2013-10-25 14:00:00','2013-10-25 14:30:00',1,NULL,'Cs du 26/08/2013',0),(478,3,93,'2013-11-13 08:00:00','2013-11-13 08:30:00',1,NULL,'EFR le 26/08/2013',0),(479,3,217,'2013-10-10 14:00:00','2013-10-10 14:30:00',2,NULL,'',0),(480,3,217,'2013-10-22 14:00:00','2013-10-22 14:30:00',1,NULL,'',0),(481,3,73,'2013-08-27 09:30:00','2013-08-27 10:00:00',1,NULL,'',0),(482,3,73,'2013-09-04 10:30:00','2013-09-04 11:00:00',1,NULL,'rappelera pour nouveau RV',0),(483,4,278,'2013-08-27 10:45:00','2013-08-27 11:15:00',1,NULL,'',0),(484,3,278,'2013-10-28 10:30:00','2013-10-28 11:00:00',1,NULL,'',0),(485,3,104,'2013-10-16 10:00:00','2013-10-16 10:30:00',1,NULL,'',0),(486,4,309,'2013-08-27 11:20:00','2013-08-27 11:50:00',1,NULL,'',0),(487,3,309,'2013-09-25 11:15:00','2013-09-25 11:45:00',2,NULL,'Cs du 27/08/2013',0),(488,3,309,'2013-10-24 08:00:00','2013-10-24 08:30:00',1,NULL,'',0),(489,3,310,'2013-10-01 08:15:00','2013-10-01 08:45:00',2,NULL,'cs du 27/08/2013',0),(490,3,310,'2013-11-18 08:00:00','2013-11-18 08:30:00',1,NULL,'',0),(492,3,170,'2013-10-15 14:30:00','2013-10-15 15:00:00',1,NULL,'',0),(493,3,60,'2013-09-16 17:00:00','2013-09-16 17:30:00',1,NULL,'SAS app le 27/08/2013.',0),(494,3,314,'2013-09-11 08:00:00','2013-09-11 08:30:00',2,NULL,'',0),(496,2,307,'2013-09-03 08:15:00','2013-09-03 08:45:00',2,NULL,'',0),(498,3,43,'2013-10-14 08:00:00','2013-10-14 08:30:00',1,NULL,'',0),(499,3,47,'2013-10-28 09:00:00','2013-10-28 09:30:00',1,NULL,'a ete hospitalisé ',0),(501,2,261,'2013-10-24 16:00:00','2013-10-24 17:00:00',3,NULL,'',0),(502,3,261,'2013-09-19 15:00:00','2013-09-19 15:30:00',1,NULL,'',0),(503,2,318,'2013-08-28 10:30:00','2013-08-28 11:00:00',1,NULL,'',0),(504,4,316,'2013-08-28 10:00:00','2013-08-28 10:30:00',1,NULL,'',0),(505,2,318,'2013-10-10 14:45:00','2013-10-10 15:15:00',2,NULL,'',0),(507,3,316,'2013-09-26 14:45:00','2013-09-26 15:15:00',2,NULL,'Cs du 28/08/2013',0),(508,3,155,'2013-09-24 11:30:00','2013-09-24 12:00:00',1,NULL,'',0),(509,4,225,'2013-08-28 11:00:00','2013-08-28 11:30:00',1,NULL,'',0),(511,3,319,'2013-10-01 11:00:00','2013-10-01 11:30:00',2,NULL,'',0),(512,3,319,'2013-10-17 10:00:00','2013-10-17 10:30:00',1,NULL,'',0),(513,3,319,'2013-08-28 14:00:00','2013-08-28 14:30:00',1,NULL,'Deman