<?php
session_start();
session_destroy();


require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");


// Serveur uniquement
if (isset($_SERVER['SCRIPT_URI']) && !strstr($_SERVER['SCRIPT_URI'],"https"))
{
	Header('Location:https://www.pneumo.re/cabinet/authentification/login_form.php');
	exit;
}
?>
<!doctype html>
<html>
<head>
<title>Base Cabinet</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="robots" content="noindex, nofollow">
	<meta name="viewport"	content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- origine du favicon : https://www.favicon.cc/?action=icon&file_id=923858 ou /cabinet/config/favicon.ico-->
	<link rel="icon" href="data:image/x-icon;base64,AAABAAEAEBAQAAEABAAoAQAAFgAAACgAAAAQAAAAIAAAAAEABAAAAAAAgAAAAAAAAAAAAAAAEAAAAAAAAAD///8AK54CAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAREREREREAABEREREREQAAERERERERAAAREAAAABEAABEQAAAAAAAAERAAAAAAAAAREAAAAAAAABEQAAAAAAAAERAAAAARAAAREREREREAABEREREREQAAERERERERAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA">

	<?php
	$tab_librairies =	array(
			'jquery',
			'twitter-bootstrap',
			'font-awesome');
	
	libraries($tab_librairies);
	?>

	<style type="text/css">		
		.header-bar {
			position:absolute;
			top:0px;
			left:0px;
			height:70px;
			width:100%;
			border-bottom: 1px solid #E5E5E5;
			background-color:#F1F1F1;
		}
		
		.footer-bar {
			position: absolute;
			bottom: 0px;
			left:0px;
			height: 35px;
			width: 100%;
			border-top: 1px solid #ebebeb;
			overflow: hidden;
		}

		.footer {
			padding-top: 9px;
			font-size: .85em;
			white-space: nowrap;
			line-height: 0;
		}
		.footer ul {
			color: #999;
			float: left;
			max-width: 80%;
		}
		.footer ul li {
			display: inline;
			padding: 0 1.5em 0 0;
		}

		.logo {
			font-family: Georgia, Times, "Times New Roman", serif;
			font-size: 48px;
			font-style: normal;
			font-variant: normal;
			font-weight: 700;
			line-height: 26.4px;
			color: #33cc66;
			text-shadow: #000000 1px 1px, #000000 -1px 1px, #000000 -1px -1px, #000000 1px -1px;
		}
	</style>

	<script> 
	$(function() {
		// -------------------------------
		// Permet de valider le formulaire
		// avant de l'envoyer
		// -------------------------------
		$("#form_auth").submit(function()
		{
			$.ajax({
				type:		"POST",
				url:		"login.php",
				data:		$(this).serialize(),
				beforeSend:	function() {
						$('#submit').html("<div class='spinner-border spinner-border-sm' role='status'></div> Connection");
					},
				complete:	function() {	
					},
				success:	function(response) { 

						if (!isNaN(response))
							document.location.href = "/cabinet/config/link_service.php?id_service="+response;
						else
						{
							$('#error_message').show();
							$('#error_message').html(response);
							$('#submit').html("<button type='submit' class='btn btn-primary'>Connexion</button>");
							
						}
					}
			 });

			return false;

		});
	
	});
	</script> 
</head>

<body>

<div class='header-bar'>
	<div class='logo' style='margin-top:18px;margin-left:11px'>Cabinet</div>
</div>

<div style='position:absolute;top:120px;left:40px;width:380px;'>
	<div style='color:#DD4B39;font-size:14pt'>Base Cabinet</div>
	<p>Cette base appellée Cabinet a été conçu pour un cabinet médical.</p>
	<p>Le front Office est le <a href='/cabinet/site/index.php' target='_blank'>Site web</a></p>
</div>

<div style='position:absolute;top:120px;left:500px;width:340px;border: 1px #E5E5E5 solid;background-color:#F1F1F1;padding-top:20px;padding-bottom:10px;padding-left:20px'>

	<form id="form_auth">
		<div style='padding-top:0px;padding-bottom:10px;font-size:12pt'>Connexion</div>
		
		<div style="padding-top:10px">
			<label for="email" style='font-weight:bold;width:230px'>Adresse e-mail</label>
			<input style='width:200px' class="form-control" type="email" id="email" name="email">
		</div>
		
		<div style="padding-top:10px">
			<label for="password" style='font-weight:bold;width:230px'>Mot de passe</label>
			<input style='width:200px' class="form-control" type="password" id="password" name="password">
			
			<div id='attente'></div>
			<div id='error_message' class='alert alert-danger' style='display:none;width:266px'></div>
		</div>
	
		<div id="submit" style="padding-top:10px">
			<button type="submit" class="btn btn-primary">Connexion</button>
			<p style="margin-top:10px"><a href='recovery_form.php'>Vous ne pouvez pas accéder à votre compte ?</a></p>
		</div>
	</form>
</div>

<div class="footer-bar">
	<div class="footer">
		<ul>
			<li>©<?php echo date('Y') ?> Cabinet</li>
			<li>Votre adresse IP : <span style='font-weight:bold'><?php echo $_SERVER['REMOTE_ADDR']?><span></li>
		</ul>
	</div>
</div>

</body>
</html>