<?php
// ======================
// RENDEZ-VOUS
// --> Formulaire d'ajout
// ======================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
?>

<script> 
$(function() {

	$("#form1").validate({    
		rules: {
			old_password: {
				required: true,
				minlength: 2
			},
			new_password: {
				required: true,
				minlength: 6
			},
			confirm_new_password: {
				equalTo: "#new_password"
			},
		},
		messages: {
			old_password: {
				required: "vide !",
				minlength: "..."
			},
			new_password: {
				required: "vide !",
				minlength: "6 caracteres minimum"
			},
			confirm_new_password: {
				equalTo: "Tapez le meme mot de passe"
			}
		}
	});

	// -------------------------------
	// Permet de valider le formulaire
	// avant de l'envoyer
	// -------------------------------
	$("#form1").submit(function()
	{
		$.ajax({
			type:		"GET",
			url:		"/cabinet/authentification/change_password.php",
			data:		$(this).serialize(),
			beforeSend:	function() {
				$('#submit').html("Modifier vos infos <div class='spinner-border spinner-border-sm' role='status'></div>");
			},
			success:	function(response){ 
				if (response == "ok")
					$('#submit').html("Modifier vos infos <i class='fa fa-check' aria-hidden='true'></i>");
				else
					$("#form1").html("Erreur : "+response);
			}
		});

		return false;
	});


});
</script> 

<?php
// Identité
$sql_personnel	= dbquery("SELECT * FROM personnel WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)
	die('Attention : Personnel non reconnu');
?>

<form id='form1'>

	<table cellpadding='5'>
	<tr>
		<td style='text-align:right'>Ancien mot de passe :</td>
		<td><input id='old_password' name='old_password' type='password' style='width:200px' value=""></td>
	</tr>
	<tr>
		<td style='text-align:right'>Nouveau mot de passe :</td>
		<td><input id='new_password' name='new_password' type='password' style='width:200px' value=""></td>
	</tr>
	<tr>
		<td style='text-align:right'>Confirmer le mot de passe :</td>
		<td><input id='confirm_new_password' name='confirm_new_password' type='password' style='width:200px' value=""></td>
	</tr>
	</table>

	<button class="btn btn-primary" type='submit' id='submit'>Modifier vos infos</button>
</form>

</body>
</html>