<?php
// ------------------
// PLANNING 2
// --> Version mobile
// ------------------

session_start();

// Acces a https://www.pneumo.re/cabinet/home/index.php?date=2015-03-17&home=1 par exemple

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// Initialise le planning a une semaine donnée
if (!isset($_GET['date']))
{
	// Lundi : on conserve le meme jour
	// Samedi PM ou dimanche : on va au prochain lundi
	// Mardi / Mercredi / Jeudi / Vendredi / Samedi AM : on va au precedent lundi
	$date = new mydatetime();
	
	if ($date->format("l") == "Saturday" || $date->format("l") == "Sunday")
		$date -> change_to_next_monday();

	Header('Location:/cabinet/agenda/mobile/planning.php?date='.$date->format('Y-m-d'));
	exit;
}


// Détecte les date erronnées
try {
	$date_today		= new mydatetime(date('Y-m-d'));
	$date			= new mydatetime($_GET['date']);
	$date_prev		= clone $date;
	$date_suiv		= clone $date;
	$date_encours	= clone $date;

	$date_prev -> modify('previous week');
	$date_suiv -> modify('next week');
	$date_encours -> change_to_last_monday();
}
catch(Exception $e) {
	exit;
}
?>

<!doctype html>
<html>
<head>
	<title>Planning mobile</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="robots"		content="noindex, nofollow">
	<meta name="viewport"	content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<?php
	$tab_librairies =	array(
			'jquery',
			'jqueryui',
			'twitter-bootstrap',
			'font-awesome',
			'jquery.tablesorter');
	
	libraries($tab_librairies);
	?>

	<link rel="stylesheet" href="/cabinet/agenda/mobile/planning.css" >


	<script type="text/javascript">
	<!--
	$(document).ready(function() {

		$(".envoi_sms").click(function() {
			$.ajax({
				type: "GET",
				url: "send_sms.php",
				data: "id="+$(this).attr('id'),
				success: function(){
				}
			});
		});

		$(".date_normal").click(function() {
			
			$("#planning_jour").load("/cabinet/agenda/mobile/planning.php?date="+$(this).attr("value")+"&home=1&load=1");

		});

		
		$("table").tablesorter({
			theme : "bootstrap",
			widthFixed: true,
			widgets : [ "uitheme", "zebra" ],
			widgetOptions : {
			}
		})

	});
	</script>

</head>

<body>


<?php
echo "<div class='date_fr_complete'>".date_iso_fr_complete($date->format('Y-m-d'))." <a href='/cabinet/pdf/pdf_consultations.php?date%5B0%5D=".$date->format('Y-m-d')."&orientation=portrait' target='_new'><i style='background-color:white;color:red' class='fa fa-file-pdf-o fa-lg'></i></a></div>";




$tab_font_awesome['fixe']		= "fa-phone";
$tab_font_awesome['portable']	= "fa-mobile";
?>

<table>
<thead>
</thead>
<tbody>
<tr>


<?php
// Clients non décédé
$sql_agenda = dbquery("SELECT *
	FROM clients,agenda,type_rendez_vous
	WHERE clients.id_client = agenda.id_client
		AND agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
		AND DATE(agenda.datetime_debut)='".$_GET['date']."'
		AND deces = '0'
	ORDER BY agenda.datetime_debut ASC, clients.nom ASC, clients.prenom ASC");

for ($i=0;$i<dbnumrows($sql_agenda);$i++)
{
	$id_agenda				= dbresult($sql_agenda,$i,"agenda.id_agenda");
	$nom					= dbresult($sql_agenda,$i,"clients.nom");
	$prenom					= dbresult($sql_agenda,$i,"clients.prenom");

	$datetime_debut			= new datetime(dbresult($sql_agenda,$i,"agenda.datetime_debut"));
	$datetime_fin			= new datetime(dbresult($sql_agenda,$i,"agenda.datetime_fin"));
	$type_rendez_vous		= dbresult($sql_agenda,$i,"type_rendez_vous.abrege");
	$societe				= dbresult($sql_agenda,$i,"agenda.societe");
	$commentaire			= dbresult($sql_agenda,$i,"agenda.commentaire");
	$background_color		= dbresult($sql_agenda,$i,"type_rendez_vous.background_color");

	$checked				= dbresult($sql_agenda,$i,"agenda.checked");


	echo "<tr><td style='width:40px'>".$datetime_debut->format('H:i')."</td>";
	echo "<td style='width:300px'><a href='/cabinet/consultations/gestion_clients/index.php?id_client=".dbresult($sql_agenda,$i,"id_client")."' target='_new'>".$prenom." ".$nom."</a></td>";
	echo "<td style='width:50px;text-align:center;background-color:#".$background_color."'>".$type_rendez_vous."</td>";
	echo "<td style='width:50px;'>".$societe."</td>";
	echo "<td style='width:50px;'>".$commentaire."</td>";
	
	echo "<td style='width:110px;color:grey'>";
	if ($_GET['home'] <> 1)
	{	
		$sql_agenda_ccam = dbquery("SELECT *
			FROM agenda_ccam
			WHERE id_agenda='".$id_agenda."'
			ORDER BY code_ccam ASC");
		
		for ($k=0;$k<dbnumrows($sql_agenda_ccam);$k++)
		{
			echo dbresult($sql_agenda_ccam,$k,"code_ccam")."<br>";
		}
	}
	else
	{
		// --------------
		// Les téléphones
		// --------------
		echo "<table style='border-collapse: collapse;width:280px'>";
		$sql_client_telephone = dbquery("SELECT *
			FROM clients_telephone
			WHERE id_client = '".dbresult($sql_agenda,$i,"id_client")."'
			ORDER BY type_telephone ASC");
		for ($j=0;$j<dbnumrows($sql_client_telephone);$j++)
		{
			$id_client_telephone	= dbresult($sql_client_telephone,$j,"id_client_telephone");
			$type_telephone	= dbresult($sql_client_telephone,$j,"type_telephone");
			$telephone		= dbresult($sql_client_telephone,$j,"telephone");
			$contact		= dbresult($sql_client_telephone,$j,"contact");

			
			echo "<tr><td style='width:40px;text-align:center;padding:2px'><i style='color:#50DA63' class='fa ".$tab_font_awesome[$type_telephone]." fa-2x'></i></td>";
			echo "<td style='width:98px;padding:5px'>".$telephone."</td>";
			echo "<td style='width:50px;color:red'>".$contact."</td>";

			// Telephone portable (Personnel : David Tanguy = 4)
			echo "<td style='width:36px;padding:5px'>";
			if ($type_telephone == 'portable' && $_SESSION['id_personnel'] == 4)
				echo "<button class='envoi_sms' id='".$id_agenda."|".$id_client_telephone."'>SMS</button>";
			echo "</td></tr>";

		}
		echo "</table>";
	}
	echo "</td>";
	echo "<td>";
	if ($checked == 1)
		echo "<img src='/images/icones/16px/ok.png' width='16' height='16' border='0' alt=''>";
	echo "</td></tr>";
}
?>
</tbody>
</table>

</body>
</html>