<?php
// ------------
// JOURS FERIÉS
// --> Liste
// ------------

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
?>

<script type="text/javascript"> 
$(document).ready(function()
{		
	$("table").tablesorter({
		headers: { 0: { sorter: false }, 1: { sorter: false }},
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})


	// Trash (Icone)
	$(".fa-trash-o").click(function() {
		$( "#"+$(this).attr('id') ).hide();
		$( "#button_"+$(this).attr('id') ).show();
	});

	// Confirmation d'effacement (Boutton)
	$(".confirm_delete").click(function() {

		$("#ajax").html("<div class='spinner-border spinner-border-sm' role='status'></div> <span style='left: 10px; color:green'>Suppression du jour férié</span>");

		$.ajax({
			type:		"GET",
			url:		"/cabinet/agenda/jours_feries/delete.php",
			data:		"date="+$(this).attr('date'),
			beforeSend:	function()
				{	$("#ajax").html("<div class='spinner-border spinner-border-sm' role='status'></div> <span style='left: 10px; color:green'>Suppression du jour férié</span>");
				},
			complete:	function()
				{	
				},
			success:	function(response){ 
					$("#ajax").load("/cabinet/agenda/jours_feries/index_ajax.php?year=<?php echo $_GET['year'] ?>");
				}
		 });


	});


	// -------------------------------
	// Permet de valider le formulaire
	// avant de l'envoyer
	// -------------------------------
	$("#form_add").submit(function()
	{
		$.ajax({
			type:		"GET",
			url:		"/cabinet/agenda/jours_feries/add.php",
			data:		$(this).serialize(),
			beforeSend:	function()
				{	$("#ajax").html("<div class='spinner-border spinner-border-sm' role='status'></div> <span style='left: 10px; color:green'>Ajout du jour férié <b>"+$('#nom').val()+"</b></span>");
				},
			complete:	function()
				{	
				},
			success:	function(response){ 
					if (response == "ok")
						$("#ajax").load("/cabinet/agenda/jours_feries/index_ajax.php?year=<?php echo $_GET['year'] ?>");
					else
						$("#ajax").html("Erreur : "+response);
				}
		 });

		return false;

	});

});	
</script>


<form id="form_add">

	<?php
	$sql_jours_feries = dbquery("SELECT * FROM jours_feries WHERE YEAR(date) = '".$_GET['year']."' ORDER BY date ASC");
	?>

	<!-- Nombre de réponses -->
	<p><font color="green"><b><?php echo dbnumrows($sql_jours_feries)?></b> date<?php if (dbnumrows($sql_jours_feries)>1) echo "s"?></font></p>


	<table id="table" class="tablesorter">
	<thead>
	<tr>
		<th>Date</th>
		<th>Nom</th>
		<th></th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td><input class="form-control" type="text" id="date" name="date" style='width:120px' maxlength="10"  required></td>
		<td><input class="form-control" type="text" id="nom"  name="nom"  style='width:180px' required></td>
		<td><button class='btn btn-primary' type='submit'>Ajout</button></td>
	</tr>

	<?php
	for ($i=0;$i<dbnumrows($sql_jours_feries);$i++)
	{
		$date = new DateTime(dbresult($sql_jours_feries,$i,"date"));
		?>
		
		<tr>
			<td><?php echo $date->format('d/m/Y') ?></td>
			<td><?php echo dbresult($sql_jours_feries,$i,"nom") ?></td>
			<td style='text-align:center'>
				<i id='<?php echo $date->format('Y-m-d') ?>' style='color:red' class='fa fa-trash-o fa-lg'></i>&nbsp;
				<button type='button' id='button_<?php echo $date->format('Y-m-d') ?>' date='<?php echo $date->format('Y-m-d') ?>' class='btn btn-secondary confirm_delete' style='display:none'>Confirmer la suppression</button>
			</td>
		</tr>
		<?php
	}
	?>
	</tbody>
	</table>

</form>

</body>
</html>