<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");

libraries(array('fullcalendar'));
?>

<style type='text/css'>
#calendar {
	position:absolute;
	top:-20px;
	left:0px
	width: <?php echo $agenda_width ?>px;
	margin: 0 auto;
}
</style>

<?php
$date = new DateTime();


// --------------------------
// Date par defaut
// --> Vas a la semaine prochaine
// --------------------------
$default_date = new DateTime();

if ($default_date->format('l') == "Saturday")
	$default_date->modify('+2 days');

if ($default_date->format('l') == "Sunday")
	$default_date->modify('+1 days');
?>
<script>

document.addEventListener('DOMContentLoaded', function() {
	var calendarEl = document.getElementById('calendar');


	var calendar = new FullCalendar.Calendar(calendarEl, {
		schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',

		headerToolbar: {
			left: 'prev,next today',
			center: 'title',
			right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
		},

		themeSystem:'standard',
		locale:'fr',
		firstDay: 1,


		
		buttonText: {
			today:    'Aujourd\'hui',
			month:    'Mois',
			week:     'Semaine',
			day:      'Jour',
			list:     'Liste',

		},

		allDayText : 'Journée entière',
		minTime: '08:00:00',
		maxTime: '20:00:00',

		

		defaultDate: '<?php echo $date->format('Y-m-d') ?>',
		
		dateClick: function(info) {

			$.fancybox.open({
				src  : 'choix_client.php?datetime_debut=' + info.dateStr,
				type : 'ajax',
				opts : {
					afterClose : function() {
						calendar.refetchEvents();
					}
				}

			});
		},

		eventClick: function(info) {

			// Exemple info.event.id : conge_273

			// Congés classique du personnel => Modification
			if (info.event.id.indexOf("conge_classique") != -1)
			{
				$.fancybox.open({
					src  : '/cabinet/gestion/conges/classique/update_form.php?id_personnel_conge='+info.event.id.substr(16),
					type : 'ajax',
					opts : {
						afterClose : function() {
							calendar.refetchEvents();
						}
					}
				});
			}

			// Congés (cyclique) du personnel => Modification
			if (info.event.id.indexOf("conge_cyclique") != -1)
			{
				$.fancybox.open({
					src : '/cabinet/gestion/conges/cyclique/update_form.php?id_personnel_conge_cyclique='+info.event.id.substr(15),
					type : 'ajax',
					opts : {
						afterClose : function() {
							calendar.refetchEvents();
						}
					}
				});
			}
			

			// Rendez-vous patient classique
			if (info.event.id.indexOf("conge_classique") == -1 && info.event.id.indexOf("conge_cyclique") == -1 && info.event.id.indexOf("ferie") == -1)
			{
				$.fancybox.open({
					src  : 'update_form.php?id_agenda='+info.event.id,
					type : 'ajax',
					opts : {
						afterClose : function() {         
							calendar.refetchEvents();
						}
					}
				});
			}
		},
		
		eventDrop: function(info) {

			$.ajax({
				type: "GET",
				url: "change_datetime.php",
				data: "id_agenda="+info.event.id+"&datetime_debut="+info.event.start.toString()+"&datetime_fin="+info.event.end.toString(),
				success: function(){

				}
			});

		},
		eventResize: function(info) {
					
			$.ajax({
				type: "GET",
				url: "change_datetime.php",
				data: "id_agenda="+info.event.id+"&datetime_debut="+info.event.start.toString()+"&datetime_fin="+info.event.end.toString(),
				success: function(){

				}
			});
		},

		weekNumbers: true,

		editable: true,
		navLinks: true, // can click day/week names to navigate views
		eventLimit: true, // allow "more" link when too many events
		events: {
			url: 'fullcalendar_event.php',
			failure: function() {
				alert('Erreur de chargement des données JSON.');
			}
		}
	});

	calendar.render();


	$(document).ready(function() {

		// Regroupe les checkbox
		$("#type_rendez_vous").buttonset();


		// ----------------------------------------------
		// MISE A JOUR DU TYPE DE RENDEZ VOUS
		// --> Declencheur : click sur bouton
		// ----------------------------------------------
		
		$("#type_rendez_vous").change(function() {

			// Consultation + EFR/Sommeil + PPC/TM + Autre = 4 types de rendez vous)

			var string =  "field_type_rendez_vous_groupe_selection[1]=" + $("#field_type_rendez_vous_groupe_selection_1").is(':checked');
			string    += "&field_type_rendez_vous_groupe_selection[2]=" + $("#field_type_rendez_vous_groupe_selection_2").is(':checked');
			string    += "&field_type_rendez_vous_groupe_selection[3]=" + $("#field_type_rendez_vous_groupe_selection_3").is(':checked');	
			string    += "&field_type_rendez_vous_groupe_selection[4]=" + $("#field_type_rendez_vous_groupe_selection_4").is(':checked');	


			$.ajax({
				type: "GET",
				url: "/cabinet/agenda/type_rendez_vous_groupe_update.php",
				data: string,
				success: function(msg){
					calendar.refetchEvents();
				}
			});
		});
		
	});

});

</script>

<body>

<span id="agenda_mobile_icalendar" style="position:absolute; top: -10px; left: 14px; z-index:1">

	<a class='btn btn-outline-secondary' id='agenda_mobile' href='mobile/planning.php' target='_new' ><i style="color:black" class="fa fa-mobile fa-lg"></i></a>

	<a class='btn btn-outline-secondary' data-fancybox data-type='ajax' id='icalendar_form' href='icalendar_form.php'><i style="color:black" class="fa fa-android fa-lg"></i></a>
	
	<a class='btn btn-outline-secondary' data-fancybox data-type='ajax' id='jour_feries'	href='jours_feries/index.php' title="Jours feriés"><i style="color:red" class="fa fa-calendar fa-lg"></i></a>

	<a class='btn btn-outline-secondary'	id='etats'	href='/cabinet/agenda/etats/index.php'><i style="color:black" class="fa fa-print fa-lg"></i></a>

	<a class='btn btn-outline-secondary'	id='etats'	href='/cabinet/gestion/conges/index.php'><i style="color:black" class="fa fa-plane fa-lg"></i></a>
</span>


<div id="type_rendez_vous" style="position:absolute; top:-8px; left:388px;z-index:1;width:434px">
	<?php
	// --------------------
	// Types de rendez vous
	//  -> Consultation
	//  -> EFR / Sommeil
	//  -> Autre
	// ---------------------
	$sql_type_rendez_vous_groupe = dbquery("SELECT *
		FROM type_rendez_vous_groupe
		ORDER BY id_type_rendez_vous_groupe");

	for ($i=0;$i<dbnumrows($sql_type_rendez_vous_groupe);$i++)
	{
		$id_type_rendez_vous_groupe			= dbresult($sql_type_rendez_vous_groupe,$i,"id_type_rendez_vous_groupe");
		$intitule_type_rendez_vous_groupe	= dbresult($sql_type_rendez_vous_groupe,$i,"intitule");

		$checked = "";
		$sql_checked = dbquery("SELECT *
			FROM personnel_type_rendez_vous_groupe
			WHERE id_personnel = '".$_SESSION['id_personnel']."'
				AND id_type_rendez_vous_groupe = '".$id_type_rendez_vous_groupe."'");
		if (dbnumrows($sql_checked) > 0)
			$checked = " checked";

		echo "&nbsp;<input type='checkbox' id='field_type_rendez_vous_groupe_selection_".$id_type_rendez_vous_groupe."' name='field_type_rendez_vous_groupe_selection[".$id_type_rendez_vous_groupe."]' value='1'".$checked."><label for='field_type_rendez_vous_groupe_selection_".$id_type_rendez_vous_groupe."'>".$intitule_type_rendez_vous_groupe."</label>";
	}
	?>
</div>

<div style="position:absolute; top:0px;width: 1200px;margin: 40px auto;padding: 0 10px;" id='calendar'></div>


<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>