<?php
// ====================
// Logs des Erreurs SQL
// --> par jour
// ====================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");



// Jour precedent, actuel et suivant
$date					= new DateTime($_GET['date']);
$date_jour_precedent	= new DateTime($_GET['date']);
$date_jour_suivant		= new DateTime($_GET['date']);

$date_jour_precedent->modify('-1 day');
$date_jour_suivant->modify('+1 day');
?>


<script type='text/javascript'>
$(document).ready(function() {

	$(".tablesorter").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	});

	$("#previous").click(function() {

		$("#ajax").load("index_ajax.php?date=<?php echo $date_jour_precedent->format('Y-m-d') ?>");
	
	});

	$("#next").click(function() {

		$("#ajax").load("index_ajax.php?date=<?php echo $date_jour_suivant->format('Y-m-d') ?>");
	});

	$(".delete").click(function() {

		id_log_sql_numrow = $(this).attr('id');
	
		$.ajax({
			type:		"GET",
			url:		"delete.php",
			data:		"id_log_sql_numrow="+id_log_sql_numrow,
			beforeSend:	function() {
					
				},
			complete:	function() {	
				},
			success:	function(response) { 

				$("#ajax").load("index_ajax.php?date=<?php echo $date->format('Y-m-d') ?>");
			}
		});

	});

});

</script>


<!-- PREVIOUS -->
<i style="position:absolute;top:0px; left:70px; width:20px; font-weight:bold; text-align:left; color:#6C7D96; cursor:pointer" id='previous' class="bi bi-chevron-left fa-2x"></i>

<!-- DATE EN COURS -->
<div style="position:absolute;top:3px; left:90px; width:380px; font-weight:bold; text-align:center"><?php echo date_iso_fr_complete($date->format("Y-m-d")) ?></div>


<!-- NEXT -->
<i style="position:absolute;top:0px; left:470px; width:20px; font-weight:bold; text-align:right;  color:#6C7D96; cursor:pointer" id='next' class="bi bi-chevron-right fa-2x"></i>



<table class="tablesorter" style="position:relative;top:50px;">
<thead>
<tr>
	<th></th>
	<th>Date & Heure</th>
	<th>Ligne</th>
	<th>Champ</th>
	<th>Personnel connecté</th>
	<th>Adresse IP</th>
	<th>Fichier</th>
</tr>
</thead>
<tbody>

<?php
$log_sql_numrows = dbquery("SELECT * FROM log_sql_numrows
	WHERE DATE(datetime) = '".$_GET['date']."'
	ORDER BY datetime");

for ($i=0;$i<dbnumrows($log_sql_numrows);$i++)
{
	$id_log_sql_numrow			= dbresult($log_sql_numrows,$i,"id_log_sql_numrow");
	$datetime					= dbresult($log_sql_numrows,$i,"datetime");
	$ligne						= dbresult($log_sql_numrows,$i,"ligne");
	$champ						= dbresult($log_sql_numrows,$i,"champ");
	$id_personnel				= dbresult($log_sql_numrows,$i,"id_personnel");
	$adresse_ip_client			= dbresult($log_sql_numrows,$i,"adresse_ip_client");
	$fichier					= dbresult($log_sql_numrows,$i,"fichier");

	$log_sql_error_personnel = dbquery("SELECT nom,prenom FROM personnel WHERE id_personnel = '".$id_personnel."'");
	if (dbnumrows($log_sql_error_personnel) > 0)
		$personnel = dbresult($log_sql_error_personnel,0,"prenom")." ".dbresult($log_sql_error_personnel,0,"nom");

	echo "<tr id=".$i.">";
	echo "<td style='text-align:center'><i id='".$id_log_sql_numrow."' style='color:red;cursor:pointer' class='delete fa fa-trash fa-lg'></i></a></td>";
	echo "<td>".$datetime."</td>";
	echo "<td>".$ligne."</td>";
	echo "<td>".$champ."</td>";
	echo "<td style='color:red'>".$personnel."</td>";
	echo "<td>".$adresse_ip_client."</td>";
	echo "<td>".str_replace(".php?",".php?<br>",$fichier)."</td></tr>";
}
?>

</tbody>
</table>