<?php
// ================
// LOG DES ERREURS SQL
// ================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");

$date = new DateTime();

libraries(array('fullcalendar'));
?>

<script type="text/javascript">
<!--
$(document).ready(function() {
	
	// Chargement initial
    $("#ajax").load("index_ajax.php?date=<?php echo date('Y-m-d') ?>");
});	

document.addEventListener('DOMContentLoaded', function() {

	var calendarEl = document.getElementById('calendar');

	var calendar = new FullCalendar.Calendar(calendarEl, {
	
		schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',

		headerToolbar: {
		  left: 'prev,next today',
		  center: 'title',
		  right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
		},

		locale:'fr',
		
		initialDate: '<?php echo $date->format('Y-m-d') ?>',
		
		dateClick: function(info) {
			$("#ajax").load("index_ajax.php?date=" + info.dateStr);
		},
		
		weekNumbers: true,

		editable: true,
		navLinks: true, // can click day/week names to navigate views
		dayMaxEventRows: true, // allow "more" link when too many events
		events: {
			url: 'fullcalendar_event.php',
			failure: function() {
				alert('Erreur de chargement des données JSON.');
			}
		}
	});

	calendar.render();
});
</script>


<div class='title'>Log des erreurs SQL</div>


<div style='position:absolute;top:50px;left:20px;width:700px;' id='calendar'></div>


<!-- Ajax //-->
<div style="position:relative;top:600px;color:red solid 1px" id='ajax'>
	<div class='spinner-border spinner-border-sm' role='status'></div>
</div>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>