<?php
// ===================
// LOGS DES ERRORS PHP
// ===================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");


// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");

// --------------------------
// Date par defaut
// --> Vas a la semaine prochaine
// --------------------------
$date = new DateTime();


libraries(array('fullcalendar'));


// Log error
$log_error = dbquery("SELECT * FROM log_php_error");
?>

<script type='text/javascript'>
document.addEventListener('DOMContentLoaded', function() {

	var calendarEl = document.getElementById('calendar');

	var calendar = new FullCalendar.Calendar(calendarEl, {
	
		schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',

		headerToolbar: {
		  left: 'prev,next today',
		  center: 'title',
		  right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
		},

		locale:'fr',
		
		initialDate: '<?php echo $date->format('Y-m-d') ?>',
		
		dateClick: function(info) {
			$("#ajax").load("index_ajax.php?date=" + info.dateStr);
		},
		
		weekNumbers: true,

		editable: true,
		navLinks: true, // can click day/week names to navigate views
		dayMaxEventRows: true, // allow "more" link when too many events
		events: {
			url: 'fullcalendar_event.php',
			failure: function() {
				alert('Erreur de chargement des données JSON.');
			}
		}
	});

	calendar.render();
});



$(document).ready(function() {
	

	$("#form1").submit(function()
	{
		$.ajax({
			async: true,
			type:		"GET",
			url:		"empty_php_logs.php",
			data:		$(this).serialize(),
			success:	function(response){
				
				if (response == "ok")
				{
					$('#submit').html("<i style='color:red' class='fa fa-trash-o fa-lg'></i> Effacer les logs (0 ligne)</i>");
				}
			}
		 });

		return false;
	});

});	
</script>


<div class="title">Logs des erreurs PHP</div>

<div style='position:absolute;top:60px;left:20px;width:700px;' id='calendar'></div>

<?php
$filename = '../../../../../logs/php_error.log';
?>

<form id='form1' style='position:absolute;top:20px;left:360px'>
	<button class="btn btn-secondary" type="submit" id="submit"><i style='color:red' class='fa fa-trash-o fa-lg'></i> Efface les logs (<?php echo dbnumrows($log_error) ?> ligne(s))</button>
</form>

<?php
// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>